/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionDialogUtil {
    private ExceptionDialogUtil() {
    }

    public static void explainOsmApiInitializationException(OsmApiInitializationException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainOsmApiInitializationException(e), I18n.tr("Error"), 0, HelpUtil.ht("/ErrorMessages#OsmApiInitializationException"));
    }

    public static void explainChangesetClosedException(ChangesetClosedException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainChangesetClosedException(e), I18n.tr("Error"), 0, HelpUtil.ht("/Action/Upload#ChangesetClosed"));
    }

    public static void explainPreconditionFailed(OsmApiException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainPreconditionFailed(e), I18n.tr("Precondition violation"), 0, HelpUtil.ht("/ErrorMessages#OsmApiException"));
    }

    public static void explainGeneric(Exception e) {
        e.printStackTrace();
        BugReportExceptionHandler.handleException(e);
    }

    public static void explainSecurityException(OsmTransferException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainSecurityException(e), I18n.tr("Security exception"), 0, HelpUtil.ht("/ErrorMessages#SecurityException"));
    }

    public static void explainNestedSocketException(OsmTransferException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedSocketException(e), I18n.tr("Network exception"), 0, HelpUtil.ht("/ErrorMessages#NestedSocketException"));
    }

    public static void explainNestedIOException(OsmTransferException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedIOException(e), I18n.tr("IO Exception"), 0, HelpUtil.ht("/ErrorMessages#NestedIOException"));
    }

    public static void explainNestedIllegalDataException(OsmTransferException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedIllegalDataException(e), I18n.tr("Illegal Data"), 0, HelpUtil.ht("/ErrorMessages#IllegalDataException"));
    }

    public static void explainNestedInvocationTargetException(Exception e) {
        InvocationTargetException ex = ExceptionDialogUtil.getNestedException(e, InvocationTargetException.class);
        if (ex != null) {
            BugReportExceptionHandler.handleException(ex);
            return;
        }
    }

    public static void explainInternalServerError(OsmTransferException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainInternalServerError(e), I18n.tr("Internal Server Error"), 0, HelpUtil.ht("/ErrorMessages#InternalServerError"));
    }

    public static void explainBadRequest(OsmApiException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainBadRequest(e), I18n.tr("Bad Request"), 0, HelpUtil.ht("/ErrorMessages#BadRequest"));
    }

    public static void explainNotFound(OsmApiException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNotFound(e), I18n.tr("Not Found"), 0, HelpUtil.ht("/ErrorMessages#NotFound"));
    }

    public static void explainConflict(OsmApiException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainConflict(e), I18n.tr("Conflict"), 0, HelpUtil.ht("/ErrorMessages#Conflict"));
    }

    public static void explainAuthenticationFailed(OsmApiException e) {
        String authMethod = Main.pref.get("osm-server.auth-method", "basic");
        String msg = authMethod.equals("oauth") ? ExceptionUtil.explainFailedOAuthAuthentication(e) : ExceptionUtil.explainFailedBasicAuthentication(e);
        HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Authentication Failed"), 0, HelpUtil.ht("/ErrorMessages#AuthenticationFailed"));
    }

    public static void explainAuthorizationFailed(OsmApiException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainFailedOAuthAuthorisation(e), I18n.tr("Authorisation Failed"), 0, HelpUtil.ht("/ErrorMessages#AuthenticationFailed"));
    }

    public static void explainClientTimeout(OsmApiException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainClientTimeout(e), I18n.tr("Client Time Out"), 0, HelpUtil.ht("/ErrorMessages#ClientTimeOut"));
    }

    public static void explainGenericHttpException(OsmApiException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainClientTimeout(e), I18n.tr("Communication with OSM server failed"), 0, HelpUtil.ht("/ErrorMessages#GenericCommunicationError"));
    }

    public static void explainMissingOAuthAccessTokenException(MissingOAuthAccessTokenException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainMissingOAuthAccessTokenException(e), I18n.tr("Authentication failed"), 0, HelpUtil.ht("/ErrorMessages#MissingOAuthAccessToken"));
    }

    public static void explainNestedUnkonwnHostException(OsmTransferException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedUnknownHostException(e), I18n.tr("Unknown host"), 0, HelpUtil.ht("/ErrorMessages#UnknownHost"));
    }

    protected static <T> T getNestedException(Exception e, Class<T> nestedClass) {
        Throwable t;
        for (t = e; t != null && !nestedClass.isInstance(t); t = t.getCause()) {
        }
        if (t == null) {
            return null;
        }
        if (nestedClass.isInstance(t)) {
            return nestedClass.cast(t);
        }
        return null;
    }

    public static void explainOsmTransferException(OsmTransferException e) {
        if (ExceptionDialogUtil.getNestedException(e, SecurityException.class) != null) {
            ExceptionDialogUtil.explainSecurityException(e);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(e, SocketException.class) != null) {
            ExceptionDialogUtil.explainNestedSocketException(e);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(e, UnknownHostException.class) != null) {
            ExceptionDialogUtil.explainNestedUnkonwnHostException(e);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(e, IOException.class) != null) {
            ExceptionDialogUtil.explainNestedIOException(e);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(e, IllegalDataException.class) != null) {
            ExceptionDialogUtil.explainNestedIllegalDataException(e);
            return;
        }
        if (e instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)e);
            return;
        }
        if (e instanceof ChangesetClosedException) {
            ExceptionDialogUtil.explainChangesetClosedException((ChangesetClosedException)e);
            return;
        }
        if (e instanceof MissingOAuthAccessTokenException) {
            ExceptionDialogUtil.explainMissingOAuthAccessTokenException((MissingOAuthAccessTokenException)e);
            return;
        }
        if (e instanceof OsmApiException) {
            OsmApiException oae = (OsmApiException)e;
            switch (oae.getResponseCode()) {
                case 412: {
                    ExceptionDialogUtil.explainPreconditionFailed(oae);
                    return;
                }
                case 410: {
                    ExceptionDialogUtil.explainGoneForUnknownPrimitive(oae);
                    return;
                }
                case 500: {
                    ExceptionDialogUtil.explainInternalServerError(oae);
                    return;
                }
                case 400: {
                    ExceptionDialogUtil.explainBadRequest(oae);
                    return;
                }
                case 404: {
                    ExceptionDialogUtil.explainNotFound(oae);
                    return;
                }
                case 409: {
                    ExceptionDialogUtil.explainConflict(oae);
                    return;
                }
                case 401: {
                    ExceptionDialogUtil.explainAuthenticationFailed(oae);
                    return;
                }
                case 403: {
                    ExceptionDialogUtil.explainAuthorizationFailed(oae);
                    return;
                }
                case 408: {
                    ExceptionDialogUtil.explainClientTimeout(oae);
                    return;
                }
            }
            ExceptionDialogUtil.explainGenericHttpException(oae);
            return;
        }
        ExceptionDialogUtil.explainGeneric(e);
    }

    public static void explainGoneForUnknownPrimitive(OsmApiException e) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainGoneForUnknownPrimitive(e), I18n.tr("Object deleted"), 0, HelpUtil.ht("/ErrorMessages#GoneForUnknownPrimitive"));
    }

    public static void explainException(Exception e) {
        if (ExceptionDialogUtil.getNestedException(e, InvocationTargetException.class) != null) {
            ExceptionDialogUtil.explainNestedInvocationTargetException(e);
            return;
        }
        if (e instanceof OsmTransferException) {
            ExceptionDialogUtil.explainOsmTransferException((OsmTransferException)e);
            return;
        }
        ExceptionDialogUtil.explainGeneric(e);
    }
}

