/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Epsg2176;
import org.openstreetmap.josm.data.projection.Epsg2177;
import org.openstreetmap.josm.data.projection.Epsg2178;
import org.openstreetmap.josm.data.projection.Epsg2179;
import org.openstreetmap.josm.data.projection.Epsg2180;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.PuwgData;
import org.openstreetmap.josm.data.projection.UTM;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Puwg
extends UTM
implements Projection,
ProjectionSubPrefs {
    public static final int DEFAULT_ZONE = 0;
    private int zone = 0;
    static PuwgData[] Zones = new PuwgData[]{new Epsg2180(), new Epsg2176(), new Epsg2177(), new Epsg2178(), new Epsg2179()};
    private static DecimalFormat decFormatter = new DecimalFormat("###0");

    @Override
    public EastNorth latlon2eastNorth(LatLon p) {
        PuwgData z = Zones[this.zone];
        double easting = z.getPuwgFalseEasting();
        double northing = z.getPuwgFalseNorthing();
        double scale = z.getPuwgScaleFactor();
        double center = z.getPuwgCentralMeridian();
        EastNorth a = this.mapLatLonToXY(Math.toRadians(p.lat()), Math.toRadians(p.lon()), center);
        return new EastNorth(a.east() * scale + easting, a.north() * scale + northing);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth p) {
        PuwgData z = Zones[this.zone];
        double easting = z.getPuwgFalseEasting();
        double northing = z.getPuwgFalseNorthing();
        double scale = z.getPuwgScaleFactor();
        double center = z.getPuwgCentralMeridian();
        return this.mapXYToLatLon((p.east() - easting) / scale, (p.north() - northing) / scale, center);
    }

    @Override
    public String toString() {
        return I18n.tr("PUWG (Poland)");
    }

    @Override
    public String toCode() {
        return Zones[this.zone].toCode();
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode() + this.zone;
    }

    @Override
    public String getCacheDirectoryName() {
        return Zones[this.zone].getCacheDirectoryName();
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return Zones[this.zone].getWorldBoundsLatLon();
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 0.009;
    }

    public String eastToString(EastNorth p) {
        return decFormatter.format(p.east());
    }

    public String northToString(EastNorth p) {
        return decFormatter.format(p.north());
    }

    @Override
    public void setupPreferencePanel(JPanel p) {
        JComboBox<PuwgData> prefcb = new JComboBox<PuwgData>(Zones);
        prefcb.setSelectedIndex(this.zone);
        p.setLayout(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("PUWG Zone")), GBC.std().insets(5, 5, 0, 5));
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        p.add(prefcb, GBC.eop().fill(2));
        p.add(GBC.glue(1, 1), GBC.eol().fill(1));
    }

    @Override
    public Collection<String> getPreferences(JPanel p) {
        Component prefcb = p.getComponent(2);
        if (!(prefcb instanceof JComboBox)) {
            return null;
        }
        int zone = ((JComboBox)prefcb).getSelectedIndex();
        return Collections.singleton(Zones[zone].toCode());
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        for (PuwgData p : Zones) {
            if (!code.equals(p.toCode())) continue;
            return Collections.singleton(code);
        }
        return null;
    }

    @Override
    public void setPreferences(Collection<String> args) {
        this.zone = 0;
        if (args != null) {
            try {
                Iterator<String> i$ = args.iterator();
                if (i$.hasNext()) {
                    String s = i$.next();
                    for (int i = 0; i < Zones.length; ++i) {
                        if (!s.equals(Zones[i].toCode())) continue;
                        this.zone = i;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

