/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambertCC9Zones
implements Projection,
ProjectionSubPrefs {
    public static final double[] n = new double[]{0.6691500006885269, 0.682018118346418, 0.6946784863203991, 0.7071272481559119, 0.7193606118567315, 0.7313748510399917, 0.7431663060711892, 0.7547313851789208, 0.7660665655489937};
    public static final double[] c = new double[]{1.215363305807804E7, 1.2050261119223533E7, 1.195716926884592E7, 1.18737533925172E7, 1.1799460698022118E7, 1.17337838820243E7, 1.16762559948139E7, 1.1626445901183508E7, 1.1583954251630554E7};
    public static final double Xs = 1700000.0;
    public static final double[] Ys = new double[]{8293467.503439436, 9049604.665107645, 9814691.693461388, 1.0588107871787189E7, 1.1369285637569271E7, 1.2157704903382052E7, 1.2952888086405803E7, 1.3754395745267643E7, 1.4561822739114787E7};
    public static final double lg0 = 0.04079234433198;
    public static final double epsilon = 1.0E-12;
    public static final double cMaxLatZonesRadian = Math.toRadians(51.1);
    public static final double cMinLatZonesDegree = 41.0;
    public static final double cMinLatZonesRadian = Math.toRadians(41.0);
    public static final double cMinLonZonesRadian = Math.toRadians(-5.0);
    public static final double cMaxLonZonesRadian = Math.toRadians(10.2);
    public static final double lambda0 = Math.toRadians(3.0);
    public static final double e = Ellipsoid.GRS80.e;
    public static final double e2 = Ellipsoid.GRS80.e2;
    public static final double a = Ellipsoid.GRS80.a;
    public static final double cMaxOverlappingZones = 1.5;
    public static final int DEFAULT_ZONE = 0;
    private static int layoutZone = 0;
    private static String[] lambert9zones = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, 41, 43), I18n.tr("{0} ({1} to {2} degrees)", 2, 42, 44), I18n.tr("{0} ({1} to {2} degrees)", 3, 43, 45), I18n.tr("{0} ({1} to {2} degrees)", 4, 44, 46), I18n.tr("{0} ({1} to {2} degrees)", 5, 45, 47), I18n.tr("{0} ({1} to {2} degrees)", 6, 46, 48), I18n.tr("{0} ({1} to {2} degrees)", 7, 47, 49), I18n.tr("{0} ({1} to {2} degrees)", 8, 48, 50), I18n.tr("{0} ({1} to {2} degrees)", 9, 49, 51)};

    private double L(double phi, double e) {
        double sinphi = Math.sin(phi);
        return 0.5 * Math.log((1.0 + sinphi) / (1.0 - sinphi)) - e / 2.0 * Math.log((1.0 + e * sinphi) / (1.0 - e * sinphi));
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon p) {
        double lt = Math.toRadians(p.lat());
        double lg = Math.toRadians(p.lon());
        if (lt >= cMinLatZonesRadian && lt <= cMaxLatZonesRadian && lg >= cMinLonZonesRadian && lg <= cMaxLonZonesRadian) {
            return this.ConicProjection(lt, lg, layoutZone);
        }
        return this.ConicProjection(lt, lg, 0);
    }

    private EastNorth ConicProjection(double lat, double lon, int nz) {
        double R = c[nz] * Math.exp(-n[nz] * this.L(lat, e));
        double gamma = n[nz] * (lon - lambda0);
        double X = 1700000.0 + R * Math.sin(gamma);
        double Y = Ys[nz] + -R * Math.cos(gamma);
        return new EastNorth(X, Y);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth p) {
        return this.Geographic(p, layoutZone);
    }

    private LatLon Geographic(EastNorth ea, int nz) {
        double R = Math.sqrt(Math.pow(ea.getX() - 1700000.0, 2.0) + Math.pow(ea.getY() - Ys[nz], 2.0));
        double gamma = Math.atan((ea.getX() - 1700000.0) / (Ys[nz] - ea.getY()));
        double lon = lambda0 + gamma / n[nz];
        double latIso = -1.0 / n[nz] * Math.log(Math.abs(R / c[nz]));
        double lat = Ellipsoid.GRS80.latitude(latIso, e, 1.0E-12);
        return new LatLon(Math.toDegrees(lat), Math.toDegrees(lon));
    }

    @Override
    public String toString() {
        return I18n.tr("Lambert CC9 Zone (France)");
    }

    public static int north2ZoneNumber(double north) {
        int nz = (int)(north / 1000000.0) - 1;
        if (nz < 0) {
            return 0;
        }
        if (nz > 8) {
            return 8;
        }
        return nz;
    }

    @Override
    public String toCode() {
        return "EPSG:" + (3942 + layoutZone);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + layoutZone;
    }

    @Override
    public String getCacheDirectoryName() {
        return "lambert";
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        double medLatZone = 41.0 + (double)(layoutZone + 1);
        return new Bounds(new LatLon(Math.max(medLatZone - 1.0 - 1.5, 41.0), -4.9), new LatLon(Math.min(medLatZone + 1.0 + 1.5, Math.toDegrees(cMaxLatZonesRadian)), 10.2));
    }

    public int getLayoutZone() {
        return layoutZone;
    }

    @Override
    public void setupPreferencePanel(JPanel p) {
        JComboBox<String> prefcb = new JComboBox<String>(lambert9zones);
        prefcb.setSelectedIndex(layoutZone);
        p.setLayout(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Lambert CC Zone")), GBC.std().insets(5, 5, 0, 5));
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        p.add(prefcb, GBC.eop().fill(2));
        p.add((Component)new JLabel(ImageProvider.get("data/projection", "LambertCC9Zones.png")), GBC.eol().fill(2));
        p.add(GBC.glue(1, 1), GBC.eol().fill(1));
    }

    @Override
    public Collection<String> getPreferences(JPanel p) {
        Component prefcb = p.getComponent(2);
        if (!(prefcb instanceof JComboBox)) {
            return null;
        }
        layoutZone = ((JComboBox)prefcb).getSelectedIndex();
        return Collections.singleton(Integer.toString(layoutZone + 1));
    }

    @Override
    public void setPreferences(Collection<String> args) {
        layoutZone = 0;
        if (args != null) {
            try {
                String s;
                Iterator<String> i$ = args.iterator();
                if (i$.hasNext() && ((layoutZone = Integer.parseInt(s = i$.next()) - 1) < 0 || layoutZone > 8)) {
                    layoutZone = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        if (code.startsWith("EPSG:39") && code.length() == 9) {
            try {
                String zonestring = code.substring(5, 4);
                int zoneval = Integer.parseInt(zonestring) - 3942;
                if (zoneval >= 0 && zoneval <= 8) {
                    return Collections.singleton(zonestring);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

