/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User {
    private static AtomicLong uidCounter = new AtomicLong();
    private static HashMap<Long, User> userMap = new HashMap();
    private final HashSet<String> names = new HashSet();
    private final long uid;

    private static long getNextLocalUid() {
        return uidCounter.decrementAndGet();
    }

    public static User createLocalUser(String name) {
        for (long i = -1L; i >= uidCounter.get(); --i) {
            User olduser = User.getById(i);
            if (olduser == null || !olduser.hasName(name)) continue;
            return olduser;
        }
        User user = new User(User.getNextLocalUid(), name);
        userMap.put(user.getId(), user);
        return user;
    }

    public static User createOsmUser(long uid, String name) {
        User user = userMap.get(uid);
        if (user == null) {
            user = new User(uid, name);
            userMap.put(user.getId(), user);
        }
        user.addName(name);
        return user;
    }

    public static void clearUserMap() {
        userMap.clear();
    }

    public static User getById(long uid) {
        return userMap.get(uid);
    }

    public static List<User> getByName(String name) {
        if (name == null) {
            name = "";
        }
        ArrayList<User> ret = new ArrayList<User>();
        for (User user : userMap.values()) {
            if (!user.hasName(name)) continue;
            ret.add(user);
        }
        return ret;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.names) {
            sb.append(name);
            sb.append('/');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public ArrayList<String> getNames() {
        return new ArrayList<String>(this.names);
    }

    public void addName(String name) {
        this.names.add(name);
    }

    public boolean hasName(String name) {
        return this.names.contains(name);
    }

    public long getId() {
        return this.uid;
    }

    private User(long uid, String name) {
        this.uid = uid;
        if (name != null) {
            this.addName(name);
        }
    }

    public boolean isOsmUser() {
        return this.uid > 0L;
    }

    public boolean isLocalUser() {
        return this.uid < 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return this.uid == other.uid;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("id:" + this.uid);
        if (this.names.size() == 1) {
            s.append(" name:" + this.getName());
        } else if (this.names.size() > 1) {
            s.append(String.format(" %d names:%s", this.names.size(), this.getName()));
        }
        return s.toString();
    }
}

