/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeAction
extends JosmAction {
    protected OsmDataLayer layer;
    JCheckBox cbClearUndoRedo;
    protected Set<OsmPrimitive> toPurge;
    protected Set<OsmPrimitive> toPurgeChecked;
    protected Set<OsmPrimitive> makeIncomplete;
    protected List<OsmPrimitive> toPurgeAdditionally;

    public PurgeAction() {
        super(I18n.tr("Purge..."), "purge", I18n.tr("Forget objects but do not delete them on server when uploading."), Shortcut.registerShortcut("system:purge", I18n.tr("Edit: {0}", I18n.tr("Purge")), 80, 2, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/Purge"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> sel = this.getCurrentDataSet().getSelected();
        this.layer = Main.map.mapView.getEditLayer();
        this.toPurge = new HashSet<OsmPrimitive>(sel);
        this.toPurgeAdditionally = new ArrayList<OsmPrimitive>();
        this.toPurgeChecked = new HashSet<OsmPrimitive>();
        while (!this.toPurge.isEmpty()) {
            OsmPrimitive osm = this.toPurge.iterator().next();
            for (OsmPrimitive parent : osm.getReferrers()) {
                if (this.toPurge.contains(parent) || this.toPurgeChecked.contains(parent) || !(parent instanceof Way) && (!(parent instanceof Relation) || !osm.isNew())) continue;
                this.toPurgeAdditionally.add(parent);
                this.toPurge.add(parent);
            }
            this.toPurge.remove(osm);
            this.toPurgeChecked.add(osm);
        }
        this.makeIncomplete = new HashSet<OsmPrimitive>();
        block2: for (OsmPrimitive child : this.toPurgeChecked) {
            if (child.isNew()) continue;
            for (OsmPrimitive parent : child.getReferrers()) {
                if (!(parent instanceof Relation) || this.toPurgeChecked.contains(parent)) continue;
                this.makeIncomplete.add(child);
                continue block2;
            }
        }
        if (Main.pref.getBoolean("purge.add_untagged_waynodes", true)) {
            HashSet<Node> wayNodes = new HashSet<Node>();
            for (OsmPrimitive osm : this.toPurgeChecked) {
                if (!(osm instanceof Way)) continue;
                Way w = (Way)osm;
                block5: for (Node n : w.getNodes()) {
                    if (n.isTagged() || this.toPurgeChecked.contains(n)) continue;
                    for (OsmPrimitive ref : n.getReferrers()) {
                        if (ref == w || this.toPurgeChecked.contains(ref)) continue;
                        continue block5;
                    }
                    wayNodes.add(n);
                }
            }
            this.toPurgeChecked.addAll(wayNodes);
            this.toPurgeAdditionally.addAll(wayNodes);
        }
        boolean modified = false;
        for (OsmPrimitive osm : this.toPurgeChecked) {
            if (!osm.isModified()) continue;
            modified = true;
            break;
        }
        ExtendedDialog confirmDlg = new ExtendedDialog(Main.parent, I18n.tr("Confirm Purging"), new String[]{I18n.tr("Purge"), I18n.tr("Cancel")});
        confirmDlg.setContent(this.buildPanel(modified), false);
        confirmDlg.setButtonIcons(new String[]{"ok", "cancel"});
        int answer = confirmDlg.showDialog().getValue();
        if (answer != 1) {
            return;
        }
        Main.pref.put("purge.clear_undo_redo", this.cbClearUndoRedo.isSelected());
        Main.main.undoRedo.add(new PurgeCommand(Main.map.mapView.getEditLayer(), this.toPurgeChecked, this.makeIncomplete));
        if (this.cbClearUndoRedo.isSelected()) {
            Main.main.undoRedo.clean();
            Main.map.selectionListDialog.clearSelectionHistory();
        }
    }

    private JPanel buildPanel(boolean modified) {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.add(Box.createRigidArea(new Dimension(400, 0)), GBC.eol().fill(2));
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel("<html>" + I18n.tr("This operation makes JOSM forget the selected objects.<br> They will be removed from the layer, but <i>not</i> deleted<br> on the server when uploading.") + "</html>", ImageProvider.get("purge"), 2), GBC.eol().fill(2));
        if (!this.toPurgeAdditionally.isEmpty()) {
            pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            pnl.add((Component)new JLabel("<html>" + I18n.tr("The following dependent objects will be purged<br> in addition to the selected objects:") + "</html>", ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
            Collections.sort(this.toPurgeAdditionally, new Comparator<OsmPrimitive>(){

                @Override
                public int compare(OsmPrimitive o1, OsmPrimitive o2) {
                    int type = o1.getType().compareTo(o2.getType());
                    if (type != 0) {
                        return -type;
                    }
                    return Long.valueOf(o1.getUniqueId()).compareTo(o2.getUniqueId());
                }
            });
            JList<OsmPrimitive> list = new JList<OsmPrimitive>(this.toPurgeAdditionally.toArray(new OsmPrimitive[0]));
            list.setCellRenderer(new OsmPrimitivRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    return super.getListCellRendererComponent(list, value, index, true, false);
                }
            });
            JScrollPane scroll = new JScrollPane(list);
            scroll.setPreferredSize(new Dimension(250, 300));
            scroll.setMinimumSize(new Dimension(250, 300));
            pnl.add((Component)scroll, GBC.std().fill(3).weight(0.0, 1.0));
            JButton addToSelection = new JButton(new AbstractAction(){
                {
                    this.putValue("ShortDescription", I18n.tr("Add to selection"));
                    this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
                }

                public void actionPerformed(ActionEvent e) {
                    PurgeAction.this.layer.data.addSelected(PurgeAction.this.toPurgeAdditionally);
                }
            });
            addToSelection.setMargin(new Insets(0, 0, 0, 0));
            pnl.add((Component)addToSelection, GBC.eol().anchor(16).weight(1.0, 1.0).insets(2, 0, 0, 3));
        }
        if (modified) {
            pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            pnl.add((Component)new JLabel("<html>" + I18n.tr("Some of the objects are modified.<br> Proceed, if these changes should be discarded.</html>"), ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
        }
        this.cbClearUndoRedo = new JCheckBox(I18n.tr("Clear Undo/Redo buffer"));
        this.cbClearUndoRedo.setSelected(Main.pref.getBoolean("purge.clear_undo_redo", false));
        pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        pnl.add((Component)this.cbClearUndoRedo, GBC.eol());
        return pnl;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!this.getCurrentDataSet().selectionEmpty());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

