/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class JpegSegmentReader {
    private final File _file;
    private final byte[] _data;
    private final InputStream _stream;
    private JpegSegmentData _segmentData;
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;
    public static final byte SEGMENT_APP0 = -32;
    public static final byte SEGMENT_APP1 = -31;
    public static final byte SEGMENT_APP2 = -30;
    public static final byte SEGMENT_APP3 = -29;
    public static final byte SEGMENT_APP4 = -28;
    public static final byte SEGMENT_APP5 = -27;
    public static final byte SEGMENT_APP6 = -26;
    public static final byte SEGMENT_APP7 = -25;
    public static final byte SEGMENT_APP8 = -24;
    public static final byte SEGMENT_APP9 = -23;
    public static final byte SEGMENT_APPA = -22;
    public static final byte SEGMENT_APPB = -21;
    public static final byte SEGMENT_APPC = -20;
    public static final byte SEGMENT_APPD = -19;
    public static final byte SEGMENT_APPE = -18;
    public static final byte SEGMENT_APPF = -17;
    public static final byte SEGMENT_SOI = -40;
    public static final byte SEGMENT_DQT = -37;
    public static final byte SEGMENT_DHT = -60;
    public static final byte SEGMENT_SOF0 = -64;
    public static final byte SEGMENT_COM = -2;

    public JpegSegmentReader(File file) throws JpegProcessingException {
        this._file = file;
        this._data = null;
        this._stream = null;
        this.readSegments();
    }

    public JpegSegmentReader(byte[] byArray) throws JpegProcessingException {
        this._file = null;
        this._data = byArray;
        this._stream = null;
        this.readSegments();
    }

    public JpegSegmentReader(InputStream inputStream) throws JpegProcessingException {
        this._stream = inputStream;
        this._file = null;
        this._data = null;
        this.readSegments();
    }

    public JpegSegmentReader(JpegSegmentData jpegSegmentData) {
        this._file = null;
        this._data = null;
        this._stream = null;
        this._segmentData = jpegSegmentData;
    }

    public byte[] readSegment(byte by) throws JpegProcessingException {
        return this.readSegment(by, 0);
    }

    public byte[] readSegment(byte by, int n) {
        return this._segmentData.getSegment(by, n);
    }

    public final int getSegmentCount(byte by) {
        return this._segmentData.getSegmentCount(by);
    }

    public final JpegSegmentData getSegmentData() {
        return this._segmentData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readSegments() throws JpegProcessingException {
        this._segmentData = new JpegSegmentData();
        BufferedInputStream bufferedInputStream = this.getJpegInputStream();
        try {
            int n = 0;
            if (!this.isValidJpegHeaderBytes(bufferedInputStream)) {
                throw new JpegProcessingException("not a jpeg file");
            }
            n += 2;
            while (true) {
                byte by;
                if (((by = (byte)(bufferedInputStream.read() & 0xFF)) & 0xFF) != 255) {
                    throw new JpegProcessingException("expected jpeg segment start identifier 0xFF at offset " + n + ", not 0x" + Integer.toHexString(by & 0xFF));
                }
                ++n;
                byte by2 = (byte)(bufferedInputStream.read() & 0xFF);
                ++n;
                byte[] byArray = new byte[2];
                bufferedInputStream.read(byArray, 0, 2);
                n += 2;
                int n2 = byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF;
                if ((n2 -= 2) > bufferedInputStream.available()) {
                    throw new JpegProcessingException("segment size would extend beyond file stream length");
                }
                if (n2 < 0) {
                    throw new JpegProcessingException("segment size would be less than zero");
                }
                byte[] byArray2 = new byte[n2];
                bufferedInputStream.read(byArray2, 0, n2);
                n += n2;
                if ((by2 & 0xFF) == 218) {
                    return;
                }
                if ((by2 & 0xFF) == 217) {
                    return;
                }
                this._segmentData.addSegment(by2, byArray2);
                continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new JpegProcessingException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new JpegProcessingException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
            }
        }
    }

    private BufferedInputStream getJpegInputStream() throws JpegProcessingException {
        InputStream inputStream;
        if (this._stream != null) {
            if (this._stream instanceof BufferedInputStream) {
                return (BufferedInputStream)this._stream;
            }
            return new BufferedInputStream(this._stream);
        }
        if (this._data == null) {
            try {
                inputStream = new FileInputStream(this._file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JpegProcessingException("Jpeg file does not exist", fileNotFoundException);
            }
        } else {
            inputStream = new ByteArrayInputStream(this._data);
        }
        return new BufferedInputStream(inputStream);
    }

    private boolean isValidJpegHeaderBytes(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        inputStream.read(byArray, 0, 2);
        return (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216;
    }
}

