/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import org.apache.tools.ant.BuildException;

public class IvyListModules
extends IvyTask {
    private String _organisation;
    private String _module;
    private String _branch = "*";
    private String _revision;
    private String _matcher = "exactOrRegexp";
    private String _property;
    private String _value;

    public String getMatcher() {
        return this._matcher;
    }

    public void setMatcher(String matcher) {
        this._matcher = matcher;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getProperty() {
        return this._property;
    }

    public void setProperty(String name) {
        this._property = name;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public String getBranch() {
        return this._branch;
    }

    public void setBranch(String branch) {
        this._branch = branch;
    }

    public void execute() throws BuildException {
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy findmodules");
        }
        if (this._module == null) {
            throw new BuildException("no module name provided for ivy findmodules");
        }
        if (this._revision == null) {
            throw new BuildException("no revision provided for ivy findmodules");
        }
        if (this._property == null) {
            throw new BuildException("no property provided for ivy findmodules");
        }
        if (this._value == null) {
            throw new BuildException("no value provided for ivy findmodules");
        }
        Ivy ivy = this.getIvyInstance();
        ModuleRevisionId[] mrids = ivy.listModules(ModuleRevisionId.newInstance(this._organisation, this._module, this._branch, this._revision), ivy.getMatcher(this._matcher));
        for (int i = 0; i < mrids.length; ++i) {
            String name = IvyPatternHelper.substitute(ivy.substitute(this._property), mrids[i]);
            String value = IvyPatternHelper.substitute(ivy.substitute(this._value), mrids[i]);
            this.getProject().setProperty(name, value);
        }
    }
}

