/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;

public class AudioInputStream
extends InputStream {
    protected AudioFormat format;
    protected long frameLength;
    protected long framePos;
    protected int frameSize;
    private InputStream input;
    private long markedFramePos;

    public AudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l) {
        this.format = audioFormat;
        this.frameLength = l;
        this.framePos = 0L;
        this.frameSize = audioFormat.getFrameSize();
        this.input = inputStream;
    }

    public AudioInputStream(TargetDataLine targetDataLine) {
        this(new TargetInputStream(targetDataLine), targetDataLine.getFormat(), -1);
    }

    public int available() throws IOException {
        int n = this.input.available();
        if (this.frameSize != -1) {
            n -= n % this.frameSize;
        }
        return n;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public void mark(int n) {
        this.input.mark(n);
        this.markedFramePos = this.framePos;
    }

    public boolean markSupported() {
        return this.input.markSupported();
    }

    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("frame size must be 1 for read()");
        }
        int n = this.framePos == this.frameLength ? -1 : this.input.read();
        if (n != -1) {
            ++this.framePos;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.framePos == this.frameLength) {
            n3 = -1;
        } else {
            int n4;
            int n5 = this.frameSize == -1 ? 1 : this.frameSize;
            n2 -= n2 % n5;
            for (n3 = 0; n3 == 0 || n3 % n5 != 0; n3 += n4) {
                n4 = this.input.read(byArray, n, n2);
                if (n4 >= 0) continue;
                if (n3 == 0) {
                    return -1;
                }
                n3 -= n3 % n5;
                break;
            }
            this.framePos += (long)(n3 / n5);
        }
        return n3;
    }

    public void reset() throws IOException {
        this.input.reset();
        this.framePos = this.markedFramePos;
    }

    public long skip(long l) throws IOException {
        if (this.frameSize != -1) {
            l -= l % (long)this.frameSize;
        }
        long l2 = this.input.skip(l);
        if (this.frameSize != -1) {
            this.framePos += l2 / (long)this.frameSize;
        }
        return l2;
    }

    private static class TargetInputStream
    extends InputStream {
        private TargetDataLine line;
        private byte[] buf;

        public TargetInputStream(TargetDataLine targetDataLine) {
            this.line = targetDataLine;
        }

        public synchronized int read() throws IOException {
            int n;
            if (this.buf == null) {
                this.buf = new byte[1];
            }
            if ((n = this.read(this.buf, 0, 1)) < 0) {
                return -1;
            }
            return this.buf[0];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.line.read(byArray, n, n2);
        }
    }
}

