/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.ssl;

import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SslRMIServerSocketFactory
implements RMIServerSocketFactory {
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private boolean needClientAuth;
    private static SSLServerSocketFactory socketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();

    public SslRMIServerSocketFactory() {
        this.enabledProtocols = null;
        this.enabledCipherSuites = null;
        this.needClientAuth = false;
    }

    public SslRMIServerSocketFactory(String[] stringArray, String[] stringArray2, boolean bl) {
        this.enabledCipherSuites = stringArray;
        this.enabledProtocols = stringArray2;
        this.needClientAuth = bl;
        try {
            if (stringArray2 != null || stringArray != null) {
                this.createServerSocket(0);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)socketFactory.createServerSocket(n);
        if (this.enabledCipherSuites != null) {
            sSLServerSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            sSLServerSocket.setEnabledProtocols(this.enabledProtocols);
        }
        sSLServerSocket.setNeedClientAuth(this.needClientAuth);
        return sSLServerSocket;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SslRMIServerSocketFactory)) {
            return false;
        }
        SslRMIServerSocketFactory sslRMIServerSocketFactory = (SslRMIServerSocketFactory)object;
        if (this.needClientAuth != sslRMIServerSocketFactory.needClientAuth) {
            return false;
        }
        if (!SslRMIServerSocketFactory.cmpStrArray(this.enabledCipherSuites, sslRMIServerSocketFactory.enabledCipherSuites)) {
            return false;
        }
        return SslRMIServerSocketFactory.cmpStrArray(this.enabledProtocols, sslRMIServerSocketFactory.enabledProtocols);
    }

    static boolean cmpStrArray(String[] stringArray, String[] stringArray2) {
        if ((stringArray == null || stringArray2 == null) && stringArray != stringArray2) {
            return false;
        }
        if (stringArray != null) {
            if (stringArray.length != stringArray2.length) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(stringArray2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String[] getEnabledCipherSuites() {
        if (this.enabledCipherSuites == null) {
            return null;
        }
        return (String[])this.enabledCipherSuites.clone();
    }

    public String[] getEnabledProtocols() {
        if (this.enabledProtocols == null) {
            return null;
        }
        return (String[])this.enabledProtocols.clone();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        if (this.enabledCipherSuites != null) {
            for (n = 0; n < this.enabledCipherSuites.length; ++n) {
                n2 ^= this.enabledCipherSuites[n].hashCode();
            }
        }
        if (this.enabledProtocols != null) {
            for (n = 0; n < this.enabledProtocols.length; ++n) {
                n2 ^= this.enabledProtocols[n].hashCode();
            }
        }
        n2 = this.needClientAuth ? n2 ^ 0xFFFF : n2;
        return n2;
    }
}

