/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.IntersectingDomainCombiner;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.VMAccessControlState;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.LinkedList;

final class VMAccessController {
    private static final AccessControlContext DEFAULT_CONTEXT;
    private static final boolean DEBUG = false;

    private static void debug(String string) {
        System.err.print(">>> VMAccessController: ");
        System.err.println(string);
    }

    private VMAccessController() {
    }

    static void pushContext(AccessControlContext accessControlContext) {
        VMAccessControlState vMAccessControlState = VMAccessControlState.getThreadState();
        if (vMAccessControlState == null) {
            return;
        }
        LinkedList linkedList = vMAccessControlState.getContexts();
        linkedList.addFirst(accessControlContext);
    }

    static void popContext() {
        block1: {
            VMAccessControlState vMAccessControlState = VMAccessControlState.getThreadState();
            if (vMAccessControlState == null) {
                return;
            }
            LinkedList linkedList = vMAccessControlState.getContexts();
            if (linkedList.isEmpty()) break block1;
            linkedList.removeFirst();
        }
    }

    static AccessControlContext getContext() {
        Object object;
        VMAccessControlState vMAccessControlState = VMAccessControlState.getThreadState();
        if (vMAccessControlState == null) {
            return DEFAULT_CONTEXT;
        }
        if (vMAccessControlState.isInGetContext()) {
            return DEFAULT_CONTEXT;
        }
        vMAccessControlState.setInGetContext(true);
        Object[] objectArray = VMAccessController.getStack();
        Class[] classArray = (Class[])objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        AccessControlContext accessControlContext = null;
        for (int i = 3; i < classArray.length; ++i) {
            Object object2;
            object = classArray[i];
            if (bl && i == classArray.length - 2 && !((AbstractCollection)(object2 = vMAccessControlState.getContexts())).isEmpty()) {
                accessControlContext = (AccessControlContext)((LinkedList)object2).getFirst();
            }
            if ((object2 = ((Class)object).getProtectionDomain()) == null || hashSet2.contains(object2)) continue;
            hashSet2.add(object2);
            hashSet.add(new ProtectionDomain(((ProtectionDomain)object2).getCodeSource(), ((ProtectionDomain)object2).getPermissions()));
        }
        ProtectionDomain[] protectionDomainArray = (ProtectionDomain[])hashSet.toArray(new ProtectionDomain[hashSet.size()]);
        accessControlContext = accessControlContext != null ? ((object = accessControlContext.getDomainCombiner()) == null ? new AccessControlContext(IntersectingDomainCombiner.SINGLETON.combine(protectionDomainArray, accessControlContext.getProtectionDomains())) : new AccessControlContext(protectionDomainArray, accessControlContext, (DomainCombiner)object)) : new AccessControlContext(protectionDomainArray);
        vMAccessControlState.setInGetContext(false);
        return accessControlContext;
    }

    private static native Object[] getStack();

    static {
        CodeSource codeSource = new CodeSource(null, null);
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{new ProtectionDomain(codeSource, permissions)};
        DEFAULT_CONTEXT = new AccessControlContext(protectionDomainArray);
    }
}

