/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferFloat
extends DataBuffer {
    private float[] data;
    private float[][] bankData;

    public DataBufferFloat(int n) {
        super(4, n, 1, 0);
        this.bankData = new float[1][];
        this.data = new float[n];
        this.bankData[0] = this.data;
    }

    public DataBufferFloat(int n, int n2) {
        super(4, n, n2);
        this.bankData = new float[n2][n];
        this.data = this.bankData[0];
    }

    public DataBufferFloat(float[] fArray, int n) {
        super(4, n, 1, 0);
        this.bankData = new float[1][];
        this.data = fArray;
        this.bankData[0] = this.data;
    }

    public DataBufferFloat(float[] fArray, int n, int n2) {
        super(4, n, 1, n2);
        this.bankData = new float[1][];
        this.data = fArray;
        this.bankData[0] = this.data;
    }

    public DataBufferFloat(float[][] fArray, int n) {
        super(4, n, fArray.length);
        this.bankData = fArray;
        this.data = this.bankData[0];
    }

    public DataBufferFloat(float[][] fArray, int n, int[] nArray) {
        super(4, n, fArray.length, nArray);
        this.bankData = fArray;
        this.data = this.bankData[0];
    }

    public float[] getData() {
        return this.data;
    }

    public float[] getData(int n) {
        return this.bankData[n];
    }

    public float[][] getBankData() {
        return this.bankData;
    }

    public int getElem(int n) {
        return (int)this.data[n + this.offset];
    }

    public int getElem(int n, int n2) {
        return (int)this.bankData[n][n2 + this.offsets[n]];
    }

    public void setElem(int n, int n2) {
        this.data[n + this.offset] = n2;
    }

    public void setElem(int n, int n2, int n3) {
        this.bankData[n][n2 + this.offsets[n]] = n3;
    }

    public float getElemFloat(int n) {
        return this.data[n + this.offset];
    }

    public float getElemFloat(int n, int n2) {
        return this.bankData[n][n2 + this.offsets[n]];
    }

    public void setElemFloat(int n, float f) {
        this.data[n + this.offset] = f;
    }

    public void setElemFloat(int n, int n2, float f) {
        this.bankData[n][n2 + this.offsets[n]] = f;
    }

    public double getElemDouble(int n) {
        return this.getElemFloat(n);
    }

    public double getElemDouble(int n, int n2) {
        return this.getElemFloat(n, n2);
    }

    public void setElemDouble(int n, double d) {
        this.setElemFloat(n, (float)d);
    }

    public void setElemDouble(int n, int n2, double d) {
        this.setElemFloat(n, n2, (float)d);
    }
}

