/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.pipeline.TeeConsumer;
import gnu.xml.pipeline.TextConsumer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class PipelineFactory {
    private String[] tokens;
    private int index;
    private static final String[][] builtinStages = new String[][]{{"dom", "gnu.xml.dom.Consumer"}, {"nsfix", "gnu.xml.pipeline.NSFilter"}, {"null", "gnu.xml.pipeline.EventFilter"}, {"server", "gnu.xml.pipeline.CallFilter"}, {"tee", "gnu.xml.pipeline.TeeConsumer"}, {"validate", "gnu.xml.pipeline.ValidationConsumer"}, {"wf", "gnu.xml.pipeline.WellFormednessFilter"}, {"xinclude", "gnu.xml.pipeline.XIncludeFilter"}, {"xslt", "gnu.xml.pipeline.XsltFilter"}};

    public static EventConsumer createPipeline(String string) throws IOException {
        return PipelineFactory.createPipeline(string, null);
    }

    public static EventConsumer createPipeline(String string, EventConsumer eventConsumer) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        PipelineFactory pipelineFactory = new PipelineFactory();
        Pipeline pipeline = pipelineFactory.parsePipeline(stringArray, eventConsumer);
        return pipeline.createPipeline();
    }

    private PipelineFactory() {
    }

    public static EventConsumer createPipeline(String[] stringArray, EventConsumer eventConsumer) throws IOException {
        PipelineFactory pipelineFactory = new PipelineFactory();
        Pipeline pipeline = pipelineFactory.parsePipeline(stringArray, eventConsumer);
        return pipeline.createPipeline();
    }

    private Pipeline parsePipeline(String[] stringArray, EventConsumer eventConsumer) {
        this.tokens = stringArray;
        this.index = 0;
        Pipeline pipeline = this.parsePipeline(eventConsumer);
        if (this.index != stringArray.length) {
            throw new ArrayIndexOutOfBoundsException("extra token: " + this.tokens[this.index]);
        }
        return pipeline;
    }

    private Pipeline parsePipeline(EventConsumer eventConsumer) {
        Pipeline pipeline = new Pipeline(this.parseStage());
        if (this.index > this.tokens.length - 2 || !"|".equals(this.tokens[this.index])) {
            pipeline.next = eventConsumer;
            return pipeline;
        }
        ++this.index;
        pipeline.rest = this.parsePipeline(eventConsumer);
        return pipeline;
    }

    private Stage parseStage() {
        Stage stage = new Stage(this.tokens[this.index++]);
        if (this.index > this.tokens.length - 2 || !"(".equals(this.tokens[this.index])) {
            return stage;
        }
        ++this.index;
        stage.param = this.parsePipeline(null);
        if (this.index >= this.tokens.length) {
            throw new ArrayIndexOutOfBoundsException("missing right paren");
        }
        if (!")".equals(this.tokens[this.index++])) {
            throw new ArrayIndexOutOfBoundsException("required right paren, not: " + this.tokens[this.index - 1]);
        }
        return stage;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Pipeline {
        Stage stage;
        Pipeline rest;
        EventConsumer next;

        Pipeline(Stage stage) {
            this.stage = stage;
        }

        public String toString() {
            if (this.rest == null && this.next == null) {
                return this.stage.toString();
            }
            if (this.rest != null) {
                return this.stage + " | " + this.rest;
            }
            throw new IllegalArgumentException("next");
        }

        EventConsumer createPipeline() throws IOException {
            if (this.next == null) {
                this.next = this.rest == null ? this.stage.createStage(null) : this.stage.createStage(this.rest.createPipeline());
            }
            return this.next;
        }
    }

    private static class Stage {
        String id;
        Pipeline param;

        Stage(String string) {
            this.id = string;
        }

        public String toString() {
            if (this.param == null) {
                return this.id;
            }
            return this.id + " ( " + this.param + " )";
        }

        private void fail(String string) throws IOException {
            throw new IOException("in '" + this.id + "' stage of pipeline, " + string);
        }

        EventConsumer createStage(EventConsumer eventConsumer) throws IOException {
            int n;
            String string = this.id;
            for (n = 0; n < builtinStages.length; ++n) {
                if (!this.id.equals(builtinStages[n][0])) continue;
                string = builtinStages[n][1];
                break;
            }
            if ("write".equals(string) || "xhtml".equals(string)) {
                String string2;
                n = "xhtml".equals(string) ? 1 : 0;
                OutputStream outputStream = null;
                if (this.param == null) {
                    this.fail("parameter is required");
                }
                if ("stdout".equals(string2 = this.param.toString())) {
                    outputStream = System.out;
                } else if ("stderr".equals(string2)) {
                    outputStream = System.err;
                } else {
                    File file = new File(string2);
                    if (file.exists()) {
                        this.fail("file already exists: " + file.getName());
                    }
                    outputStream = new FileOutputStream(file);
                }
                TextConsumer textConsumer = n == 0 ? new TextConsumer(outputStream) : new TextConsumer((Writer)new OutputStreamWriter(outputStream, "8859_1"), true);
                textConsumer.setPrettyPrinting(true);
                if (eventConsumer == null) {
                    return textConsumer;
                }
                return new TeeConsumer(textConsumer, eventConsumer);
            }
            Object object = null;
            try {
                Object object2;
                Class clazz = Class.forName(string);
                Class[] classArray = null;
                Constructor constructor = null;
                boolean bl = false;
                Object[] objectArray = null;
                Object object3 = null;
                if (eventConsumer != null) {
                    if (this.param == null) {
                        classArray = new Class[]{PipelineFactory.class$("gnu.xml.pipeline.EventConsumer")};
                        objectArray = new Object[]{eventConsumer};
                        object = "no-param filter";
                    } else {
                        classArray = new Class[]{PipelineFactory.class$("java.lang.String"), PipelineFactory.class$("gnu.xml.pipeline.EventConsumer")};
                        objectArray = new Object[]{this.param.toString(), eventConsumer};
                        object = "one-param filter";
                    }
                    try {
                        constructor = clazz.getConstructor(classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        bl = true;
                        object = (String)object + " built from ";
                    }
                }
                if (constructor == null) {
                    if (this.param == null) {
                        classArray = new Class[]{};
                        objectArray = new Object[]{};
                        object2 = "no-param terminus";
                    } else {
                        classArray = new Class[]{PipelineFactory.class$("java.lang.String")};
                        objectArray = new Object[]{this.param.toString()};
                        object2 = "one-param terminus";
                    }
                    object = object == null ? object2 : (String)object + (String)object2;
                    constructor = clazz.getConstructor(classArray);
                }
                if ((object3 = constructor.newInstance(objectArray)) instanceof EventConsumer) {
                    if (bl) {
                        return new TeeConsumer((EventConsumer)object3, eventConsumer);
                    }
                    return (EventConsumer)object3;
                }
                object2 = new EventFilter();
                boolean bl2 = false;
                if (object3 instanceof ContentHandler) {
                    ((EventFilter)object2).setContentHandler((ContentHandler)object3);
                    bl2 = true;
                }
                if (object3 instanceof DTDHandler) {
                    ((EventFilter)object2).setDTDHandler((DTDHandler)object3);
                    bl2 = true;
                }
                if (object3 instanceof LexicalHandler) {
                    ((EventFilter)object2).setProperty("http://xml.org/sax/properties/lexical-handler", object3);
                    bl2 = true;
                }
                if (object3 instanceof DeclHandler) {
                    ((EventFilter)object2).setProperty("http://xml.org/sax/properties/declaration-handler", object3);
                    bl2 = true;
                }
                if (!bl2) {
                    this.fail("class is neither Consumer nor Handler");
                }
                if (bl) {
                    return new TeeConsumer((EventConsumer)object2, eventConsumer);
                }
                return object2;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.fail(string + " constructor missing -- " + object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.fail(string + " class not found");
            }
            catch (Exception exception) {
                this.fail("stage not available: " + exception.getMessage());
            }
            return null;
        }
    }
}

