/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

public class DCT {
    public double[][] c;
    public double[][] cT;

    private /* synthetic */ void finit$() {
        this.c = new double[8][8];
        this.cT = new double[8][8];
    }

    public DCT() {
        this.finit$();
        this.initMatrix();
    }

    public static double C(int n) {
        if (n == 0) {
            return 1.0 / Math.sqrt(2.0);
        }
        return 1.0;
    }

    private void initMatrix() {
        int n;
        for (n = 0; n < 8; ++n) {
            double d = 8.0;
            this.c[0][n] = 1.0 / Math.sqrt(d);
            this.cT[n][0] = this.c[0][n];
        }
        for (n = 1; n < 8; ++n) {
            for (int i = 0; i < 8; ++i) {
                double d = i;
                double d2 = n;
                this.c[n][i] = Math.sqrt(0.25) * Math.cos((2.0 * d + 1.0) * d2 * Math.PI / 16.0);
                this.cT[i][n] = this.c[n][i];
            }
        }
    }

    public static double[][] slow_idct(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                double d = 0.0;
                for (double d2 = 0.0; d2 < 8.0; d2 += 1.0) {
                    double d3 = 0.0;
                    for (double d4 = 0.0; d4 < 8.0; d4 += 1.0) {
                        d3 += DCT.C((int)d4) / 2.0 * dArray[(int)d2][(int)d4] * Math.cos((double)(2 * j + 1) * d4 * Math.PI / 16.0) * Math.cos((double)(2 * i + 1) * d2 * Math.PI / 16.0);
                    }
                    d += DCT.C((int)d2) / 2.0 * d3;
                }
                dArray2[i][j] = d + 128.0;
            }
        }
        return dArray2;
    }

    public static float[][] slow_fdct(float[][] fArray) {
        float[][] fArray2 = new float[8][8];
        for (int i = 0; i < 8; ++i) {
            int n = 0;
            while (n < 8) {
                fArray2[i][n] = 0.0f * (float)DCT.C(i) * (float)DCT.C(n);
                float f = 0.0f;
                for (int j = 0; j < 8; ++j) {
                    for (int k = 0; k < 8; ++k) {
                        f = (float)((double)f + (double)fArray[k][j] * Math.cos((double)((2 * j + 1) * i) * Math.PI / 16.0) * Math.cos((double)((2 * k + 1) * n) * Math.PI / 16.0));
                    }
                }
                float[] fArray3 = fArray2[i];
                int n2 = n++;
                fArray3[n2] = fArray3[n2] * f;
            }
        }
        return fArray2;
    }

    public float[][] fast_fdct(float[][] fArray) {
        int n;
        int n2;
        int n3;
        float[][] fArray2 = new float[8][8];
        double[][] dArray = new double[8][8];
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                dArray[n3][n2] = 0.0;
                for (n = 0; n < 8; ++n) {
                    double[] dArray2 = dArray[n3];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + (double)((int)fArray[n3][n] - 128) * this.cT[n][n2];
                }
            }
        }
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                double d = 0.0;
                for (n = 0; n < 8; ++n) {
                    d += this.c[n3][n] * dArray[n][n2];
                }
                fArray2[n3][n2] = (int)Math.round(d) * 8;
            }
        }
        return fArray2;
    }

    public double[][] fast_idct(double[][] dArray) {
        int n;
        int n2;
        int n3;
        double[][] dArray2 = new double[8][8];
        double[][] dArray3 = new double[8][8];
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                dArray3[n3][n2] = 0.0;
                for (n = 0; n < 8; ++n) {
                    double[] dArray4 = dArray3[n3];
                    int n4 = n2;
                    dArray4[n4] = dArray4[n4] + dArray[n3][n] * this.c[n][n2];
                }
            }
        }
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                double d = 0.0;
                for (n = 0; n < 8; ++n) {
                    d += this.cT[n3][n] * dArray3[n][n2];
                }
                dArray2[n3][n2] = (d += 128.0) < 0.0 ? 0.0 : (d > 255.0 ? 255.0 : (double)((int)Math.round(d)));
            }
        }
        return dArray2;
    }

    public double[][] idj_fast_fdct(float[][] fArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        int n;
        double[][] dArray = new double[8][8];
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i < 8; ++i) {
                dArray[n][i] = (double)fArray[n][i] - 128.0;
            }
        }
        for (n = 0; n < 8; ++n) {
            d19 = dArray[n][0] + dArray[n][7];
            d18 = dArray[n][0] - dArray[n][7];
            d17 = dArray[n][1] + dArray[n][6];
            d16 = dArray[n][1] - dArray[n][6];
            d15 = dArray[n][2] + dArray[n][5];
            d14 = dArray[n][2] - dArray[n][5];
            d13 = dArray[n][3] + dArray[n][4];
            d12 = dArray[n][3] - dArray[n][4];
            d11 = d19 + d13;
            d10 = d19 - d13;
            d9 = d17 + d15;
            d8 = d17 - d15;
            dArray[n][0] = d11 + d9;
            dArray[n][4] = d11 - d9;
            d7 = (d8 + d10) * 0.707106781;
            dArray[n][2] = d10 + d7;
            dArray[n][6] = d10 - d7;
            d11 = d12 + d14;
            d9 = d14 + d16;
            d8 = d16 + d18;
            d6 = (d11 - d8) * 0.382683433;
            d5 = 0.5411961 * d11 + d6;
            d4 = 1.306562965 * d8 + d6;
            d3 = d9 * 0.707106781;
            d2 = d18 + d3;
            d = d18 - d3;
            dArray[n][5] = d + d5;
            dArray[n][3] = d - d5;
            dArray[n][1] = d2 + d4;
            dArray[n][7] = d2 - d4;
        }
        for (n = 0; n < 8; ++n) {
            d19 = dArray[0][n] + dArray[7][n];
            d18 = dArray[0][n] - dArray[7][n];
            d17 = dArray[1][n] + dArray[6][n];
            d16 = dArray[1][n] - dArray[6][n];
            d15 = dArray[2][n] + dArray[5][n];
            d14 = dArray[2][n] - dArray[5][n];
            d13 = dArray[3][n] + dArray[4][n];
            d12 = dArray[3][n] - dArray[4][n];
            d11 = d19 + d13;
            d10 = d19 - d13;
            d9 = d17 + d15;
            d8 = d17 - d15;
            dArray[0][n] = d11 + d9;
            dArray[4][n] = d11 - d9;
            d7 = (d8 + d10) * 0.707106781;
            dArray[2][n] = d10 + d7;
            dArray[6][n] = d10 - d7;
            d11 = d12 + d14;
            d9 = d14 + d16;
            d8 = d16 + d18;
            d6 = (d11 - d8) * 0.382683433;
            d5 = 0.5411961 * d11 + d6;
            d4 = 1.306562965 * d8 + d6;
            d3 = d9 * 0.707106781;
            d2 = d18 + d3;
            d = d18 - d3;
            dArray[5][n] = d + d5;
            dArray[3][n] = d - d5;
            dArray[1][n] = d2 + d4;
            dArray[7][n] = d2 - d4;
        }
        return dArray;
    }
}

