/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.BaseKeyring;
import gnu.javax.crypto.keyring.CertificateEntry;
import gnu.javax.crypto.keyring.CompressedEntry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.IPublicKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PasswordAuthenticatedEntry;
import gnu.javax.crypto.keyring.Properties;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;

public class GnuPublicKeyring
extends BaseKeyring
implements IPublicKeyring {
    private static final Logger log = Logger.getLogger(GnuPublicKeyring.class$("gnu.javax.crypto.keyring.GnuPublicKeyring").getName());
    public static final int USAGE = 4;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public GnuPublicKeyring(String string, int n) {
        this.keyring = new PasswordAuthenticatedEntry(string, n, new Properties());
        this.keyring2 = new CompressedEntry(new Properties());
        this.keyring.add(this.keyring2);
    }

    public GnuPublicKeyring() {
    }

    public boolean containsCertificate(String string) {
        boolean bl = false;
        if (this.containsAlias(string)) {
            Iterator iterator = this.get(string).iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof CertificateEntry)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public Certificate getCertificate(String string) {
        Certificate certificate = null;
        if (this.containsAlias(string)) {
            Iterator iterator = this.get(string).iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (!(entry instanceof CertificateEntry)) continue;
                certificate = ((CertificateEntry)entry).getCertificate();
                break;
            }
        }
        return certificate;
    }

    public void putCertificate(String string, Certificate certificate) {
        block0: {
            if (this.containsCertificate(string)) break block0;
            Properties properties = new Properties();
            properties.put("alias", this.fixAlias(string));
            this.add(new CertificateEntry(certificate, new Date(), properties));
        }
    }

    protected void load(InputStream inputStream, char[] cArray) throws IOException {
        if (inputStream.read() != 4) {
            throw new MalformedKeyringException("incompatible keyring usage");
        }
        if (inputStream.read() != 3) {
            throw new MalformedKeyringException("expecting password-authenticated entry tag");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.keyring = PasswordAuthenticatedEntry.decode(dataInputStream, cArray);
    }

    protected void store(OutputStream outputStream, char[] cArray) throws IOException {
        outputStream.write(4);
        this.keyring.encode(new DataOutputStream(outputStream), cArray);
    }
}

