/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.prng;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import java.util.Map;

public class MDGenerator
extends BasePRNG
implements Cloneable {
    public static final String MD_NAME = "gnu.crypto.prng.md.hash.name";
    public static final String SEEED = "gnu.crypto.prng.md.seed";
    private IMessageDigest md;

    public MDGenerator() {
        super("md");
    }

    public void setup(Map map) {
        String string = (String)map.get(MD_NAME);
        if (string == null) {
            if (this.md == null) {
                this.md = HashFactory.getInstance("sha-160");
            } else {
                this.md.reset();
            }
        } else {
            this.md = HashFactory.getInstance(string);
        }
        byte[] byArray = (byte[])map.get(SEEED);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.md.update(byArray, 0, byArray.length);
    }

    public void fillBlock() throws LimitReachedException {
        IMessageDigest iMessageDigest = (IMessageDigest)this.md.clone();
        this.buffer = iMessageDigest.digest();
        this.md.update(this.buffer, 0, this.buffer.length);
    }

    public void addRandomByte(byte by) {
        if (this.md == null) {
            throw new IllegalStateException("not initialized");
        }
        this.md.update(by);
    }

    public void addRandomBytes(byte[] byArray, int n, int n2) {
        if (this.md == null) {
            throw new IllegalStateException("not initialized");
        }
        this.md.update(byArray, n, n2);
    }

    public Object clone() throws CloneNotSupportedException {
        MDGenerator mDGenerator = (MDGenerator)super.clone();
        if (this.md != null) {
            mDGenerator.md = (IMessageDigest)this.md.clone();
        }
        return mDGenerator;
    }
}

