/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.loader;

import gnu.java.net.loader.FileResource;
import gnu.java.net.loader.Resource;
import gnu.java.net.loader.URLLoader;
import gnu.java.net.loader.URLStreamHandlerCache;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.StringTokenizer;

public final class FileURLLoader
extends URLLoader {
    File dir;

    public FileURLLoader(URLClassLoader uRLClassLoader, URLStreamHandlerCache uRLStreamHandlerCache, URLStreamHandlerFactory uRLStreamHandlerFactory, URL uRL, URL uRL2) {
        super(uRLClassLoader, uRLStreamHandlerCache, uRLStreamHandlerFactory, uRL, uRL2);
        this.dir = new File(uRL2.getFile());
    }

    public Resource getResource(String string) {
        try {
            File file = this.walkPathComponents(string);
            if (file == null) {
                return null;
            }
            return new FileResource(this, file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private File walkPathComponents(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        File file = this.dir;
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n - 1; ++i) {
            String string2 = stringTokenizer.nextToken();
            if ("..".equals(string2) && file.equals(this.dir)) {
                return null;
            }
            if ((file = new File(file, string2)).exists() && file.isDirectory()) continue;
            return null;
        }
        if (n > 0) {
            String string3 = stringTokenizer.nextToken();
            if ("..".equals(string3) && file.equals(this.dir)) {
                return null;
            }
            if (!(file = new File(file, string3)).exists()) {
                return null;
            }
        }
        return file.getCanonicalFile();
    }
}

