/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyScript;

public class BecomeWorkingCopyOperation
extends RubyModelOperation {
    private IProblemRequestor problemRequestor;

    public BecomeWorkingCopyOperation(RubyScript rubyScript, IProblemRequestor iProblemRequestor) {
        super(new IRubyElement[]{rubyScript});
        this.problemRequestor = iProblemRequestor;
    }

    protected void executeOperation() throws RubyModelException {
        RubyScript rubyScript = this.getWorkingCopy();
        RubyModelManager.getRubyModelManager().getPerWorkingCopyInfo(rubyScript, true, true, this.problemRequestor);
        rubyScript.openWhenClosed(rubyScript.createElementInfo(), this.progressMonitor);
        if (!rubyScript.isPrimary()) {
            RubyElementDelta rubyElementDelta = new RubyElementDelta(this.getRubyModel());
            rubyElementDelta.added(rubyScript);
            this.addDelta(rubyElementDelta);
        } else if (rubyScript.getResource().isAccessible()) {
            RubyElementDelta rubyElementDelta = new RubyElementDelta(this.getRubyModel());
            rubyElementDelta.changed(rubyScript, 65536);
            this.addDelta(rubyElementDelta);
        } else {
            RubyElementDelta rubyElementDelta = new RubyElementDelta(this.getRubyModel());
            rubyElementDelta.added(rubyScript, 65536);
            this.addDelta(rubyElementDelta);
        }
        this.resultElements = new IRubyElement[]{rubyScript};
    }

    protected RubyScript getWorkingCopy() {
        return (RubyScript)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

