/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;

public class TabExpander {
    private final int spacesPerTab;
    private String maxTabString;

    public TabExpander(int n) {
        this.spacesPerTab = n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.maxTabString = stringBuffer.toString();
    }

    public void expandTab(DocumentCommand documentCommand, IDocument iDocument) {
        try {
            int n = documentCommand.offset;
            int n2 = iDocument.getLineOfOffset(n);
            int n3 = n - iDocument.getLineOffset(n2);
            if (this.spacesPerTab > 0) {
                int n4 = this.spacesPerTab - n3 % this.spacesPerTab;
                documentCommand.text = this.maxTabString.substring(0, n4);
            } else {
                documentCommand.text = " ";
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public String getFullIndent() {
        return this.maxTabString;
    }
}

