/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.report;

import fr.jayasoft.ivy.ArtifactOrigin;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.License;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.ConfigurationResolveReport;
import fr.jayasoft.ivy.report.ReportOutputter;
import fr.jayasoft.ivy.report.ResolveReport;
import fr.jayasoft.ivy.util.FileUtil;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class XmlReportOutputter
implements ReportOutputter {
    public String getName() {
        return "xml";
    }

    public void output(ResolveReport report, File destDir) {
        String[] confs = report.getConfigurations();
        for (int i = 0; i < confs.length; ++i) {
            this.output(report.getConfigurationReport(confs[i]), confs, destDir);
        }
    }

    public void output(ConfigurationResolveReport report, File destDir) {
        this.output(report, new String[]{report.getConfiguration()}, destDir);
    }

    public void output(ConfigurationResolveReport report, String[] confs, File destDir) {
        try {
            destDir.mkdirs();
            File reportFile = new File(destDir, XmlReportOutputter.getReportFileName(report));
            FileOutputStream stream = new FileOutputStream(reportFile);
            this.output(report, confs, stream);
            ((OutputStream)stream).close();
            Message.verbose("\treport for " + report.getModuleDescriptor().getModuleRevisionId() + " " + report.getConfiguration() + " produced in " + reportFile);
            File reportXsl = new File(destDir, "ivy-report.xsl");
            File reportCss = new File(destDir, "ivy-report.css");
            if (!reportXsl.exists()) {
                FileUtil.copy(XmlReportOutputter.class.getResource("ivy-report.xsl"), reportXsl, null);
            }
            if (!reportCss.exists()) {
                FileUtil.copy(XmlReportOutputter.class.getResource("ivy-report.css"), reportCss, null);
            }
        }
        catch (IOException ex) {
            Message.error("impossible to produce report for " + report.getModuleDescriptor() + ": " + ex.getMessage());
        }
    }

    public void output(ConfigurationResolveReport report, OutputStream stream) {
        this.output(report, new String[]{report.getConfiguration()}, stream);
    }

    public void output(ConfigurationResolveReport report, String[] confs, OutputStream stream) {
        PrintWriter out = new PrintWriter(stream);
        ModuleRevisionId mrid = report.getModuleDescriptor().getModuleRevisionId();
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        out.println("<?xml-stylesheet type=\"text/xsl\" href=\"ivy-report.xsl\"?>");
        out.println("<ivy-report version=\"1.0\">");
        out.println("\t<info");
        out.println("\t\torganisation=\"" + mrid.getOrganisation() + "\"");
        out.println("\t\tmodule=\"" + mrid.getName() + "\"");
        out.println("\t\tconf=\"" + report.getConfiguration() + "\"");
        out.println("\t\tconfs=\"" + StringUtils.join(confs, ", ") + "\"");
        out.println("\t\tdate=\"" + Ivy.DATE_FORMAT.format(report.getDate()) + "\"/>");
        out.println("\t<dependencies>");
        ArrayList dependencies = new ArrayList(report.getModuleRevisionIds());
        Iterator iter = report.getModuleIds().iterator();
        while (iter.hasNext()) {
            ModuleId mid = (ModuleId)iter.next();
            out.println("\t\t<module organisation=\"" + mid.getOrganisation() + "\"" + " name=\"" + mid.getName() + "\"" + " resolver=\"" + report.getIvy().getResolverName(mid) + "\">");
            Iterator it2 = report.getNodes(mid).iterator();
            while (it2.hasNext()) {
                IvyNode.EvictionData ed;
                Collection selected;
                int i;
                IvyNode dep = (IvyNode)it2.next();
                ModuleDescriptor md = null;
                if (dep.getModuleRevision() != null) {
                    md = dep.getModuleRevision().getDescriptor();
                }
                StringBuffer details = new StringBuffer();
                if (dep.isLoaded()) {
                    details.append(" status=\"").append(dep.getDescriptor().getStatus()).append("\"").append(" pubdate=\"").append(Ivy.DATE_FORMAT.format(new Date(dep.getPublication()))).append("\"").append(" resolver=\"").append(dep.getModuleRevision().getResolver().getName()).append("\"").append(" artresolver=\"").append(dep.getModuleRevision().getArtifactResolver().getName()).append("\"");
                }
                if (dep.isEvicted(report.getConfiguration())) {
                    IvyNode.EvictionData ed2 = dep.getEvictedData(report.getConfiguration());
                    if (ed2.getConflictManager() != null) {
                        details.append(" evicted=\"").append(ed2.getConflictManager()).append("\"");
                    } else {
                        details.append(" evicted=\"transitive\"");
                    }
                }
                if (dep.hasProblem()) {
                    details.append(" error=\"").append(dep.getProblem().getMessage()).append("\"");
                }
                if (md != null && md.getHomePage() != null) {
                    details.append(" homepage=\"").append(md.getHomePage()).append("\"");
                }
                Map extraAttributes = md != null ? md.getExtraAttributes() : dep.getResolvedId().getExtraAttributes();
                Iterator iterator = extraAttributes.keySet().iterator();
                while (iterator.hasNext()) {
                    String attName = (String)iterator.next();
                    details.append(" extra-").append(attName).append("=\"").append(extraAttributes.get(attName)).append("\"");
                }
                String defaultValue = dep.getDescriptor() != null ? " default=\"" + dep.getDescriptor().isDefault() + "\"" : "";
                int position = dependencies.indexOf(dep.getResolvedId());
                out.println("\t\t\t<revision name=\"" + dep.getResolvedId().getRevision() + "\"" + (dep.getResolvedId().getBranch() == null ? "" : " branch=\"" + dep.getResolvedId().getBranch() + "\"") + details + " downloaded=\"" + dep.isDownloaded() + "\"" + " searched=\"" + dep.isSearched() + "\"" + defaultValue + " conf=\"" + this.toString(dep.getConfigurations(report.getConfiguration())) + "\"" + " position=\"" + position + "\">");
                if (md != null) {
                    License[] licenses = md.getLicenses();
                    for (i = 0; i < licenses.length; ++i) {
                        String lurl = licenses[i].getUrl() != null ? " url=\"" + licenses[i].getUrl() + "\"" : "";
                        out.println("\t\t\t\t<license name=\"" + licenses[i].getName() + "\"" + lurl + "/>");
                    }
                }
                if (dep.isEvicted(report.getConfiguration()) && (selected = (ed = dep.getEvictedData(report.getConfiguration())).getSelected()) != null) {
                    Iterator it3 = selected.iterator();
                    while (it3.hasNext()) {
                        IvyNode sel = (IvyNode)it3.next();
                        out.println("\t\t\t\t<evicted-by rev=\"" + sel.getResolvedId().getRevision() + "\"/>");
                    }
                }
                IvyNode.Caller[] callers = dep.getCallers(report.getConfiguration());
                for (i = 0; i < callers.length; ++i) {
                    StringBuffer callerDetails = new StringBuffer();
                    Map callerExtraAttributes = callers[i].getDependencyDescriptor().getExtraAttributes();
                    Iterator iterator2 = callerExtraAttributes.keySet().iterator();
                    while (iterator2.hasNext()) {
                        String attName = (String)iterator2.next();
                        callerDetails.append(" extra-").append(attName).append("=\"").append(callerExtraAttributes.get(attName)).append("\"");
                    }
                    out.println("\t\t\t\t<caller organisation=\"" + callers[i].getModuleRevisionId().getOrganisation() + "\"" + " name=\"" + callers[i].getModuleRevisionId().getName() + "\"" + " conf=\"" + this.toString(callers[i].getCallerConfigurations()) + "\"" + " rev=\"" + callers[i].getAskedDependencyId().getRevision() + "\"" + callerDetails + "/>");
                }
                ArtifactDownloadReport[] adr = report.getDownloadReports(dep.getResolvedId());
                out.println("\t\t\t\t<artifacts>");
                for (int i2 = 0; i2 < adr.length; ++i2) {
                    out.print("\t\t\t\t\t<artifact name=\"" + adr[i2].getName() + "\" type=\"" + adr[i2].getType() + "\" ext=\"" + adr[i2].getExt() + "\"");
                    extraAttributes = adr[i2].getArtifact().getExtraAttributes();
                    Iterator iterator3 = extraAttributes.keySet().iterator();
                    while (iterator3.hasNext()) {
                        String attName = (String)iterator3.next();
                        out.print(" extra-" + attName + "=\"" + extraAttributes.get(attName) + "\"");
                    }
                    out.print(" status=\"" + adr[i2].getDownloadStatus() + "\"");
                    out.print(" size=\"" + adr[i2].getSize() + "\"");
                    ArtifactOrigin origin = adr[i2].getArtifactOrigin();
                    if (origin != null) {
                        out.println(">");
                        out.println("\t\t\t\t\t\t<origin-location is-local=\"" + String.valueOf(origin.isLocal()) + "\"" + " location=\"" + origin.getLocation() + "\"/>");
                        out.println("\t\t\t\t\t</artifact>");
                        continue;
                    }
                    out.println("/>");
                }
                out.println("\t\t\t\t</artifacts>");
                out.println("\t\t\t</revision>");
            }
            out.println("\t\t</module>");
        }
        out.println("\t</dependencies>");
        out.println("</ivy-report>");
        out.flush();
    }

    private String toString(String[] strs) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strs.length; ++i) {
            buf.append(strs[i]);
            if (i + 1 >= strs.length) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String getReportFileName(ConfigurationResolveReport report) {
        return XmlReportOutputter.getReportFileName(report.getModuleDescriptor().getModuleRevisionId().getModuleId(), report.getConfiguration());
    }

    public static String getReportFileName(ModuleId mid, String conf) {
        return mid.getOrganisation() + "-" + mid.getName() + "-" + conf + ".xml";
    }
}

