/*
 * Decompiled with CFR 0.152.
 */
package clojure;

import clojure.lang.AFn;
import clojure.lang.AReference;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.Keyword;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import clojure.string$blank_QMARK_;
import clojure.string$capitalize;
import clojure.string$escape;
import clojure.string$join;
import clojure.string$loading__4410__auto__;
import clojure.string$lower_case;
import clojure.string$replace;
import clojure.string$replace_by;
import clojure.string$replace_first;
import clojure.string$replace_first_by;
import clojure.string$replace_first_char;
import clojure.string$reverse;
import clojure.string$split;
import clojure.string$split_lines;
import clojure.string$trim;
import clojure.string$trim_newline;
import clojure.string$triml;
import clojure.string$trimr;
import clojure.string$upper_case;
import java.util.Arrays;

public class string__init {
    public static final Var const__0 = RT.var("clojure.core", "ns");
    public static final Var const__1 = RT.var("clojure.core", "in-ns");
    public static final AFn const__2 = (AFn)((Object)((IObj)Symbol.create(null, "clojure.string")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "doc")), "Clojure String utilities\n\nIt is poor form to (:use clojure.string). Instead, use require\nwith :as to specify a prefix, e.g.\n\n(ns your.namespace.here\n  (:require '[clojure.string :as str]))\n\nDesign notes for clojure.string:\n\n1. Strings are objects (as opposed to sequences). As such, the\n   string being manipulated is the first argument to a function;\n   passing nil will result in a NullPointerException unless\n   documented otherwise. If you want sequence-y behavior instead,\n   use a sequence.\n\n2. Functions are generally not lazy, and call straight to host\n   methods where those are available and efficient.\n\n3. Functions take advantage of String implementation details to\n   write high-performing loop/recurs instead of using higher-order\n   functions. (This is not idiomatic in general-purpose application\n   code.)\n\n4. When a function is documented to accept a string argument, it\n   will take any implementation of the correct *interface* on the\n   host platform. In Java, this is CharSequence, which is more\n   general than String. In ordinary usage you will almost always\n   pass concrete strings. If you are doing something unusual,\n   e.g. passing a mutable implementation of CharSequence, then\n   thead-safety is your responsibility.", Keyword.intern(Symbol.create(null, "author")), "Stuart Sierra, Stuart Halloway, David Liebke")));
    public static final Var const__3 = RT.var("clojure.core", "with-loading-context");
    public static final Var const__4 = RT.var("clojure.core", "fn");
    public static final Var const__5 = RT.var("clojure.core", "defn");
    public static final Var const__6 = RT.var("clojure.string", "reverse");
    public static final Keyword const__7 = Keyword.intern(Symbol.create(null, "file"));
    public static final Keyword const__8 = Keyword.intern(Symbol.create(null, "line"));
    public static final Object const__9 = 46;
    public static final Keyword const__10 = Keyword.intern(Symbol.create(null, "arglists"));
    public static final Object const__11 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Keyword const__12 = Keyword.intern(Symbol.create(null, "added"));
    public static final Keyword const__13 = Keyword.intern(Symbol.create(null, "doc"));
    public static final Keyword const__14 = Keyword.intern(Symbol.create(null, "tag"));
    public static final Object const__15 = Class.forName("java.lang.String");
    public static final Var const__16 = RT.var("clojure.core", "defn-");
    public static final Var const__17 = RT.var("clojure.string", "replace-by");
    public static final Object const__18 = 52;
    public static final Object const__19 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))), Symbol.create(null, "re"), Symbol.create(null, "f"))));
    public static final Keyword const__20 = Keyword.intern(Symbol.create(null, "private"));
    public static final Var const__21 = RT.var("clojure.string", "replace");
    public static final Object const__22 = 63;
    public static final Object const__23 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))), Symbol.create(null, "match"), Symbol.create(null, "replacement"))));
    public static final Var const__24 = RT.var("clojure.string", "replace-first-by");
    public static final Object const__25 = 85;
    public static final Object const__26 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))), ((IObj)Symbol.create(null, "re")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "Pattern"))), Symbol.create(null, "f"))));
    public static final Var const__27 = RT.var("clojure.string", "replace-first-char");
    public static final Object const__28 = 95;
    public static final Object const__29 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))), ((IObj)Symbol.create(null, "match")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "Character"))), Symbol.create(null, "replace"))));
    public static final Var const__30 = RT.var("clojure.string", "replace-first");
    public static final Object const__31 = 103;
    public static final Object const__32 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))), Symbol.create(null, "match"), Symbol.create(null, "replacement"))));
    public static final Var const__33 = RT.var("clojure.string", "join");
    public static final Object const__34 = 130;
    public static final Object const__35 = PersistentList.create(Arrays.asList(RT.vector(Symbol.create(null, "coll")), RT.vector(Symbol.create(null, "separator"), RT.vector(Symbol.create(null, "x"), Symbol.create(null, "&"), Symbol.create(null, "more")))));
    public static final Var const__36 = RT.var("clojure.string", "capitalize");
    public static final Object const__37 = 146;
    public static final Object const__38 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Var const__39 = RT.var("clojure.string", "upper-case");
    public static final Object const__40 = 157;
    public static final Object const__41 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Var const__42 = RT.var("clojure.string", "lower-case");
    public static final Object const__43 = 163;
    public static final Object const__44 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Var const__45 = RT.var("clojure.string", "split");
    public static final Object const__46 = 169;
    public static final Object const__47 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))), ((IObj)Symbol.create(null, "re")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "Pattern")))), RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))), ((IObj)Symbol.create(null, "re")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "Pattern"))), Symbol.create(null, "limit"))));
    public static final Var const__48 = RT.var("clojure.string", "split-lines");
    public static final Object const__49 = 178;
    public static final Object const__50 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Var const__51 = RT.var("clojure.string", "trim");
    public static final Object const__52 = 184;
    public static final Object const__53 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Var const__54 = RT.var("clojure.string", "triml");
    public static final Object const__55 = 190;
    public static final Object const__56 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Var const__57 = RT.var("clojure.string", "trimr");
    public static final Object const__58 = 201;
    public static final Object const__59 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Var const__60 = RT.var("clojure.string", "trim-newline");
    public static final Object const__61 = 212;
    public static final Object const__62 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Var const__63 = RT.var("clojure.string", "blank?");
    public static final Object const__64 = 225;
    public static final Object const__65 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))))));
    public static final Var const__66 = RT.var("clojure.string", "escape");
    public static final Object const__67 = 238;
    public static final Object const__68 = PersistentList.create(Arrays.asList(RT.vector(((IObj)Symbol.create(null, "s")).withMeta(RT.map(Keyword.intern(Symbol.create(null, "tag")), Symbol.create(null, "CharSequence"))), Symbol.create(null, "cmap"))));

    public static void load() {
        Object object = ((IFn)const__1.get()).invoke(const__2);
        Object object2 = ((IFn)new string$loading__4410__auto__(null)).invoke();
        Var var = const__6;
        var.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__9, const__10, const__11, const__12, "1.2", const__13, "Returns s with its characters reversed.", const__14, const__15));
        Var var2 = var;
        var.bindRoot(((IObj)new string$reverse(null)).withMeta(((AReference)const__6).meta()));
        Var var3 = const__17;
        var3.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__18, const__10, const__19, const__20, Boolean.TRUE));
        Var var4 = var3;
        var3.bindRoot(((IObj)new string$replace_by(null)).withMeta(((AReference)const__17).meta()));
        Var var5 = const__21;
        var5.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__22, const__10, const__23, const__12, "1.2", const__13, "Replaces all instance of match with replacement in s.\n\n   match/replacement can be:\n\n   string / string\n   char / char\n   pattern / (string or function of match).\n\n   See also replace-first.", const__14, const__15));
        Var var6 = var5;
        var5.bindRoot(((IObj)new string$replace(null)).withMeta(((AReference)const__21).meta()));
        Var var7 = const__24;
        var7.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__25, const__10, const__26, const__20, Boolean.TRUE));
        Var var8 = var7;
        var7.bindRoot(((IObj)new string$replace_first_by(null)).withMeta(((AReference)const__24).meta()));
        Var var9 = const__27;
        var9.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__28, const__10, const__29, const__20, Boolean.TRUE));
        Var var10 = var9;
        var9.bindRoot(((IObj)new string$replace_first_char(null)).withMeta(((AReference)const__27).meta()));
        Var var11 = const__30;
        var11.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__31, const__10, const__32, const__12, "1.2", const__13, "Replaces the first instance of match with replacement in s.\n\n   match/replacement can be:\n\n   char / char\n   string / string\n   pattern / (string or function of match).\n\n   See also replace-all.", const__14, const__15));
        Var var12 = var11;
        var11.bindRoot(((IObj)new string$replace_first(null)).withMeta(((AReference)const__30).meta()));
        Var var13 = const__33;
        var13.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__34, const__10, const__35, const__12, "1.2", const__13, "Returns a string of all elements in coll, separated by\n   an optional separator.  Like Perl's join.", const__14, const__15));
        Var var14 = var13;
        var13.bindRoot(((IObj)new string$join(null)).withMeta(((AReference)const__33).meta()));
        Var var15 = const__36;
        var15.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__37, const__10, const__38, const__12, "1.2", const__13, "Converts first character of the string to upper-case, all other\n  characters to lower-case.", const__14, const__15));
        Var var16 = var15;
        var15.bindRoot(((IObj)new string$capitalize(null)).withMeta(((AReference)const__36).meta()));
        Var var17 = const__39;
        var17.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__40, const__10, const__41, const__12, "1.2", const__13, "Converts string to all upper-case.", const__14, const__15));
        Var var18 = var17;
        var17.bindRoot(((IObj)new string$upper_case(null)).withMeta(((AReference)const__39).meta()));
        Var var19 = const__42;
        var19.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__43, const__10, const__44, const__12, "1.2", const__13, "Converts string to all lower-case.", const__14, const__15));
        Var var20 = var19;
        var19.bindRoot(((IObj)new string$lower_case(null)).withMeta(((AReference)const__42).meta()));
        Var var21 = const__45;
        var21.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__46, const__10, const__47, const__12, "1.2", const__13, "Splits string on a regular expression.  Optional argument limit is\n  the maximum number of splits. Not lazy. Returns vector of the splits."));
        Var var22 = var21;
        var21.bindRoot(((IObj)new string$split(null)).withMeta(((AReference)const__45).meta()));
        Var var23 = const__48;
        var23.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__49, const__10, const__50, const__12, "1.2", const__13, "Splits s on \\n or \\r\\n."));
        Var var24 = var23;
        var23.bindRoot(((IObj)new string$split_lines(null)).withMeta(((AReference)const__48).meta()));
        Var var25 = const__51;
        var25.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__52, const__10, const__53, const__12, "1.2", const__13, "Removes whitespace from both ends of string.", const__14, const__15));
        Var var26 = var25;
        var25.bindRoot(((IObj)new string$trim(null)).withMeta(((AReference)const__51).meta()));
        Var var27 = const__54;
        var27.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__55, const__10, const__56, const__12, "1.2", const__13, "Removes whitespace from the left side of string.", const__14, const__15));
        Var var28 = var27;
        var27.bindRoot(((IObj)new string$triml(null)).withMeta(((AReference)const__54).meta()));
        Var var29 = const__57;
        var29.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__58, const__10, const__59, const__12, "1.2", const__13, "Removes whitespace from the right side of string.", const__14, const__15));
        Var var30 = var29;
        var29.bindRoot(((IObj)new string$trimr(null)).withMeta(((AReference)const__57).meta()));
        Var var31 = const__60;
        var31.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__61, const__10, const__62, const__12, "1.2", const__13, "Removes all trailing newline \\n or return \\r characters from\n  string.  Similar to Perl's chomp.", const__14, const__15));
        Var var32 = var31;
        var31.bindRoot(((IObj)new string$trim_newline(null)).withMeta(((AReference)const__60).meta()));
        Var var33 = const__63;
        var33.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__64, const__10, const__65, const__12, "1.2", const__13, "True if s is nil, empty, or contains only whitespace."));
        Var var34 = var33;
        var33.bindRoot(((IObj)new string$blank_QMARK_(null)).withMeta(((AReference)const__63).meta()));
        Var var35 = const__66;
        var35.setMeta(RT.map(const__7, "clojure/string.clj", const__8, const__67, const__10, const__68, const__12, "1.2", const__13, "Return a new string, using cmap to escape each character ch\n   from s as follows:\n   \n   If (cmap ch) is nil, append ch to the new string.\n   If (cmap ch) is non-nil, append (str (cmap ch)) instead.", const__14, const__15));
        Var var36 = var35;
        var35.bindRoot(((IObj)new string$escape(null)).withMeta(((AReference)const__66).meta()));
    }

    static {
        Compiler.pushNS();
        try {
            string__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

