/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSourceType;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.PlatformSpecificConnectionOptionPanel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class ArchitectDataSourceTypePanel
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(ArchitectDataSourceTypePanel.class);
    private ArchitectDataSourceType dsType;
    private JPanel panel;
    private final JTextField name = new JTextField();
    private final JTextField connectionStringTemplate = new JTextField();
    private final JTextField driverClass = new JTextField();
    private final PlatformSpecificConnectionOptionPanel template = new PlatformSpecificConnectionOptionPanel(new JTextField());

    public ArchitectDataSourceTypePanel() {
        this.buildPanel();
        this.editDsType(null);
    }

    private void buildPanel() {
        this.connectionStringTemplate.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ArchitectDataSourceTypePanel.this.template.setTemplate(ArchitectDataSourceTypePanel.this.connectionStringTemplate.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                ArchitectDataSourceTypePanel.this.template.setTemplate(ArchitectDataSourceTypePanel.this.connectionStringTemplate.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                ArchitectDataSourceTypePanel.this.template.setTemplate(ArchitectDataSourceTypePanel.this.connectionStringTemplate.getText());
            }
        });
        PanelBuilder pb = new PanelBuilder(new FormLayout("4dlu,pref,4dlu,pref:grow,4dlu", "4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu"));
        CellConstraints cc = new CellConstraints();
        CellConstraints cl = new CellConstraints();
        int row = 2;
        pb.addLabel("Name", cl.xy(2, row), (Component)this.name, cc.xy(4, row));
        pb.addLabel("Driver Class", cl.xy(2, row += 2), (Component)this.driverClass, cc.xy(4, row));
        pb.addLabel("Connection String Template", cl.xy(2, row += 2), (Component)this.connectionStringTemplate, cc.xy(4, row));
        this.connectionStringTemplate.setToolTipText("Variables should be of the form <variable name:default value>");
        pb.addTitle("Options Editor Preview (based on URL template)", cl.xyw(2, row += 2, 3));
        pb.addLabel("Sample Options", cl.xy(2, row += 2), (Component)this.template.getPanel(), cc.xy(4, row));
        this.panel = pb.getPanel();
    }

    public void editDsType(ArchitectDataSourceType dst) {
        this.dsType = dst;
        if (dst == null) {
            this.name.setText("");
            this.name.setEnabled(false);
            this.driverClass.setText("");
            this.driverClass.setEnabled(false);
            this.connectionStringTemplate.setText("");
        } else {
            this.name.setText(dst.getName());
            this.name.setEnabled(true);
            this.driverClass.setText(dst.getJdbcDriver());
            this.driverClass.setEnabled(true);
            this.connectionStringTemplate.setText(dst.getJdbcUrl());
            this.connectionStringTemplate.setEnabled(true);
        }
    }

    public boolean applyChanges() {
        logger.debug((Object)("Applying changes to data source type " + this.dsType));
        if (this.dsType != null) {
            this.dsType.setName(this.name.getText());
            this.dsType.setJdbcDriver(this.driverClass.getText());
            this.dsType.setJdbcUrl(this.connectionStringTemplate.getText());
        }
        return true;
    }

    public void discardChanges() {
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

