/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSourceType;
import ca.sqlpower.architect.jdbc.ConnectionDecorator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectDataSource {
    private static final Logger logger = Logger.getLogger(ArchitectDataSource.class);
    private final ParentTypeNameSynchronizer parentTypeUpdater = new ParentTypeNameSynchronizer();
    private Map<String, String> properties;
    private ArchitectDataSourceType parentType;
    private boolean parentSet = false;
    public static final String DBCS_DRIVER_CLASS = "JDBC Driver Class";
    public static final String DBCS_URL = "JDBC URL";
    public static final String DBCS_JAR = "JAR File";
    public static final String DBCS_CONNECTION_TYPE = "Connection Type";
    public static final String PL_LOGICAL = "Logical";
    public static final String PL_TYPE = "Type";
    public static final String PL_DSN = "DSN";
    public static final String PL_SCHEMA_OWNER = "PL Schema Owner";
    public static final String PL_UID = "UID";
    public static final String PL_PWD = "PWD";
    public static final String PL_TNS = "TNS Name";
    public static final String PL_DATABASE_NAME = "Database Name";
    public static final String PL_IP = "IP";
    public static final String PL_PORT = "PORT";
    private transient PropertyChangeSupport pcs;

    public void diff(ArchitectDataSource o2) {
        Map<String, String> p2 = o2.properties;
        this.dump(this.properties, p2, DBCS_DRIVER_CLASS);
        this.dump(this.properties, p2, DBCS_URL);
        this.dump(this.properties, p2, PL_LOGICAL);
        this.dump(this.properties, p2, PL_TYPE);
        this.dump(this.properties, p2, PL_DSN);
        this.dump(this.properties, p2, PL_SCHEMA_OWNER);
        this.dump(this.properties, p2, PL_UID);
        this.dump(this.properties, p2, PL_PWD);
        this.dump(this.properties, p2, PL_TNS);
        this.dump(this.properties, p2, PL_DATABASE_NAME);
        this.dump(this.properties, p2, PL_IP);
        this.dump(this.properties, p2, PL_PORT);
        Iterator<String> iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            System.out.print(iter.next() + ", ");
        }
        logger.debug((Object)"\n");
        Iterator<String> iter2 = p2.keySet().iterator();
        while (iter2.hasNext()) {
            logger.debug((Object)(iter2.next() + ", "));
        }
        logger.debug((Object)"\n");
    }

    private void dump(Map<String, String> myMap, Map<String, String> otherMap, String key) {
        String val1 = myMap.get(key);
        String val2 = otherMap.get(key);
        System.out.print("Property=" + key + "; me=" + val1 + "; other=" + val2 + ';');
        if (val1 != null && val2 != null && !val1.equals(val2)) {
            logger.debug((Object)" <-- DIFFERENT");
        }
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public ArchitectDataSource() {
        this.properties = new LinkedHashMap<String, String>();
        this.setParentType(new ArchitectDataSourceType());
        this.parentSet = false;
    }

    ArchitectDataSource(ArchitectDataSource copyMe) {
        this.properties = new LinkedHashMap<String, String>(copyMe.properties);
        this.setParentType(copyMe.parentType);
    }

    private String putImpl(String key, String value, String propertyName) {
        String oldValue = this.get(key);
        this.properties.put(key, value);
        this.getPcs().firePropertyChange(propertyName, oldValue, value);
        return oldValue;
    }

    public String put(String key, String value) {
        return this.putImpl(key, value, key);
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public Map<String, String> getPropertiesMap() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ArchitectDataSource)) {
            return false;
        }
        ArchitectDataSource other = (ArchitectDataSource)o;
        return ((Object)this.properties).equals(other.properties);
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    public Connection createConnection() throws SQLException {
        try {
            if (this.getParentType() == null) {
                throw new SQLException("Data Source \"" + this.getName() + "\" has no database type.");
            }
            this.getParentType().checkConnectPrereqs();
            if (this.getUrl() == null || this.getUrl().trim().length() == 0) {
                throw new SQLException("Data Source \"" + this.getName() + "\" has no JDBC URL.");
            }
            if (this.getUser() == null || this.getUser().trim().length() == 0) {
                throw new SQLException("Data Source \"" + this.getName() + "\" has no JDBC username.");
            }
            if (logger.isDebugEnabled()) {
                StringBuffer loaders = new StringBuffer();
                loaders.append("Local Classloader chain: ");
                for (ClassLoader cl = this.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
                    loaders.append(cl).append(", ");
                }
                logger.debug((Object)loaders);
            }
            Driver driver = (Driver)Class.forName(this.getDriverClass(), true, this.parentType.getJdbcClassLoader()).newInstance();
            logger.info((Object)("Driver Class " + this.getDriverClass() + " loaded without exception"));
            if (!driver.acceptsURL(this.getUrl())) {
                throw new SQLException("Couldn't connect to database \"" + this.getName() + "\":\n" + "JDBC Driver " + this.getDriverClass() + "\n" + "does not accept the URL " + this.getUrl());
            }
            Properties connectionProps = new Properties();
            connectionProps.setProperty("user", this.getUser());
            connectionProps.setProperty("password", this.getPass());
            Connection realConnection = driver.connect(this.getUrl(), connectionProps);
            if (realConnection == null) {
                throw new SQLException("JDBC Driver returned a null connection!");
            }
            ConnectionDecorator connection = ConnectionDecorator.createFacade(realConnection);
            logger.debug((Object)("Connection class is: " + connection.getClass().getName()));
            return connection;
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"Driver Class not found", (Throwable)e);
            throw new SQLException("JDBC Driver \"" + this.getDriverClass() + "\" not found.");
        }
        catch (InstantiationException e) {
            logger.error((Object)"Creating SQL Exception to conform to interface.  Real exception is: ", (Throwable)e);
            throw new SQLException("Couldn't create an instance of the JDBC driver '" + this.getDriverClass() + "'. " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"Creating SQL Exception to conform to interface.  Real exception is: ", (Throwable)e);
            throw new SQLException("Couldn't connect to database because the JDBC driver has no public constructor (this is bad). " + e.getMessage());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().removePropertyChangeListener(l);
    }

    public List getPropertyChangeListeners() {
        return Collections.unmodifiableList(Arrays.asList(this.pcs.getPropertyChangeListeners()));
    }

    public ArchitectDataSourceType getParentType() {
        return this.parentType;
    }

    public void setParentType(ArchitectDataSourceType type) {
        if (this.parentType != null) {
            this.parentType.removePropertyChangeListener(this.parentTypeUpdater);
        }
        this.parentType = type;
        if (this.parentType != null) {
            this.parentType.addPropertyChangeListener(this.parentTypeUpdater);
        }
        this.parentSet = true;
        this.putImpl(DBCS_CONNECTION_TYPE, type.getName(), "parentType");
    }

    public String getName() {
        return this.get(PL_LOGICAL);
    }

    public void setName(String argName) {
        this.putImpl(PL_LOGICAL, argName, "name");
    }

    public String getDisplayName() {
        return this.get(PL_LOGICAL);
    }

    public void setDisplayName(String argDisplayName) {
        this.putImpl(PL_LOGICAL, argDisplayName, "name");
    }

    public String getUrl() {
        return this.get(DBCS_URL);
    }

    public void setUrl(String argUrl) {
        this.putImpl(DBCS_URL, argUrl, "url");
    }

    public String getDriverClass() {
        if (this.getParentType() == null) {
            return null;
        }
        return this.getParentType().getJdbcDriver();
    }

    public String getUser() {
        return this.get(PL_UID);
    }

    public void setUser(String argUser) {
        this.putImpl(PL_UID, argUser, "user");
    }

    public String getPass() {
        return this.get(PL_PWD);
    }

    public void setPass(String argPass) {
        this.putImpl(PL_PWD, argPass, "pass");
    }

    public String getPlSchema() {
        return this.properties.get(PL_SCHEMA_OWNER);
    }

    public void setPlSchema(String schema) {
        this.putImpl(PL_SCHEMA_OWNER, schema, "plSchema");
    }

    public String getPlDbType() {
        return this.properties.get(PL_TYPE);
    }

    public void setPlDbType(String type) {
        this.putImpl(PL_TYPE, type, "plDbType");
    }

    public String getOdbcDsn() {
        return this.properties.get(PL_DSN);
    }

    public void setOdbcDsn(String dsn) {
        this.putImpl(PL_DSN, dsn, "odbcDsn");
    }

    public boolean isParentSet() {
        return this.parentSet;
    }

    private class ParentTypeNameSynchronizer
    implements PropertyChangeListener {
        private ParentTypeNameSynchronizer() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == ArchitectDataSource.this.parentType && "name".equals(evt.getPropertyName())) {
                ArchitectDataSource.this.properties.put(ArchitectDataSource.DBCS_CONNECTION_TYPE, (String)evt.getNewValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultComparator
    implements Comparator<ArchitectDataSource> {
        @Override
        public int compare(ArchitectDataSource ds1, ArchitectDataSource ds2) {
            if (ds1 == ds2) {
                return 0;
            }
            String v1 = ds1.getName();
            String v2 = ds2.getName();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            int tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            v1 = ds1.getUrl();
            v2 = ds2.getUrl();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            v1 = ds1.getDriverClass();
            v2 = ds2.getDriverClass();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            v1 = ds1.getUser();
            v2 = ds2.getUser();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            v1 = ds1.getPass();
            v2 = ds2.getPass();
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            tmp = v1 != null && v2 != null ? v1.compareTo(v2) : 0;
            if (tmp != 0) {
                return tmp;
            }
            return 0;
        }
    }
}

