/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.splash;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ImageIcon;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.splash.SplashScreen;
import org.apache.tools.ant.util.Base64Converter;

public class SplashTask
extends Task {
    private static final int FIVE_SECONDS = 5000;
    private String imgurl = null;
    private String proxy = null;
    private String user = null;
    private String password = null;
    private String port = "80";
    private int showDuration = 5000;
    private boolean useProxy = false;
    private static SplashScreen splash = null;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$optional$splash$SplashTask;

    public void setImageURL(String imgurl) {
        this.imgurl = imgurl;
    }

    public void setUseproxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setShowduration(int duration) {
        this.showDuration = duration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        boolean success;
        block24: {
            block25: {
                if (splash != null) {
                    splash.setVisible(false);
                    this.getProject().removeBuildListener((BuildListener)splash);
                    splash.dispose();
                    splash = null;
                }
                this.log("Creating new SplashScreen", 3);
                InputStream in = null;
                if (this.imgurl != null) {
                    try {
                        URL url;
                        URLConnection conn = null;
                        if (this.useProxy && this.proxy != null && this.proxy.length() > 0 && this.port != null && this.port.length() > 0) {
                            this.log("Using proxied Connection", 4);
                            System.getProperties().put("http.proxySet", "true");
                            System.getProperties().put("http.proxyHost", this.proxy);
                            System.getProperties().put("http.proxyPort", this.port);
                            url = new URL(this.imgurl);
                            conn = url.openConnection();
                            if (this.user != null && this.user.length() > 0) {
                                String encodedcreds = new Base64Converter().encode(this.user + ":" + this.password);
                                conn.setRequestProperty("Proxy-Authorization", encodedcreds);
                            }
                        } else {
                            System.getProperties().put("http.proxySet", "false");
                            System.getProperties().put("http.proxyHost", "");
                            System.getProperties().put("http.proxyPort", "");
                            this.log("Using Direction HTTP Connection", 4);
                            url = new URL(this.imgurl);
                            conn = url.openConnection();
                        }
                        conn.setDoInput(true);
                        conn.setDoOutput(false);
                        in = conn.getInputStream();
                    }
                    catch (Throwable ioe) {
                        this.log("Unable to download image, trying default Ant Logo", 4);
                        this.log("(Exception was \"" + ioe.getMessage() + "\"", 4);
                    }
                }
                if (in == null) {
                    ClassLoader cl = (class$org$apache$tools$ant$taskdefs$optional$splash$SplashTask == null ? (class$org$apache$tools$ant$taskdefs$optional$splash$SplashTask = SplashTask.class$("org.apache.tools.ant.taskdefs.optional.splash.SplashTask")) : class$org$apache$tools$ant$taskdefs$optional$splash$SplashTask).getClassLoader();
                    in = cl != null ? cl.getResourceAsStream("images/ant_logo_large.gif") : ClassLoader.getSystemResourceAsStream("images/ant_logo_large.gif");
                }
                success = false;
                if (in == null) break block25;
                DataInputStream din = new DataInputStream(in);
                try {
                    try {
                        int data;
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        while ((data = din.read()) != -1) {
                            bout.write((byte)data);
                        }
                        this.log("Got ByteArray, creating splash", 4);
                        try {
                            ImageIcon img = new ImageIcon(bout.toByteArray());
                            splash = new SplashScreen(img);
                            success = true;
                        }
                        catch (Throwable e) {
                            this.logHeadless(e);
                        }
                        Object var8_13 = null;
                    }
                    catch (Exception e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    try {
                        din.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        if (!success) throw throwable;
                        throw new BuildException((Throwable)ioe);
                    }
                }
                try {}
                catch (IOException ioe) {
                    if (success) {
                        throw new BuildException((Throwable)ioe);
                    }
                    break block24;
                }
                din.close();
                break block24;
            }
            try {
                splash = new SplashScreen("Image Unavailable.");
                success = true;
            }
            catch (Throwable e) {
                this.logHeadless(e);
            }
        }
        if (!success) return;
        splash.setVisible(true);
        splash.toFront();
        this.getProject().addBuildListener((BuildListener)splash);
        try {
            Thread.sleep(this.showDuration);
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logHeadless(Throwable e) {
        this.log("failed to display SplashScreen, caught " + e.getClass().getName() + " with message: " + e.getMessage(), 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

