CREATE TABLE income_tax_rate (
    id integer AUTO_INCREMENT NOT NULL,
    country varchar(250),
    province varchar(250),
    effective_date integer NOT NULL,
    income numeric(10,4) NOT NULL,
    rate numeric(10,4) NOT NULL,
    constant numeric(10,4),
	PRIMARY KEY(id)
) ENGINE=InnoDB;



CREATE TABLE income_tax_rate_us (
    id integer AUTO_INCREMENT NOT NULL,
    country varchar(250),
    state varchar(250),
    district varchar(250),
    effective_date integer NOT NULL,
    status integer NOT NULL,
    income numeric(10,4) NOT NULL,
    rate numeric(10,4) NOT NULL,
    constant numeric(10,4) DEFAULT 0,
	PRIMARY KEY(id)
) ENGINE=InnoDB;



CREATE UNIQUE INDEX income_tax_rate_id_uniq ON income_tax_rate(id);
CREATE UNIQUE INDEX income_tax_rate_us_id_uniq ON income_tax_rate_us(id);



INSERT INTO income_tax_rate VALUES (37, 'CA', 'AB', 1072944000, 0, 10, 0);
INSERT INTO income_tax_rate VALUES (5, 'CA', 'BC', 1072944000, 32476, 6.05, 0);
INSERT INTO income_tax_rate VALUES (6, 'CA', 'BC', 1072944000, 64954, 9.15, 1007);
INSERT INTO income_tax_rate VALUES (7, 'CA', 'BC', 1072944000, 74575, 11.7, 2663);
INSERT INTO income_tax_rate VALUES (8, 'CA', 'BC', 1072944000, 90555, 13.7, 4155);
INSERT INTO income_tax_rate VALUES (9, 'CA', 'BC', 1072944000, 90555, 14.7, 5060);
INSERT INTO income_tax_rate VALUES (1, 'CA', NULL, 1072944000, 35000, 16, 0);
INSERT INTO income_tax_rate VALUES (2, 'CA', NULL, 1072944000, 70000, 22, 2100);
INSERT INTO income_tax_rate VALUES (3, 'CA', NULL, 1072944000, 113804, 26, 4900);
INSERT INTO income_tax_rate VALUES (4, 'CA', NULL, 1072944000, 113804, 29, 8314);
INSERT INTO income_tax_rate VALUES (28, 'CA', 'BC', 1041408000, 32476, 6.05, 0);
INSERT INTO income_tax_rate VALUES (29, 'CA', 'BC', 1041408000, 64954, 9.15, 1007);
INSERT INTO income_tax_rate VALUES (30, 'CA', 'BC', 1041408000, 74575, 11.7, 2663);
INSERT INTO income_tax_rate VALUES (31, 'CA', 'BC', 1041408000, 90555, 13.7, 4155);
INSERT INTO income_tax_rate VALUES (32, 'CA', 'BC', 1041408000, 90555, 14.7, 5060);
INSERT INTO income_tax_rate VALUES (33, 'CA', NULL, 1041408000, 35000, 16, 0);
INSERT INTO income_tax_rate VALUES (34, 'CA', NULL, 1041408000, 70000, 22, 2100);
INSERT INTO income_tax_rate VALUES (35, 'CA', NULL, 1041408000, 113804, 26, 4900);
INSERT INTO income_tax_rate VALUES (36, 'CA', NULL, 1041408000, 113804, 29, 8314);
INSERT INTO income_tax_rate VALUES (19, 'CA', 'BC', 1009872000, 32476, 6.05, 0);
INSERT INTO income_tax_rate VALUES (20, 'CA', 'BC', 1009872000, 64954, 9.15, 1007);
INSERT INTO income_tax_rate VALUES (21, 'CA', 'BC', 1009872000, 74575, 11.7, 2663);
INSERT INTO income_tax_rate VALUES (22, 'CA', 'BC', 1009872000, 90555, 13.7, 4155);
INSERT INTO income_tax_rate VALUES (23, 'CA', 'BC', 1009872000, 90555, 14.7, 5060);
INSERT INTO income_tax_rate VALUES (24, 'CA', NULL, 1009872000, 35000, 16, 0);
INSERT INTO income_tax_rate VALUES (25, 'CA', NULL, 1009872000, 70000, 22, 2100);
INSERT INTO income_tax_rate VALUES (26, 'CA', NULL, 1009872000, 113804, 26, 4900);
INSERT INTO income_tax_rate VALUES (27, 'CA', NULL, 1009872000, 113804, 29, 8314);
INSERT INTO income_tax_rate VALUES (10, 'CA', 'BC', 978336000, 32476, 6.05, 0);
INSERT INTO income_tax_rate VALUES (11, 'CA', 'BC', 978336000, 64954, 9.15, 1007);
INSERT INTO income_tax_rate VALUES (12, 'CA', 'BC', 978336000, 74575, 11.7, 2663);
INSERT INTO income_tax_rate VALUES (13, 'CA', 'BC', 978336000, 90555, 13.7, 4155);
INSERT INTO income_tax_rate VALUES (14, 'CA', 'BC', 978336000, 90555, 14.7, 5060);
INSERT INTO income_tax_rate VALUES (15, 'CA', NULL, 978336000, 35000, 16, 0);
INSERT INTO income_tax_rate VALUES (16, 'CA', NULL, 978336000, 70000, 22, 2100);
INSERT INTO income_tax_rate VALUES (17, 'CA', NULL, 978336000, 113804, 26, 4900);
INSERT INTO income_tax_rate VALUES (18, 'CA', NULL, 978336000, 113804, 29, 8314);
INSERT INTO income_tax_rate VALUES (48, 'CA', NULL, 1104566400, 35595, 16, 0);
INSERT INTO income_tax_rate VALUES (49, 'CA', NULL, 1104566400, 71190, 22, 2136);
INSERT INTO income_tax_rate VALUES (50, 'CA', NULL, 1104566400, 115739, 26, 4983);
INSERT INTO income_tax_rate VALUES (51, 'CA', NULL, 1104566400, 115739, 29, 8455);
INSERT INTO income_tax_rate VALUES (52, 'CA', 'AB', 1104566400, 0, 10, 0);
INSERT INTO income_tax_rate VALUES (53, 'CA', 'BC', 1104566400, 33061, 6.05, 0);
INSERT INTO income_tax_rate VALUES (54, 'CA', 'BC', 1104566400, 66123, 9.15, 1025);
INSERT INTO income_tax_rate VALUES (55, 'CA', 'BC', 1104566400, 75917, 11.7, 2711);
INSERT INTO income_tax_rate VALUES (56, 'CA', 'BC', 1104566400, 92185, 13.7, 4229);
INSERT INTO income_tax_rate VALUES (57, 'CA', 'BC', 1104566400, 92185, 14.7, 5151);
INSERT INTO income_tax_rate VALUES (58, 'CA', 'BC', 1120201200, 33061, 6.05, 0);
INSERT INTO income_tax_rate VALUES (59, 'CA', 'BC', 1120201200, 66123, 9.15, 1007);
INSERT INTO income_tax_rate VALUES (60, 'CA', 'BC', 1120201200, 75917, 11.7, 2663);
INSERT INTO income_tax_rate VALUES (61, 'CA', 'BC', 1120201200, 92185, 13.7, 4155);
INSERT INTO income_tax_rate VALUES (63, 'CA', NULL, 1136102400, 36378, 15, 0);
INSERT INTO income_tax_rate VALUES (62, 'CA', 'BC', 1120201200, 92185, 14.7, 5151);
INSERT INTO income_tax_rate VALUES (64, 'CA', NULL, 1136102400, 72756, 22, 2546);
INSERT INTO income_tax_rate VALUES (65, 'CA', NULL, 1136102400, 118285, 26, 5457);
INSERT INTO income_tax_rate VALUES (66, 'CA', NULL, 1136102400, 118285, 29, 9005);
INSERT INTO income_tax_rate VALUES (67, 'CA', 'ON', 1136102400, 34758, 6.05, 0);
INSERT INTO income_tax_rate VALUES (68, 'CA', 'ON', 1136102400, 69517, 9.15, 1077);
INSERT INTO income_tax_rate VALUES (69, 'CA', 'ON', 1136102400, 69517, 11.16, 2475);
INSERT INTO income_tax_rate VALUES (70, 'CA', 'SK', 1136102400, 37579, 11, 0);
INSERT INTO income_tax_rate VALUES (71, 'CA', 'SK', 1136102400, 107367, 13, 752);
INSERT INTO income_tax_rate VALUES (72, 'CA', 'SK', 1136102400, 107367, 15, 2899);
INSERT INTO income_tax_rate VALUES (73, 'CA', 'BC', 1136102400, 33755, 6.05, 0);
INSERT INTO income_tax_rate VALUES (74, 'CA', 'BC', 1136102400, 67511, 9.15, 1046);
INSERT INTO income_tax_rate VALUES (75, 'CA', 'BC', 1136102400, 77511, 11.7, 2768);
INSERT INTO income_tax_rate VALUES (76, 'CA', 'BC', 1136102400, 94121, 13.7, 4318);
INSERT INTO income_tax_rate VALUES (77, 'CA', 'BC', 1136102400, 94121, 14.7, 5259);
INSERT INTO income_tax_rate VALUES (78, 'CA', 'MB', 1136102400, 30544, 10.9, 0);
INSERT INTO income_tax_rate VALUES (79, 'CA', 'MB', 1136102400, 65000, 13.5, 794);
INSERT INTO income_tax_rate VALUES (80, 'CA', 'MB', 1136102400, 65000, 17.4, 3329);


INSERT INTO income_tax_rate VALUES (81, 'CA', NULL, 1151737200, 36378, 15.5, 0);
INSERT INTO income_tax_rate VALUES (82, 'CA', NULL, 1151737200, 72756, 22, 2365);
INSERT INTO income_tax_rate VALUES (83, 'CA', NULL, 1151737200, 118285, 26, 5275);
INSERT INTO income_tax_rate VALUES (84, 'CA', NULL, 1151737200, 118285, 29, 8823);



INSERT INTO income_tax_rate_us VALUES (1, 'US', NULL, NULL, 1136102400, 10, 2652, 0, 0);
INSERT INTO income_tax_rate_us VALUES (2, 'US', NULL, NULL, 1136102400, 10, 9984, 10, 2652);
INSERT INTO income_tax_rate_us VALUES (3, 'US', NULL, NULL, 1136102400, 10, 32240, 15, 5096);
INSERT INTO income_tax_rate_us VALUES (4, 'US', NULL, NULL, 1136102400, 10, 73268, 25, 15953.60);
INSERT INTO income_tax_rate_us VALUES (5, 'US', NULL, NULL, 1136102400, 10, 156676, 28, 22094.30);
INSERT INTO income_tax_rate_us VALUES (6, 'US', NULL, NULL, 1136102400, 10, 338416, 33, 42485.60);
INSERT INTO income_tax_rate_us VALUES (7, 'US', NULL, NULL, 1136102400, 10, 338416, 35, 59396);
INSERT INTO income_tax_rate_us VALUES (8, 'US', NULL, NULL, 1136102400, 20, 8008, 0, 0);
INSERT INTO income_tax_rate_us VALUES (9, 'US', NULL, NULL, 1136102400, 20, 22880, 10, 8008);
INSERT INTO income_tax_rate_us VALUES (10, 'US', NULL, NULL, 1136102400, 20, 68016, 15, 12965.20);
INSERT INTO income_tax_rate_us VALUES (11, 'US', NULL, NULL, 1136102400, 20, 126880, 25, 34985.60);
INSERT INTO income_tax_rate_us VALUES (12, 'US', NULL, NULL, 1136102400, 20, 195468, 28, 44831.30);
INSERT INTO income_tax_rate_us VALUES (13, 'US', NULL, NULL, 1136102400, 20, 343564, 33, 67655.10);
INSERT INTO income_tax_rate_us VALUES (14, 'US', NULL, NULL, 1136102400, 20, 343564, 35, 83421.50);
INSERT INTO income_tax_rate_us VALUES (15, 'US', 'MO', NULL, 1136102400, 10, 1000, 1.5, 0);
INSERT INTO income_tax_rate_us VALUES (16, 'US', 'MO', NULL, 1136102400, 10, 2000, 2.0, 15.00);
INSERT INTO income_tax_rate_us VALUES (17, 'US', 'MO', NULL, 1136102400, 10, 3000, 2.5, 35.00);
INSERT INTO income_tax_rate_us VALUES (18, 'US', 'MO', NULL, 1136102400, 10, 4000, 3.0, 60.00);
INSERT INTO income_tax_rate_us VALUES (19, 'US', 'MO', NULL, 1136102400, 10, 5000, 3.5, 90.00);
INSERT INTO income_tax_rate_us VALUES (20, 'US', 'MO', NULL, 1136102400, 10, 6000, 4.0, 125.00);
INSERT INTO income_tax_rate_us VALUES (21, 'US', 'MO', NULL, 1136102400, 10, 7000, 4.5, 165.00);
INSERT INTO income_tax_rate_us VALUES (22, 'US', 'MO', NULL, 1136102400, 10, 8000, 5.0, 210.00);
INSERT INTO income_tax_rate_us VALUES (23, 'US', 'MO', NULL, 1136102400, 10, 9000, 5.5, 260.00);
INSERT INTO income_tax_rate_us VALUES (24, 'US', 'MO', NULL, 1136102400, 10, 9000, 6.0, 315.00);
INSERT INTO income_tax_rate_us VALUES (25, 'US', 'MO', NULL, 1136102400, 20, 1000, 1.5, 0);
INSERT INTO income_tax_rate_us VALUES (26, 'US', 'MO', NULL, 1136102400, 20, 2000, 2.0, 15.00);
INSERT INTO income_tax_rate_us VALUES (27, 'US', 'MO', NULL, 1136102400, 20, 3000, 2.5, 35.00);
INSERT INTO income_tax_rate_us VALUES (28, 'US', 'MO', NULL, 1136102400, 20, 4000, 3.0, 60.00);
INSERT INTO income_tax_rate_us VALUES (29, 'US', 'MO', NULL, 1136102400, 20, 5000, 3.5, 90.00);
INSERT INTO income_tax_rate_us VALUES (30, 'US', 'MO', NULL, 1136102400, 20, 6000, 4.0, 125.00);
INSERT INTO income_tax_rate_us VALUES (31, 'US', 'MO', NULL, 1136102400, 20, 7000, 4.5, 165.00);
INSERT INTO income_tax_rate_us VALUES (32, 'US', 'MO', NULL, 1136102400, 20, 8000, 5.0, 210.00);
INSERT INTO income_tax_rate_us VALUES (33, 'US', 'MO', NULL, 1136102400, 20, 9000, 5.5, 260.00);
INSERT INTO income_tax_rate_us VALUES (34, 'US', 'MO', NULL, 1136102400, 20, 9000, 6.0, 315.00);
INSERT INTO income_tax_rate_us VALUES (35, 'US', 'MO', NULL, 1136102400, 30, 1000, 1.5, 0);
INSERT INTO income_tax_rate_us VALUES (36, 'US', 'MO', NULL, 1136102400, 30, 2000, 2.0, 15.00);
INSERT INTO income_tax_rate_us VALUES (37, 'US', 'MO', NULL, 1136102400, 30, 3000, 2.5, 35.00);
INSERT INTO income_tax_rate_us VALUES (38, 'US', 'MO', NULL, 1136102400, 30, 4000, 3.0, 60.00);
INSERT INTO income_tax_rate_us VALUES (39, 'US', 'MO', NULL, 1136102400, 30, 5000, 3.5, 90.00);
INSERT INTO income_tax_rate_us VALUES (40, 'US', 'MO', NULL, 1136102400, 30, 6000, 4.0, 125.00);
INSERT INTO income_tax_rate_us VALUES (41, 'US', 'MO', NULL, 1136102400, 30, 7000, 4.5, 165.00);
INSERT INTO income_tax_rate_us VALUES (42, 'US', 'MO', NULL, 1136102400, 30, 8000, 5.0, 210.00);
INSERT INTO income_tax_rate_us VALUES (43, 'US', 'MO', NULL, 1136102400, 30, 9000, 5.5, 260.00);
INSERT INTO income_tax_rate_us VALUES (44, 'US', 'MO', NULL, 1136102400, 30, 9000, 6.0, 315.00);
INSERT INTO income_tax_rate_us VALUES (45, 'US', 'MO', NULL, 1136102400, 40, 1000, 1.5, 0);
INSERT INTO income_tax_rate_us VALUES (46, 'US', 'MO', NULL, 1136102400, 40, 2000, 2.0, 15.00);
INSERT INTO income_tax_rate_us VALUES (47, 'US', 'MO', NULL, 1136102400, 40, 3000, 2.5, 35.00);
INSERT INTO income_tax_rate_us VALUES (48, 'US', 'MO', NULL, 1136102400, 40, 4000, 3.0, 60.00);
INSERT INTO income_tax_rate_us VALUES (49, 'US', 'MO', NULL, 1136102400, 40, 5000, 3.5, 90.00);
INSERT INTO income_tax_rate_us VALUES (50, 'US', 'MO', NULL, 1136102400, 40, 6000, 4.0, 125.00);
INSERT INTO income_tax_rate_us VALUES (51, 'US', 'MO', NULL, 1136102400, 40, 7000, 4.5, 165.00);
INSERT INTO income_tax_rate_us VALUES (52, 'US', 'MO', NULL, 1136102400, 40, 8000, 5.0, 210.00);
INSERT INTO income_tax_rate_us VALUES (53, 'US', 'MO', NULL, 1136102400, 40, 9000, 5.5, 260.00);
INSERT INTO income_tax_rate_us VALUES (54, 'US', 'MO', NULL, 1136102400, 40, 9000, 6.0, 315.00);
INSERT INTO income_tax_rate_us VALUES (55, 'US', 'CA', NULL, 1136102400, 10, 6319, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (56, 'US', 'CA', NULL, 1136102400, 10, 14979, 2.0, 63.19);
INSERT INTO income_tax_rate_us VALUES (57, 'US', 'CA', NULL, 1136102400, 10, 23641, 4.0, 236.39);
INSERT INTO income_tax_rate_us VALUES (58, 'US', 'CA', NULL, 1136102400, 10, 32819, 6.0, 582.87);
INSERT INTO income_tax_rate_us VALUES (59, 'US', 'CA', NULL, 1136102400, 10, 41476, 8.0, 1133.55);
INSERT INTO income_tax_rate_us VALUES (60, 'US', 'CA', NULL, 1136102400, 10, 999999, 9.3, 1826.11);
INSERT INTO income_tax_rate_us VALUES (61, 'US', 'CA', NULL, 1136102400, 10, 999999, 10.3, 90968.75);
INSERT INTO income_tax_rate_us VALUES (62, 'US', 'CA', NULL, 1136102400, 10, 6319, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (63, 'US', 'CA', NULL, 1136102400, 10, 14979, 2.0, 63.19);
INSERT INTO income_tax_rate_us VALUES (64, 'US', 'CA', NULL, 1136102400, 10, 23641, 4.0, 236.39);
INSERT INTO income_tax_rate_us VALUES (65, 'US', 'CA', NULL, 1136102400, 10, 32819, 6.0, 582.87);
INSERT INTO income_tax_rate_us VALUES (66, 'US', 'CA', NULL, 1136102400, 10, 41476, 8.0, 1133.55);
INSERT INTO income_tax_rate_us VALUES (67, 'US', 'CA', NULL, 1136102400, 10, 999999, 9.3, 1826.11);
INSERT INTO income_tax_rate_us VALUES (68, 'US', 'CA', NULL, 1136102400, 10, 999999, 10.3, 90968.75);
INSERT INTO income_tax_rate_us VALUES (69, 'US', 'CA', NULL, 1136102400, 20, 6319, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (70, 'US', 'CA', NULL, 1136102400, 20, 14979, 2.0, 63.19);
INSERT INTO income_tax_rate_us VALUES (71, 'US', 'CA', NULL, 1136102400, 20, 23641, 4.0, 236.39);
INSERT INTO income_tax_rate_us VALUES (72, 'US', 'CA', NULL, 1136102400, 20, 32819, 6.0, 582.87);
INSERT INTO income_tax_rate_us VALUES (73, 'US', 'CA', NULL, 1136102400, 20, 41476, 8.0, 1133.55);
INSERT INTO income_tax_rate_us VALUES (74, 'US', 'CA', NULL, 1136102400, 20, 999999, 9.3, 1826.11);
INSERT INTO income_tax_rate_us VALUES (75, 'US', 'CA', NULL, 1136102400, 20, 999999, 10.3, 90968.75);
INSERT INTO income_tax_rate_us VALUES (76, 'US', 'CA', NULL, 1136102400, 30, 12638, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (77, 'US', 'CA', NULL, 1136102400, 30, 29958, 2.0, 126.38);
INSERT INTO income_tax_rate_us VALUES (78, 'US', 'CA', NULL, 1136102400, 30, 47282, 4.0, 472.78);
INSERT INTO income_tax_rate_us VALUES (79, 'US', 'CA', NULL, 1136102400, 30, 65638, 6.0, 1165.74);
INSERT INTO income_tax_rate_us VALUES (80, 'US', 'CA', NULL, 1136102400, 30, 82952, 8.0, 2267.10);
INSERT INTO income_tax_rate_us VALUES (81, 'US', 'CA', NULL, 1136102400, 30, 999999, 9.3, 3652.22);
INSERT INTO income_tax_rate_us VALUES (82, 'US', 'CA', NULL, 1136102400, 30, 999999, 10.3, 88937.59);
INSERT INTO income_tax_rate_us VALUES (83, 'US', 'CA', NULL, 1136102400, 40, 12644, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (84, 'US', 'CA', NULL, 1136102400, 40, 29959, 2.0, 126.44);
INSERT INTO income_tax_rate_us VALUES (85, 'US', 'CA', NULL, 1136102400, 40, 38619, 4.0, 472.74);
INSERT INTO income_tax_rate_us VALUES (86, 'US', 'CA', NULL, 1136102400, 40, 47796, 6.0, 819.14);
INSERT INTO income_tax_rate_us VALUES (87, 'US', 'CA', NULL, 1136102400, 40, 56456, 8.0, 1369.76);
INSERT INTO income_tax_rate_us VALUES (88, 'US', 'CA', NULL, 1136102400, 40, 999999, 9.3, 2062.56);
INSERT INTO income_tax_rate_us VALUES (89, 'US', 'CA', NULL, 1136102400, 40, 999999, 10.3, 89812.06);
INSERT INTO income_tax_rate_us VALUES (90, 'US', 'NY', NULL, 1136102400, 10, 8000, 4.0, 0);
INSERT INTO income_tax_rate_us VALUES (91, 'US', 'NY', NULL, 1136102400, 10, 11000, 4.5, 320);
INSERT INTO income_tax_rate_us VALUES (92, 'US', 'NY', NULL, 1136102400, 10, 13000, 5.25, 455);
INSERT INTO income_tax_rate_us VALUES (93, 'US', 'NY', NULL, 1136102400, 10, 20000, 5.90, 580);
INSERT INTO income_tax_rate_us VALUES (94, 'US', 'NY', NULL, 1136102400, 10, 90000, 6.85, 973);
INSERT INTO income_tax_rate_us VALUES (95, 'US', 'NY', NULL, 1136102400, 10, 100000, 7.64, 5768);
INSERT INTO income_tax_rate_us VALUES (96, 'US', 'NY', NULL, 1136102400, 10, 150000, 8.14, 6532);
INSERT INTO income_tax_rate_us VALUES (97, 'US', 'NY', NULL, 1136102400, 10, 150000, 7.35, 10604);
INSERT INTO income_tax_rate_us VALUES (98, 'US', 'NY', NULL, 1136102400, 20, 8000, 4.0, 0);
INSERT INTO income_tax_rate_us VALUES (99, 'US', 'NY', NULL, 1136102400, 20, 11000, 4.5, 320);
INSERT INTO income_tax_rate_us VALUES (100, 'US', 'NY', NULL, 1136102400, 20, 13000, 5.25, 455);
INSERT INTO income_tax_rate_us VALUES (101, 'US', 'NY', NULL, 1136102400, 20, 20000, 5.90, 580);
INSERT INTO income_tax_rate_us VALUES (102, 'US', 'NY', NULL, 1136102400, 20, 90000, 6.85, 973);
INSERT INTO income_tax_rate_us VALUES (103, 'US', 'NY', NULL, 1136102400, 20, 100000, 7.64, 5768);
INSERT INTO income_tax_rate_us VALUES (104, 'US', 'NY', NULL, 1136102400, 20, 150000, 8.14, 6532);
INSERT INTO income_tax_rate_us VALUES (105, 'US', 'NY', NULL, 1136102400, 20, 150000, 7.35, 10604);
INSERT INTO income_tax_rate_us VALUES (106, 'US', 'NY', 'NYC', 1136102400, 10, 8000, 1.9, 0);
INSERT INTO income_tax_rate_us VALUES (107, 'US', 'NY', 'NYC', 1136102400, 10, 8700, 2.65, 152);
INSERT INTO income_tax_rate_us VALUES (108, 'US', 'NY', 'NYC', 1136102400, 10, 15000, 3.10, 172);
INSERT INTO income_tax_rate_us VALUES (109, 'US', 'NY', 'NYC', 1136102400, 10, 25000, 3.70, 366);
INSERT INTO income_tax_rate_us VALUES (110, 'US', 'NY', 'NYC', 1136102400, 10, 60000, 3.90, 736);
INSERT INTO income_tax_rate_us VALUES (111, 'US', 'NY', 'NYC', 1136102400, 10, 60000, 4.00, 2101);
INSERT INTO income_tax_rate_us VALUES (112, 'US', 'NY', 'NYC', 1136102400, 20, 8000, 1.9, 0);
INSERT INTO income_tax_rate_us VALUES (113, 'US', 'NY', 'NYC', 1136102400, 20, 8700, 2.65, 152);
INSERT INTO income_tax_rate_us VALUES (114, 'US', 'NY', 'NYC', 1136102400, 20, 15000, 3.10, 172);
INSERT INTO income_tax_rate_us VALUES (115, 'US', 'NY', 'NYC', 1136102400, 20, 25000, 3.70, 366);
INSERT INTO income_tax_rate_us VALUES (116, 'US', 'NY', 'NYC', 1136102400, 20, 60000, 3.90, 736);
INSERT INTO income_tax_rate_us VALUES (117, 'US', 'NY', 'NYC', 1136102400, 20, 60000, 4.00, 2101);
INSERT INTO income_tax_rate_us VALUES (118, 'US', 'NY', 'YONKERS', 1136102400, 10, 8000, 4.0, 0);
INSERT INTO income_tax_rate_us VALUES (119, 'US', 'NY', 'YONKERS', 1136102400, 10, 11000, 4.5, 320);
INSERT INTO income_tax_rate_us VALUES (120, 'US', 'NY', 'YONKERS', 1136102400, 10, 13000, 5.25, 455);
INSERT INTO income_tax_rate_us VALUES (121, 'US', 'NY', 'YONKERS', 1136102400, 10, 20000, 5.90, 580);
INSERT INTO income_tax_rate_us VALUES (122, 'US', 'NY', 'YONKERS', 1136102400, 10, 90000, 6.85, 973);
INSERT INTO income_tax_rate_us VALUES (123, 'US', 'NY', 'YONKERS', 1136102400, 10, 100000, 7.64, 5768);
INSERT INTO income_tax_rate_us VALUES (124, 'US', 'NY', 'YONKERS', 1136102400, 10, 150000, 8.14, 6532);
INSERT INTO income_tax_rate_us VALUES (125, 'US', 'NY', 'YONKERS', 1136102400, 10, 150000, 7.35, 10604);
INSERT INTO income_tax_rate_us VALUES (126, 'US', 'NY', 'YONKERS', 1136102400, 20, 8000, 4.0, 0);
INSERT INTO income_tax_rate_us VALUES (127, 'US', 'NY', 'YONKERS', 1136102400, 20, 11000, 4.5, 320);
INSERT INTO income_tax_rate_us VALUES (128, 'US', 'NY', 'YONKERS', 1136102400, 20, 13000, 5.25, 455);
INSERT INTO income_tax_rate_us VALUES (129, 'US', 'NY', 'YONKERS', 1136102400, 20, 20000, 5.90, 580);
INSERT INTO income_tax_rate_us VALUES (130, 'US', 'NY', 'YONKERS', 1136102400, 20, 90000, 6.85, 973);
INSERT INTO income_tax_rate_us VALUES (131, 'US', 'NY', 'YONKERS', 1136102400, 20, 100000, 7.64, 5768);
INSERT INTO income_tax_rate_us VALUES (132, 'US', 'NY', 'YONKERS', 1136102400, 20, 150000, 8.14, 6532);
INSERT INTO income_tax_rate_us VALUES (133, 'US', 'NY', 'YONKERS', 1136102400, 20, 150000, 7.35, 10604);
INSERT INTO income_tax_rate_us VALUES (134, 'US', 'OH', NULL, 1136102400, 0, 5000, 0.774, 0);
INSERT INTO income_tax_rate_us VALUES (135, 'US', 'OH', NULL, 1136102400, 0, 10000, 1.547, 38.70);
INSERT INTO income_tax_rate_us VALUES (136, 'US', 'OH', NULL, 1136102400, 0, 15000, 3.094, 116.05);
INSERT INTO income_tax_rate_us VALUES (137, 'US', 'OH', NULL, 1136102400, 0, 20000, 3.868, 270.75);
INSERT INTO income_tax_rate_us VALUES (138, 'US', 'OH', NULL, 1136102400, 0, 40000, 4.642, 464.15);
INSERT INTO income_tax_rate_us VALUES (139, 'US', 'OH', NULL, 1136102400, 0, 80000, 5.416, 1392.55);
INSERT INTO income_tax_rate_us VALUES (140, 'US', 'OH', NULL, 1136102400, 0, 100000, 6.189, 3558.95);
INSERT INTO income_tax_rate_us VALUES (141, 'US', 'OH', NULL, 1136102400, 0, 100000, 7.736, 4796.75);
INSERT INTO income_tax_rate_us VALUES (142, 'US', 'GA', NULL, 1136102400, 10, 750, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (143, 'US', 'GA', NULL, 1136102400, 10, 2250, 2.0, 7.50);
INSERT INTO income_tax_rate_us VALUES (144, 'US', 'GA', NULL, 1136102400, 10, 3750, 3.0, 37.50);
INSERT INTO income_tax_rate_us VALUES (145, 'US', 'GA', NULL, 1136102400, 10, 5250, 4.0, 82.50);
INSERT INTO income_tax_rate_us VALUES (146, 'US', 'GA', NULL, 1136102400, 10, 7000, 5.0, 142.50);
INSERT INTO income_tax_rate_us VALUES (147, 'US', 'GA', NULL, 1136102400, 10, 7000, 6.0, 230);
INSERT INTO income_tax_rate_us VALUES (148, 'US', 'GA', NULL, 1136102400, 20, 500, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (149, 'US', 'GA', NULL, 1136102400, 20, 1500, 2.0, 5);
INSERT INTO income_tax_rate_us VALUES (150, 'US', 'GA', NULL, 1136102400, 20, 2500, 3.0, 25);
INSERT INTO income_tax_rate_us VALUES (151, 'US', 'GA', NULL, 1136102400, 20, 3500, 4.0, 55);
INSERT INTO income_tax_rate_us VALUES (152, 'US', 'GA', NULL, 1136102400, 20, 5000, 5.0, 95);
INSERT INTO income_tax_rate_us VALUES (153, 'US', 'GA', NULL, 1136102400, 20, 5000, 6.0, 170);
INSERT INTO income_tax_rate_us VALUES (154, 'US', 'GA', NULL, 1136102400, 30, 1000, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (155, 'US', 'GA', NULL, 1136102400, 30, 3000, 2.0, 10);
INSERT INTO income_tax_rate_us VALUES (156, 'US', 'GA', NULL, 1136102400, 30, 5000, 3.0, 50);
INSERT INTO income_tax_rate_us VALUES (157, 'US', 'GA', NULL, 1136102400, 30, 7000, 4.0, 110);
INSERT INTO income_tax_rate_us VALUES (158, 'US', 'GA', NULL, 1136102400, 30, 10000, 5.0, 190);
INSERT INTO income_tax_rate_us VALUES (159, 'US', 'GA', NULL, 1136102400, 30, 10000, 6.0, 340);
INSERT INTO income_tax_rate_us VALUES (160, 'US', 'GA', NULL, 1136102400, 40, 500, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (161, 'US', 'GA', NULL, 1136102400, 40, 1500, 2.0, 5);
INSERT INTO income_tax_rate_us VALUES (162, 'US', 'GA', NULL, 1136102400, 40, 2500, 3.0, 25);
INSERT INTO income_tax_rate_us VALUES (163, 'US', 'GA', NULL, 1136102400, 40, 3500, 4.0, 55);
INSERT INTO income_tax_rate_us VALUES (164, 'US', 'GA', NULL, 1136102400, 40, 5000, 5.0, 95);
INSERT INTO income_tax_rate_us VALUES (165, 'US', 'GA', NULL, 1136102400, 40, 5000, 6.0, 170);
INSERT INTO income_tax_rate_us VALUES (166, 'US', 'GA', NULL, 1136102400, 50, 1000, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (167, 'US', 'GA', NULL, 1136102400, 50, 3000, 2.0, 10);
INSERT INTO income_tax_rate_us VALUES (168, 'US', 'GA', NULL, 1136102400, 50, 5000, 3.0, 50);
INSERT INTO income_tax_rate_us VALUES (169, 'US', 'GA', NULL, 1136102400, 50, 7000, 4.0, 110);
INSERT INTO income_tax_rate_us VALUES (170, 'US', 'GA', NULL, 1136102400, 50, 10000, 5.0, 190);
INSERT INTO income_tax_rate_us VALUES (171, 'US', 'GA', NULL, 1136102400, 50, 10000, 6.0, 340);
INSERT INTO income_tax_rate_us VALUES (172, 'US', 'NJ', NULL, 1136102400, 10, 20000, 1.5, 0);
INSERT INTO income_tax_rate_us VALUES (173, 'US', 'NJ', NULL, 1136102400, 10, 35000, 2.0, 300);
INSERT INTO income_tax_rate_us VALUES (174, 'US', 'NJ', NULL, 1136102400, 10, 40000, 3.9, 600);
INSERT INTO income_tax_rate_us VALUES (175, 'US', 'NJ', NULL, 1136102400, 10, 75000, 6.1, 795);
INSERT INTO income_tax_rate_us VALUES (176, 'US', 'NJ', NULL, 1136102400, 10, 500000, 7.0, 2930);
INSERT INTO income_tax_rate_us VALUES (177, 'US', 'NJ', NULL, 1136102400, 10, 500000, 9.9, 32680);
INSERT INTO income_tax_rate_us VALUES (178, 'US', 'NJ', NULL, 1136102400, 20, 20000, 1.5, 0);
INSERT INTO income_tax_rate_us VALUES (179, 'US', 'NJ', NULL, 1136102400, 20, 50000, 2.0, 300);
INSERT INTO income_tax_rate_us VALUES (180, 'US', 'NJ', NULL, 1136102400, 20, 70000, 2.7, 900);
INSERT INTO income_tax_rate_us VALUES (181, 'US', 'NJ', NULL, 1136102400, 20, 80000, 3.9, 1440);
INSERT INTO income_tax_rate_us VALUES (182, 'US', 'NJ', NULL, 1136102400, 20, 150000, 6.1, 1830);
INSERT INTO income_tax_rate_us VALUES (183, 'US', 'NJ', NULL, 1136102400, 20, 500000, 7.0, 6100);
INSERT INTO income_tax_rate_us VALUES (184, 'US', 'NJ', NULL, 1136102400, 20, 500000, 9.9, 30600);
INSERT INTO income_tax_rate_us VALUES (185, 'US', 'NJ', NULL, 1136102400, 30, 20000, 1.5, 0);
INSERT INTO income_tax_rate_us VALUES (186, 'US', 'NJ', NULL, 1136102400, 30, 40000, 2.3, 300);
INSERT INTO income_tax_rate_us VALUES (187, 'US', 'NJ', NULL, 1136102400, 30, 50000, 2.8, 760);
INSERT INTO income_tax_rate_us VALUES (188, 'US', 'NJ', NULL, 1136102400, 30, 60000, 3.5, 1040);
INSERT INTO income_tax_rate_us VALUES (189, 'US', 'NJ', NULL, 1136102400, 30, 150000, 5.6, 1390);
INSERT INTO income_tax_rate_us VALUES (190, 'US', 'NJ', NULL, 1136102400, 30, 500000, 6.6, 6430);
INSERT INTO income_tax_rate_us VALUES (191, 'US', 'NJ', NULL, 1136102400, 30, 500000, 9.9, 29530);
INSERT INTO income_tax_rate_us VALUES (192, 'US', 'NJ', NULL, 1136102400, 40, 20000, 1.5, 0);
INSERT INTO income_tax_rate_us VALUES (193, 'US', 'NJ', NULL, 1136102400, 40, 40000, 2.7, 300);
INSERT INTO income_tax_rate_us VALUES (194, 'US', 'NJ', NULL, 1136102400, 40, 50000, 3.4, 840);
INSERT INTO income_tax_rate_us VALUES (195, 'US', 'NJ', NULL, 1136102400, 40, 60000, 4.3, 1180);
INSERT INTO income_tax_rate_us VALUES (196, 'US', 'NJ', NULL, 1136102400, 40, 150000, 5.6, 1610);
INSERT INTO income_tax_rate_us VALUES (197, 'US', 'NJ', NULL, 1136102400, 40, 500000, 6.5, 6650);
INSERT INTO income_tax_rate_us VALUES (198, 'US', 'NJ', NULL, 1136102400, 40, 500000, 9.9, 29400);
INSERT INTO income_tax_rate_us VALUES (199, 'US', 'NJ', NULL, 1136102400, 50, 20000, 1.5, 0);
INSERT INTO income_tax_rate_us VALUES (200, 'US', 'NJ', NULL, 1136102400, 50, 35000, 2.0, 300);
INSERT INTO income_tax_rate_us VALUES (201, 'US', 'NJ', NULL, 1136102400, 50, 100000, 5.8, 600);
INSERT INTO income_tax_rate_us VALUES (202, 'US', 'NJ', NULL, 1136102400, 50, 500000, 6.5, 4370);
INSERT INTO income_tax_rate_us VALUES (203, 'US', 'NJ', NULL, 1136102400, 50, 500000, 9.9, 30370);
INSERT INTO income_tax_rate_us VALUES (204, 'US', 'NC', NULL, 1136102400, 10, 12750, 6, 0);
INSERT INTO income_tax_rate_us VALUES (205, 'US', 'NC', NULL, 1136102400, 10, 60000, 7, 127.50);
INSERT INTO income_tax_rate_us VALUES (206, 'US', 'NC', NULL, 1136102400, 10, 120000, 7.75, 577.50);
INSERT INTO income_tax_rate_us VALUES (207, 'US', 'NC', NULL, 1136102400, 10, 120000, 8.25, 1177.50);
INSERT INTO income_tax_rate_us VALUES (208, 'US', 'NC', NULL, 1136102400, 20, 10625, 6, 0);
INSERT INTO income_tax_rate_us VALUES (209, 'US', 'NC', NULL, 1136102400, 20, 50000, 7, 106.25);
INSERT INTO income_tax_rate_us VALUES (210, 'US', 'NC', NULL, 1136102400, 20, 100000, 7.75, 481.25);
INSERT INTO income_tax_rate_us VALUES (211, 'US', 'NC', NULL, 1136102400, 20, 100000, 8.25, 981.25);
INSERT INTO income_tax_rate_us VALUES (212, 'US', 'NC', NULL, 1136102400, 30, 17000, 6, 0);
INSERT INTO income_tax_rate_us VALUES (213, 'US', 'NC', NULL, 1136102400, 30, 80000, 7, 170);
INSERT INTO income_tax_rate_us VALUES (214, 'US', 'NC', NULL, 1136102400, 30, 160000, 7.75, 770);
INSERT INTO income_tax_rate_us VALUES (215, 'US', 'NC', NULL, 1136102400, 30, 160000, 8.25, 1570);
INSERT INTO income_tax_rate_us VALUES (216, 'US', 'VA', NULL, 1136102400, 0, 3000, 2, 0);
INSERT INTO income_tax_rate_us VALUES (217, 'US', 'VA', NULL, 1136102400, 0, 5000, 3, 60);
INSERT INTO income_tax_rate_us VALUES (218, 'US', 'VA', NULL, 1136102400, 0, 17000, 5, 120);
INSERT INTO income_tax_rate_us VALUES (219, 'US', 'VA', NULL, 1136102400, 0, 17000, 5.75, 720);
INSERT INTO income_tax_rate_us VALUES (220, 'US', 'WI', NULL, 1136102400, 10, 4000, 0, 0);
INSERT INTO income_tax_rate_us VALUES (221, 'US', 'WI', NULL, 1136102400, 10, 10620, 4.6, 0);
INSERT INTO income_tax_rate_us VALUES (222, 'US', 'WI', NULL, 1136102400, 10, 11825, 5.154, 305);
INSERT INTO income_tax_rate_us VALUES (223, 'US', 'WI', NULL, 1136102400, 10, 18629, 6.888, 367);
INSERT INTO income_tax_rate_us VALUES (224, 'US', 'WI', NULL, 1136102400, 10, 43953, 7.280, 836);
INSERT INTO income_tax_rate_us VALUES (225, 'US', 'WI', NULL, 1136102400, 10, 115140, 6.5, 2680);
INSERT INTO income_tax_rate_us VALUES (226, 'US', 'WI', NULL, 1136102400, 10, 115140, 6.75, 7307);
INSERT INTO income_tax_rate_us VALUES (227, 'US', 'WI', NULL, 1136102400, 20, 5500, 0, 0);
INSERT INTO income_tax_rate_us VALUES (228, 'US', 'WI', NULL, 1136102400, 20, 13470, 4.6, 0);
INSERT INTO income_tax_rate_us VALUES (229, 'US', 'WI', NULL, 1136102400, 20, 14950, 6.15, 367);
INSERT INTO income_tax_rate_us VALUES (230, 'US', 'WI', NULL, 1136102400, 20, 20067, 7.38, 458);
INSERT INTO income_tax_rate_us VALUES (231, 'US', 'WI', NULL, 1136102400, 20, 42450, 7.8, 836);
INSERT INTO income_tax_rate_us VALUES (232, 'US', 'WI', NULL, 1136102400, 20, 115140, 6.5, 2582);
INSERT INTO income_tax_rate_us VALUES (233, 'US', 'WI', NULL, 1136102400, 20, 115140, 6.75, 7307);
INSERT INTO income_tax_rate_us VALUES (234, 'US', 'MN', NULL, 1136102400, 10, 1850, 0, 0);
INSERT INTO income_tax_rate_us VALUES (235, 'US', 'MN', NULL, 1136102400, 10, 22360, 5.35, 0);
INSERT INTO income_tax_rate_us VALUES (236, 'US', 'MN', NULL, 1136102400, 10, 69210, 7.05, 1097.29);
INSERT INTO income_tax_rate_us VALUES (237, 'US', 'MN', NULL, 1136102400, 10, 69210, 7.85, 4400.22);
INSERT INTO income_tax_rate_us VALUES (238, 'US', 'MN', NULL, 1136102400, 20, 6150, 0, 0);
INSERT INTO income_tax_rate_us VALUES (239, 'US', 'MN', NULL, 1136102400, 20, 36130, 5.35, 0);
INSERT INTO income_tax_rate_us VALUES (240, 'US', 'MN', NULL, 1136102400, 20, 125250, 7.05, 1603.93);
INSERT INTO income_tax_rate_us VALUES (241, 'US', 'MN', NULL, 1136102400, 20, 125250, 7.85, 7886.89);
INSERT INTO income_tax_rate_us VALUES (242, 'US', 'CO', NULL, 1136102400, 10, 1850, 0, 0);
INSERT INTO income_tax_rate_us VALUES (243, 'US', 'CO', NULL, 1136102400, 10, 1850, 4.63, 0);
INSERT INTO income_tax_rate_us VALUES (244, 'US', 'CO', NULL, 1136102400, 20, 7000, 0, 0);
INSERT INTO income_tax_rate_us VALUES (245, 'US', 'CO', NULL, 1136102400, 20, 7000, 4.63, 0);
INSERT INTO income_tax_rate_us VALUES (246, 'US', 'AL', NULL, 1136102400, 10, 500, 2, 0);
INSERT INTO income_tax_rate_us VALUES (247, 'US', 'AL', NULL, 1136102400, 10, 2500, 4, 10);
INSERT INTO income_tax_rate_us VALUES (248, 'US', 'AL', NULL, 1136102400, 10, 3000, 5, 110);
INSERT INTO income_tax_rate_us VALUES (249, 'US', 'AL', NULL, 1136102400, 20, 1000, 2, 0);
INSERT INTO income_tax_rate_us VALUES (250, 'US', 'AL', NULL, 1136102400, 20, 5000, 4, 20);
INSERT INTO income_tax_rate_us VALUES (251, 'US', 'AL', NULL, 1136102400, 20, 6000, 5, 220);
INSERT INTO income_tax_rate_us VALUES (252, 'US', 'AL', NULL, 1136102400, 30, 500, 2, 0);
INSERT INTO income_tax_rate_us VALUES (253, 'US', 'AL', NULL, 1136102400, 30, 2500, 4, 10);
INSERT INTO income_tax_rate_us VALUES (254, 'US', 'AL', NULL, 1136102400, 30, 3000, 5, 110);
INSERT INTO income_tax_rate_us VALUES (255, 'US', 'AL', NULL, 1136102400, 40, 500, 2, 0);
INSERT INTO income_tax_rate_us VALUES (256, 'US', 'AL', NULL, 1136102400, 40, 2500, 4, 10);
INSERT INTO income_tax_rate_us VALUES (257, 'US', 'AL', NULL, 1136102400, 40, 3000, 5, 110);
INSERT INTO income_tax_rate_us VALUES (258, 'US', 'SC', NULL, 1136102400, 0, 2000, 2, 0);
INSERT INTO income_tax_rate_us VALUES (259, 'US', 'SC', NULL, 1136102400, 0, 4000, 3, 20);
INSERT INTO income_tax_rate_us VALUES (260, 'US', 'SC', NULL, 1136102400, 0, 6000, 4, 60);
INSERT INTO income_tax_rate_us VALUES (261, 'US', 'SC', NULL, 1136102400, 0, 8000, 5, 120);
INSERT INTO income_tax_rate_us VALUES (262, 'US', 'SC', NULL, 1136102400, 0, 10000, 6, 200);
INSERT INTO income_tax_rate_us VALUES (263, 'US', 'SC', NULL, 1136102400, 0, 10000, 7, 300);
INSERT INTO income_tax_rate_us VALUES (264, 'US', 'KY', NULL, 1136102400, 0, 3000, 2, 0);
INSERT INTO income_tax_rate_us VALUES (265, 'US', 'KY', NULL, 1136102400, 0, 4000, 3, 60);
INSERT INTO income_tax_rate_us VALUES (266, 'US', 'KY', NULL, 1136102400, 0, 5000, 4, 90);
INSERT INTO income_tax_rate_us VALUES (267, 'US', 'KY', NULL, 1136102400, 0, 8000, 5, 130);
INSERT INTO income_tax_rate_us VALUES (268, 'US', 'KY', NULL, 1136102400, 0, 75000, 5.8, 280);
INSERT INTO income_tax_rate_us VALUES (269, 'US', 'KY', NULL, 1136102400, 0, 75000, 6, 4166);
INSERT INTO income_tax_rate_us VALUES (270, 'US', 'OR', NULL, 1136102400, 10, 300, 0, 0);
INSERT INTO income_tax_rate_us VALUES (271, 'US', 'OR', NULL, 1136102400, 10, 8030, 7, 0);
INSERT INTO income_tax_rate_us VALUES (272, 'US', 'OR', NULL, 1136102400, 10, 8030, 9, 541);
INSERT INTO income_tax_rate_us VALUES (273, 'US', 'OR', NULL, 1136102400, 20, 2725, 0, 0);
INSERT INTO income_tax_rate_us VALUES (274, 'US', 'OR', NULL, 1136102400, 20, 16065, 7, 0);
INSERT INTO income_tax_rate_us VALUES (275, 'US', 'OR', NULL, 1136102400, 20, 16065, 9, 934);
INSERT INTO income_tax_rate_us VALUES (276, 'US', 'OK', NULL, 1136102400, 10, 2000, 0, 0);
INSERT INTO income_tax_rate_us VALUES (277, 'US', 'OK', NULL, 1136102400, 10, 3000, 0.5, 0);
INSERT INTO income_tax_rate_us VALUES (278, 'US', 'OK', NULL, 1136102400, 10, 4500, 1.0, 5);
INSERT INTO income_tax_rate_us VALUES (279, 'US', 'OK', NULL, 1136102400, 10, 5750, 2.0, 20);
INSERT INTO income_tax_rate_us VALUES (280, 'US', 'OK', NULL, 1136102400, 10, 6900, 3.0, 45);
INSERT INTO income_tax_rate_us VALUES (281, 'US', 'OK', NULL, 1136102400, 10, 9200, 4.0, 79.50);
INSERT INTO income_tax_rate_us VALUES (282, 'US', 'OK', NULL, 1136102400, 10, 10700, 5.0, 171.50);
INSERT INTO income_tax_rate_us VALUES (283, 'US', 'OK', NULL, 1136102400, 10, 12500, 6.0, 246.50);
INSERT INTO income_tax_rate_us VALUES (284, 'US', 'OK', NULL, 1136102400, 10, 12500, 6.25, 354.50);
INSERT INTO income_tax_rate_us VALUES (285, 'US', 'OK', NULL, 1136102400, 20, 3000, 0, 0);
INSERT INTO income_tax_rate_us VALUES (286, 'US', 'OK', NULL, 1136102400, 20, 5000, 0.5, 0);
INSERT INTO income_tax_rate_us VALUES (287, 'US', 'OK', NULL, 1136102400, 20, 8500, 1.0, 10);
INSERT INTO income_tax_rate_us VALUES (288, 'US', 'OK', NULL, 1136102400, 20, 10500, 2.0, 40);
INSERT INTO income_tax_rate_us VALUES (289, 'US', 'OK', NULL, 1136102400, 20, 12800, 3.0, 90);
INSERT INTO income_tax_rate_us VALUES (290, 'US', 'OK', NULL, 1136102400, 20, 15200, 4.0, 159);
INSERT INTO income_tax_rate_us VALUES (291, 'US', 'OK', NULL, 1136102400, 20, 18000, 5.0, 255);
INSERT INTO income_tax_rate_us VALUES (292, 'US', 'OK', NULL, 1136102400, 20, 24000, 6.0, 395);
INSERT INTO income_tax_rate_us VALUES (293, 'US', 'OK', NULL, 1136102400, 20, 24000, 6.25, 755);
INSERT INTO income_tax_rate_us VALUES (294, 'US', 'CT', NULL, 1136102400, 10, 0, 0, 0);
INSERT INTO income_tax_rate_us VALUES (295, 'US', 'CT', NULL, 1136102400, 10, 10000, 3.0, 0);
INSERT INTO income_tax_rate_us VALUES (296, 'US', 'CT', NULL, 1136102400, 10, 10000, 5.0, 300);
INSERT INTO income_tax_rate_us VALUES (297, 'US', 'CT', NULL, 1136102400, 40, 0, 0, 0);
INSERT INTO income_tax_rate_us VALUES (298, 'US', 'CT', NULL, 1136102400, 40, 10000, 3.0, 0);
INSERT INTO income_tax_rate_us VALUES (299, 'US', 'CT', NULL, 1136102400, 40, 10000, 5.0, 300);
INSERT INTO income_tax_rate_us VALUES (300, 'US', 'CT', NULL, 1136102400, 60, 0, 0, 0);
INSERT INTO income_tax_rate_us VALUES (301, 'US', 'CT', NULL, 1136102400, 60, 10000, 3.0, 0);
INSERT INTO income_tax_rate_us VALUES (302, 'US', 'CT', NULL, 1136102400, 60, 10000, 5.0, 300);
INSERT INTO income_tax_rate_us VALUES (303, 'US', 'CT', NULL, 1136102400, 20, 0, 0, 0);
INSERT INTO income_tax_rate_us VALUES (304, 'US', 'CT', NULL, 1136102400, 20, 16000, 3.0, 0);
INSERT INTO income_tax_rate_us VALUES (305, 'US', 'CT', NULL, 1136102400, 20, 16000, 5.0, 480);
INSERT INTO income_tax_rate_us VALUES (306, 'US', 'CT', NULL, 1136102400, 30, 0, 0, 0);
INSERT INTO income_tax_rate_us VALUES (307, 'US', 'CT', NULL, 1136102400, 30, 20000, 3.0, 0);
INSERT INTO income_tax_rate_us VALUES (308, 'US', 'CT', NULL, 1136102400, 30, 20000, 5.0, 600);
INSERT INTO income_tax_rate_us VALUES (309, 'US', 'IA', NULL, 1143878400, 0, 1300, 0.36, 0);
INSERT INTO income_tax_rate_us VALUES (310, 'US', 'IA', NULL, 1143878400, 0, 2600, 0.72, 4.68);
INSERT INTO income_tax_rate_us VALUES (311, 'US', 'IA', NULL, 1143878400, 0, 5200, 2.43, 14.04);
INSERT INTO income_tax_rate_us VALUES (312, 'US', 'IA', NULL, 1143878400, 0, 11700, 4.50, 77.22);
INSERT INTO income_tax_rate_us VALUES (313, 'US', 'IA', NULL, 1143878400, 0, 19500, 6.12, 369.72);
INSERT INTO income_tax_rate_us VALUES (314, 'US', 'IA', NULL, 1143878400, 0, 26000, 6.48, 847.08);
INSERT INTO income_tax_rate_us VALUES (315, 'US', 'IA', NULL, 1143878400, 0, 39000, 6.80, 1268.28);
INSERT INTO income_tax_rate_us VALUES (316, 'US', 'IA', NULL, 1143878400, 0, 58500, 7.92, 2152.28);
INSERT INTO income_tax_rate_us VALUES (317, 'US', 'IA', NULL, 1143878400, 0, 58500, 8.98, 3696.68);
INSERT INTO income_tax_rate_us VALUES (318, 'US', 'MS', NULL, 1136102400, 0, 5000, 3.0, 0);
INSERT INTO income_tax_rate_us VALUES (319, 'US', 'MS', NULL, 1136102400, 0, 10000, 4.0, 150);
INSERT INTO income_tax_rate_us VALUES (320, 'US', 'MS', NULL, 1136102400, 0, 10000, 5.0, 350);
INSERT INTO income_tax_rate_us VALUES (321, 'US', 'AR', NULL, 1136102400, 0, 3000, 1.0, 0);
INSERT INTO income_tax_rate_us VALUES (322, 'US', 'AR', NULL, 1136102400, 0, 6000, 2.5, 30);
INSERT INTO income_tax_rate_us VALUES (323, 'US', 'AR', NULL, 1136102400, 0, 9000, 3.5, 105);
INSERT INTO income_tax_rate_us VALUES (324, 'US', 'AR', NULL, 1136102400, 0, 15000, 4.5, 210);
INSERT INTO income_tax_rate_us VALUES (325, 'US', 'AR', NULL, 1136102400, 0, 25000, 6.0, 480);
INSERT INTO income_tax_rate_us VALUES (326, 'US', 'AR', NULL, 1136102400, 0, 25000, 7.0, 1080);
INSERT INTO income_tax_rate_us VALUES (327, 'US', 'KS', NULL, 1136102400, 10, 3000, 0, 0);
INSERT INTO income_tax_rate_us VALUES (328, 'US', 'KS', NULL, 1136102400, 10, 18000, 3.5, 0);
INSERT INTO income_tax_rate_us VALUES (329, 'US', 'KS', NULL, 1136102400, 10, 33000, 6.25, 525);
INSERT INTO income_tax_rate_us VALUES (330, 'US', 'KS', NULL, 1136102400, 10, 33000, 6.45, 1462.50);
INSERT INTO income_tax_rate_us VALUES (331, 'US', 'KS', NULL, 1136102400, 20, 6000, 0, 0);
INSERT INTO income_tax_rate_us VALUES (332, 'US', 'KS', NULL, 1136102400, 20, 36000, 3.5, 0);
INSERT INTO income_tax_rate_us VALUES (333, 'US', 'KS', NULL, 1136102400, 20, 66000, 6.25, 1050);
INSERT INTO income_tax_rate_us VALUES (334, 'US', 'KS', NULL, 1136102400, 20, 66000, 6.45, 2925);
INSERT INTO income_tax_rate_us VALUES (335, 'US', 'UT', NULL, 1136102400, 10, 2300, 0, 0);
INSERT INTO income_tax_rate_us VALUES (336, 'US', 'UT', NULL, 1136102400, 10, 3163, 2.3, 0);
INSERT INTO income_tax_rate_us VALUES (337, 'US', 'UT', NULL, 1136102400, 10, 4026, 3.1, 20);
INSERT INTO income_tax_rate_us VALUES (338, 'US', 'UT', NULL, 1136102400, 10, 4888, 4.0, 47);
INSERT INTO income_tax_rate_us VALUES (339, 'US', 'UT', NULL, 1136102400, 10, 5750, 4.9, 81);
INSERT INTO income_tax_rate_us VALUES (340, 'US', 'UT', NULL, 1136102400, 10, 6613, 5.7, 123);
INSERT INTO income_tax_rate_us VALUES (341, 'US', 'UT', NULL, 1136102400, 10, 6613, 6.5, 172);
INSERT INTO income_tax_rate_us VALUES (342, 'US', 'UT', NULL, 1136102400, 20, 2300, 0, 0);
INSERT INTO income_tax_rate_us VALUES (343, 'US', 'UT', NULL, 1136102400, 20, 4026, 2.3, 0);
INSERT INTO income_tax_rate_us VALUES (344, 'US', 'UT', NULL, 1136102400, 20, 5750, 3.1, 40);
INSERT INTO income_tax_rate_us VALUES (345, 'US', 'UT', NULL, 1136102400, 20, 7476, 4.0, 93);
INSERT INTO income_tax_rate_us VALUES (346, 'US', 'UT', NULL, 1136102400, 20, 9200, 4.9, 162);
INSERT INTO income_tax_rate_us VALUES (347, 'US', 'UT', NULL, 1136102400, 20, 10926, 5.7, 246);
INSERT INTO income_tax_rate_us VALUES (348, 'US', 'UT', NULL, 1136102400, 20, 10926, 6.5, 344);
INSERT INTO income_tax_rate_us VALUES (349, 'US', 'NM', NULL, 1136102400, 10, 1800, 0, 0);
INSERT INTO income_tax_rate_us VALUES (350, 'US', 'NM', NULL, 1136102400, 10, 7300, 1.7, 0);
INSERT INTO income_tax_rate_us VALUES (351, 'US', 'NM', NULL, 1136102400, 10, 12800, 3.2, 93.50);
INSERT INTO income_tax_rate_us VALUES (352, 'US', 'NM', NULL, 1136102400, 10, 17800, 4.7, 269.50);
INSERT INTO income_tax_rate_us VALUES (353, 'US', 'NM', NULL, 1136102400, 10, 17800, 5.3, 504.50);
INSERT INTO income_tax_rate_us VALUES (354, 'US', 'NM', NULL, 1136102400, 20, 6950, 0, 0);
INSERT INTO income_tax_rate_us VALUES (355, 'US', 'NM', NULL, 1136102400, 20, 14950, 1.7, 0);
INSERT INTO income_tax_rate_us VALUES (356, 'US', 'NM', NULL, 1136102400, 20, 22950, 3.2, 136);
INSERT INTO income_tax_rate_us VALUES (357, 'US', 'NM', NULL, 1136102400, 20, 30950, 4.7, 392);
INSERT INTO income_tax_rate_us VALUES (358, 'US', 'NM', NULL, 1136102400, 20, 30950, 5.3, 768);
INSERT INTO income_tax_rate_us VALUES (359, 'US', 'WV', NULL, 1136102400, 10, 10000, 3.0, 0);
INSERT INTO income_tax_rate_us VALUES (360, 'US', 'WV', NULL, 1136102400, 10, 25000, 4.0, 300);
INSERT INTO income_tax_rate_us VALUES (361, 'US', 'WV', NULL, 1136102400, 10, 40000, 4.5, 900);
INSERT INTO income_tax_rate_us VALUES (362, 'US', 'WV', NULL, 1136102400, 10, 60000, 6.0, 1575);
INSERT INTO income_tax_rate_us VALUES (363, 'US', 'WV', NULL, 1136102400, 10, 60000, 6.5, 2775);
INSERT INTO income_tax_rate_us VALUES (364, 'US', 'WV', NULL, 1136102400, 20, 6000, 3.0, 0);
INSERT INTO income_tax_rate_us VALUES (365, 'US', 'WV', NULL, 1136102400, 20, 15000, 4.0, 180);
INSERT INTO income_tax_rate_us VALUES (366, 'US', 'WV', NULL, 1136102400, 20, 24000, 4.5, 540);
INSERT INTO income_tax_rate_us VALUES (367, 'US', 'WV', NULL, 1136102400, 20, 36000, 6.0, 945);
INSERT INTO income_tax_rate_us VALUES (368, 'US', 'WV', NULL, 1136102400, 20, 36000, 6.5, 1665);
INSERT INTO income_tax_rate_us VALUES (369, 'US', 'NE', NULL, 1136102400, 10, 2000, 0, 0);
INSERT INTO income_tax_rate_us VALUES (370, 'US', 'NE', NULL, 1136102400, 10, 4400, 2.49, 0);
INSERT INTO income_tax_rate_us VALUES (371, 'US', 'NE', NULL, 1136102400, 10, 15500, 3.47, 54.78);
INSERT INTO income_tax_rate_us VALUES (372, 'US', 'NE', NULL, 1136102400, 10, 22750, 5.32, 439.95);
INSERT INTO income_tax_rate_us VALUES (373, 'US', 'NE', NULL, 1136102400, 10, 28100, 6.57, 825.65);
INSERT INTO income_tax_rate_us VALUES (374, 'US', 'NE', NULL, 1136102400, 10, 54100, 6.98, 1177.15);
INSERT INTO income_tax_rate_us VALUES (375, 'US', 'NE', NULL, 1136102400, 10, 75100, 7.22, 2991.95);
INSERT INTO income_tax_rate_us VALUES (376, 'US', 'NE', NULL, 1136102400, 10, 75100, 7.36, 4508.15);
INSERT INTO income_tax_rate_us VALUES (377, 'US', 'NE', NULL, 1136102400, 20, 5250, 0, 0);
INSERT INTO income_tax_rate_us VALUES (378, 'US', 'NE', NULL, 1136102400, 20, 8250, 2.49, 0);
INSERT INTO income_tax_rate_us VALUES (379, 'US', 'NE', NULL, 1136102400, 20, 22400, 3.47, 74.70);
INSERT INTO income_tax_rate_us VALUES (380, 'US', 'NE', NULL, 1136102400, 20, 35400, 5.32, 565.71);
INSERT INTO income_tax_rate_us VALUES (381, 'US', 'NE', NULL, 1136102400, 20, 42950, 6.57, 1257.35);
INSERT INTO income_tax_rate_us VALUES (382, 'US', 'NE', NULL, 1136102400, 20, 58250, 6.98, 1753.35);
INSERT INTO income_tax_rate_us VALUES (383, 'US', 'NE', NULL, 1136102400, 20, 75250, 7.22, 2821.29);
INSERT INTO income_tax_rate_us VALUES (384, 'US', 'NE', NULL, 1136102400, 20, 75250, 7.36, 4048.69);
INSERT INTO income_tax_rate_us VALUES (385, 'US', 'ID', NULL, 1136102400, 10, 1800, 0, 0);
INSERT INTO income_tax_rate_us VALUES (386, 'US', 'ID', NULL, 1136102400, 10, 2959, 1.6, 0);
INSERT INTO income_tax_rate_us VALUES (387, 'US', 'ID', NULL, 1136102400, 10, 4118, 3.6, 19);
INSERT INTO income_tax_rate_us VALUES (388, 'US', 'ID', NULL, 1136102400, 10, 5277, 4.1, 61);
INSERT INTO income_tax_rate_us VALUES (389, 'US', 'ID', NULL, 1136102400, 10, 6436, 5.1, 109);
INSERT INTO income_tax_rate_us VALUES (390, 'US', 'ID', NULL, 1136102400, 10, 7594, 6.1, 168);
INSERT INTO income_tax_rate_us VALUES (391, 'US', 'ID', NULL, 1136102400, 10, 10492, 7.1, 239);
INSERT INTO income_tax_rate_us VALUES (392, 'US', 'ID', NULL, 1136102400, 10, 24978, 7.4, 445);
INSERT INTO income_tax_rate_us VALUES (393, 'US', 'ID', NULL, 1136102400, 10, 24978, 7.8, 1517);
INSERT INTO income_tax_rate_us VALUES (394, 'US', 'ID', NULL, 1136102400, 20, 6800, 0, 0);
INSERT INTO income_tax_rate_us VALUES (395, 'US', 'ID', NULL, 1136102400, 20, 9118, 1.6, 0);
INSERT INTO income_tax_rate_us VALUES (396, 'US', 'ID', NULL, 1136102400, 20, 11436, 3.6, 37);
INSERT INTO income_tax_rate_us VALUES (397, 'US', 'ID', NULL, 1136102400, 20, 13754, 4.1, 120);
INSERT INTO income_tax_rate_us VALUES (398, 'US', 'ID', NULL, 1136102400, 20, 16072, 5.1, 215);
INSERT INTO income_tax_rate_us VALUES (399, 'US', 'ID', NULL, 1136102400, 20, 18388, 6.1, 333);
INSERT INTO income_tax_rate_us VALUES (400, 'US', 'ID', NULL, 1136102400, 20, 24184, 7.1, 474);
INSERT INTO income_tax_rate_us VALUES (401, 'US', 'ID', NULL, 1136102400, 20, 53156, 7.4, 886);
INSERT INTO income_tax_rate_us VALUES (402, 'US', 'ID', NULL, 1136102400, 20, 53156, 7.8, 3030);
INSERT INTO income_tax_rate_us VALUES (403, 'US', 'ME', NULL, 1136102400, 10, 2300, 0, 0);
INSERT INTO income_tax_rate_us VALUES (404, 'US', 'ME', NULL, 1136102400, 10, 6850, 2.0, 0);
INSERT INTO income_tax_rate_us VALUES (405, 'US', 'ME', NULL, 1136102400, 10, 11400, 4.5, 91);
INSERT INTO income_tax_rate_us VALUES (406, 'US', 'ME', NULL, 1136102400, 10, 20550, 7.0, 296);
INSERT INTO income_tax_rate_us VALUES (407, 'US', 'ME', NULL, 1136102400, 10, 20550, 8.5, 936);
INSERT INTO income_tax_rate_us VALUES (408, 'US', 'ME', NULL, 1136102400, 20, 5750, 0, 0);
INSERT INTO income_tax_rate_us VALUES (409, 'US', 'ME', NULL, 1136102400, 20, 14900, 2.0, 0);
INSERT INTO income_tax_rate_us VALUES (410, 'US', 'ME', NULL, 1136102400, 20, 24000, 4.5, 183);
INSERT INTO income_tax_rate_us VALUES (411, 'US', 'ME', NULL, 1136102400, 20, 42300, 7.0, 593);
INSERT INTO income_tax_rate_us VALUES (412, 'US', 'ME', NULL, 1136102400, 20, 42300, 8.5, 1874);
INSERT INTO income_tax_rate_us VALUES (413, 'US', 'ME', NULL, 1136102400, 30, 2875, 0, 0);
INSERT INTO income_tax_rate_us VALUES (414, 'US', 'ME', NULL, 1136102400, 30, 7450, 2.0, 0);
INSERT INTO income_tax_rate_us VALUES (415, 'US', 'ME', NULL, 1136102400, 30, 12000, 4.5, 92);
INSERT INTO income_tax_rate_us VALUES (416, 'US', 'ME', NULL, 1136102400, 30, 21150, 7.0, 296);
INSERT INTO income_tax_rate_us VALUES (417, 'US', 'ME', NULL, 1136102400, 30, 21150, 8.5, 937);
INSERT INTO income_tax_rate_us VALUES (418, 'US', 'HI', NULL, 1136102400, 10, 2000, 1.4, 0);
INSERT INTO income_tax_rate_us VALUES (419, 'US', 'HI', NULL, 1136102400, 10, 4000, 3.2, 28);
INSERT INTO income_tax_rate_us VALUES (420, 'US', 'HI', NULL, 1136102400, 10, 8000, 5.5, 92);
INSERT INTO income_tax_rate_us VALUES (421, 'US', 'HI', NULL, 1136102400, 10, 12000, 6.4, 312);
INSERT INTO income_tax_rate_us VALUES (422, 'US', 'HI', NULL, 1136102400, 10, 16000, 6.8, 568);
INSERT INTO income_tax_rate_us VALUES (423, 'US', 'HI', NULL, 1136102400, 10, 20000, 7.2, 840);
INSERT INTO income_tax_rate_us VALUES (424, 'US', 'HI', NULL, 1136102400, 10, 20000, 7.6, 1128);
INSERT INTO income_tax_rate_us VALUES (425, 'US', 'HI', NULL, 1136102400, 20, 4000, 1.4, 0);
INSERT INTO income_tax_rate_us VALUES (426, 'US', 'HI', NULL, 1136102400, 20, 8000, 3.2, 56);
INSERT INTO income_tax_rate_us VALUES (427, 'US', 'HI', NULL, 1136102400, 20, 16000, 5.5, 184);
INSERT INTO income_tax_rate_us VALUES (428, 'US', 'HI', NULL, 1136102400, 20, 24000, 6.4, 624);
INSERT INTO income_tax_rate_us VALUES (429, 'US', 'HI', NULL, 1136102400, 20, 32000, 6.8, 1136);
INSERT INTO income_tax_rate_us VALUES (430, 'US', 'HI', NULL, 1136102400, 20, 40000, 7.2, 1680);
INSERT INTO income_tax_rate_us VALUES (431, 'US', 'HI', NULL, 1136102400, 20, 40000, 7.6, 2256);

INSERT INTO income_tax_rate_us VALUES (432, 'US', 'RI', NULL, 1136102400, 10, 2650, 0, 0);
INSERT INTO income_tax_rate_us VALUES (433, 'US', 'RI', NULL, 1136102400, 10, 31500, 3.75, 0);
INSERT INTO income_tax_rate_us VALUES (434, 'US', 'RI', NULL, 1136102400, 10, 69750, 7.0, 1081.88);
INSERT INTO income_tax_rate_us VALUES (435, 'US', 'RI', NULL, 1136102400, 10, 151950, 7.75, 3759.38);
INSERT INTO income_tax_rate_us VALUES (436, 'US', 'RI', NULL, 1136102400, 10, 328250, 9.0, 10129.88);
INSERT INTO income_tax_rate_us VALUES (437, 'US', 'RI', NULL, 1136102400, 10, 328250, 9.9, 25996.88);
INSERT INTO income_tax_rate_us VALUES (438, 'US', 'RI', NULL, 1136102400, 20, 6450, 0, 0);
INSERT INTO income_tax_rate_us VALUES (439, 'US', 'RI', NULL, 1136102400, 20, 54750, 3.75, 0);
INSERT INTO income_tax_rate_us VALUES (440, 'US', 'RI', NULL, 1136102400, 20, 116600, 7.0, 1811.25);
INSERT INTO income_tax_rate_us VALUES (441, 'US', 'RI', NULL, 1136102400, 20, 187900, 7.75, 6140.75);
INSERT INTO income_tax_rate_us VALUES (442, 'US', 'RI', NULL, 1136102400, 20, 331500, 9.0, 11666.50);
INSERT INTO income_tax_rate_us VALUES (443, 'US', 'RI', NULL, 1136102400, 20, 331500, 9.9, 24590.50);

INSERT INTO income_tax_rate_us VALUES (444, 'US', 'MT', NULL, 1136102400, 0, 7000, 1.8, 0);
INSERT INTO income_tax_rate_us VALUES (445, 'US', 'MT', NULL, 1136102400, 0, 15000, 4.4, 126);
INSERT INTO income_tax_rate_us VALUES (446, 'US', 'MT', NULL, 1136102400, 0, 120000, 6.0, 478);
INSERT INTO income_tax_rate_us VALUES (447, 'US', 'MT', NULL, 1136102400, 0, 120000, 6.6, 6778);
INSERT INTO income_tax_rate_us VALUES (448, 'US', 'DE', NULL, 1136102400, 0, 2000, 0, 0);
INSERT INTO income_tax_rate_us VALUES (449, 'US', 'DE', NULL, 1136102400, 0, 5000, 2.20, 0);
INSERT INTO income_tax_rate_us VALUES (450, 'US', 'DE', NULL, 1136102400, 0, 10000, 3.90, 66);
INSERT INTO income_tax_rate_us VALUES (451, 'US', 'DE', NULL, 1136102400, 0, 20000, 4.80, 261);
INSERT INTO income_tax_rate_us VALUES (452, 'US', 'DE', NULL, 1136102400, 0, 25000, 5.20, 741);
INSERT INTO income_tax_rate_us VALUES (453, 'US', 'DE', NULL, 1136102400, 0, 60000, 5.55, 1001);
INSERT INTO income_tax_rate_us VALUES (454, 'US', 'DE', NULL, 1136102400, 0, 60000, 5.95, 2943.50);
INSERT INTO income_tax_rate_us VALUES (455, 'US', 'ND', NULL, 1136102400, 10, 3500, 0, 0);
INSERT INTO income_tax_rate_us VALUES (456, 'US', 'ND', NULL, 1136102400, 10, 32500, 2.10, 0);
INSERT INTO income_tax_rate_us VALUES (457, 'US', 'ND', NULL, 1136102400, 10, 68500, 3.92, 609);
INSERT INTO income_tax_rate_us VALUES (458, 'US', 'ND', NULL, 1136102400, 10, 156000, 4.34, 2020.20);
INSERT INTO income_tax_rate_us VALUES (459, 'US', 'ND', NULL, 1136102400, 10, 338100, 5.04, 5839.40);
INSERT INTO income_tax_rate_us VALUES (460, 'US', 'ND', NULL, 1136102400, 10, 338100, 5.54, 14987);
INSERT INTO income_tax_rate_us VALUES (461, 'US', 'ND', NULL, 1136102400, 20, 8500, 0, 0);
INSERT INTO income_tax_rate_us VALUES (462, 'US', 'ND', NULL, 1136102400, 20, 57900, 2.10, 0);
INSERT INTO income_tax_rate_us VALUES (463, 'US', 'ND', NULL, 1136102400, 20, 110000, 3.92, 1037.40);
INSERT INTO income_tax_rate_us VALUES (464, 'US', 'ND', NULL, 1136102400, 20, 196000, 4.34, 3079.72);
INSERT INTO income_tax_rate_us VALUES (465, 'US', 'ND', NULL, 1136102400, 20, 343200, 5.04, 6812.12);
INSERT INTO income_tax_rate_us VALUES (466, 'US', 'ND', NULL, 1136102400, 20, 343200, 5.54, 14231);
INSERT INTO income_tax_rate_us VALUES (467, 'US', 'VT', NULL, 1136102400, 10, 2650, 0, 0);
INSERT INTO income_tax_rate_us VALUES (468, 'US', 'VT', NULL, 1136102400, 10, 32240, 3.6, 0);
INSERT INTO income_tax_rate_us VALUES (469, 'US', 'VT', NULL, 1136102400, 10, 73250, 7.2, 1065.24);
INSERT INTO income_tax_rate_us VALUES (470, 'US', 'VT', NULL, 1136102400, 10, 156650, 8.5, 4017.97);
INSERT INTO income_tax_rate_us VALUES (471, 'US', 'VT', NULL, 1136102400, 10, 338400, 9.0, 11106.96);
INSERT INTO income_tax_rate_us VALUES (472, 'US', 'VT', NULL, 1136102400, 10, 338400, 9.5, 27464.46);
INSERT INTO income_tax_rate_us VALUES (473, 'US', 'VT', NULL, 1136102400, 20, 8000, 0, 0);
INSERT INTO income_tax_rate_us VALUES (474, 'US', 'VT', NULL, 1136102400, 20, 56800, 3.6, 0);
INSERT INTO income_tax_rate_us VALUES (475, 'US', 'VT', NULL, 1136102400, 20, 126900, 7.2, 1756.80);
INSERT INTO income_tax_rate_us VALUES (476, 'US', 'VT', NULL, 1136102400, 20, 195450, 8.5, 6804);
INSERT INTO income_tax_rate_us VALUES (477, 'US', 'VT', NULL, 1136102400, 20, 343550, 9.0, 12630.75);
INSERT INTO income_tax_rate_us VALUES (478, 'US', 'VT', NULL, 1136102400, 20, 343550, 9.5, 25959.75);
INSERT INTO income_tax_rate_us VALUES (479, 'US', 'DC', NULL, 1136102400, 10, 2500, 0, 0);
INSERT INTO income_tax_rate_us VALUES (480, 'US', 'DC', NULL, 1136102400, 10, 10000, 4.5, 0);
INSERT INTO income_tax_rate_us VALUES (481, 'US', 'DC', NULL, 1136102400, 10, 40000, 7.0, 337.50);
INSERT INTO income_tax_rate_us VALUES (482, 'US', 'DC', NULL, 1136102400, 10, 40000, 8.7, 2437.50);
INSERT INTO income_tax_rate_us VALUES (483, 'US', 'DC', NULL, 1136102400, 20, 2500, 0, 0);
INSERT INTO income_tax_rate_us VALUES (484, 'US', 'DC', NULL, 1136102400, 20, 10000, 4.5, 0);
INSERT INTO income_tax_rate_us VALUES (485, 'US', 'DC', NULL, 1136102400, 20, 40000, 7.0, 337.50);
INSERT INTO income_tax_rate_us VALUES (486, 'US', 'DC', NULL, 1136102400, 20, 40000, 8.7, 2437.50);
INSERT INTO income_tax_rate_us VALUES (487, 'US', 'DC', NULL, 1136102400, 30, 1250, 0, 0);
INSERT INTO income_tax_rate_us VALUES (488, 'US', 'DC', NULL, 1136102400, 30, 10000, 4.5, 0);
INSERT INTO income_tax_rate_us VALUES (489, 'US', 'DC', NULL, 1136102400, 30, 40000, 7.0, 393.75);
INSERT INTO income_tax_rate_us VALUES (490, 'US', 'DC', NULL, 1136102400, 30, 40000, 8.7, 2493.75);
INSERT INTO income_tax_rate_us VALUES (491, 'US', 'DC', NULL, 1136102400, 40, 2500, 0, 0);
INSERT INTO income_tax_rate_us VALUES (492, 'US', 'DC', NULL, 1136102400, 40, 10000, 4.5, 0);
INSERT INTO income_tax_rate_us VALUES (493, 'US', 'DC', NULL, 1136102400, 40, 40000, 7.0, 337.50);
INSERT INTO income_tax_rate_us VALUES (494, 'US', 'DC', NULL, 1136102400, 40, 40000, 8.7, 2437.50);


INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 10, 2650, 0, 0);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 10, 32240, 3.75, 0);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 10, 73250, 7.0, 1109.63);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 10, 156650, 7.75, 3980.33);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 10, 338400, 9.0, 10443.83);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 10, 328400, 9.9, 26801.33);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 20, 6450, 0, 0);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 20, 56500, 3.75, 0);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 20, 120200, 7.0, 1876.88);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 20, 193750, 7.75, 6335.88);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 20, 341850, 9.0, 12036.01);
INSERT INTO income_tax_rate_us VALUES (DEFAULT, 'US', 'RI', NULL, 1151218800, 20, 341850, 9.9, 25365.01);


