# gui-uninstall.pl
# $Id: gui-uninstall.pl 15823 2009-10-18 01:41:28Z preining $
#
# Copyright 2008 Tomasz Luczak
# Copyright 2008, 2009 Norbert Preining
#
# GUI for tlmgr
#

our $back_f3 = $back->add("uninstall", -label => __("Uninstallation"), -justify => "left");
$screens{"uninstall"} = $back_f3;

if ($^O=~/^MSWin(32|64)$/i) {
  my $lab = $back_f3->Label(-justify    => 'left', 
           -text => __("Please use the \"Add/Remove Programs\" from the Control Panel!"));

  $lab->pack(-padx => "10m", -pady => "5m");
} else {
  my $lab = $back_f3->Label(-justify    => 'left', 
           -text => __("Really remove the complete TeX Live %s installation?\nYour last chance to change your mind!", $TeXLive::TLConfig::ReleaseYear));

  $lab->pack(-padx => "10m", -pady => "5m");

  my $f = $back_f3->Frame;
  $f->pack(-padx => "10m", -pady => "5m");

  my $ok = $f->Button(-text => __("Remove TeX Live %s", $TeXLive::TLConfig::ReleaseYear), 
          -state => $::action_button_state,
          -command => sub { 
                            system("tlmgr", "uninstall", "--force");
                            $mw->Dialog(-text => __("Complete removal completed"), -buttons => [ __("Ok") ])->Show;
                            $mw->destroy; 
                            exit(0); 
                          });

  $ok->pack(-side => 'left', -padx => "3m");
}

1;

### Local Variables:
### perl-indent-level: 2
### tab-width: 2
### indent-tabs-mode: nil
### End:
# vim:set tabstop=2 expandtab: #
