# gui-arch.pl
# $Id: gui-arch.pl 14998 2009-09-02 08:45:00Z preining $
#
# Copyright 2008 Tomasz Luczak
# Copyright 2008, 2009 Norbert Preining
#
# GUI for tlmgr
#


our $back_arch = $back->add("arch",-label => __("Architectures"));
$screens{"arch"} = $back_arch;

# this will be loaded only on unix systems!
#

our @archsavail;
our @archsinstalled;
our %archs;
our $currentarch;

our %archsbuttons;
our $arch_frame;
our $subframe;

push @update_function_list, \&init_archs;

$back_arch->Label(-text => __("Select architectures to support"))->pack(-padx => "5m", -pady => "5m");


sub init_archs {
  if (!defined($tlmediatlpdb)) {
    @archsavailable = ();
  } else {
    @archsavail = $tlmediatlpdb->available_architectures;
  }
  $currentarch = $localtlmedia->platform();
  @archsinstalled = $localtlpdb->available_architectures;
  foreach my $a (@archsavail) {
    $archs{$a} = 0;
    if (grep(/^$a$/,@archsinstalled)) {
      $archs{$a} = 1;
    }
  }
  foreach my $a (keys %archsbuttons) {
    $archsbuttons{$a}->destroy;
  }
  $arch_frame->destroy if defined($arch_frame);
  $subframe->destroy if defined($subframe);
  $subframe = $back_arch->Frame;
  foreach my $a (@archsavail) {
    $archsbuttons{$a} = 
      $subframe->Checkbutton(-command => sub { check_on_removal($a); },
                          -variable => \$archs{$a}, 
                          -text => platform_desc($a)
                         )->pack(-anchor => 'w');
  }
  $subframe->pack;
  $arch_frame = $back_arch->Frame;
  $arch_frame->pack(-padx => "10m", -pady => "5m");
  $arch_frame->Button(-text => __("Apply changes"), 
    -state => $::action_button_state,
    -command => sub { apply_changes(); })->pack(-side => 'left', -padx => "3m");
  $arch_frame->Button(-text => __("Reset changes"), 
    -state => $::action_button_state,
    -command => sub { init_archs(); })->pack(-side => 'left', -padx => "3m");
}

sub check_on_removal {
  my $a = shift;
  if (!$archs{$a} && $a eq $currentarch) {
    # removal not supported
    $archs{$a} = 1;
    $arch_frame->Dialog(-title => "info",
                        -text => __("Removals of the main architecture not possible!"),
                        -buttons => [ __("Ok") ])->Show;
  }
}


sub apply_changes {
  my @todo_add;
  my @todo_remove;
  foreach my $a (@archsavail) {
    if (!$archs{$a} && grep(/^$a$/,@archsinstalled)) {
      push @todo_remove, $a;
      next;
    }
    if ($archs{$a} && !grep(/^$a$/,@archsinstalled)) {
      push @todo_add, $a;
      next;
    }
  }
  if (@todo_add) {
    execute_action_gui ( "arch", "add", @todo_add );
  }
  if (@todo_remove) {
    execute_action_gui ( "arch", "remove", @todo_remove );
  }
  if (@todo_add || @todo_remove) {
    reinit_local_tlpdb();
    init_archs();
  }
}

1;

### Local Variables:
### perl-indent-level: 2
### tab-width: 2
### indent-tabs-mode: nil
### End:
# vim:set tabstop=2 expandtab: #
