#if !defined(__MSP430_HEADERS_RTC_H__)
#define __MSP430_HEADERS_RTC_H__

/* rtc.h
 *
 * mspgcc project: MSP430 device headers
 * Real-Time Clock
 *
 * Based on cc430x613x.h version 1.5 by Texas Instruments
 *
 * Peter A. Bigot <pab@peoplepowerco.com>
 *
 */

/* Switches:
__MSP430_HAS_RTC__ -- defined to indicate availability of module
__MSP430_RTC_BASE__ - base address of RTC module
*/

#if defined(__MSP430_RTC_BASE__)

#define RTCCTL01_ __MSP430_RTC_BASE__ + 0x00  /* Real Timer Control 0/1 */
sfrw(RTCCTL01, RTCCTL01_);
#define RTCCTL01_L_ __MSP430_RTC_BASE__ + 0x00  
sfrb(RTCCTL01_L, RTCCTL01_L_);
#define RTCCTL01_H_ __MSP430_RTC_BASE__ + 0x01  
sfrb(RTCCTL01_H, RTCCTL01_H_);
#define RTCCTL23_ __MSP430_RTC_BASE__ + 0x02  /* Real Timer Control 2/3 */
sfrw(RTCCTL23, RTCCTL23_);
#define RTCCTL23_L_ __MSP430_RTC_BASE__ + 0x02  
sfrb(RTCCTL23_L, RTCCTL23_L_);
#define RTCCTL23_H_ __MSP430_RTC_BASE__ + 0x03  
sfrb(RTCCTL23_H, RTCCTL23_H_);
#define RTCPS0CTL_ __MSP430_RTC_BASE__ + 0x08  /* Real Timer Prescale Timer 0 Control */
sfrw(RTCPS0CTL, RTCPS0CTL_);
#define RTCPS0CTL_L_ __MSP430_RTC_BASE__ + 0x08  
sfrb(RTCPS0CTL_L, RTCPS0CTL_L_);
#define RTCPS0CTL_H_ __MSP430_RTC_BASE__ + 0x09  
sfrb(RTCPS0CTL_H, RTCPS0CTL_H_);
#define RTCPS1CTL_ __MSP430_RTC_BASE__ + 0x0a  /* Real Timer Prescale Timer 1 Control */
sfrw(RTCPS1CTL, RTCPS1CTL_);
#define RTCPS1CTL_L_ __MSP430_RTC_BASE__ + 0x0a  
sfrb(RTCPS1CTL_L, RTCPS1CTL_L_);
#define RTCPS1CTL_H_ __MSP430_RTC_BASE__ + 0x0b  
sfrb(RTCPS1CTL_H, RTCPS1CTL_H_);
#define RTCPS_ __MSP430_RTC_BASE__ + 0x0c  /* Real Timer Prescale Timer Control */
sfrw(RTCPS, RTCPS_);
#define RTCPS_L_ __MSP430_RTC_BASE__ + 0x0c  
sfrb(RTCPS_L, RTCPS_L_);
#define RTCPS_H_ __MSP430_RTC_BASE__ + 0x0d  
sfrb(RTCPS_H, RTCPS_H_);
#define RTCIV_ __MSP430_RTC_BASE__ + 0x0e  /* Real Time Clock Interrupt Vector */
sfrw(RTCIV, RTCIV_);
#define RTCTIM0_ __MSP430_RTC_BASE__ + 0x10  /* Real Time Clock Time 0 */
sfrw(RTCTIM0, RTCTIM0_);
#define RTCTIM0_L_ __MSP430_RTC_BASE__ + 0x10  
sfrb(RTCTIM0_L, RTCTIM0_L_);
#define RTCTIM0_H_ __MSP430_RTC_BASE__ + 0x11  
sfrb(RTCTIM0_H, RTCTIM0_H_);
#define RTCTIM1_ __MSP430_RTC_BASE__ + 0x12  /* Real Time Clock Time 1 */
sfrw(RTCTIM1, RTCTIM1_);
#define RTCTIM1_L_ __MSP430_RTC_BASE__ + 0x12  
sfrb(RTCTIM1_L, RTCTIM1_L_);
#define RTCTIM1_H_ __MSP430_RTC_BASE__ + 0x13  
sfrb(RTCTIM1_H, RTCTIM1_H_);
#define RTCDATE_ __MSP430_RTC_BASE__ + 0x14  /* Real Time Clock Date */
sfrw(RTCDATE, RTCDATE_);
#define RTCDATE_L_ __MSP430_RTC_BASE__ + 0x14  
sfrb(RTCDATE_L, RTCDATE_L_);
#define RTCDATE_H_ __MSP430_RTC_BASE__ + 0x15  
sfrb(RTCDATE_H, RTCDATE_H_);
#define RTCYEAR_ __MSP430_RTC_BASE__ + 0x16  /* Real Time Clock Year */
sfrw(RTCYEAR, RTCYEAR_);
#define RTCYEAR_L_ __MSP430_RTC_BASE__ + 0x16  
sfrb(RTCYEAR_L, RTCYEAR_L_);
#define RTCYEAR_H_ __MSP430_RTC_BASE__ + 0x17  
sfrb(RTCYEAR_H, RTCYEAR_H_);
#define RTCAMINHR_ __MSP430_RTC_BASE__ + 0x18  /* Real Time Clock Alarm Min/Hour */
sfrw(RTCAMINHR, RTCAMINHR_);
#define RTCAMINHR_L_ __MSP430_RTC_BASE__ + 0x18  
sfrb(RTCAMINHR_L, RTCAMINHR_L_);
#define RTCAMINHR_H_ __MSP430_RTC_BASE__ + 0x19  
sfrb(RTCAMINHR_H, RTCAMINHR_H_);
#define RTCADOWDAY_ __MSP430_RTC_BASE__ + 0x1a  /* Real Time Clock Alarm day of week/day */
sfrw(RTCADOWDAY, RTCADOWDAY_);
#define RTCADOWDAY_L_ __MSP430_RTC_BASE__ + 0x1a  
sfrb(RTCADOWDAY_L, RTCADOWDAY_L_);
#define RTCADOWDAY_H_ __MSP430_RTC_BASE__ + 0x1b  
sfrb(RTCADOWDAY_H, RTCADOWDAY_H_);

#define RTCCTL0                RTCCTL01_L     /* Real Time Clock Control 0 */
#define RTCCTL1                RTCCTL01_H     /* Real Time Clock Control 1 */
#define RTCCTL2                RTCCTL23_L     /* Real Time Clock Control 2 */
#define RTCCTL3                RTCCTL23_H     /* Real Time Clock Control 3 */
#define RTCNT12                RTCTIM0
#define RTCNT34                RTCTIM1
#define RTCNT1                 RTCTIM0_L
#define RTCNT2                 RTCTIM0_H
#define RTCNT3                 RTCTIM1_L
#define RTCNT4                 RTCTIM1_H
#define RTCSEC                 RTCTIM0_L
#define RTCMIN                 RTCTIM0_H
#define RTCHOUR                RTCTIM1_L
#define RTCDOW                 RTCTIM1_H
#define RTCDAY                 RTCDATE_L
#define RTCMON                 RTCDATE_H
#define RTCYEARL               RTCYEAR_L
#define RTCYEARH               RTCYEAR_H
#define RT0PS                  RTCPS_L
#define RT1PS                  RTCPS_H
#define RTCAMIN                RTCAMINHR_L    /* Real Time Clock Alarm Min */
#define RTCAHOUR               RTCAMINHR_H    /* Real Time Clock Alarm Hour */
#define RTCADOW                RTCADOWDAY_L   /* Real Time Clock Alarm day of week */
#define RTCADAY                RTCADOWDAY_H   /* Real Time Clock Alarm day */

/* RTCCTL01 Control Bits */
#define RTCBCD                 (0x8000)       /* RTC BCD  0:Binary / 1:BCD */
#define RTCHOLD                (0x4000)       /* RTC Hold */
#define RTCMODE                (0x2000)       /* RTC Mode 0:Counter / 1: Calendar */
#define RTCRDY                 (0x1000)       /* RTC Ready */
#define RTCSSEL1               (0x0800)       /* RTC Source Select 1 */
#define RTCSSEL0               (0x0400)       /* RTC Source Select 0 */
#define RTCTEV1                (0x0200)       /* RTC Time Event 1 */
#define RTCTEV0                (0x0100)       /* RTC Time Event 0 */
//#define Reserved          (0x0080)
#define RTCTEVIE               (0x0040)       /* RTC Time Event Interrupt Enable Flag */
#define RTCAIE                 (0x0020)       /* RTC Alarm Interrupt Enable Flag */
#define RTCRDYIE               (0x0010)       /* RTC Ready Interrupt Enable Flag */
//#define Reserved          (0x0008)
#define RTCTEVIFG              (0x0004)       /* RTC Time Event Interrupt Flag */
#define RTCAIFG                (0x0002)       /* RTC Alarm Interrupt Flag */
#define RTCRDYIFG              (0x0001)       /* RTC Ready Interrupt Flag */

/* RTCCTL01 Control Bits */
//#define Reserved          (0x0080)
#define RTCTEVIE_L             (0x0040)       /* RTC Time Event Interrupt Enable Flag */
#define RTCAIE_L               (0x0020)       /* RTC Alarm Interrupt Enable Flag */
#define RTCRDYIE_L             (0x0010)       /* RTC Ready Interrupt Enable Flag */
//#define Reserved          (0x0008)
#define RTCTEVIFG_L            (0x0004)       /* RTC Time Event Interrupt Flag */
#define RTCAIFG_L              (0x0002)       /* RTC Alarm Interrupt Flag */
#define RTCRDYIFG_L            (0x0001)       /* RTC Ready Interrupt Flag */

/* RTCCTL01 Control Bits */
#define RTCBCD_H               (0x0080)       /* RTC BCD  0:Binary / 1:BCD */
#define RTCHOLD_H              (0x0040)       /* RTC Hold */
#define RTCMODE_H              (0x0020)       /* RTC Mode 0:Counter / 1: Calendar */
#define RTCRDY_H               (0x0010)       /* RTC Ready */
#define RTCSSEL1_H             (0x0008)       /* RTC Source Select 1 */
#define RTCSSEL0_H             (0x0004)       /* RTC Source Select 0 */
#define RTCTEV1_H              (0x0002)       /* RTC Time Event 1 */
#define RTCTEV0_H              (0x0001)       /* RTC Time Event 0 */
//#define Reserved          (0x0080)
//#define Reserved          (0x0008)

#define RTCSSEL_0              (0x0000)       /* RTC Source Select ACLK */
#define RTCSSEL_1              (0x0400)       /* RTC Source Select SMCLK */
#define RTCSSEL_2              (0x0800)       /* RTC Source Select RT1PS */
#define RTCSSEL_3              (0x0C00)       /* RTC Source Select RT1PS */
#define RTCSSEL__ACLK          (0x0000)       /* RTC Source Select ACLK */
#define RTCSSEL__SMCLK         (0x0400)       /* RTC Source Select SMCLK */
#define RTCSSEL__RT1PS         (0x0800)       /* RTC Source Select RT1PS */
#define RTCTEV_0               (0x0000)       /* RTC Time Event: 0 (Min. changed) */
#define RTCTEV_1               (0x0100)       /* RTC Time Event: 1 (Hour changed) */
#define RTCTEV_2               (0x0200)       /* RTC Time Event: 2 (12:00 changed) */
#define RTCTEV_3               (0x0300)       /* RTC Time Event: 3 (00:00 changed) */
#define RTCTEV__MIN            (0x0000)       /* RTC Time Event: 0 (Min. changed) */
#define RTCTEV__HOUR           (0x0100)       /* RTC Time Event: 1 (Hour changed) */
#define RTCTEV__1200           (0x0200)       /* RTC Time Event: 2 (12:00 changed) */
#define RTCTEV__0000           (0x0300)       /* RTC Time Event: 3 (00:00 changed) */

/* RTCCTL23 Control Bits */
#define RTCCALF1               (0x0200)       /* RTC Calibration Frequency Bit 1 */
#define RTCCALF0               (0x0100)       /* RTC Calibration Frequency Bit 0 */
#define RTCCALS                (0x0080)       /* RTC Calibration Sign */
//#define Reserved          (0x0040)
#define RTCCAL5                (0x0020)       /* RTC Calibration Bit 5 */
#define RTCCAL4                (0x0010)       /* RTC Calibration Bit 4 */
#define RTCCAL3                (0x0008)       /* RTC Calibration Bit 3 */
#define RTCCAL2                (0x0004)       /* RTC Calibration Bit 2 */
#define RTCCAL1                (0x0002)       /* RTC Calibration Bit 1 */
#define RTCCAL0                (0x0001)       /* RTC Calibration Bit 0 */

/* RTCCTL23 Control Bits */
#define RTCCALS_L              (0x0080)       /* RTC Calibration Sign */
//#define Reserved          (0x0040)
#define RTCCAL5_L              (0x0020)       /* RTC Calibration Bit 5 */
#define RTCCAL4_L              (0x0010)       /* RTC Calibration Bit 4 */
#define RTCCAL3_L              (0x0008)       /* RTC Calibration Bit 3 */
#define RTCCAL2_L              (0x0004)       /* RTC Calibration Bit 2 */
#define RTCCAL1_L              (0x0002)       /* RTC Calibration Bit 1 */
#define RTCCAL0_L              (0x0001)       /* RTC Calibration Bit 0 */

/* RTCCTL23 Control Bits */
#define RTCCALF1_H             (0x0002)       /* RTC Calibration Frequency Bit 1 */
#define RTCCALF0_H             (0x0001)       /* RTC Calibration Frequency Bit 0 */
//#define Reserved          (0x0040)

#define RTCCALF_0              (0x0000)       /* RTC Calibration Frequency: No Output */
#define RTCCALF_1              (0x0100)       /* RTC Calibration Frequency: 512 Hz */
#define RTCCALF_2              (0x0200)       /* RTC Calibration Frequency: 256 Hz */
#define RTCCALF_3              (0x0300)       /* RTC Calibration Frequency: 1 Hz */

/* RTCPS0CTL Control Bits */
//#define Reserved          (0x8000)
#define RT0SSEL                (0x4000)       /* RTC Prescale Timer 0 Source Select 0:ACLK / 1:SMCLK */
#define RT0PSDIV2              (0x2000)       /* RTC Prescale Timer 0 Clock Divide Bit: 2 */
#define RT0PSDIV1              (0x1000)       /* RTC Prescale Timer 0 Clock Divide Bit: 1 */
#define RT0PSDIV0              (0x0800)       /* RTC Prescale Timer 0 Clock Divide Bit: 0 */
//#define Reserved          (0x0400)
//#define Reserved          (0x0200)
#define RT0PSHOLD              (0x0100)       /* RTC Prescale Timer 0 Hold */
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)
#define RT0IP2                 (0x0010)       /* RTC Prescale Timer 0 Interrupt Interval Bit: 2 */
#define RT0IP1                 (0x0008)       /* RTC Prescale Timer 0 Interrupt Interval Bit: 1 */
#define RT0IP0                 (0x0004)       /* RTC Prescale Timer 0 Interrupt Interval Bit: 0 */
#define RT0PSIE                (0x0002)       /* RTC Prescale Timer 0 Interrupt Enalbe Flag */
#define RT0PSIFG               (0x0001)       /* RTC Prescale Timer 0 Interrupt Flag */

/* RTCPS0CTL Control Bits */
//#define Reserved          (0x8000)
//#define Reserved          (0x0400)
//#define Reserved          (0x0200)
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)
#define RT0IP2_L               (0x0010)       /* RTC Prescale Timer 0 Interrupt Interval Bit: 2 */
#define RT0IP1_L               (0x0008)       /* RTC Prescale Timer 0 Interrupt Interval Bit: 1 */
#define RT0IP0_L               (0x0004)       /* RTC Prescale Timer 0 Interrupt Interval Bit: 0 */
#define RT0PSIE_L              (0x0002)       /* RTC Prescale Timer 0 Interrupt Enalbe Flag */
#define RT0PSIFG_L             (0x0001)       /* RTC Prescale Timer 0 Interrupt Flag */

/* RTCPS0CTL Control Bits */
//#define Reserved          (0x8000)
#define RT0SSEL_H              (0x0040)       /* RTC Prescale Timer 0 Source Select 0:ACLK / 1:SMCLK */
#define RT0PSDIV2_H            (0x0020)       /* RTC Prescale Timer 0 Clock Divide Bit: 2 */
#define RT0PSDIV1_H            (0x0010)       /* RTC Prescale Timer 0 Clock Divide Bit: 1 */
#define RT0PSDIV0_H            (0x0008)       /* RTC Prescale Timer 0 Clock Divide Bit: 0 */
//#define Reserved          (0x0400)
//#define Reserved          (0x0200)
#define RT0PSHOLD_H            (0x0001)       /* RTC Prescale Timer 0 Hold */
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)

#define RT0IP_0                (0x0000)       /* RTC Prescale Timer 0 Interrupt Interval /2 */
#define RT0IP_1                (0x0004)       /* RTC Prescale Timer 0 Interrupt Interval /4 */
#define RT0IP_2                (0x0008)       /* RTC Prescale Timer 0 Interrupt Interval /8 */
#define RT0IP_3                (0x000C)       /* RTC Prescale Timer 0 Interrupt Interval /16 */
#define RT0IP_4                (0x0010)       /* RTC Prescale Timer 0 Interrupt Interval /32 */
#define RT0IP_5                (0x0014)       /* RTC Prescale Timer 0 Interrupt Interval /64 */
#define RT0IP_6                (0x0018)       /* RTC Prescale Timer 0 Interrupt Interval /128 */
#define RT0IP_7                (0x001C)       /* RTC Prescale Timer 0 Interrupt Interval /256 */

#define RT0PSDIV_0             (0x0000)       /* RTC Prescale Timer 0 Clock Divide /2 */
#define RT0PSDIV_1             (0x0800)       /* RTC Prescale Timer 0 Clock Divide /4 */
#define RT0PSDIV_2             (0x1000)       /* RTC Prescale Timer 0 Clock Divide /8 */
#define RT0PSDIV_3             (0x1800)       /* RTC Prescale Timer 0 Clock Divide /16 */
#define RT0PSDIV_4             (0x2000)       /* RTC Prescale Timer 0 Clock Divide /32 */
#define RT0PSDIV_5             (0x2800)       /* RTC Prescale Timer 0 Clock Divide /64 */
#define RT0PSDIV_6             (0x3000)       /* RTC Prescale Timer 0 Clock Divide /128 */
#define RT0PSDIV_7             (0x3800)       /* RTC Prescale Timer 0 Clock Divide /256 */

/* RTCPS1CTL Control Bits */
#define RT1SSEL1               (0x8000)       /* RTC Prescale Timer 1 Source Select Bit 1 */
#define RT1SSEL0               (0x4000)       /* RTC Prescale Timer 1 Source Select Bit 0 */
#define RT1PSDIV2              (0x2000)       /* RTC Prescale Timer 1 Clock Divide Bit: 2 */
#define RT1PSDIV1              (0x1000)       /* RTC Prescale Timer 1 Clock Divide Bit: 1 */
#define RT1PSDIV0              (0x0800)       /* RTC Prescale Timer 1 Clock Divide Bit: 0 */
//#define Reserved          (0x0400)
//#define Reserved          (0x0200)
#define RT1PSHOLD              (0x0100)       /* RTC Prescale Timer 1 Hold */
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)
#define RT1IP2                 (0x0010)       /* RTC Prescale Timer 1 Interrupt Interval Bit: 2 */
#define RT1IP1                 (0x0008)       /* RTC Prescale Timer 1 Interrupt Interval Bit: 1 */
#define RT1IP0                 (0x0004)       /* RTC Prescale Timer 1 Interrupt Interval Bit: 0 */
#define RT1PSIE                (0x0002)       /* RTC Prescale Timer 1 Interrupt Enalbe Flag */
#define RT1PSIFG               (0x0001)       /* RTC Prescale Timer 1 Interrupt Flag */

/* RTCPS1CTL Control Bits */
//#define Reserved          (0x0400)
//#define Reserved          (0x0200)
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)
#define RT1IP2_L               (0x0010)       /* RTC Prescale Timer 1 Interrupt Interval Bit: 2 */
#define RT1IP1_L               (0x0008)       /* RTC Prescale Timer 1 Interrupt Interval Bit: 1 */
#define RT1IP0_L               (0x0004)       /* RTC Prescale Timer 1 Interrupt Interval Bit: 0 */
#define RT1PSIE_L              (0x0002)       /* RTC Prescale Timer 1 Interrupt Enalbe Flag */
#define RT1PSIFG_L             (0x0001)       /* RTC Prescale Timer 1 Interrupt Flag */

/* RTCPS1CTL Control Bits */
#define RT1SSEL1_H             (0x0080)       /* RTC Prescale Timer 1 Source Select Bit 1 */
#define RT1SSEL0_H             (0x0040)       /* RTC Prescale Timer 1 Source Select Bit 0 */
#define RT1PSDIV2_H            (0x0020)       /* RTC Prescale Timer 1 Clock Divide Bit: 2 */
#define RT1PSDIV1_H            (0x0010)       /* RTC Prescale Timer 1 Clock Divide Bit: 1 */
#define RT1PSDIV0_H            (0x0008)       /* RTC Prescale Timer 1 Clock Divide Bit: 0 */
//#define Reserved          (0x0400)
//#define Reserved          (0x0200)
#define RT1PSHOLD_H            (0x0001)       /* RTC Prescale Timer 1 Hold */
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)

#define RT1IP_0                (0x0000)       /* RTC Prescale Timer 1 Interrupt Interval /2 */
#define RT1IP_1                (0x0004)       /* RTC Prescale Timer 1 Interrupt Interval /4 */
#define RT1IP_2                (0x0008)       /* RTC Prescale Timer 1 Interrupt Interval /8 */
#define RT1IP_3                (0x000C)       /* RTC Prescale Timer 1 Interrupt Interval /16 */
#define RT1IP_4                (0x0010)       /* RTC Prescale Timer 1 Interrupt Interval /32 */
#define RT1IP_5                (0x0014)       /* RTC Prescale Timer 1 Interrupt Interval /64 */
#define RT1IP_6                (0x0018)       /* RTC Prescale Timer 1 Interrupt Interval /128 */
#define RT1IP_7                (0x001C)       /* RTC Prescale Timer 1 Interrupt Interval /256 */

#define RT1PSDIV_0             (0x0000)       /* RTC Prescale Timer 1 Clock Divide /2 */
#define RT1PSDIV_1             (0x0800)       /* RTC Prescale Timer 1 Clock Divide /4 */
#define RT1PSDIV_2             (0x1000)       /* RTC Prescale Timer 1 Clock Divide /8 */
#define RT1PSDIV_3             (0x1800)       /* RTC Prescale Timer 1 Clock Divide /16 */
#define RT1PSDIV_4             (0x2000)       /* RTC Prescale Timer 1 Clock Divide /32 */
#define RT1PSDIV_5             (0x2800)       /* RTC Prescale Timer 1 Clock Divide /64 */
#define RT1PSDIV_6             (0x3000)       /* RTC Prescale Timer 1 Clock Divide /128 */
#define RT1PSDIV_7             (0x3800)       /* RTC Prescale Timer 1 Clock Divide /256 */

#define RT1SSEL_0              (0x0000)       /* RTC Prescale Timer Source Select ACLK */
#define RT1SSEL_1              (0x4000)       /* RTC Prescale Timer Source Select SMCLK */
#define RT1SSEL_2              (0x8000)       /* RTC Prescale Timer Source Select RT0PS */
#define RT1SSEL_3              (0xC000)       /* RTC Prescale Timer Source Select RT0PS */

/* RTC Definitions */
#define RTC_NONE               (0x0000)       /* No Interrupt pending */
#define RTC_RTCRDYIFG          (0x0002)       /* RTC ready: RTCRDYIFG */
#define RTC_RTCTEVIFG          (0x0004)       /* RTC interval timer: RTCTEVIFG */
#define RTC_RTCAIFG            (0x0006)       /* RTC user alarm: RTCAIFG */
#define RTC_RT0PSIFG           (0x0008)       /* RTC prescaler 0: RT0PSIFG */
#define RTC_RT1PSIFG           (0x000A)       /* RTC prescaler 1: RT1PSIFG */

#define RTC_A_VECTOR           RTC_VECTOR     /* 0xFFDC RTC */

#endif /* __MSP430_RTC_BASE__ */

#endif /* __MSP430_HEADERS_RTC_H__ */

