#if !defined(__MSP430_HEADERS_PMM_H__)
#define __MSP430_HEADERS_PMM_H__

/* pmm.h
 *
 * mspgcc project: MSP430 device headers
 * PMM module header
 *
 * (c) 2009 by J.M.Gross <mspgcc@grossibaer.de>
 * Originally based in part on work by Texas Instruments Inc.
 *
 * $Id: $
 *
 */

/* Switches:
__MSP430_PMM_BASE__ - base address of PMM module
*/

#if defined(__MSP430_PMM_BASE__)

// PMM control register 0 bits (PMMCTL0)
// the quickstart guide PMM demo code states that writing the password to
// PMMCTL0_H unlocks the PMM registers for write operation.
// writing a 0 locks them again. (and indeed causes no RESET/NMI)
//
#define PMMPW             (0xa500)                                              // PW for writing PMMCTL0
#define PMMPW_H           (0xa5)                                                // single-byte PW for writing directly to PMMCTL0_H
#define PMMHPMRE          (0x80)                                                // enable global PMM high power module request
#define PMMREGOFF         (0x10)                                                // regulator off
#define PMMSWPOR          (0x08)                                                // trigger POR
#define PMMSWBOR          (0x04)                                                // trigger BOR
#define PMMCOREV1         (0x02)                                                // core voltage bit 1
#define PMMCOREV0         (0x01)                                                // core voltage bit 0
//aliases defined by MSPGCC
#define PMMCOREV_0        (0)
#define PMMCOREV_1        (1)
#define PMMCOREV_2        (2)
#define PMMCOREV_3        (3)

// PMM control register 1 bits (PMMCTL1)
#define PMMCMD1           (0x20)                                                // voltage regulator current mode bit 1
#define PMMCMD0           (0x10)                                                // voltage regulator current mode bit 0
#define PMMREFMD          (0x01)                                                // PMM reference mode
//aliases defined by MSPGCC
#define PMMCMD_0          (0<<4)
#define PMMCMD_1          (1<<4)
#define PMMCMD_2          (2<<4)
#define PMMCMD_3          (3<<4)
#define PMMCMD_LPM        PMMCMD_0                                              // VR current range defined by Low power mode
#define PMMCMD_LOW        PMMCMD_2                                              // VR forced to low current mode
#define PMMCMD_FULL       PMMCMD_3                                              // VR forced to high current mode

// SV supervisor and monitor high side control register bits (SCSMHCTL)
#define SVMHFP            (0x8000)                                              // SVM high side full performance mode
#define SVMHE             (0x4000)                                              // SVM high side enable
#define SVMHOVPE          (0x1000)                                              // SVM high side overvoltage detection enable
#define SVSHFP            (0x0800)                                              // SVS high side full performance mode
#define SVSHE             (0x0400)                                              // SVS high side enable
#define SVSHRVL1          (0x0200)                                              // SVS high side reset voltage level bit 1
#define SVSHRVL0          (0x0100)                                              // SVS high side reset voltage level bit 0
#define SVSMHACE          (0x0080)                                              // SVS/SVM high side automatic control enable
#define SCSMHEVM          (0x0040)                                              // SVS/SVM high side event mask
#define SVSHMD            (0x0010)                                              // SVS high side mode
#define SVSMHDLYST        (0x0008)                                              // SVS/SVM high side delay status
#define SVSMHRRL2         (0x0004)                                              // SVS/SVM high side release voltage level bit 2
#define SVSMHRRL1         (0x0002)                                              // SVS/SVM high side release voltage level bit 1
#define SVSMHRRL0         (0x0001)                                              // SVS/SVM high side release voltage level bit 0
//aliases defined by MSPGCC
#define SVSHRVL_0         (0<<8)                                                // SVS high side reset voltage level 0
#define SVSHRVL_1         (1<<8)                                                // SVS high side reset voltage level 1
#define SVSHRVL_2         (2<<8)                                                // SVS high side reset voltage level 2
#define SVSHRVL_3         (3<<8)                                                // SVS high side reset voltage level 3
#define SVSMHRRL_0        (0)                                                   // SVS/SVM high side release voltage level 0
#define SVSMHRRL_1        (1)                                                   // SVS/SVM high side release voltage level 1
#define SVSMHRRL_2        (2)                                                   // SVS/SVM high side release voltage level 2
#define SVSMHRRL_3        (3)                                                   // SVS/SVM high side release voltage level 3
#define SVSMHRRL_4        (4)                                                   // SVS/SVM high side release voltage level 4
#define SVSMHRRL_5        (5)                                                   // SVS/SVM high side release voltage level 5
#define SVSMHRRL_6        (6)                                                   // SVS/SVM high side release voltage level 6
#define SVSMHRRL_7        (7)                                                   // SVS/SVM high side release voltage level 7

// SV supervisor and monitor low side control register bits (SCSMLCTL)
#define SVMLFP            (0x8000)                                              // SVM low side full performance mode
#define SVMLE             (0x4000)                                              // SVM low side enable
#define SVMLOVPE          (0x1000)                                              // SVM low side overvoltage detection enable
#define SVSLFP            (0x0800)                                              // SVS low side full performance mode
#define SVSLE             (0x0400)                                              // SVS low side enable
#define SVSLRVL1          (0x0200)                                              // SVS low side reset voltage level bit 1
#define SVSLRVL0          (0x0100)                                              // SVS low side reset voltage level bit 0
#define SVSMLACE          (0x0080)                                              // SVS/SVM low side automatic control enable
#define SCSMLEVM          (0x0040)                                              // SVS/SVM low side event mask
#define SVSLMD            (0x0010)                                              // SVS low side mode
#define SVSMLDLYST        (0x0008)                                              // SVS/SVM low side delay status
#define SVSMLRRL2         (0x0004)                                              // SVS/SVM low side release voltage level bit 2
#define SVSMLRRL1         (0x0002)                                              // SVS/SVM low side release voltage level bit 1
#define SVSMLRRL0         (0x0001)                                              // SVS/SVM low side release voltage level bit 0
//aliases defined by MSPGCC
#define SVSLRVL_0         (0<<8)                                                // SVS low side reset voltage level 0
#define SVSLRVL_1         (1<<8)                                                // SVS low side reset voltage level 1
#define SVSLRVL_2         (2<<8)                                                // SVS low side reset voltage level 2
#define SVSLRVL_3         (3<<8)                                                // SVS low side reset voltage level 3
#define SVSMLRRL_0        (0)                                                   // SVS/SVM low side release voltage level 0
#define SVSMLRRL_1        (1)                                                   // SVS/SVM low side release voltage level 1
#define SVSMLRRL_2        (2)                                                   // SVS/SVM low side release voltage level 2
#define SVSMLRRL_3        (3)                                                   // SVS/SVM low side release voltage level 3
#define SVSMLRRL_4        (4)                                                   // SVS/SVM low side release voltage level 4
#define SVSMLRRL_5        (5)                                                   // SVS/SVM low side release voltage level 5
#define SVSMLRRL_6        (6)                                                   // SVS/SVM low side release voltage level 6
#define SVSMLRRL_7        (7)                                                   // SVS/SVM low side release voltage level 7

// SVSIN and SVMOUT control register bits (SVSMIO)
#define SVMHVLROE         (0x1000)                                              // SVM high side voltage level reached output enable
#define SVMHOE            (0x0800)                                              // SVM high side output enable
#define SVMOUTPOL         (0x0020)                                              // SVMOUT pin polarity high
#define SVMLVLROE         (0x0010)                                              // SVM low side voltage level reached output enable
#define SVMLOE            (0x0008)                                              // SVM low side output enable

// PMM interrupt flag register bits (PMMIFG)
#define PMMLPM5IFG        (0x8000)                                              // LPM5 flag
#define SVSLIFG           (0x2000)                                              // SVS low side interrupt flag
#define SVSHIFG           (0x1000)                                              // SVS high side interrupt flag
#define PMMPORIFG         (0x0400)                                              // PMM software POR interrupt flag
#define PMMRSTIFG         (0x0200)                                              // PMM reset pin interrupt flag
#define PMMBORIFG         (0x0100)                                              // PMM software BOR interrupt flag
#define SVMHVLRIFG        (0x0040)                                              // SVM high side voltage level reached interrupt flag
#define SVMHIFG           (0x0020)                                              // SVM high side interrupt flag
#define SVSMHDLYIFG       (0x0010)                                              // SVS/SVM high side delay expired interrupt flag
#define SVMLVLRIFG        (0x0004)                                              // SVM low side voltage level reached intterrupt flag
#define SVMLIFG           (0x0002)                                              // SVM low side interrupt flag
#define SVSMLDLYIFG       (0x0001)                                              // SVS/SVM low side delay expired interrupt flag

// PMM reset and interrupt enable register (PMMRIE)
#define SVMHVLRPE         (0x2000)                                              // SVM high side voltage level reached power on reset enable
#define SVSHPE            (0x1000)                                              // SVS high side power on reset enable
#define SVMLVLRPE         (0x0200)                                              // SVM low side voltage level reached power on reset enable
#define SVSLPE            (0x0100)                                              // SVS low side power on reset enable
#define SVMHVLRIE         (0x0040)                                              // SVM high side reset voltage level interrupt enable
#define SVMHIE            (0x0020)                                              // SVM high side interrupt enable
#define SVSMHDLYIE        (0x0010)                                              // SVS/SVM high side delay expired interrupt enable
#define SVMLVLRIE         (0x0004)                                              // SVM low side reset voltage level interrupt enable
#define SVMLIE            (0x0002)                                              // SVM low side interrupt enable
#define SVSMLDLYIE        (0x0001)                                              // SVS/SVM low side delay expired interrupt enable

// Power mode 5 control register 0
#define LOCKIO            (0x0001)                                              // lock I/O pin configuration


#define PMMCTL0_           __MSP430_PMM_BASE__ + 0x00                           // PMM control register 0
sfrw(PMMCTL0, PMMCTL0_);
sfrb(PMMCTL0_L, PMMCTL0_);
sfrb(PMMCTL0_H, PMMCTL0_ +1);
#define PMMCTL1_           __MSP430_PMM_BASE__ + 0x02                           // PMM control register 1
sfrw(PMMCTL1, PMMCTL1_);
#define SVSMHCTL_          __MSP430_PMM_BASE__ + 0x04                           // SVS/SVM high side control register
sfrw(SVSMHCTL, SVSMHCTL_);
#define SVSMLCTL_          __MSP430_PMM_BASE__ + 0x06                           // SVS/SVM low side control register
sfrw(SVSMLCTL, SVSMLCTL_);
#define SVSMIO_            __MSP430_PMM_BASE__ + 0x08                           // SVSIN and SVMOUT control register (optional, does not exist in device datasheet peripheral map)
sfrw(SVSMIO, SVSMIO_);
#define PMMIFG_            __MSP430_PMM_BASE__ + 0x0C                           // PMM interrupt flag register      // family users guide says 0x0A
sfrw(PMMIFG, PMMIFG_);
#define PMMRIE_            __MSP430_PMM_BASE__ + 0x0E                           // PMM reset and interrupt enable register
sfrw(PMMRIE, PMMRIE_);
#define PM5CTL0_           __MSP430_PMM_BASE__ + 0x10                           // Power mode 5 control register 0  // only exists in user guide, not in device dataheet peripheral map
sfrw(PM5CTL0, PM5CTL0_);                                                        // errata sheet tells this is not really working at all.

#endif /* __MSP430_PMM_BASE__ */

#endif /* __MSP430_HEADERS_PMM_H__ */
