/**
 * \file libdvd.h
 * \author Stphane Borel <stef@via.ecp.fr>
 * \author Samuel Hocevar <sam@zoy.org>
 * \brief The \e libdvd public header.
 *
 * This header contains the public types and functions that applications
 * using \e libdvd may use.
 */

/*
 * Copyright (C) 1998-2002 VideoLAN
 * $Id: libdvd.h,v 1.3 2004/03/01 21:36:21 hshoexer Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 */

#ifndef _LIBDVD_LIBDVD_H
#ifndef _DOXYGEN_SKIP_ME
#define _LIBDVD_LIBDVD_H 1
#endif

#ifdef __cplusplus
extern "C" {
#endif

/** Library instance handle, to be used for each library call. */
typedef struct libdvd_s* libdvd_t;


/** The block size of a DVD. */
#define LIBDVD_BLOCK_SIZE      2048

/** The default flag to be used by \e libdvd functions. */
#define LIBDVD_NOFLAGS         0

/** Flag to ask libdvd_read() to decrypt the data it reads. */
#define LIBDVD_READ_DECRYPT    (1 << 0)

/** Flag to tell libdvd_seek() it is seeking in MPEG data. */
#define LIBDVD_SEEK_MPEG       (1 << 0)

/** Flag to ask libdvd_seek() to check the current title key. */
#define LIBDVD_SEEK_KEY        (1 << 1)


/*
 * Our version number. The variable name contains the interface version.
 */
extern char *        libdvd_interface_2;


/*
 * Exported prototypes.
 */
extern libdvd_t libdvd_open  ( char *psz_target );
extern int      libdvd_close ( libdvd_t );
extern int      libdvd_seek  ( libdvd_t,
                               int i_blocks,
                               int i_flags );
extern int      libdvd_read  ( libdvd_t,
                               void *p_buffer,
                               int i_blocks,
                               int i_flags );
extern int      libdvd_readv ( libdvd_t,
                               void *p_iovec,
                               int i_blocks,
                               int i_flags );
extern char *   libdvd_error ( libdvd_t );


/*
 * Deprecated stuff.
 */
#ifndef _DOXYGEN_SKIP_ME
#define libdvd_title(a,b) libdvd_seek(a,b,LIBDVD_SEEK_KEY)
#define libdvd_handle libdvd_t
#endif


#ifdef __cplusplus
}
#endif

#endif /* <libdvd/libdvd.h> */
