require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&HEADER_ASN1_H)) {
    eval 'sub HEADER_ASN1_H () {1;}' unless defined(&HEADER_ASN1_H);
    require 'time.ph';
    require 'openssl/e_os2.ph';
    unless(defined(&OPENSSL_NO_BIO)) {
	require 'openssl/bio.ph';
    }
    require 'openssl/stack.ph';
    require 'openssl/safestack.ph';
    require 'openssl/symhacks.ph';
    require 'openssl/ossl_typ.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
	require 'openssl/bn.ph';
    }
    if(defined(&OPENSSL_BUILD_SHLIBCRYPTO)) {
	undef(&OPENSSL_EXTERN) if defined(&OPENSSL_EXTERN);
	eval 'sub OPENSSL_EXTERN () { &OPENSSL_EXPORT;}' unless defined(&OPENSSL_EXTERN);
    }
    if(defined(&__cplusplus)) {
    }
    eval 'sub V_ASN1_UNIVERSAL () {0x;}' unless defined(&V_ASN1_UNIVERSAL);
    eval 'sub V_ASN1_APPLICATION () {0x40;}' unless defined(&V_ASN1_APPLICATION);
    eval 'sub V_ASN1_CONTEXT_SPECIFIC () {0x80;}' unless defined(&V_ASN1_CONTEXT_SPECIFIC);
    eval 'sub V_ASN1_PRIVATE () {0xc0;}' unless defined(&V_ASN1_PRIVATE);
    eval 'sub V_ASN1_CONSTRUCTED () {0x20;}' unless defined(&V_ASN1_CONSTRUCTED);
    eval 'sub V_ASN1_PRIMITIVE_TAG () {0x1f;}' unless defined(&V_ASN1_PRIMITIVE_TAG);
    eval 'sub V_ASN1_PRIMATIVE_TAG () {0x1f;}' unless defined(&V_ASN1_PRIMATIVE_TAG);
    eval 'sub V_ASN1_APP_CHOOSE () {-2;}' unless defined(&V_ASN1_APP_CHOOSE);
    eval 'sub V_ASN1_OTHER () {-3;}' unless defined(&V_ASN1_OTHER);
    eval 'sub V_ASN1_ANY () {-4;}' unless defined(&V_ASN1_ANY);
    eval 'sub V_ASN1_NEG () {0x100;}' unless defined(&V_ASN1_NEG);
    eval 'sub V_ASN1_UNDEF () {-1;}' unless defined(&V_ASN1_UNDEF);
    eval 'sub V_ASN1_EOC () {0;}' unless defined(&V_ASN1_EOC);
    eval 'sub V_ASN1_BOOLEAN () {1;}' unless defined(&V_ASN1_BOOLEAN);
    eval 'sub V_ASN1_INTEGER () {2;}' unless defined(&V_ASN1_INTEGER);
    eval 'sub V_ASN1_NEG_INTEGER () {(2|  &V_ASN1_NEG);}' unless defined(&V_ASN1_NEG_INTEGER);
    eval 'sub V_ASN1_BIT_STRING () {3;}' unless defined(&V_ASN1_BIT_STRING);
    eval 'sub V_ASN1_OCTET_STRING () {4;}' unless defined(&V_ASN1_OCTET_STRING);
    eval 'sub V_ASN1_NULL () {5;}' unless defined(&V_ASN1_NULL);
    eval 'sub V_ASN1_OBJECT () {6;}' unless defined(&V_ASN1_OBJECT);
    eval 'sub V_ASN1_OBJECT_DESCRIPTOR () {7;}' unless defined(&V_ASN1_OBJECT_DESCRIPTOR);
    eval 'sub V_ASN1_EXTERNAL () {8;}' unless defined(&V_ASN1_EXTERNAL);
    eval 'sub V_ASN1_REAL () {9;}' unless defined(&V_ASN1_REAL);
    eval 'sub V_ASN1_ENUMERATED () {10;}' unless defined(&V_ASN1_ENUMERATED);
    eval 'sub V_ASN1_NEG_ENUMERATED () {(10|  &V_ASN1_NEG);}' unless defined(&V_ASN1_NEG_ENUMERATED);
    eval 'sub V_ASN1_UTF8STRING () {12;}' unless defined(&V_ASN1_UTF8STRING);
    eval 'sub V_ASN1_SEQUENCE () {16;}' unless defined(&V_ASN1_SEQUENCE);
    eval 'sub V_ASN1_SET () {17;}' unless defined(&V_ASN1_SET);
    eval 'sub V_ASN1_NUMERICSTRING () {18;}' unless defined(&V_ASN1_NUMERICSTRING);
    eval 'sub V_ASN1_PRINTABLESTRING () {19;}' unless defined(&V_ASN1_PRINTABLESTRING);
    eval 'sub V_ASN1_T61STRING () {20;}' unless defined(&V_ASN1_T61STRING);
    eval 'sub V_ASN1_TELETEXSTRING () {20;}' unless defined(&V_ASN1_TELETEXSTRING);
    eval 'sub V_ASN1_VIDEOTEXSTRING () {21;}' unless defined(&V_ASN1_VIDEOTEXSTRING);
    eval 'sub V_ASN1_IA5STRING () {22;}' unless defined(&V_ASN1_IA5STRING);
    eval 'sub V_ASN1_UTCTIME () {23;}' unless defined(&V_ASN1_UTCTIME);
    eval 'sub V_ASN1_GENERALIZEDTIME () {24;}' unless defined(&V_ASN1_GENERALIZEDTIME);
    eval 'sub V_ASN1_GRAPHICSTRING () {25;}' unless defined(&V_ASN1_GRAPHICSTRING);
    eval 'sub V_ASN1_ISO64STRING () {26;}' unless defined(&V_ASN1_ISO64STRING);
    eval 'sub V_ASN1_VISIBLESTRING () {26;}' unless defined(&V_ASN1_VISIBLESTRING);
    eval 'sub V_ASN1_GENERALSTRING () {27;}' unless defined(&V_ASN1_GENERALSTRING);
    eval 'sub V_ASN1_UNIVERSALSTRING () {28;}' unless defined(&V_ASN1_UNIVERSALSTRING);
    eval 'sub V_ASN1_BMPSTRING () {30;}' unless defined(&V_ASN1_BMPSTRING);
    eval 'sub B_ASN1_NUMERICSTRING () {0x1;}' unless defined(&B_ASN1_NUMERICSTRING);
    eval 'sub B_ASN1_PRINTABLESTRING () {0x2;}' unless defined(&B_ASN1_PRINTABLESTRING);
    eval 'sub B_ASN1_T61STRING () {0x4;}' unless defined(&B_ASN1_T61STRING);
    eval 'sub B_ASN1_TELETEXSTRING () {0x4;}' unless defined(&B_ASN1_TELETEXSTRING);
    eval 'sub B_ASN1_VIDEOTEXSTRING () {0x8;}' unless defined(&B_ASN1_VIDEOTEXSTRING);
    eval 'sub B_ASN1_IA5STRING () {0x10;}' unless defined(&B_ASN1_IA5STRING);
    eval 'sub B_ASN1_GRAPHICSTRING () {0x20;}' unless defined(&B_ASN1_GRAPHICSTRING);
    eval 'sub B_ASN1_ISO64STRING () {0x40;}' unless defined(&B_ASN1_ISO64STRING);
    eval 'sub B_ASN1_VISIBLESTRING () {0x40;}' unless defined(&B_ASN1_VISIBLESTRING);
    eval 'sub B_ASN1_GENERALSTRING () {0x80;}' unless defined(&B_ASN1_GENERALSTRING);
    eval 'sub B_ASN1_UNIVERSALSTRING () {0x100;}' unless defined(&B_ASN1_UNIVERSALSTRING);
    eval 'sub B_ASN1_OCTET_STRING () {0x200;}' unless defined(&B_ASN1_OCTET_STRING);
    eval 'sub B_ASN1_BIT_STRING () {0x400;}' unless defined(&B_ASN1_BIT_STRING);
    eval 'sub B_ASN1_BMPSTRING () {0x800;}' unless defined(&B_ASN1_BMPSTRING);
    eval 'sub B_ASN1_UNKNOWN () {0x1000;}' unless defined(&B_ASN1_UNKNOWN);
    eval 'sub B_ASN1_UTF8STRING () {0x2000;}' unless defined(&B_ASN1_UTF8STRING);
    eval 'sub B_ASN1_UTCTIME () {0x4000;}' unless defined(&B_ASN1_UTCTIME);
    eval 'sub B_ASN1_GENERALIZEDTIME () {0x8000;}' unless defined(&B_ASN1_GENERALIZEDTIME);
    eval 'sub B_ASN1_SEQUENCE () {0x10000;}' unless defined(&B_ASN1_SEQUENCE);
    eval 'sub MBSTRING_FLAG () {0x1000;}' unless defined(&MBSTRING_FLAG);
    eval 'sub MBSTRING_UTF8 () {( &MBSTRING_FLAG);}' unless defined(&MBSTRING_UTF8);
    eval 'sub MBSTRING_ASC () {( &MBSTRING_FLAG|1);}' unless defined(&MBSTRING_ASC);
    eval 'sub MBSTRING_BMP () {( &MBSTRING_FLAG|2);}' unless defined(&MBSTRING_BMP);
    eval 'sub MBSTRING_UNIV () {( &MBSTRING_FLAG|4);}' unless defined(&MBSTRING_UNIV);
    eval 'sub SMIME_OLDMIME () {0x400;}' unless defined(&SMIME_OLDMIME);
    eval 'sub SMIME_CRLFEOL () {0x800;}' unless defined(&SMIME_CRLFEOL);
    eval 'sub SMIME_STREAM () {0x1000;}' unless defined(&SMIME_STREAM);
    eval 'sub DECLARE_ASN1_SET_OF {
        my($type) = @_;
	    eval q();
    }' unless defined(&DECLARE_ASN1_SET_OF);
    eval 'sub IMPLEMENT_ASN1_SET_OF {
        my($type) = @_;
	    eval q();
    }' unless defined(&IMPLEMENT_ASN1_SET_OF);
    eval 'sub ASN1_OBJECT_FLAG_DYNAMIC () {0x1;}' unless defined(&ASN1_OBJECT_FLAG_DYNAMIC);
    eval 'sub ASN1_OBJECT_FLAG_CRITICAL () {0x2;}' unless defined(&ASN1_OBJECT_FLAG_CRITICAL);
    eval 'sub ASN1_OBJECT_FLAG_DYNAMIC_STRINGS () {0x4;}' unless defined(&ASN1_OBJECT_FLAG_DYNAMIC_STRINGS);
    eval 'sub ASN1_OBJECT_FLAG_DYNAMIC_DATA () {0x8;}' unless defined(&ASN1_OBJECT_FLAG_DYNAMIC_DATA);
    eval 'sub ASN1_STRING_FLAG_BITS_LEFT () {0x8;}' unless defined(&ASN1_STRING_FLAG_BITS_LEFT);
    eval 'sub ASN1_STRING_FLAG_NDEF () {0x10;}' unless defined(&ASN1_STRING_FLAG_NDEF);
    eval 'sub ASN1_STRING_FLAG_CONT () {0x20;}' unless defined(&ASN1_STRING_FLAG_CONT);
    eval 'sub ASN1_LONG_UNDEF () {0x7fffffff;}' unless defined(&ASN1_LONG_UNDEF);
    eval 'sub STABLE_FLAGS_MALLOC () {0x1;}' unless defined(&STABLE_FLAGS_MALLOC);
    eval 'sub STABLE_NO_MASK () {0x2;}' unless defined(&STABLE_NO_MASK);
    eval 'sub DIRSTRING_TYPE () {( &B_ASN1_PRINTABLESTRING| &B_ASN1_T61STRING| &B_ASN1_BMPSTRING| &B_ASN1_UTF8STRING);}' unless defined(&DIRSTRING_TYPE);
    eval 'sub PKCS9STRING_TYPE () {( &DIRSTRING_TYPE| &B_ASN1_IA5STRING);}' unless defined(&PKCS9STRING_TYPE);
    eval 'sub ub_name () {32768;}' unless defined(&ub_name);
    eval 'sub ub_common_name () {64;}' unless defined(&ub_common_name);
    eval 'sub ub_locality_name () {128;}' unless defined(&ub_locality_name);
    eval 'sub ub_state_name () {128;}' unless defined(&ub_state_name);
    eval 'sub ub_organization_name () {64;}' unless defined(&ub_organization_name);
    eval 'sub ub_organization_unit_name () {64;}' unless defined(&ub_organization_unit_name);
    eval 'sub ub_title () {64;}' unless defined(&ub_title);
    eval 'sub ub_email_address () {128;}' unless defined(&ub_email_address);
    eval 'sub DECLARE_ASN1_FUNCTIONS {
        my($type) = @_;
	    eval q( &DECLARE_ASN1_FUNCTIONS_name($type, $type));
    }' unless defined(&DECLARE_ASN1_FUNCTIONS);
    eval 'sub DECLARE_ASN1_ALLOC_FUNCTIONS {
        my($type) = @_;
	    eval q( &DECLARE_ASN1_ALLOC_FUNCTIONS_name($type, $type));
    }' unless defined(&DECLARE_ASN1_ALLOC_FUNCTIONS);
    eval 'sub DECLARE_ASN1_FUNCTIONS_name {
        my($type, $name) = @_;
	    eval q( &DECLARE_ASN1_ALLOC_FUNCTIONS_name($type, $name)  &DECLARE_ASN1_ENCODE_FUNCTIONS($type, $name, $name));
    }' unless defined(&DECLARE_ASN1_FUNCTIONS_name);
    eval 'sub DECLARE_ASN1_FUNCTIONS_fname {
        my($type, $itname, $name) = @_;
	    eval q( &DECLARE_ASN1_ALLOC_FUNCTIONS_name($type, $name)  &DECLARE_ASN1_ENCODE_FUNCTIONS($type, $itname, $name));
    }' unless defined(&DECLARE_ASN1_FUNCTIONS_fname);
    eval 'sub DECLARE_ASN1_ENCODE_FUNCTIONS {
        my($type, $itname, $name) = @_;
	    eval q($type * &d2i_$name($type ** &a,  &const \'unsigned char\' ** &in, \'long len\'); \'int\'  &i2d_$name($type * &a, \'unsigned char\' ** &out);  &DECLARE_ASN1_ITEM($itname));
    }' unless defined(&DECLARE_ASN1_ENCODE_FUNCTIONS);
    eval 'sub DECLARE_ASN1_ENCODE_FUNCTIONS_const {
        my($type, $name) = @_;
	    eval q($type * &d2i_$name($type ** &a,  &const \'unsigned char\' ** &in, \'long len\'); \'int\'  &i2d_$name( &const $type * &a, \'unsigned char\' ** &out);  &DECLARE_ASN1_ITEM($name));
    }' unless defined(&DECLARE_ASN1_ENCODE_FUNCTIONS_const);
    eval 'sub DECLARE_ASN1_NDEF_FUNCTION {
        my($name) = @_;
	    eval q(\'int\'  &i2d_$name &_NDEF($name * &a, \'unsigned char\' ** &out););
    }' unless defined(&DECLARE_ASN1_NDEF_FUNCTION);
    eval 'sub DECLARE_ASN1_FUNCTIONS_const {
        my($name) = @_;
	    eval q( &DECLARE_ASN1_ALLOC_FUNCTIONS($name)  &DECLARE_ASN1_ENCODE_FUNCTIONS_const($name, $name));
    }' unless defined(&DECLARE_ASN1_FUNCTIONS_const);
    eval 'sub DECLARE_ASN1_ALLOC_FUNCTIONS_name {
        my($type, $name) = @_;
	    eval q($type *$name &_new( &void);  &void $name &_free($type * &a););
    }' unless defined(&DECLARE_ASN1_ALLOC_FUNCTIONS_name);
    eval 'sub D2I_OF {
        my($type) = @_;
	    eval q($type *(*)($type **, &const \'unsigned char\' **,\'long\'));
    }' unless defined(&D2I_OF);
    eval 'sub I2D_OF {
        my($type) = @_;
	    eval q( &int (*)($type *,\'unsigned char\' **));
    }' unless defined(&I2D_OF);
    eval 'sub I2D_OF_const {
        my($type) = @_;
	    eval q( &int (*)( &const $type *,\'unsigned char\' **));
    }' unless defined(&I2D_OF_const);
    eval 'sub CHECKED_D2I_OF {
        my($type, $d2i) = @_;
	    eval q((( &d2i_of_void*) (1? $d2i : (( &D2I_OF($type))0))));
    }' unless defined(&CHECKED_D2I_OF);
    eval 'sub CHECKED_I2D_OF {
        my($type, $i2d) = @_;
	    eval q((( &i2d_of_void*) (1? $i2d : (( &I2D_OF($type))0))));
    }' unless defined(&CHECKED_I2D_OF);
    eval 'sub CHECKED_NEW_OF {
        my($type, $xnew) = @_;
	    eval q((( &void *(*)( &void)) (1? $xnew : (($type *(*)( &void))0))));
    }' unless defined(&CHECKED_NEW_OF);
    eval 'sub CHECKED_PTR_OF {
        my($type, $p) = @_;
	    eval q((( &void*) (1? $p : ($type*)0)));
    }' unless defined(&CHECKED_PTR_OF);
    eval 'sub CHECKED_PPTR_OF {
        my($type, $p) = @_;
	    eval q((( &void**) (1? $p : ($type**)0)));
    }' unless defined(&CHECKED_PPTR_OF);
    eval 'sub TYPEDEF_D2I_OF {
        my($type) = @_;
	    eval q( &typedef $type * &d2i_of_$type($type **, &const \'unsigned char\' **,\'long\'));
    }' unless defined(&TYPEDEF_D2I_OF);
    eval 'sub TYPEDEF_I2D_OF {
        my($type) = @_;
	    eval q( &typedef \'int\'  &i2d_of_$type($type *,\'unsigned char\' **));
    }' unless defined(&TYPEDEF_I2D_OF);
    eval 'sub TYPEDEF_D2I2D_OF {
        my($type) = @_;
	    eval q( &TYPEDEF_D2I_OF($type);  &TYPEDEF_I2D_OF($type));
    }' unless defined(&TYPEDEF_D2I2D_OF);
    unless(defined(&OPENSSL_EXPORT_VAR_AS_FUNCTION)) {
	eval 'sub ASN1_ITEM_ptr {
	    my($iptr) = @_;
    	    eval q(($iptr));
	}' unless defined(&ASN1_ITEM_ptr);
	eval 'sub ASN1_ITEM_ref {
	    my($iptr) = @_;
    	    eval q((($iptr &_it)));
	}' unless defined(&ASN1_ITEM_ref);
	eval 'sub ASN1_ITEM_rptr {
	    my($ref) = @_;
    	    eval q((($ref &_it)));
	}' unless defined(&ASN1_ITEM_rptr);
	eval 'sub DECLARE_ASN1_ITEM {
	    my($name) = @_;
    	    eval q( &OPENSSL_EXTERN  &const  &ASN1_ITEM $name &_it;);
	}' unless defined(&DECLARE_ASN1_ITEM);
    } else {
	eval 'sub ASN1_ITEM_ptr {
	    my($iptr) = @_;
    	    eval q(($iptr()));
	}' unless defined(&ASN1_ITEM_ptr);
	eval 'sub ASN1_ITEM_ref {
	    my($iptr) = @_;
    	    eval q(($iptr &_it));
	}' unless defined(&ASN1_ITEM_ref);
	eval 'sub ASN1_ITEM_rptr {
	    my($ref) = @_;
    	    eval q(($ref &_it()));
	}' unless defined(&ASN1_ITEM_rptr);
	eval 'sub DECLARE_ASN1_ITEM {
	    my($name) = @_;
    	    eval q( &const  &ASN1_ITEM * $name &_it( &void););
	}' unless defined(&DECLARE_ASN1_ITEM);
    }
    eval 'sub ASN1_STRFLGS_ESC_2253 () {1;}' unless defined(&ASN1_STRFLGS_ESC_2253);
    eval 'sub ASN1_STRFLGS_ESC_CTRL () {2;}' unless defined(&ASN1_STRFLGS_ESC_CTRL);
    eval 'sub ASN1_STRFLGS_ESC_MSB () {4;}' unless defined(&ASN1_STRFLGS_ESC_MSB);
    eval 'sub ASN1_STRFLGS_ESC_QUOTE () {8;}' unless defined(&ASN1_STRFLGS_ESC_QUOTE);
    eval 'sub CHARTYPE_PRINTABLESTRING () {0x10;}' unless defined(&CHARTYPE_PRINTABLESTRING);
    eval 'sub CHARTYPE_FIRST_ESC_2253 () {0x20;}' unless defined(&CHARTYPE_FIRST_ESC_2253);
    eval 'sub CHARTYPE_LAST_ESC_2253 () {0x40;}' unless defined(&CHARTYPE_LAST_ESC_2253);
    eval 'sub ASN1_STRFLGS_UTF8_CONVERT () {0x10;}' unless defined(&ASN1_STRFLGS_UTF8_CONVERT);
    eval 'sub ASN1_STRFLGS_IGNORE_TYPE () {0x20;}' unless defined(&ASN1_STRFLGS_IGNORE_TYPE);
    eval 'sub ASN1_STRFLGS_SHOW_TYPE () {0x40;}' unless defined(&ASN1_STRFLGS_SHOW_TYPE);
    eval 'sub ASN1_STRFLGS_DUMP_ALL () {0x80;}' unless defined(&ASN1_STRFLGS_DUMP_ALL);
    eval 'sub ASN1_STRFLGS_DUMP_UNKNOWN () {0x100;}' unless defined(&ASN1_STRFLGS_DUMP_UNKNOWN);
    eval 'sub ASN1_STRFLGS_DUMP_DER () {0x200;}' unless defined(&ASN1_STRFLGS_DUMP_DER);
    eval 'sub ASN1_STRFLGS_RFC2253 () {( &ASN1_STRFLGS_ESC_2253 |  &ASN1_STRFLGS_ESC_CTRL |  &ASN1_STRFLGS_ESC_MSB |  &ASN1_STRFLGS_UTF8_CONVERT |  &ASN1_STRFLGS_DUMP_UNKNOWN |  &ASN1_STRFLGS_DUMP_DER);}' unless defined(&ASN1_STRFLGS_RFC2253);
    eval 'sub M_ASN1_STRING_length {
        my($x) = @_;
	    eval q((($x)-> &length));
    }' unless defined(&M_ASN1_STRING_length);
    eval 'sub M_ASN1_STRING_length_set {
        my($x, $n) = @_;
	    eval q((($x)-> &length = ($n)));
    }' unless defined(&M_ASN1_STRING_length_set);
    eval 'sub M_ASN1_STRING_type {
        my($x) = @_;
	    eval q((($x)-> &type));
    }' unless defined(&M_ASN1_STRING_type);
    eval 'sub M_ASN1_STRING_data {
        my($x) = @_;
	    eval q((($x)-> &data));
    }' unless defined(&M_ASN1_STRING_data);
    eval 'sub M_ASN1_BIT_STRING_new () {
        eval q(( &ASN1_BIT_STRING *)  &ASN1_STRING_type_new( &V_ASN1_BIT_STRING));
    }' unless defined(&M_ASN1_BIT_STRING_new);
    eval 'sub M_ASN1_BIT_STRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_BIT_STRING_free);
    eval 'sub M_ASN1_BIT_STRING_dup {
        my($a) = @_;
	    eval q(( &ASN1_BIT_STRING *)  &ASN1_STRING_dup(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_BIT_STRING_dup);
    eval 'sub M_ASN1_BIT_STRING_cmp {
        my($a,$b) = @_;
	    eval q( &ASN1_STRING_cmp( ( &ASN1_STRING *)$a,( &ASN1_STRING *)$b));
    }' unless defined(&M_ASN1_BIT_STRING_cmp);
    eval 'sub M_ASN1_BIT_STRING_set {
        my($a,$b,$c) = @_;
	    eval q( &ASN1_STRING_set(( &ASN1_STRING *)$a,$b,$c));
    }' unless defined(&M_ASN1_BIT_STRING_set);
    eval 'sub M_ASN1_INTEGER_new () {
        eval q(( &ASN1_INTEGER *)  &ASN1_STRING_type_new( &V_ASN1_INTEGER));
    }' unless defined(&M_ASN1_INTEGER_new);
    eval 'sub M_ASN1_INTEGER_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_INTEGER_free);
    eval 'sub M_ASN1_INTEGER_dup {
        my($a) = @_;
	    eval q(( &ASN1_INTEGER *) &ASN1_STRING_dup(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_INTEGER_dup);
    eval 'sub M_ASN1_INTEGER_cmp {
        my($a,$b) = @_;
	    eval q( &ASN1_STRING_cmp( ( &ASN1_STRING *)$a,( &ASN1_STRING *)$b));
    }' unless defined(&M_ASN1_INTEGER_cmp);
    eval 'sub M_ASN1_ENUMERATED_new () {
        eval q(( &ASN1_ENUMERATED *)  &ASN1_STRING_type_new( &V_ASN1_ENUMERATED));
    }' unless defined(&M_ASN1_ENUMERATED_new);
    eval 'sub M_ASN1_ENUMERATED_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_ENUMERATED_free);
    eval 'sub M_ASN1_ENUMERATED_dup {
        my($a) = @_;
	    eval q(( &ASN1_ENUMERATED *) &ASN1_STRING_dup(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_ENUMERATED_dup);
    eval 'sub M_ASN1_ENUMERATED_cmp {
        my($a,$b) = @_;
	    eval q( &ASN1_STRING_cmp( ( &ASN1_STRING *)$a,( &ASN1_STRING *)$b));
    }' unless defined(&M_ASN1_ENUMERATED_cmp);
    eval 'sub M_ASN1_OCTET_STRING_new () {
        eval q(( &ASN1_OCTET_STRING *)  &ASN1_STRING_type_new( &V_ASN1_OCTET_STRING));
    }' unless defined(&M_ASN1_OCTET_STRING_new);
    eval 'sub M_ASN1_OCTET_STRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_OCTET_STRING_free);
    eval 'sub M_ASN1_OCTET_STRING_dup {
        my($a) = @_;
	    eval q(( &ASN1_OCTET_STRING *)  &ASN1_STRING_dup(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_OCTET_STRING_dup);
    eval 'sub M_ASN1_OCTET_STRING_cmp {
        my($a,$b) = @_;
	    eval q( &ASN1_STRING_cmp( ( &ASN1_STRING *)$a,( &ASN1_STRING *)$b));
    }' unless defined(&M_ASN1_OCTET_STRING_cmp);
    eval 'sub M_ASN1_OCTET_STRING_set {
        my($a,$b,$c) = @_;
	    eval q( &ASN1_STRING_set(( &ASN1_STRING *)$a,$b,$c));
    }' unless defined(&M_ASN1_OCTET_STRING_set);
    eval 'sub M_ASN1_OCTET_STRING_print {
        my($a,$b) = @_;
	    eval q( &ASN1_STRING_print($a,( &ASN1_STRING *)$b));
    }' unless defined(&M_ASN1_OCTET_STRING_print);
    eval 'sub M_i2d_ASN1_OCTET_STRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a,$pp, &V_ASN1_OCTET_STRING,  &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_OCTET_STRING);
    eval 'sub B_ASN1_TIME () { &B_ASN1_UTCTIME |  &B_ASN1_GENERALIZEDTIME;}' unless defined(&B_ASN1_TIME);
    eval 'sub B_ASN1_PRINTABLE () { &B_ASN1_PRINTABLESTRING|  &B_ASN1_T61STRING|  &B_ASN1_IA5STRING|  &B_ASN1_BIT_STRING|  &B_ASN1_UNIVERSALSTRING|  &B_ASN1_BMPSTRING|  &B_ASN1_UTF8STRING|  &B_ASN1_SEQUENCE|  &B_ASN1_UNKNOWN;}' unless defined(&B_ASN1_PRINTABLE);
    eval 'sub B_ASN1_DIRECTORYSTRING () { &B_ASN1_PRINTABLESTRING|  &B_ASN1_TELETEXSTRING|  &B_ASN1_BMPSTRING|  &B_ASN1_UNIVERSALSTRING|  &B_ASN1_UTF8STRING;}' unless defined(&B_ASN1_DIRECTORYSTRING);
    eval 'sub B_ASN1_DISPLAYTEXT () { &B_ASN1_IA5STRING|  &B_ASN1_VISIBLESTRING|  &B_ASN1_BMPSTRING|  &B_ASN1_UTF8STRING;}' unless defined(&B_ASN1_DISPLAYTEXT);
    eval 'sub M_ASN1_PRINTABLE_new () {
        eval q( &ASN1_STRING_type_new( &V_ASN1_T61STRING));
    }' unless defined(&M_ASN1_PRINTABLE_new);
    eval 'sub M_ASN1_PRINTABLE_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_PRINTABLE_free);
    eval 'sub M_i2d_ASN1_PRINTABLE {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a, $pp, ($a->{type}), &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_PRINTABLE);
    eval 'sub M_d2i_ASN1_PRINTABLE {
        my($a,$pp,$l) = @_;
	    eval q( &d2i_ASN1_type_bytes(( &ASN1_STRING **)$a,$pp,$l,  &B_ASN1_PRINTABLE));
    }' unless defined(&M_d2i_ASN1_PRINTABLE);
    eval 'sub M_DIRECTORYSTRING_new () {
        eval q( &ASN1_STRING_type_new( &V_ASN1_PRINTABLESTRING));
    }' unless defined(&M_DIRECTORYSTRING_new);
    eval 'sub M_DIRECTORYSTRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_DIRECTORYSTRING_free);
    eval 'sub M_i2d_DIRECTORYSTRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a, $pp, ($a->{type}), &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_DIRECTORYSTRING);
    eval 'sub M_d2i_DIRECTORYSTRING {
        my($a,$pp,$l) = @_;
	    eval q( &d2i_ASN1_type_bytes(( &ASN1_STRING **)$a,$pp,$l,  &B_ASN1_DIRECTORYSTRING));
    }' unless defined(&M_d2i_DIRECTORYSTRING);
    eval 'sub M_DISPLAYTEXT_new () {
        eval q( &ASN1_STRING_type_new( &V_ASN1_VISIBLESTRING));
    }' unless defined(&M_DISPLAYTEXT_new);
    eval 'sub M_DISPLAYTEXT_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_DISPLAYTEXT_free);
    eval 'sub M_i2d_DISPLAYTEXT {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a, $pp, ($a->{type}), &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_DISPLAYTEXT);
    eval 'sub M_d2i_DISPLAYTEXT {
        my($a,$pp,$l) = @_;
	    eval q( &d2i_ASN1_type_bytes(( &ASN1_STRING **)$a,$pp,$l,  &B_ASN1_DISPLAYTEXT));
    }' unless defined(&M_d2i_DISPLAYTEXT);
    eval 'sub M_ASN1_PRINTABLESTRING_new () {
        eval q(( &ASN1_PRINTABLESTRING *)  &ASN1_STRING_type_new( &V_ASN1_PRINTABLESTRING));
    }' unless defined(&M_ASN1_PRINTABLESTRING_new);
    eval 'sub M_ASN1_PRINTABLESTRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_PRINTABLESTRING_free);
    eval 'sub M_i2d_ASN1_PRINTABLESTRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a,$pp, &V_ASN1_PRINTABLESTRING,  &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_PRINTABLESTRING);
    eval 'sub M_d2i_ASN1_PRINTABLESTRING {
        my($a,$pp,$l) = @_;
	    eval q(( &ASN1_PRINTABLESTRING *) &d2i_ASN1_type_bytes (( &ASN1_STRING **)$a,$pp,$l, &B_ASN1_PRINTABLESTRING));
    }' unless defined(&M_d2i_ASN1_PRINTABLESTRING);
    eval 'sub M_ASN1_T61STRING_new () {
        eval q(( &ASN1_T61STRING *)  &ASN1_STRING_type_new( &V_ASN1_T61STRING));
    }' unless defined(&M_ASN1_T61STRING_new);
    eval 'sub M_ASN1_T61STRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_T61STRING_free);
    eval 'sub M_i2d_ASN1_T61STRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a,$pp, &V_ASN1_T61STRING,  &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_T61STRING);
    eval 'sub M_d2i_ASN1_T61STRING {
        my($a,$pp,$l) = @_;
	    eval q(( &ASN1_T61STRING *) &d2i_ASN1_type_bytes (( &ASN1_STRING **)$a,$pp,$l, &B_ASN1_T61STRING));
    }' unless defined(&M_d2i_ASN1_T61STRING);
    eval 'sub M_ASN1_IA5STRING_new () {
        eval q(( &ASN1_IA5STRING *)  &ASN1_STRING_type_new( &V_ASN1_IA5STRING));
    }' unless defined(&M_ASN1_IA5STRING_new);
    eval 'sub M_ASN1_IA5STRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_IA5STRING_free);
    eval 'sub M_ASN1_IA5STRING_dup {
        my($a) = @_;
	    eval q(( &ASN1_IA5STRING *) &ASN1_STRING_dup(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_IA5STRING_dup);
    eval 'sub M_i2d_ASN1_IA5STRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a,$pp, &V_ASN1_IA5STRING,  &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_IA5STRING);
    eval 'sub M_d2i_ASN1_IA5STRING {
        my($a,$pp,$l) = @_;
	    eval q(( &ASN1_IA5STRING *) &d2i_ASN1_type_bytes(( &ASN1_STRING **)$a,$pp,$l,  &B_ASN1_IA5STRING));
    }' unless defined(&M_d2i_ASN1_IA5STRING);
    eval 'sub M_ASN1_UTCTIME_new () {
        eval q(( &ASN1_UTCTIME *)  &ASN1_STRING_type_new( &V_ASN1_UTCTIME));
    }' unless defined(&M_ASN1_UTCTIME_new);
    eval 'sub M_ASN1_UTCTIME_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_UTCTIME_free);
    eval 'sub M_ASN1_UTCTIME_dup {
        my($a) = @_;
	    eval q(( &ASN1_UTCTIME *) &ASN1_STRING_dup(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_UTCTIME_dup);
    eval 'sub M_ASN1_GENERALIZEDTIME_new () {
        eval q(( &ASN1_GENERALIZEDTIME *)  &ASN1_STRING_type_new( &V_ASN1_GENERALIZEDTIME));
    }' unless defined(&M_ASN1_GENERALIZEDTIME_new);
    eval 'sub M_ASN1_GENERALIZEDTIME_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_GENERALIZEDTIME_free);
    eval 'sub M_ASN1_GENERALIZEDTIME_dup {
        my($a) = @_;
	    eval q(( &ASN1_GENERALIZEDTIME *) &ASN1_STRING_dup( ( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_GENERALIZEDTIME_dup);
    eval 'sub M_ASN1_TIME_new () {
        eval q(( &ASN1_TIME *)  &ASN1_STRING_type_new( &V_ASN1_UTCTIME));
    }' unless defined(&M_ASN1_TIME_new);
    eval 'sub M_ASN1_TIME_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_TIME_free);
    eval 'sub M_ASN1_TIME_dup {
        my($a) = @_;
	    eval q(( &ASN1_TIME *) &ASN1_STRING_dup(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_TIME_dup);
    eval 'sub M_ASN1_GENERALSTRING_new () {
        eval q(( &ASN1_GENERALSTRING *)  &ASN1_STRING_type_new( &V_ASN1_GENERALSTRING));
    }' unless defined(&M_ASN1_GENERALSTRING_new);
    eval 'sub M_ASN1_GENERALSTRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_GENERALSTRING_free);
    eval 'sub M_i2d_ASN1_GENERALSTRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a,$pp, &V_ASN1_GENERALSTRING,  &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_GENERALSTRING);
    eval 'sub M_d2i_ASN1_GENERALSTRING {
        my($a,$pp,$l) = @_;
	    eval q(( &ASN1_GENERALSTRING *) &d2i_ASN1_type_bytes (( &ASN1_STRING **)$a,$pp,$l, &B_ASN1_GENERALSTRING));
    }' unless defined(&M_d2i_ASN1_GENERALSTRING);
    eval 'sub M_ASN1_UNIVERSALSTRING_new () {
        eval q(( &ASN1_UNIVERSALSTRING *)  &ASN1_STRING_type_new( &V_ASN1_UNIVERSALSTRING));
    }' unless defined(&M_ASN1_UNIVERSALSTRING_new);
    eval 'sub M_ASN1_UNIVERSALSTRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_UNIVERSALSTRING_free);
    eval 'sub M_i2d_ASN1_UNIVERSALSTRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a,$pp, &V_ASN1_UNIVERSALSTRING,  &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_UNIVERSALSTRING);
    eval 'sub M_d2i_ASN1_UNIVERSALSTRING {
        my($a,$pp,$l) = @_;
	    eval q(( &ASN1_UNIVERSALSTRING *) &d2i_ASN1_type_bytes (( &ASN1_STRING **)$a,$pp,$l, &B_ASN1_UNIVERSALSTRING));
    }' unless defined(&M_d2i_ASN1_UNIVERSALSTRING);
    eval 'sub M_ASN1_BMPSTRING_new () {
        eval q(( &ASN1_BMPSTRING *)  &ASN1_STRING_type_new( &V_ASN1_BMPSTRING));
    }' unless defined(&M_ASN1_BMPSTRING_new);
    eval 'sub M_ASN1_BMPSTRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_BMPSTRING_free);
    eval 'sub M_i2d_ASN1_BMPSTRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a,$pp, &V_ASN1_BMPSTRING,  &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_BMPSTRING);
    eval 'sub M_d2i_ASN1_BMPSTRING {
        my($a,$pp,$l) = @_;
	    eval q(( &ASN1_BMPSTRING *) &d2i_ASN1_type_bytes (( &ASN1_STRING **)$a,$pp,$l, &B_ASN1_BMPSTRING));
    }' unless defined(&M_d2i_ASN1_BMPSTRING);
    eval 'sub M_ASN1_VISIBLESTRING_new () {
        eval q(( &ASN1_VISIBLESTRING *)  &ASN1_STRING_type_new( &V_ASN1_VISIBLESTRING));
    }' unless defined(&M_ASN1_VISIBLESTRING_new);
    eval 'sub M_ASN1_VISIBLESTRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_VISIBLESTRING_free);
    eval 'sub M_i2d_ASN1_VISIBLESTRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a,$pp, &V_ASN1_VISIBLESTRING,  &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_VISIBLESTRING);
    eval 'sub M_d2i_ASN1_VISIBLESTRING {
        my($a,$pp,$l) = @_;
	    eval q(( &ASN1_VISIBLESTRING *) &d2i_ASN1_type_bytes (( &ASN1_STRING **)$a,$pp,$l, &B_ASN1_VISIBLESTRING));
    }' unless defined(&M_d2i_ASN1_VISIBLESTRING);
    eval 'sub M_ASN1_UTF8STRING_new () {
        eval q(( &ASN1_UTF8STRING *)  &ASN1_STRING_type_new( &V_ASN1_UTF8STRING));
    }' unless defined(&M_ASN1_UTF8STRING_new);
    eval 'sub M_ASN1_UTF8STRING_free {
        my($a) = @_;
	    eval q( &ASN1_STRING_free(( &ASN1_STRING *)$a));
    }' unless defined(&M_ASN1_UTF8STRING_free);
    eval 'sub M_i2d_ASN1_UTF8STRING {
        my($a,$pp) = @_;
	    eval q( &i2d_ASN1_bytes(( &ASN1_STRING *)$a,$pp, &V_ASN1_UTF8STRING,  &V_ASN1_UNIVERSAL));
    }' unless defined(&M_i2d_ASN1_UTF8STRING);
    eval 'sub M_d2i_ASN1_UTF8STRING {
        my($a,$pp,$l) = @_;
	    eval q(( &ASN1_UTF8STRING *) &d2i_ASN1_type_bytes (( &ASN1_STRING **)$a,$pp,$l, &B_ASN1_UTF8STRING));
    }' unless defined(&M_d2i_ASN1_UTF8STRING);
    eval 'sub IS_SEQUENCE () {0;}' unless defined(&IS_SEQUENCE);
    eval 'sub IS_SET () {1;}' unless defined(&IS_SET);
    unless(defined(&OPENSSL_NO_BIO)) {
    }
    if(0) {
    }
    unless(defined(&OPENSSL_NO_BIO)) {
    }
    eval 'sub ASN1_dup_of {
        my($type,$i2d,$d2i,$x) = @_;
	    eval q((($type*) &ASN1_dup( &CHECKED_I2D_OF($type, $i2d),  &CHECKED_D2I_OF($type, $d2i),  &CHECKED_PTR_OF($type, $x))));
    }' unless defined(&ASN1_dup_of);
    eval 'sub ASN1_dup_of_const {
        my($type,$i2d,$d2i,$x) = @_;
	    eval q((($type*) &ASN1_dup( &CHECKED_I2D_OF( &const $type, $i2d),  &CHECKED_D2I_OF($type, $d2i),  &CHECKED_PTR_OF( &const $type, $x))));
    }' unless defined(&ASN1_dup_of_const);
    eval 'sub M_ASN1_new_of {
        my($type) = @_;
	    eval q(($type *) &ASN1_item_new( &ASN1_ITEM_rptr($type)));
    }' unless defined(&M_ASN1_new_of);
    eval 'sub M_ASN1_free_of {
        my($x, $type) = @_;
	    eval q( &ASN1_item_free( &CHECKED_PTR_OF($type, $x),  &ASN1_ITEM_rptr($type)));
    }' unless defined(&M_ASN1_free_of);
    unless(defined(&OPENSSL_NO_FP_API)) {
	eval 'sub ASN1_d2i_fp_of {
	    my($type,$xnew,$d2i,$in,$x) = @_;
    	    eval q((($type*) &ASN1_d2i_fp( &CHECKED_NEW_OF($type, $xnew),  &CHECKED_D2I_OF($type, $d2i), $in,  &CHECKED_PPTR_OF($type, $x))));
	}' unless defined(&ASN1_d2i_fp_of);
	eval 'sub ASN1_i2d_fp_of {
	    my($type,$i2d,$out,$x) = @_;
    	    eval q(( &ASN1_i2d_fp( &CHECKED_I2D_OF($type, $i2d), $out,  &CHECKED_PTR_OF($type, $x))));
	}' unless defined(&ASN1_i2d_fp_of);
	eval 'sub ASN1_i2d_fp_of_const {
	    my($type,$i2d,$out,$x) = @_;
    	    eval q(( &ASN1_i2d_fp( &CHECKED_I2D_OF( &const $type, $i2d), $out,  &CHECKED_PTR_OF( &const $type, $x))));
	}' unless defined(&ASN1_i2d_fp_of_const);
    }
    unless(defined(&OPENSSL_NO_BIO)) {
	eval 'sub ASN1_d2i_bio_of {
	    my($type,$xnew,$d2i,$in,$x) = @_;
    	    eval q((($type*) &ASN1_d2i_bio(  &CHECKED_NEW_OF($type, $xnew),  &CHECKED_D2I_OF($type, $d2i), $in,  &CHECKED_PPTR_OF($type, $x))));
	}' unless defined(&ASN1_d2i_bio_of);
	eval 'sub ASN1_i2d_bio_of {
	    my($type,$i2d,$out,$x) = @_;
    	    eval q(( &ASN1_i2d_bio( &CHECKED_I2D_OF($type, $i2d), $out,  &CHECKED_PTR_OF($type, $x))));
	}' unless defined(&ASN1_i2d_bio_of);
	eval 'sub ASN1_i2d_bio_of_const {
	    my($type,$i2d,$out,$x) = @_;
    	    eval q(( &ASN1_i2d_bio( &CHECKED_I2D_OF( &const $type, $i2d), $out,  &CHECKED_PTR_OF( &const $type, $x))));
	}' unless defined(&ASN1_i2d_bio_of_const);
    }
    eval 'sub ASN1_pack_string_of {
        my($type,$obj,$i2d,$oct) = @_;
	    eval q(( &ASN1_pack_string( &CHECKED_PTR_OF($type, $obj),  &CHECKED_I2D_OF($type, $i2d), $oct)));
    }' unless defined(&ASN1_pack_string_of);
    eval 'sub ASN1_F_A2D_ASN1_OBJECT () {100;}' unless defined(&ASN1_F_A2D_ASN1_OBJECT);
    eval 'sub ASN1_F_A2I_ASN1_ENUMERATED () {101;}' unless defined(&ASN1_F_A2I_ASN1_ENUMERATED);
    eval 'sub ASN1_F_A2I_ASN1_INTEGER () {102;}' unless defined(&ASN1_F_A2I_ASN1_INTEGER);
    eval 'sub ASN1_F_A2I_ASN1_STRING () {103;}' unless defined(&ASN1_F_A2I_ASN1_STRING);
    eval 'sub ASN1_F_APPEND_EXP () {176;}' unless defined(&ASN1_F_APPEND_EXP);
    eval 'sub ASN1_F_ASN1_BIT_STRING_SET_BIT () {183;}' unless defined(&ASN1_F_ASN1_BIT_STRING_SET_BIT);
    eval 'sub ASN1_F_ASN1_CB () {177;}' unless defined(&ASN1_F_ASN1_CB);
    eval 'sub ASN1_F_ASN1_CHECK_TLEN () {104;}' unless defined(&ASN1_F_ASN1_CHECK_TLEN);
    eval 'sub ASN1_F_ASN1_COLLATE_PRIMITIVE () {105;}' unless defined(&ASN1_F_ASN1_COLLATE_PRIMITIVE);
    eval 'sub ASN1_F_ASN1_COLLECT () {106;}' unless defined(&ASN1_F_ASN1_COLLECT);
    eval 'sub ASN1_F_ASN1_D2I_EX_PRIMITIVE () {108;}' unless defined(&ASN1_F_ASN1_D2I_EX_PRIMITIVE);
    eval 'sub ASN1_F_ASN1_D2I_FP () {109;}' unless defined(&ASN1_F_ASN1_D2I_FP);
    eval 'sub ASN1_F_ASN1_D2I_READ_BIO () {107;}' unless defined(&ASN1_F_ASN1_D2I_READ_BIO);
    eval 'sub ASN1_F_ASN1_DIGEST () {184;}' unless defined(&ASN1_F_ASN1_DIGEST);
    eval 'sub ASN1_F_ASN1_DO_ADB () {110;}' unless defined(&ASN1_F_ASN1_DO_ADB);
    eval 'sub ASN1_F_ASN1_DUP () {111;}' unless defined(&ASN1_F_ASN1_DUP);
    eval 'sub ASN1_F_ASN1_ENUMERATED_SET () {112;}' unless defined(&ASN1_F_ASN1_ENUMERATED_SET);
    eval 'sub ASN1_F_ASN1_ENUMERATED_TO_BN () {113;}' unless defined(&ASN1_F_ASN1_ENUMERATED_TO_BN);
    eval 'sub ASN1_F_ASN1_EX_C2I () {204;}' unless defined(&ASN1_F_ASN1_EX_C2I);
    eval 'sub ASN1_F_ASN1_FIND_END () {190;}' unless defined(&ASN1_F_ASN1_FIND_END);
    eval 'sub ASN1_F_ASN1_GENERALIZEDTIME_SET () {185;}' unless defined(&ASN1_F_ASN1_GENERALIZEDTIME_SET);
    eval 'sub ASN1_F_ASN1_GENERATE_V3 () {178;}' unless defined(&ASN1_F_ASN1_GENERATE_V3);
    eval 'sub ASN1_F_ASN1_GET_OBJECT () {114;}' unless defined(&ASN1_F_ASN1_GET_OBJECT);
    eval 'sub ASN1_F_ASN1_HEADER_NEW () {115;}' unless defined(&ASN1_F_ASN1_HEADER_NEW);
    eval 'sub ASN1_F_ASN1_I2D_BIO () {116;}' unless defined(&ASN1_F_ASN1_I2D_BIO);
    eval 'sub ASN1_F_ASN1_I2D_FP () {117;}' unless defined(&ASN1_F_ASN1_I2D_FP);
    eval 'sub ASN1_F_ASN1_INTEGER_SET () {118;}' unless defined(&ASN1_F_ASN1_INTEGER_SET);
    eval 'sub ASN1_F_ASN1_INTEGER_TO_BN () {119;}' unless defined(&ASN1_F_ASN1_INTEGER_TO_BN);
    eval 'sub ASN1_F_ASN1_ITEM_D2I_FP () {206;}' unless defined(&ASN1_F_ASN1_ITEM_D2I_FP);
    eval 'sub ASN1_F_ASN1_ITEM_DUP () {191;}' unless defined(&ASN1_F_ASN1_ITEM_DUP);
    eval 'sub ASN1_F_ASN1_ITEM_EX_COMBINE_NEW () {121;}' unless defined(&ASN1_F_ASN1_ITEM_EX_COMBINE_NEW);
    eval 'sub ASN1_F_ASN1_ITEM_EX_D2I () {120;}' unless defined(&ASN1_F_ASN1_ITEM_EX_D2I);
    eval 'sub ASN1_F_ASN1_ITEM_I2D_BIO () {192;}' unless defined(&ASN1_F_ASN1_ITEM_I2D_BIO);
    eval 'sub ASN1_F_ASN1_ITEM_I2D_FP () {193;}' unless defined(&ASN1_F_ASN1_ITEM_I2D_FP);
    eval 'sub ASN1_F_ASN1_ITEM_PACK () {198;}' unless defined(&ASN1_F_ASN1_ITEM_PACK);
    eval 'sub ASN1_F_ASN1_ITEM_SIGN () {195;}' unless defined(&ASN1_F_ASN1_ITEM_SIGN);
    eval 'sub ASN1_F_ASN1_ITEM_UNPACK () {199;}' unless defined(&ASN1_F_ASN1_ITEM_UNPACK);
    eval 'sub ASN1_F_ASN1_ITEM_VERIFY () {197;}' unless defined(&ASN1_F_ASN1_ITEM_VERIFY);
    eval 'sub ASN1_F_ASN1_MBSTRING_NCOPY () {122;}' unless defined(&ASN1_F_ASN1_MBSTRING_NCOPY);
    eval 'sub ASN1_F_ASN1_OBJECT_NEW () {123;}' unless defined(&ASN1_F_ASN1_OBJECT_NEW);
    eval 'sub ASN1_F_ASN1_OUTPUT_DATA () {207;}' unless defined(&ASN1_F_ASN1_OUTPUT_DATA);
    eval 'sub ASN1_F_ASN1_PACK_STRING () {124;}' unless defined(&ASN1_F_ASN1_PACK_STRING);
    eval 'sub ASN1_F_ASN1_PCTX_NEW () {205;}' unless defined(&ASN1_F_ASN1_PCTX_NEW);
    eval 'sub ASN1_F_ASN1_PKCS5_PBE_SET () {125;}' unless defined(&ASN1_F_ASN1_PKCS5_PBE_SET);
    eval 'sub ASN1_F_ASN1_SEQ_PACK () {126;}' unless defined(&ASN1_F_ASN1_SEQ_PACK);
    eval 'sub ASN1_F_ASN1_SEQ_UNPACK () {127;}' unless defined(&ASN1_F_ASN1_SEQ_UNPACK);
    eval 'sub ASN1_F_ASN1_SIGN () {128;}' unless defined(&ASN1_F_ASN1_SIGN);
    eval 'sub ASN1_F_ASN1_STR2TYPE () {179;}' unless defined(&ASN1_F_ASN1_STR2TYPE);
    eval 'sub ASN1_F_ASN1_STRING_SET () {186;}' unless defined(&ASN1_F_ASN1_STRING_SET);
    eval 'sub ASN1_F_ASN1_STRING_TABLE_ADD () {129;}' unless defined(&ASN1_F_ASN1_STRING_TABLE_ADD);
    eval 'sub ASN1_F_ASN1_STRING_TYPE_NEW () {130;}' unless defined(&ASN1_F_ASN1_STRING_TYPE_NEW);
    eval 'sub ASN1_F_ASN1_TEMPLATE_EX_D2I () {132;}' unless defined(&ASN1_F_ASN1_TEMPLATE_EX_D2I);
    eval 'sub ASN1_F_ASN1_TEMPLATE_NEW () {133;}' unless defined(&ASN1_F_ASN1_TEMPLATE_NEW);
    eval 'sub ASN1_F_ASN1_TEMPLATE_NOEXP_D2I () {131;}' unless defined(&ASN1_F_ASN1_TEMPLATE_NOEXP_D2I);
    eval 'sub ASN1_F_ASN1_TIME_SET () {175;}' unless defined(&ASN1_F_ASN1_TIME_SET);
    eval 'sub ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING () {134;}' unless defined(&ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING);
    eval 'sub ASN1_F_ASN1_TYPE_GET_OCTETSTRING () {135;}' unless defined(&ASN1_F_ASN1_TYPE_GET_OCTETSTRING);
    eval 'sub ASN1_F_ASN1_UNPACK_STRING () {136;}' unless defined(&ASN1_F_ASN1_UNPACK_STRING);
    eval 'sub ASN1_F_ASN1_UTCTIME_SET () {187;}' unless defined(&ASN1_F_ASN1_UTCTIME_SET);
    eval 'sub ASN1_F_ASN1_VERIFY () {137;}' unless defined(&ASN1_F_ASN1_VERIFY);
    eval 'sub ASN1_F_B64_READ_ASN1 () {208;}' unless defined(&ASN1_F_B64_READ_ASN1);
    eval 'sub ASN1_F_B64_WRITE_ASN1 () {209;}' unless defined(&ASN1_F_B64_WRITE_ASN1);
    eval 'sub ASN1_F_BITSTR_CB () {180;}' unless defined(&ASN1_F_BITSTR_CB);
    eval 'sub ASN1_F_BN_TO_ASN1_ENUMERATED () {138;}' unless defined(&ASN1_F_BN_TO_ASN1_ENUMERATED);
    eval 'sub ASN1_F_BN_TO_ASN1_INTEGER () {139;}' unless defined(&ASN1_F_BN_TO_ASN1_INTEGER);
    eval 'sub ASN1_F_C2I_ASN1_BIT_STRING () {189;}' unless defined(&ASN1_F_C2I_ASN1_BIT_STRING);
    eval 'sub ASN1_F_C2I_ASN1_INTEGER () {194;}' unless defined(&ASN1_F_C2I_ASN1_INTEGER);
    eval 'sub ASN1_F_C2I_ASN1_OBJECT () {196;}' unless defined(&ASN1_F_C2I_ASN1_OBJECT);
    eval 'sub ASN1_F_COLLECT_DATA () {140;}' unless defined(&ASN1_F_COLLECT_DATA);
    eval 'sub ASN1_F_D2I_ASN1_BIT_STRING () {141;}' unless defined(&ASN1_F_D2I_ASN1_BIT_STRING);
    eval 'sub ASN1_F_D2I_ASN1_BOOLEAN () {142;}' unless defined(&ASN1_F_D2I_ASN1_BOOLEAN);
    eval 'sub ASN1_F_D2I_ASN1_BYTES () {143;}' unless defined(&ASN1_F_D2I_ASN1_BYTES);
    eval 'sub ASN1_F_D2I_ASN1_GENERALIZEDTIME () {144;}' unless defined(&ASN1_F_D2I_ASN1_GENERALIZEDTIME);
    eval 'sub ASN1_F_D2I_ASN1_HEADER () {145;}' unless defined(&ASN1_F_D2I_ASN1_HEADER);
    eval 'sub ASN1_F_D2I_ASN1_INTEGER () {146;}' unless defined(&ASN1_F_D2I_ASN1_INTEGER);
    eval 'sub ASN1_F_D2I_ASN1_OBJECT () {147;}' unless defined(&ASN1_F_D2I_ASN1_OBJECT);
    eval 'sub ASN1_F_D2I_ASN1_SET () {148;}' unless defined(&ASN1_F_D2I_ASN1_SET);
    eval 'sub ASN1_F_D2I_ASN1_TYPE_BYTES () {149;}' unless defined(&ASN1_F_D2I_ASN1_TYPE_BYTES);
    eval 'sub ASN1_F_D2I_ASN1_UINTEGER () {150;}' unless defined(&ASN1_F_D2I_ASN1_UINTEGER);
    eval 'sub ASN1_F_D2I_ASN1_UTCTIME () {151;}' unless defined(&ASN1_F_D2I_ASN1_UTCTIME);
    eval 'sub ASN1_F_D2I_NETSCAPE_RSA () {152;}' unless defined(&ASN1_F_D2I_NETSCAPE_RSA);
    eval 'sub ASN1_F_D2I_NETSCAPE_RSA_2 () {153;}' unless defined(&ASN1_F_D2I_NETSCAPE_RSA_2);
    eval 'sub ASN1_F_D2I_PRIVATEKEY () {154;}' unless defined(&ASN1_F_D2I_PRIVATEKEY);
    eval 'sub ASN1_F_D2I_PUBLICKEY () {155;}' unless defined(&ASN1_F_D2I_PUBLICKEY);
    eval 'sub ASN1_F_D2I_RSA_NET () {200;}' unless defined(&ASN1_F_D2I_RSA_NET);
    eval 'sub ASN1_F_D2I_RSA_NET_2 () {201;}' unless defined(&ASN1_F_D2I_RSA_NET_2);
    eval 'sub ASN1_F_D2I_X509 () {156;}' unless defined(&ASN1_F_D2I_X509);
    eval 'sub ASN1_F_D2I_X509_CINF () {157;}' unless defined(&ASN1_F_D2I_X509_CINF);
    eval 'sub ASN1_F_D2I_X509_PKEY () {159;}' unless defined(&ASN1_F_D2I_X509_PKEY);
    eval 'sub ASN1_F_I2D_ASN1_SET () {188;}' unless defined(&ASN1_F_I2D_ASN1_SET);
    eval 'sub ASN1_F_I2D_ASN1_TIME () {160;}' unless defined(&ASN1_F_I2D_ASN1_TIME);
    eval 'sub ASN1_F_I2D_DSA_PUBKEY () {161;}' unless defined(&ASN1_F_I2D_DSA_PUBKEY);
    eval 'sub ASN1_F_I2D_EC_PUBKEY () {181;}' unless defined(&ASN1_F_I2D_EC_PUBKEY);
    eval 'sub ASN1_F_I2D_PRIVATEKEY () {163;}' unless defined(&ASN1_F_I2D_PRIVATEKEY);
    eval 'sub ASN1_F_I2D_PUBLICKEY () {164;}' unless defined(&ASN1_F_I2D_PUBLICKEY);
    eval 'sub ASN1_F_I2D_RSA_NET () {162;}' unless defined(&ASN1_F_I2D_RSA_NET);
    eval 'sub ASN1_F_I2D_RSA_PUBKEY () {165;}' unless defined(&ASN1_F_I2D_RSA_PUBKEY);
    eval 'sub ASN1_F_LONG_C2I () {166;}' unless defined(&ASN1_F_LONG_C2I);
    eval 'sub ASN1_F_OID_MODULE_INIT () {174;}' unless defined(&ASN1_F_OID_MODULE_INIT);
    eval 'sub ASN1_F_PARSE_TAGGING () {182;}' unless defined(&ASN1_F_PARSE_TAGGING);
    eval 'sub ASN1_F_PKCS5_PBE2_SET () {167;}' unless defined(&ASN1_F_PKCS5_PBE2_SET);
    eval 'sub ASN1_F_PKCS5_PBE_SET () {202;}' unless defined(&ASN1_F_PKCS5_PBE_SET);
    eval 'sub ASN1_F_SMIME_READ_ASN1 () {210;}' unless defined(&ASN1_F_SMIME_READ_ASN1);
    eval 'sub ASN1_F_SMIME_TEXT () {211;}' unless defined(&ASN1_F_SMIME_TEXT);
    eval 'sub ASN1_F_X509_CINF_NEW () {168;}' unless defined(&ASN1_F_X509_CINF_NEW);
    eval 'sub ASN1_F_X509_CRL_ADD0_REVOKED () {169;}' unless defined(&ASN1_F_X509_CRL_ADD0_REVOKED);
    eval 'sub ASN1_F_X509_INFO_NEW () {170;}' unless defined(&ASN1_F_X509_INFO_NEW);
    eval 'sub ASN1_F_X509_NAME_ENCODE () {203;}' unless defined(&ASN1_F_X509_NAME_ENCODE);
    eval 'sub ASN1_F_X509_NAME_EX_D2I () {158;}' unless defined(&ASN1_F_X509_NAME_EX_D2I);
    eval 'sub ASN1_F_X509_NAME_EX_NEW () {171;}' unless defined(&ASN1_F_X509_NAME_EX_NEW);
    eval 'sub ASN1_F_X509_NEW () {172;}' unless defined(&ASN1_F_X509_NEW);
    eval 'sub ASN1_F_X509_PKEY_NEW () {173;}' unless defined(&ASN1_F_X509_PKEY_NEW);
    eval 'sub ASN1_R_ADDING_OBJECT () {171;}' unless defined(&ASN1_R_ADDING_OBJECT);
    eval 'sub ASN1_R_ASN1_PARSE_ERROR () {198;}' unless defined(&ASN1_R_ASN1_PARSE_ERROR);
    eval 'sub ASN1_R_ASN1_SIG_PARSE_ERROR () {199;}' unless defined(&ASN1_R_ASN1_SIG_PARSE_ERROR);
    eval 'sub ASN1_R_AUX_ERROR () {100;}' unless defined(&ASN1_R_AUX_ERROR);
    eval 'sub ASN1_R_BAD_CLASS () {101;}' unless defined(&ASN1_R_BAD_CLASS);
    eval 'sub ASN1_R_BAD_OBJECT_HEADER () {102;}' unless defined(&ASN1_R_BAD_OBJECT_HEADER);
    eval 'sub ASN1_R_BAD_PASSWORD_READ () {103;}' unless defined(&ASN1_R_BAD_PASSWORD_READ);
    eval 'sub ASN1_R_BAD_TAG () {104;}' unless defined(&ASN1_R_BAD_TAG);
    eval 'sub ASN1_R_BN_LIB () {105;}' unless defined(&ASN1_R_BN_LIB);
    eval 'sub ASN1_R_BOOLEAN_IS_WRONG_LENGTH () {106;}' unless defined(&ASN1_R_BOOLEAN_IS_WRONG_LENGTH);
    eval 'sub ASN1_R_BUFFER_TOO_SMALL () {107;}' unless defined(&ASN1_R_BUFFER_TOO_SMALL);
    eval 'sub ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER () {108;}' unless defined(&ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER);
    eval 'sub ASN1_R_DATA_IS_WRONG () {109;}' unless defined(&ASN1_R_DATA_IS_WRONG);
    eval 'sub ASN1_R_DECODE_ERROR () {110;}' unless defined(&ASN1_R_DECODE_ERROR);
    eval 'sub ASN1_R_DECODING_ERROR () {111;}' unless defined(&ASN1_R_DECODING_ERROR);
    eval 'sub ASN1_R_DEPTH_EXCEEDED () {174;}' unless defined(&ASN1_R_DEPTH_EXCEEDED);
    eval 'sub ASN1_R_ENCODE_ERROR () {112;}' unless defined(&ASN1_R_ENCODE_ERROR);
    eval 'sub ASN1_R_ERROR_GETTING_TIME () {173;}' unless defined(&ASN1_R_ERROR_GETTING_TIME);
    eval 'sub ASN1_R_ERROR_LOADING_SECTION () {172;}' unless defined(&ASN1_R_ERROR_LOADING_SECTION);
    eval 'sub ASN1_R_ERROR_PARSING_SET_ELEMENT () {113;}' unless defined(&ASN1_R_ERROR_PARSING_SET_ELEMENT);
    eval 'sub ASN1_R_ERROR_SETTING_CIPHER_PARAMS () {114;}' unless defined(&ASN1_R_ERROR_SETTING_CIPHER_PARAMS);
    eval 'sub ASN1_R_EXPECTING_AN_INTEGER () {115;}' unless defined(&ASN1_R_EXPECTING_AN_INTEGER);
    eval 'sub ASN1_R_EXPECTING_AN_OBJECT () {116;}' unless defined(&ASN1_R_EXPECTING_AN_OBJECT);
    eval 'sub ASN1_R_EXPECTING_A_BOOLEAN () {117;}' unless defined(&ASN1_R_EXPECTING_A_BOOLEAN);
    eval 'sub ASN1_R_EXPECTING_A_TIME () {118;}' unless defined(&ASN1_R_EXPECTING_A_TIME);
    eval 'sub ASN1_R_EXPLICIT_LENGTH_MISMATCH () {119;}' unless defined(&ASN1_R_EXPLICIT_LENGTH_MISMATCH);
    eval 'sub ASN1_R_EXPLICIT_TAG_NOT_CONSTRUCTED () {120;}' unless defined(&ASN1_R_EXPLICIT_TAG_NOT_CONSTRUCTED);
    eval 'sub ASN1_R_FIELD_MISSING () {121;}' unless defined(&ASN1_R_FIELD_MISSING);
    eval 'sub ASN1_R_FIRST_NUM_TOO_LARGE () {122;}' unless defined(&ASN1_R_FIRST_NUM_TOO_LARGE);
    eval 'sub ASN1_R_HEADER_TOO_LONG () {123;}' unless defined(&ASN1_R_HEADER_TOO_LONG);
    eval 'sub ASN1_R_ILLEGAL_BITSTRING_FORMAT () {175;}' unless defined(&ASN1_R_ILLEGAL_BITSTRING_FORMAT);
    eval 'sub ASN1_R_ILLEGAL_BOOLEAN () {176;}' unless defined(&ASN1_R_ILLEGAL_BOOLEAN);
    eval 'sub ASN1_R_ILLEGAL_CHARACTERS () {124;}' unless defined(&ASN1_R_ILLEGAL_CHARACTERS);
    eval 'sub ASN1_R_ILLEGAL_FORMAT () {177;}' unless defined(&ASN1_R_ILLEGAL_FORMAT);
    eval 'sub ASN1_R_ILLEGAL_HEX () {178;}' unless defined(&ASN1_R_ILLEGAL_HEX);
    eval 'sub ASN1_R_ILLEGAL_IMPLICIT_TAG () {179;}' unless defined(&ASN1_R_ILLEGAL_IMPLICIT_TAG);
    eval 'sub ASN1_R_ILLEGAL_INTEGER () {180;}' unless defined(&ASN1_R_ILLEGAL_INTEGER);
    eval 'sub ASN1_R_ILLEGAL_NESTED_TAGGING () {181;}' unless defined(&ASN1_R_ILLEGAL_NESTED_TAGGING);
    eval 'sub ASN1_R_ILLEGAL_NULL () {125;}' unless defined(&ASN1_R_ILLEGAL_NULL);
    eval 'sub ASN1_R_ILLEGAL_NULL_VALUE () {182;}' unless defined(&ASN1_R_ILLEGAL_NULL_VALUE);
    eval 'sub ASN1_R_ILLEGAL_OBJECT () {183;}' unless defined(&ASN1_R_ILLEGAL_OBJECT);
    eval 'sub ASN1_R_ILLEGAL_OPTIONAL_ANY () {126;}' unless defined(&ASN1_R_ILLEGAL_OPTIONAL_ANY);
    eval 'sub ASN1_R_ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE () {170;}' unless defined(&ASN1_R_ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE);
    eval 'sub ASN1_R_ILLEGAL_TAGGED_ANY () {127;}' unless defined(&ASN1_R_ILLEGAL_TAGGED_ANY);
    eval 'sub ASN1_R_ILLEGAL_TIME_VALUE () {184;}' unless defined(&ASN1_R_ILLEGAL_TIME_VALUE);
    eval 'sub ASN1_R_INTEGER_NOT_ASCII_FORMAT () {185;}' unless defined(&ASN1_R_INTEGER_NOT_ASCII_FORMAT);
    eval 'sub ASN1_R_INTEGER_TOO_LARGE_FOR_LONG () {128;}' unless defined(&ASN1_R_INTEGER_TOO_LARGE_FOR_LONG);
    eval 'sub ASN1_R_INVALID_BMPSTRING_LENGTH () {129;}' unless defined(&ASN1_R_INVALID_BMPSTRING_LENGTH);
    eval 'sub ASN1_R_INVALID_DIGIT () {130;}' unless defined(&ASN1_R_INVALID_DIGIT);
    eval 'sub ASN1_R_INVALID_MIME_TYPE () {200;}' unless defined(&ASN1_R_INVALID_MIME_TYPE);
    eval 'sub ASN1_R_INVALID_MODIFIER () {186;}' unless defined(&ASN1_R_INVALID_MODIFIER);
    eval 'sub ASN1_R_INVALID_NUMBER () {187;}' unless defined(&ASN1_R_INVALID_NUMBER);
    eval 'sub ASN1_R_INVALID_SEPARATOR () {131;}' unless defined(&ASN1_R_INVALID_SEPARATOR);
    eval 'sub ASN1_R_INVALID_TIME_FORMAT () {132;}' unless defined(&ASN1_R_INVALID_TIME_FORMAT);
    eval 'sub ASN1_R_INVALID_UNIVERSALSTRING_LENGTH () {133;}' unless defined(&ASN1_R_INVALID_UNIVERSALSTRING_LENGTH);
    eval 'sub ASN1_R_INVALID_UTF8STRING () {134;}' unless defined(&ASN1_R_INVALID_UTF8STRING);
    eval 'sub ASN1_R_IV_TOO_LARGE () {135;}' unless defined(&ASN1_R_IV_TOO_LARGE);
    eval 'sub ASN1_R_LENGTH_ERROR () {136;}' unless defined(&ASN1_R_LENGTH_ERROR);
    eval 'sub ASN1_R_LIST_ERROR () {188;}' unless defined(&ASN1_R_LIST_ERROR);
    eval 'sub ASN1_R_MIME_NO_CONTENT_TYPE () {201;}' unless defined(&ASN1_R_MIME_NO_CONTENT_TYPE);
    eval 'sub ASN1_R_MIME_PARSE_ERROR () {202;}' unless defined(&ASN1_R_MIME_PARSE_ERROR);
    eval 'sub ASN1_R_MIME_SIG_PARSE_ERROR () {203;}' unless defined(&ASN1_R_MIME_SIG_PARSE_ERROR);
    eval 'sub ASN1_R_MISSING_EOC () {137;}' unless defined(&ASN1_R_MISSING_EOC);
    eval 'sub ASN1_R_MISSING_SECOND_NUMBER () {138;}' unless defined(&ASN1_R_MISSING_SECOND_NUMBER);
    eval 'sub ASN1_R_MISSING_VALUE () {189;}' unless defined(&ASN1_R_MISSING_VALUE);
    eval 'sub ASN1_R_MSTRING_NOT_UNIVERSAL () {139;}' unless defined(&ASN1_R_MSTRING_NOT_UNIVERSAL);
    eval 'sub ASN1_R_MSTRING_WRONG_TAG () {140;}' unless defined(&ASN1_R_MSTRING_WRONG_TAG);
    eval 'sub ASN1_R_NESTED_ASN1_STRING () {197;}' unless defined(&ASN1_R_NESTED_ASN1_STRING);
    eval 'sub ASN1_R_NON_HEX_CHARACTERS () {141;}' unless defined(&ASN1_R_NON_HEX_CHARACTERS);
    eval 'sub ASN1_R_NOT_ASCII_FORMAT () {190;}' unless defined(&ASN1_R_NOT_ASCII_FORMAT);
    eval 'sub ASN1_R_NOT_ENOUGH_DATA () {142;}' unless defined(&ASN1_R_NOT_ENOUGH_DATA);
    eval 'sub ASN1_R_NO_CONTENT_TYPE () {204;}' unless defined(&ASN1_R_NO_CONTENT_TYPE);
    eval 'sub ASN1_R_NO_MATCHING_CHOICE_TYPE () {143;}' unless defined(&ASN1_R_NO_MATCHING_CHOICE_TYPE);
    eval 'sub ASN1_R_NO_MULTIPART_BODY_FAILURE () {205;}' unless defined(&ASN1_R_NO_MULTIPART_BODY_FAILURE);
    eval 'sub ASN1_R_NO_MULTIPART_BOUNDARY () {206;}' unless defined(&ASN1_R_NO_MULTIPART_BOUNDARY);
    eval 'sub ASN1_R_NO_SIG_CONTENT_TYPE () {207;}' unless defined(&ASN1_R_NO_SIG_CONTENT_TYPE);
    eval 'sub ASN1_R_NULL_IS_WRONG_LENGTH () {144;}' unless defined(&ASN1_R_NULL_IS_WRONG_LENGTH);
    eval 'sub ASN1_R_OBJECT_NOT_ASCII_FORMAT () {191;}' unless defined(&ASN1_R_OBJECT_NOT_ASCII_FORMAT);
    eval 'sub ASN1_R_ODD_NUMBER_OF_CHARS () {145;}' unless defined(&ASN1_R_ODD_NUMBER_OF_CHARS);
    eval 'sub ASN1_R_PRIVATE_KEY_HEADER_MISSING () {146;}' unless defined(&ASN1_R_PRIVATE_KEY_HEADER_MISSING);
    eval 'sub ASN1_R_SECOND_NUMBER_TOO_LARGE () {147;}' unless defined(&ASN1_R_SECOND_NUMBER_TOO_LARGE);
    eval 'sub ASN1_R_SEQUENCE_LENGTH_MISMATCH () {148;}' unless defined(&ASN1_R_SEQUENCE_LENGTH_MISMATCH);
    eval 'sub ASN1_R_SEQUENCE_NOT_CONSTRUCTED () {149;}' unless defined(&ASN1_R_SEQUENCE_NOT_CONSTRUCTED);
    eval 'sub ASN1_R_SEQUENCE_OR_SET_NEEDS_CONFIG () {192;}' unless defined(&ASN1_R_SEQUENCE_OR_SET_NEEDS_CONFIG);
    eval 'sub ASN1_R_SHORT_LINE () {150;}' unless defined(&ASN1_R_SHORT_LINE);
    eval 'sub ASN1_R_SIG_INVALID_MIME_TYPE () {208;}' unless defined(&ASN1_R_SIG_INVALID_MIME_TYPE);
    eval 'sub ASN1_R_STREAMING_NOT_SUPPORTED () {209;}' unless defined(&ASN1_R_STREAMING_NOT_SUPPORTED);
    eval 'sub ASN1_R_STRING_TOO_LONG () {151;}' unless defined(&ASN1_R_STRING_TOO_LONG);
    eval 'sub ASN1_R_STRING_TOO_SHORT () {152;}' unless defined(&ASN1_R_STRING_TOO_SHORT);
    eval 'sub ASN1_R_TAG_VALUE_TOO_HIGH () {153;}' unless defined(&ASN1_R_TAG_VALUE_TOO_HIGH);
    eval 'sub ASN1_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD () {154;}' unless defined(&ASN1_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD);
    eval 'sub ASN1_R_TIME_NOT_ASCII_FORMAT () {193;}' unless defined(&ASN1_R_TIME_NOT_ASCII_FORMAT);
    eval 'sub ASN1_R_TOO_LONG () {155;}' unless defined(&ASN1_R_TOO_LONG);
    eval 'sub ASN1_R_TYPE_NOT_CONSTRUCTED () {156;}' unless defined(&ASN1_R_TYPE_NOT_CONSTRUCTED);
    eval 'sub ASN1_R_UNABLE_TO_DECODE_RSA_KEY () {157;}' unless defined(&ASN1_R_UNABLE_TO_DECODE_RSA_KEY);
    eval 'sub ASN1_R_UNABLE_TO_DECODE_RSA_PRIVATE_KEY () {158;}' unless defined(&ASN1_R_UNABLE_TO_DECODE_RSA_PRIVATE_KEY);
    eval 'sub ASN1_R_UNEXPECTED_EOC () {159;}' unless defined(&ASN1_R_UNEXPECTED_EOC);
    eval 'sub ASN1_R_UNKNOWN_FORMAT () {160;}' unless defined(&ASN1_R_UNKNOWN_FORMAT);
    eval 'sub ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM () {161;}' unless defined(&ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM);
    eval 'sub ASN1_R_UNKNOWN_OBJECT_TYPE () {162;}' unless defined(&ASN1_R_UNKNOWN_OBJECT_TYPE);
    eval 'sub ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE () {163;}' unless defined(&ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE);
    eval 'sub ASN1_R_UNKNOWN_TAG () {194;}' unless defined(&ASN1_R_UNKNOWN_TAG);
    eval 'sub ASN1_R_UNKOWN_FORMAT () {195;}' unless defined(&ASN1_R_UNKOWN_FORMAT);
    eval 'sub ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE () {164;}' unless defined(&ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE);
    eval 'sub ASN1_R_UNSUPPORTED_CIPHER () {165;}' unless defined(&ASN1_R_UNSUPPORTED_CIPHER);
    eval 'sub ASN1_R_UNSUPPORTED_ENCRYPTION_ALGORITHM () {166;}' unless defined(&ASN1_R_UNSUPPORTED_ENCRYPTION_ALGORITHM);
    eval 'sub ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE () {167;}' unless defined(&ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE);
    eval 'sub ASN1_R_UNSUPPORTED_TYPE () {196;}' unless defined(&ASN1_R_UNSUPPORTED_TYPE);
    eval 'sub ASN1_R_WRONG_TAG () {168;}' unless defined(&ASN1_R_WRONG_TAG);
    eval 'sub ASN1_R_WRONG_TYPE () {169;}' unless defined(&ASN1_R_WRONG_TYPE);
    if(defined(&__cplusplus)) {
    }
}
1;
