require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_IF_JMEREG_H)) {
    eval 'sub _IF_JMEREG_H () {1;}' unless defined(&_IF_JMEREG_H);
    eval 'sub JME_REV_JMC250_A1 () {0x1;}' unless defined(&JME_REV_JMC250_A1);
    eval 'sub JME_REV_JMC250_A2 () {0x11;}' unless defined(&JME_REV_JMC250_A2);
    eval 'sub JME_PCIR_BAR () {0x10;}' unless defined(&JME_PCIR_BAR);
    eval 'sub JME_PCI_EROM () {0x30;}' unless defined(&JME_PCI_EROM);
    eval 'sub JME_PCI_DBG () {0x9c;}' unless defined(&JME_PCI_DBG);
    eval 'sub JME_PCI_SPI () {0xb0;}' unless defined(&JME_PCI_SPI);
    eval 'sub SPI_ENB () {0x10;}' unless defined(&SPI_ENB);
    eval 'sub SPI_SO_STATUS () {0x8;}' unless defined(&SPI_SO_STATUS);
    eval 'sub SPI_SI_CTRL () {0x4;}' unless defined(&SPI_SI_CTRL);
    eval 'sub SPI_SCK_CTRL () {0x2;}' unless defined(&SPI_SCK_CTRL);
    eval 'sub SPI_CS_N_CTRL () {0x1;}' unless defined(&SPI_CS_N_CTRL);
    eval 'sub JME_PCI_PHYCFG0 () {0xc0;}' unless defined(&JME_PCI_PHYCFG0);
    eval 'sub JME_PCI_PHYCFG1 () {0xc4;}' unless defined(&JME_PCI_PHYCFG1);
    eval 'sub JME_PCI_PHYCFG2 () {0xc8;}' unless defined(&JME_PCI_PHYCFG2);
    eval 'sub JME_PCI_PHYCFG3 () {0xcc;}' unless defined(&JME_PCI_PHYCFG3);
    eval 'sub JME_PCI_PIPECTL1 () {0xd0;}' unless defined(&JME_PCI_PIPECTL1);
    eval 'sub JME_PCI_PIPECTL2 () {0xd4;}' unless defined(&JME_PCI_PIPECTL2);
    eval 'sub JME_PCI_LES () {0xd8;}' unless defined(&JME_PCI_LES);
    eval 'sub JME_PCI_PE0 () {0xe0;}' unless defined(&JME_PCI_PE0);
    eval 'sub PE0_SPI_EXIST () {0x200000;}' unless defined(&PE0_SPI_EXIST);
    eval 'sub PE0_PME_D0 () {0x100000;}' unless defined(&PE0_PME_D0);
    eval 'sub PE0_PME_D3H () {0x80000;}' unless defined(&PE0_PME_D3H);
    eval 'sub PE0_PME_SPI_PAD () {0x40000;}' unless defined(&PE0_PME_SPI_PAD);
    eval 'sub PE0_MASK_ASPM () {0x20000;}' unless defined(&PE0_MASK_ASPM);
    eval 'sub PE0_EEPROM_RW_DIS () {0x8000;}' unless defined(&PE0_EEPROM_RW_DIS);
    eval 'sub PE0_PCI_INTA () {0x1000;}' unless defined(&PE0_PCI_INTA);
    eval 'sub PE0_PCI_INTB () {0x2000;}' unless defined(&PE0_PCI_INTB);
    eval 'sub PE0_PCI_INTC () {0x3000;}' unless defined(&PE0_PCI_INTC);
    eval 'sub PE0_PCI_INTD () {0x4000;}' unless defined(&PE0_PCI_INTD);
    eval 'sub PE0_PCI_SVSSID_WR_ENB () {0x800;}' unless defined(&PE0_PCI_SVSSID_WR_ENB);
    eval 'sub PE0_MSIX_SIZE_8 () {0x700;}' unless defined(&PE0_MSIX_SIZE_8);
    eval 'sub PE0_MSIX_SIZE_7 () {0x600;}' unless defined(&PE0_MSIX_SIZE_7);
    eval 'sub PE0_MSIX_SIZE_6 () {0x500;}' unless defined(&PE0_MSIX_SIZE_6);
    eval 'sub PE0_MSIX_SIZE_5 () {0x400;}' unless defined(&PE0_MSIX_SIZE_5);
    eval 'sub PE0_MSIX_SIZE_4 () {0x300;}' unless defined(&PE0_MSIX_SIZE_4);
    eval 'sub PE0_MSIX_SIZE_3 () {0x200;}' unless defined(&PE0_MSIX_SIZE_3);
    eval 'sub PE0_MSIX_SIZE_2 () {0x100;}' unless defined(&PE0_MSIX_SIZE_2);
    eval 'sub PE0_MSIX_SIZE_1 () {0x;}' unless defined(&PE0_MSIX_SIZE_1);
    eval 'sub PE0_MSIX_SIZE_DEF () {0x700;}' unless defined(&PE0_MSIX_SIZE_DEF);
    eval 'sub PE0_MSIX_CAP_DIS () {0x80;}' unless defined(&PE0_MSIX_CAP_DIS);
    eval 'sub PE0_MSI_PVMC_ENB () {0x40;}' unless defined(&PE0_MSI_PVMC_ENB);
    eval 'sub PE0_LCAP_EXIT_LAT_MASK () {0x38;}' unless defined(&PE0_LCAP_EXIT_LAT_MASK);
    eval 'sub PE0_LCAP_EXIT_LAT_DEF () {0x38;}' unless defined(&PE0_LCAP_EXIT_LAT_DEF);
    eval 'sub PE0_PM_AUXC_MASK () {0x7;}' unless defined(&PE0_PM_AUXC_MASK);
    eval 'sub PE0_PM_AUXC_DEF () {0x7;}' unless defined(&PE0_PM_AUXC_DEF);
    eval 'sub JME_PCI_PE1 () {0xe4;}' unless defined(&JME_PCI_PE1);
    eval 'sub JME_PCI_PHYTEST () {0xf8;}' unless defined(&JME_PCI_PHYTEST);
    eval 'sub JME_PCI_GPR () {0xfc;}' unless defined(&JME_PCI_GPR);
    eval 'sub JME_TXCSR () {0x;}' unless defined(&JME_TXCSR);
    eval 'sub TXCSR_QWEIGHT_MASK () {0xf000000;}' unless defined(&TXCSR_QWEIGHT_MASK);
    eval 'sub TXCSR_QWEIGHT_SHIFT () {24;}' unless defined(&TXCSR_QWEIGHT_SHIFT);
    eval 'sub TXCSR_TXQ_SEL_MASK () {0x70000;}' unless defined(&TXCSR_TXQ_SEL_MASK);
    eval 'sub TXCSR_TXQ_SEL_SHIFT () {16;}' unless defined(&TXCSR_TXQ_SEL_SHIFT);
    eval 'sub TXCSR_TXQ_START () {0x1;}' unless defined(&TXCSR_TXQ_START);
    eval 'sub TXCSR_TXQ_START_SHIFT () {8;}' unless defined(&TXCSR_TXQ_START_SHIFT);
    eval 'sub TXCSR_FIFO_THRESH_4QW () {0x;}' unless defined(&TXCSR_FIFO_THRESH_4QW);
    eval 'sub TXCSR_FIFO_THRESH_8QW () {0x40;}' unless defined(&TXCSR_FIFO_THRESH_8QW);
    eval 'sub TXCSR_FIFO_THRESH_12QW () {0x80;}' unless defined(&TXCSR_FIFO_THRESH_12QW);
    eval 'sub TXCSR_FIFO_THRESH_16QW () {0xc0;}' unless defined(&TXCSR_FIFO_THRESH_16QW);
    eval 'sub TXCSR_DMA_SIZE_64 () {0x;}' unless defined(&TXCSR_DMA_SIZE_64);
    eval 'sub TXCSR_DMA_SIZE_128 () {0x10;}' unless defined(&TXCSR_DMA_SIZE_128);
    eval 'sub TXCSR_DMA_SIZE_256 () {0x20;}' unless defined(&TXCSR_DMA_SIZE_256);
    eval 'sub TXCSR_DMA_SIZE_512 () {0x30;}' unless defined(&TXCSR_DMA_SIZE_512);
    eval 'sub TXCSR_DMA_BURST () {0x4;}' unless defined(&TXCSR_DMA_BURST);
    eval 'sub TXCSR_TX_SUSPEND () {0x2;}' unless defined(&TXCSR_TX_SUSPEND);
    eval 'sub TXCSR_TX_ENB () {0x1;}' unless defined(&TXCSR_TX_ENB);
    eval 'sub TXCSR_TXQ0 () {0;}' unless defined(&TXCSR_TXQ0);
    eval 'sub TXCSR_TXQ1 () {1;}' unless defined(&TXCSR_TXQ1);
    eval 'sub TXCSR_TXQ2 () {2;}' unless defined(&TXCSR_TXQ2);
    eval 'sub TXCSR_TXQ3 () {3;}' unless defined(&TXCSR_TXQ3);
    eval 'sub TXCSR_TXQ4 () {4;}' unless defined(&TXCSR_TXQ4);
    eval 'sub TXCSR_TXQ5 () {5;}' unless defined(&TXCSR_TXQ5);
    eval 'sub TXCSR_TXQ6 () {6;}' unless defined(&TXCSR_TXQ6);
    eval 'sub TXCSR_TXQ7 () {7;}' unless defined(&TXCSR_TXQ7);
    eval 'sub TXCSR_TXQ_WEIGHT {
        my($x) = @_;
	    eval q(((($x) <<  &TXCSR_QWEIGHT_SHIFT) &  &TXCSR_QWEIGHT_MASK));
    }' unless defined(&TXCSR_TXQ_WEIGHT);
    eval 'sub TXCSR_TXQ_WEIGHT_MIN () {0;}' unless defined(&TXCSR_TXQ_WEIGHT_MIN);
    eval 'sub TXCSR_TXQ_WEIGHT_MAX () {15;}' unless defined(&TXCSR_TXQ_WEIGHT_MAX);
    eval 'sub TXCSR_TXQ_N_SEL {
        my($x) = @_;
	    eval q(((($x) <<  &TXCSR_TXQ_SEL_SHIFT) &  &TXCSR_TXQ_SEL_MASK));
    }' unless defined(&TXCSR_TXQ_N_SEL);
    eval 'sub TXCSR_TXQ_N_START {
        my($x) = @_;
	    eval q(( &TXCSR_TXQ_START << ( &TXCSR_TXQ_START_SHIFT + ($x))));
    }' unless defined(&TXCSR_TXQ_N_START);
    eval 'sub JME_TXDBA_LO () {0x4;}' unless defined(&JME_TXDBA_LO);
    eval 'sub JME_TXDBA_HI () {0x8;}' unless defined(&JME_TXDBA_HI);
    eval 'sub JME_TXQDC () {0xc;}' unless defined(&JME_TXQDC);
    eval 'sub TXQDC_MASK () {0x7f0;}' unless defined(&TXQDC_MASK);
    eval 'sub JME_TXNDA () {0x10;}' unless defined(&JME_TXNDA);
    eval 'sub TXNDA_ADDR_MASK () {0xfffffff0;}' unless defined(&TXNDA_ADDR_MASK);
    eval 'sub TXNDA_DESC_EMPTY () {0x8;}' unless defined(&TXNDA_DESC_EMPTY);
    eval 'sub TXNDA_DESC_VALID () {0x4;}' unless defined(&TXNDA_DESC_VALID);
    eval 'sub TXNDA_DESC_WAIT () {0x2;}' unless defined(&TXNDA_DESC_WAIT);
    eval 'sub TXNDA_DESC_FETCH () {0x1;}' unless defined(&TXNDA_DESC_FETCH);
    eval 'sub JME_TXMAC () {0x14;}' unless defined(&JME_TXMAC);
    eval 'sub TXMAC_IFG2_MASK () {0xc0000000;}' unless defined(&TXMAC_IFG2_MASK);
    eval 'sub TXMAC_IFG2_DEFAULT () {0x40000000;}' unless defined(&TXMAC_IFG2_DEFAULT);
    eval 'sub TXMAC_IFG1_MASK () {0x30000000;}' unless defined(&TXMAC_IFG1_MASK);
    eval 'sub TXMAC_IFG1_DEFAULT () {0x20000000;}' unless defined(&TXMAC_IFG1_DEFAULT);
    eval 'sub TXMAC_THRESH_1_PKT () {0x300;}' unless defined(&TXMAC_THRESH_1_PKT);
    eval 'sub TXMAC_THRESH_1_2_PKT () {0x200;}' unless defined(&TXMAC_THRESH_1_2_PKT);
    eval 'sub TXMAC_THRESH_1_4_PKT () {0x100;}' unless defined(&TXMAC_THRESH_1_4_PKT);
    eval 'sub TXMAC_THRESH_1_8_PKT () {0x;}' unless defined(&TXMAC_THRESH_1_8_PKT);
    eval 'sub TXMAC_FRAME_BURST () {0x80;}' unless defined(&TXMAC_FRAME_BURST);
    eval 'sub TXMAC_CARRIER_EXT () {0x40;}' unless defined(&TXMAC_CARRIER_EXT);
    eval 'sub TXMAC_IFG_ENB () {0x20;}' unless defined(&TXMAC_IFG_ENB);
    eval 'sub TXMAC_BACKOFF () {0x10;}' unless defined(&TXMAC_BACKOFF);
    eval 'sub TXMAC_CARRIER_SENSE () {0x8;}' unless defined(&TXMAC_CARRIER_SENSE);
    eval 'sub TXMAC_COLL_ENB () {0x4;}' unless defined(&TXMAC_COLL_ENB);
    eval 'sub TXMAC_CRC_ENB () {0x2;}' unless defined(&TXMAC_CRC_ENB);
    eval 'sub TXMAC_PAD_ENB () {0x1;}' unless defined(&TXMAC_PAD_ENB);
    eval 'sub JME_TXPFC () {0x18;}' unless defined(&JME_TXPFC);
    eval 'sub TXPFC_VLAN_TAG_MASK () {0xffff0000;}' unless defined(&TXPFC_VLAN_TAG_MASK);
    eval 'sub TXPFC_VLAN_TAG_SHIFT () {16;}' unless defined(&TXPFC_VLAN_TAG_SHIFT);
    eval 'sub TXPFC_VLAN_ENB () {0x8000;}' unless defined(&TXPFC_VLAN_ENB);
    eval 'sub TXPFC_PAUSE_ENB () {0x1;}' unless defined(&TXPFC_PAUSE_ENB);
    eval 'sub JME_TXTRHD () {0x1c;}' unless defined(&JME_TXTRHD);
    eval 'sub TXTRHD_RT_PERIOD_ENB () {0x80000000;}' unless defined(&TXTRHD_RT_PERIOD_ENB);
    eval 'sub TXTRHD_RT_PERIOD_MASK () {0x7fffff00;}' unless defined(&TXTRHD_RT_PERIOD_MASK);
    eval 'sub TXTRHD_RT_PERIOD_SHIFT () {8;}' unless defined(&TXTRHD_RT_PERIOD_SHIFT);
    eval 'sub TXTRHD_RT_LIMIT_ENB () {0x80;}' unless defined(&TXTRHD_RT_LIMIT_ENB);
    eval 'sub TXTRHD_RT_LIMIT_MASK () {0x7f;}' unless defined(&TXTRHD_RT_LIMIT_MASK);
    eval 'sub TXTRHD_RT_LIMIT_SHIFT () {0;}' unless defined(&TXTRHD_RT_LIMIT_SHIFT);
    eval 'sub TXTRHD_RT_PERIOD_DEFAULT () {8192;}' unless defined(&TXTRHD_RT_PERIOD_DEFAULT);
    eval 'sub TXTRHD_RT_LIMIT_DEFAULT () {8;}' unless defined(&TXTRHD_RT_LIMIT_DEFAULT);
    eval 'sub JME_RXCSR () {0x20;}' unless defined(&JME_RXCSR);
    eval 'sub RXCSR_FIFO_FTHRESH_16T () {0x;}' unless defined(&RXCSR_FIFO_FTHRESH_16T);
    eval 'sub RXCSR_FIFO_FTHRESH_32T () {0x10000000;}' unless defined(&RXCSR_FIFO_FTHRESH_32T);
    eval 'sub RXCSR_FIFO_FTHRESH_64T () {0x20000000;}' unless defined(&RXCSR_FIFO_FTHRESH_64T);
    eval 'sub RXCSR_FIFO_FTHRESH_128T () {0x30000000;}' unless defined(&RXCSR_FIFO_FTHRESH_128T);
    eval 'sub RXCSR_FIFO_FTHRESH_MASK () {0x30000000;}' unless defined(&RXCSR_FIFO_FTHRESH_MASK);
    eval 'sub RXCSR_FIFO_THRESH_16QW () {0x;}' unless defined(&RXCSR_FIFO_THRESH_16QW);
    eval 'sub RXCSR_FIFO_THRESH_32QW () {0x4000000;}' unless defined(&RXCSR_FIFO_THRESH_32QW);
    eval 'sub RXCSR_FIFO_THRESH_64QW () {0x8000000;}' unless defined(&RXCSR_FIFO_THRESH_64QW);
    eval 'sub RXCSR_FIFO_THRESH_128QW () {0xc000000;}' unless defined(&RXCSR_FIFO_THRESH_128QW);
    eval 'sub RXCSR_FIFO_THRESH_MASK () {0xc000000;}' unless defined(&RXCSR_FIFO_THRESH_MASK);
    eval 'sub RXCSR_DMA_SIZE_16 () {0x;}' unless defined(&RXCSR_DMA_SIZE_16);
    eval 'sub RXCSR_DMA_SIZE_32 () {0x1000000;}' unless defined(&RXCSR_DMA_SIZE_32);
    eval 'sub RXCSR_DMA_SIZE_64 () {0x2000000;}' unless defined(&RXCSR_DMA_SIZE_64);
    eval 'sub RXCSR_DMA_SIZE_128 () {0x3000000;}' unless defined(&RXCSR_DMA_SIZE_128);
    eval 'sub RXCSR_RXQ_SEL_MASK () {0x30000;}' unless defined(&RXCSR_RXQ_SEL_MASK);
    eval 'sub RXCSR_RXQ_SEL_SHIFT () {16;}' unless defined(&RXCSR_RXQ_SEL_SHIFT);
    eval 'sub RXCSR_DESC_RT_GAP_MASK () {0xf000;}' unless defined(&RXCSR_DESC_RT_GAP_MASK);
    eval 'sub RXCSR_DESC_RT_GAP_SHIFT () {12;}' unless defined(&RXCSR_DESC_RT_GAP_SHIFT);
    eval 'sub RXCSR_DESC_RT_GAP_256 () {0x;}' unless defined(&RXCSR_DESC_RT_GAP_256);
    eval 'sub RXCSR_DESC_RT_GAP_512 () {0x1000;}' unless defined(&RXCSR_DESC_RT_GAP_512);
    eval 'sub RXCSR_DESC_RT_GAP_1024 () {0x2000;}' unless defined(&RXCSR_DESC_RT_GAP_1024);
    eval 'sub RXCSR_DESC_RT_GAP_2048 () {0x3000;}' unless defined(&RXCSR_DESC_RT_GAP_2048);
    eval 'sub RXCSR_DESC_RT_GAP_4096 () {0x4000;}' unless defined(&RXCSR_DESC_RT_GAP_4096);
    eval 'sub RXCSR_DESC_RT_GAP_8192 () {0x5000;}' unless defined(&RXCSR_DESC_RT_GAP_8192);
    eval 'sub RXCSR_DESC_RT_GAP_16384 () {0x6000;}' unless defined(&RXCSR_DESC_RT_GAP_16384);
    eval 'sub RXCSR_DESC_RT_GAP_32768 () {0x7000;}' unless defined(&RXCSR_DESC_RT_GAP_32768);
    eval 'sub RXCSR_DESC_RT_CNT_MASK () {0xf00;}' unless defined(&RXCSR_DESC_RT_CNT_MASK);
    eval 'sub RXCSR_DESC_RT_CNT_SHIFT () {8;}' unless defined(&RXCSR_DESC_RT_CNT_SHIFT);
    eval 'sub RXCSR_PASS_WAKEUP_PKT () {0x40;}' unless defined(&RXCSR_PASS_WAKEUP_PKT);
    eval 'sub RXCSR_PASS_MAGIC_PKT () {0x20;}' unless defined(&RXCSR_PASS_MAGIC_PKT);
    eval 'sub RXCSR_PASS_RUNT_PKT () {0x10;}' unless defined(&RXCSR_PASS_RUNT_PKT);
    eval 'sub RXCSR_PASS_BAD_PKT () {0x8;}' unless defined(&RXCSR_PASS_BAD_PKT);
    eval 'sub RXCSR_RXQ_START () {0x4;}' unless defined(&RXCSR_RXQ_START);
    eval 'sub RXCSR_RX_SUSPEND () {0x2;}' unless defined(&RXCSR_RX_SUSPEND);
    eval 'sub RXCSR_RX_ENB () {0x1;}' unless defined(&RXCSR_RX_ENB);
    eval 'sub RXCSR_RXQ_N_SEL {
        my($x) = @_;
	    eval q((($x) <<  &RXCSR_RXQ_SEL_SHIFT));
    }' unless defined(&RXCSR_RXQ_N_SEL);
    eval 'sub RXCSR_RXQ0 () {0;}' unless defined(&RXCSR_RXQ0);
    eval 'sub RXCSR_RXQ1 () {1;}' unless defined(&RXCSR_RXQ1);
    eval 'sub RXCSR_RXQ2 () {2;}' unless defined(&RXCSR_RXQ2);
    eval 'sub RXCSR_RXQ3 () {3;}' unless defined(&RXCSR_RXQ3);
    eval 'sub RXCSR_DESC_RT_CNT {
        my($x) = @_;
	    eval q((((($x) / 4) <<  &RXCSR_DESC_RT_CNT_SHIFT) &  &RXCSR_DESC_RT_CNT_MASK));
    }' unless defined(&RXCSR_DESC_RT_CNT);
    eval 'sub RXCSR_DESC_RT_CNT_DEFAULT () {32;}' unless defined(&RXCSR_DESC_RT_CNT_DEFAULT);
    eval 'sub JME_RXDBA_LO () {0x24;}' unless defined(&JME_RXDBA_LO);
    eval 'sub JME_RXDBA_HI () {0x28;}' unless defined(&JME_RXDBA_HI);
    eval 'sub JME_RXQDC () {0x2c;}' unless defined(&JME_RXQDC);
    eval 'sub RXQDC_MASK () {0x7f0;}' unless defined(&RXQDC_MASK);
    eval 'sub JME_RXNDA () {0x30;}' unless defined(&JME_RXNDA);
    eval 'sub RXNDA_ADDR_MASK () {0xfffffff0;}' unless defined(&RXNDA_ADDR_MASK);
    eval 'sub RXNDA_DESC_EMPTY () {0x8;}' unless defined(&RXNDA_DESC_EMPTY);
    eval 'sub RXNDA_DESC_VALID () {0x4;}' unless defined(&RXNDA_DESC_VALID);
    eval 'sub RXNDA_DESC_WAIT () {0x2;}' unless defined(&RXNDA_DESC_WAIT);
    eval 'sub RXNDA_DESC_FETCH () {0x1;}' unless defined(&RXNDA_DESC_FETCH);
    eval 'sub JME_RXMAC () {0x34;}' unless defined(&JME_RXMAC);
    eval 'sub RXMAC_RSS_UNICAST () {0x;}' unless defined(&RXMAC_RSS_UNICAST);
    eval 'sub RXMAC_RSS_UNI_MULTICAST () {0x10000;}' unless defined(&RXMAC_RSS_UNI_MULTICAST);
    eval 'sub RXMAC_RSS_UNI_MULTI_BROADCAST () {0x20000;}' unless defined(&RXMAC_RSS_UNI_MULTI_BROADCAST);
    eval 'sub RXMAC_RSS_ALLFRAME () {0x30000;}' unless defined(&RXMAC_RSS_ALLFRAME);
    eval 'sub RXMAC_PROMISC () {0x800;}' unless defined(&RXMAC_PROMISC);
    eval 'sub RXMAC_BROADCAST () {0x400;}' unless defined(&RXMAC_BROADCAST);
    eval 'sub RXMAC_MULTICAST () {0x200;}' unless defined(&RXMAC_MULTICAST);
    eval 'sub RXMAC_UNICAST () {0x100;}' unless defined(&RXMAC_UNICAST);
    eval 'sub RXMAC_ALLMULTI () {0x80;}' unless defined(&RXMAC_ALLMULTI);
    eval 'sub RXMAC_MULTICAST_FILTER () {0x40;}' unless defined(&RXMAC_MULTICAST_FILTER);
    eval 'sub RXMAC_COLL_DET_ENB () {0x20;}' unless defined(&RXMAC_COLL_DET_ENB);
    eval 'sub RXMAC_FC_ENB () {0x8;}' unless defined(&RXMAC_FC_ENB);
    eval 'sub RXMAC_VLAN_ENB () {0x4;}' unless defined(&RXMAC_VLAN_ENB);
    eval 'sub RXMAC_PAD_10BYTES () {0x2;}' unless defined(&RXMAC_PAD_10BYTES);
    eval 'sub RXMAC_CSUM_ENB () {0x1;}' unless defined(&RXMAC_CSUM_ENB);
    eval 'sub JME_PAR0 () {0x38;}' unless defined(&JME_PAR0);
    eval 'sub JME_PAR1 () {0x3c;}' unless defined(&JME_PAR1);
    eval 'sub JME_MAR0 () {0x40;}' unless defined(&JME_MAR0);
    eval 'sub JME_MAR1 () {0x44;}' unless defined(&JME_MAR1);
    eval 'sub JME_WFODP () {0x48;}' unless defined(&JME_WFODP);
    eval 'sub JME_WFOI () {0x4c;}' unless defined(&JME_WFOI);
    eval 'sub WFOI_MASK_0_31 () {0x;}' unless defined(&WFOI_MASK_0_31);
    eval 'sub WFOI_MASK_31_63 () {0x10;}' unless defined(&WFOI_MASK_31_63);
    eval 'sub WFOI_MASK_64_95 () {0x20;}' unless defined(&WFOI_MASK_64_95);
    eval 'sub WFOI_MASK_96_127 () {0x30;}' unless defined(&WFOI_MASK_96_127);
    eval 'sub WFOI_MASK_SEL () {0x8;}' unless defined(&WFOI_MASK_SEL);
    eval 'sub WFOI_CRC_SEL () {0x;}' unless defined(&WFOI_CRC_SEL);
    eval 'sub WFOI_WAKEUP_FRAME_MASK () {0x7;}' unless defined(&WFOI_WAKEUP_FRAME_MASK);
    eval 'sub WFOI_WAKEUP_FRAME_SEL {
        my($x) = @_;
	    eval q((($x) &  &WFOI_WAKEUP_FRAME_MASK));
    }' unless defined(&WFOI_WAKEUP_FRAME_SEL);
    eval 'sub JME_SMI () {0x50;}' unless defined(&JME_SMI);
    eval 'sub SMI_DATA_MASK () {0xffff0000;}' unless defined(&SMI_DATA_MASK);
    eval 'sub SMI_DATA_SHIFT () {16;}' unless defined(&SMI_DATA_SHIFT);
    eval 'sub SMI_REG_ADDR_MASK () {0xf800;}' unless defined(&SMI_REG_ADDR_MASK);
    eval 'sub SMI_REG_ADDR_SHIFT () {11;}' unless defined(&SMI_REG_ADDR_SHIFT);
    eval 'sub SMI_PHY_ADDR_MASK () {0x7c0;}' unless defined(&SMI_PHY_ADDR_MASK);
    eval 'sub SMI_PHY_ADDR_SHIFT () {6;}' unless defined(&SMI_PHY_ADDR_SHIFT);
    eval 'sub SMI_OP_WRITE () {0x20;}' unless defined(&SMI_OP_WRITE);
    eval 'sub SMI_OP_READ () {0x;}' unless defined(&SMI_OP_READ);
    eval 'sub SMI_OP_EXECUTE () {0x10;}' unless defined(&SMI_OP_EXECUTE);
    eval 'sub SMI_MDIO () {0x8;}' unless defined(&SMI_MDIO);
    eval 'sub SMI_MDOE () {0x4;}' unless defined(&SMI_MDOE);
    eval 'sub SMI_MDC () {0x2;}' unless defined(&SMI_MDC);
    eval 'sub SMI_MDEN () {0x1;}' unless defined(&SMI_MDEN);
    eval 'sub SMI_REG_ADDR {
        my($x) = @_;
	    eval q(((($x) <<  &SMI_REG_ADDR_SHIFT) &  &SMI_REG_ADDR_MASK));
    }' unless defined(&SMI_REG_ADDR);
    eval 'sub SMI_PHY_ADDR {
        my($x) = @_;
	    eval q(((($x) <<  &SMI_PHY_ADDR_SHIFT) &  &SMI_PHY_ADDR_MASK));
    }' unless defined(&SMI_PHY_ADDR);
    eval 'sub JME_GHC () {0x54;}' unless defined(&JME_GHC);
    eval 'sub GHC_LOOPBACK () {0x80000000;}' unless defined(&GHC_LOOPBACK);
    eval 'sub GHC_RESET () {0x40000000;}' unless defined(&GHC_RESET);
    eval 'sub GHC_TCPCK_10_100 () {0x800000;}' unless defined(&GHC_TCPCK_10_100);
    eval 'sub GHC_TCPCK_1000 () {0x400000;}' unless defined(&GHC_TCPCK_1000);
    eval 'sub GHC_TCPCK_MASK () {0xc00000;}' unless defined(&GHC_TCPCK_MASK);
    eval 'sub GHC_TXCK_10_100 () {0x200000;}' unless defined(&GHC_TXCK_10_100);
    eval 'sub GHC_TXCK_1000 () {0x100000;}' unless defined(&GHC_TXCK_1000);
    eval 'sub GHC_TXCK_MASK () {0x300000;}' unless defined(&GHC_TXCK_MASK);
    eval 'sub GHC_FULL_DUPLEX () {0x40;}' unless defined(&GHC_FULL_DUPLEX);
    eval 'sub GHC_SPEED_UNKNOWN () {0x;}' unless defined(&GHC_SPEED_UNKNOWN);
    eval 'sub GHC_SPEED_10 () {0x10;}' unless defined(&GHC_SPEED_10);
    eval 'sub GHC_SPEED_100 () {0x20;}' unless defined(&GHC_SPEED_100);
    eval 'sub GHC_SPEED_1000 () {0x30;}' unless defined(&GHC_SPEED_1000);
    eval 'sub GHC_SPEED_MASK () {0x30;}' unless defined(&GHC_SPEED_MASK);
    eval 'sub GHC_LINK_OFF () {0x4;}' unless defined(&GHC_LINK_OFF);
    eval 'sub GHC_LINK_ON () {0x2;}' unless defined(&GHC_LINK_ON);
    eval 'sub GHC_LINK_STAT_POLLING () {0x1;}' unless defined(&GHC_LINK_STAT_POLLING);
    eval 'sub JME_PMCS () {0x60;}' unless defined(&JME_PMCS);
    eval 'sub PMCS_WAKEUP_FRAME_7 () {0x80000000;}' unless defined(&PMCS_WAKEUP_FRAME_7);
    eval 'sub PMCS_WAKEUP_FRAME_6 () {0x40000000;}' unless defined(&PMCS_WAKEUP_FRAME_6);
    eval 'sub PMCS_WAKEUP_FRAME_5 () {0x20000000;}' unless defined(&PMCS_WAKEUP_FRAME_5);
    eval 'sub PMCS_WAKEUP_FRAME_4 () {0x10000000;}' unless defined(&PMCS_WAKEUP_FRAME_4);
    eval 'sub PMCS_WAKEUP_FRAME_3 () {0x8000000;}' unless defined(&PMCS_WAKEUP_FRAME_3);
    eval 'sub PMCS_WAKEUP_FRAME_2 () {0x4000000;}' unless defined(&PMCS_WAKEUP_FRAME_2);
    eval 'sub PMCS_WAKEUP_FRAME_1 () {0x2000000;}' unless defined(&PMCS_WAKEUP_FRAME_1);
    eval 'sub PMCS_WAKEUP_FRAME_0 () {0x1000000;}' unless defined(&PMCS_WAKEUP_FRAME_0);
    eval 'sub PMCS_LINK_FAIL () {0x40000;}' unless defined(&PMCS_LINK_FAIL);
    eval 'sub PMCS_LINK_RISING () {0x20000;}' unless defined(&PMCS_LINK_RISING);
    eval 'sub PMCS_MAGIC_FRAME () {0x10000;}' unless defined(&PMCS_MAGIC_FRAME);
    eval 'sub PMCS_WAKEUP_FRAME_7_ENB () {0x8000;}' unless defined(&PMCS_WAKEUP_FRAME_7_ENB);
    eval 'sub PMCS_WAKEUP_FRAME_6_ENB () {0x4000;}' unless defined(&PMCS_WAKEUP_FRAME_6_ENB);
    eval 'sub PMCS_WAKEUP_FRAME_5_ENB () {0x2000;}' unless defined(&PMCS_WAKEUP_FRAME_5_ENB);
    eval 'sub PMCS_WAKEUP_FRAME_4_ENB () {0x1000;}' unless defined(&PMCS_WAKEUP_FRAME_4_ENB);
    eval 'sub PMCS_WAKEUP_FRAME_3_ENB () {0x800;}' unless defined(&PMCS_WAKEUP_FRAME_3_ENB);
    eval 'sub PMCS_WAKEUP_FRAME_2_ENB () {0x400;}' unless defined(&PMCS_WAKEUP_FRAME_2_ENB);
    eval 'sub PMCS_WAKEUP_FRAME_1_ENB () {0x200;}' unless defined(&PMCS_WAKEUP_FRAME_1_ENB);
    eval 'sub PMCS_WAKEUP_FRAME_0_ENB () {0x100;}' unless defined(&PMCS_WAKEUP_FRAME_0_ENB);
    eval 'sub PMCS_LINK_FAIL_ENB () {0x4;}' unless defined(&PMCS_LINK_FAIL_ENB);
    eval 'sub PMCS_LINK_RISING_ENB () {0x2;}' unless defined(&PMCS_LINK_RISING_ENB);
    eval 'sub PMCS_MAGIC_FRAME_ENB () {0x1;}' unless defined(&PMCS_MAGIC_FRAME_ENB);
    eval 'sub PMCS_WOL_ENB_MASK () {0xffff;}' unless defined(&PMCS_WOL_ENB_MASK);
    eval 'sub JME_PHY_EEPROM_BASE_ADDR () {0x400;}' unless defined(&JME_PHY_EEPROM_BASE_ADDR);
    eval 'sub JME_GIGAR0LO () {0x400;}' unless defined(&JME_GIGAR0LO);
    eval 'sub JME_GIGAR0HI () {0x404;}' unless defined(&JME_GIGAR0HI);
    eval 'sub JME_GIGARALO () {0x408;}' unless defined(&JME_GIGARALO);
    eval 'sub JME_GIGARAHI () {0x40c;}' unless defined(&JME_GIGARAHI);
    eval 'sub JME_GIGARBLO () {0x410;}' unless defined(&JME_GIGARBLO);
    eval 'sub JME_GIGARBHI () {0x414;}' unless defined(&JME_GIGARBHI);
    eval 'sub JME_GIGARCLO () {0x418;}' unless defined(&JME_GIGARCLO);
    eval 'sub JME_GIGARCHI () {0x41c;}' unless defined(&JME_GIGARCHI);
    eval 'sub JME_GIGARDLO () {0x420;}' unless defined(&JME_GIGARDLO);
    eval 'sub JME_GIGARDHI () {0x424;}' unless defined(&JME_GIGARDHI);
    eval 'sub JME_GIGACSR () {0x428;}' unless defined(&JME_GIGACSR);
    eval 'sub GIGACSR_STATUS () {0x40000000;}' unless defined(&GIGACSR_STATUS);
    eval 'sub GIGACSR_CTRL_MASK () {0x30000000;}' unless defined(&GIGACSR_CTRL_MASK);
    eval 'sub GIGACSR_CTRL_DEFAULT () {0x30000000;}' unless defined(&GIGACSR_CTRL_DEFAULT);
    eval 'sub GIGACSR_TX_CLK_MASK () {0xf000000;}' unless defined(&GIGACSR_TX_CLK_MASK);
    eval 'sub GIGACSR_RX_CLK_MASK () {0xf00000;}' unless defined(&GIGACSR_RX_CLK_MASK);
    eval 'sub GIGACSR_TX_CLK_INV () {0x80000;}' unless defined(&GIGACSR_TX_CLK_INV);
    eval 'sub GIGACSR_RX_CLK_INV () {0x40000;}' unless defined(&GIGACSR_RX_CLK_INV);
    eval 'sub GIGACSR_PHY_RST () {0x10000;}' unless defined(&GIGACSR_PHY_RST);
    eval 'sub GIGACSR_IRQ_N_O () {0x1000;}' unless defined(&GIGACSR_IRQ_N_O);
    eval 'sub GIGACSR_BIST_OK () {0x200;}' unless defined(&GIGACSR_BIST_OK);
    eval 'sub GIGACSR_BIST_DONE () {0x100;}' unless defined(&GIGACSR_BIST_DONE);
    eval 'sub GIGACSR_BIST_LED_ENB () {0x10;}' unless defined(&GIGACSR_BIST_LED_ENB);
    eval 'sub GIGACSR_BIST_MASK () {0x3;}' unless defined(&GIGACSR_BIST_MASK);
    eval 'sub JME_LNKSTS () {0x430;}' unless defined(&JME_LNKSTS);
    eval 'sub LINKSTS_SPEED_10 () {0x;}' unless defined(&LINKSTS_SPEED_10);
    eval 'sub LINKSTS_SPEED_100 () {0x4000;}' unless defined(&LINKSTS_SPEED_100);
    eval 'sub LINKSTS_SPEED_1000 () {0x8000;}' unless defined(&LINKSTS_SPEED_1000);
    eval 'sub LINKSTS_FULL_DUPLEX () {0x2000;}' unless defined(&LINKSTS_FULL_DUPLEX);
    eval 'sub LINKSTS_PAGE_RCVD () {0x1000;}' unless defined(&LINKSTS_PAGE_RCVD);
    eval 'sub LINKSTS_SPDDPX_RESOLVED () {0x800;}' unless defined(&LINKSTS_SPDDPX_RESOLVED);
    eval 'sub LINKSTS_UP () {0x400;}' unless defined(&LINKSTS_UP);
    eval 'sub LINKSTS_ANEG_COMP () {0x200;}' unless defined(&LINKSTS_ANEG_COMP);
    eval 'sub LINKSTS_MDI_CROSSOVR () {0x40;}' unless defined(&LINKSTS_MDI_CROSSOVR);
    eval 'sub LINKSTS_LPAR_PAUSE_ASYM () {0x2;}' unless defined(&LINKSTS_LPAR_PAUSE_ASYM);
    eval 'sub LINKSTS_LPAR_PAUSE () {0x1;}' unless defined(&LINKSTS_LPAR_PAUSE);
    eval 'sub JME_SMBCSR () {0x440;}' unless defined(&JME_SMBCSR);
    eval 'sub SMBCSR_SLAVE_ADDR_MASK () {0x7f000000;}' unless defined(&SMBCSR_SLAVE_ADDR_MASK);
    eval 'sub SMBCSR_WR_DATA_NACK () {0x40000;}' unless defined(&SMBCSR_WR_DATA_NACK);
    eval 'sub SMBCSR_CMD_NACK () {0x20000;}' unless defined(&SMBCSR_CMD_NACK);
    eval 'sub SMBCSR_RELOAD () {0x10000;}' unless defined(&SMBCSR_RELOAD);
    eval 'sub SMBCSR_CMD_ADDR_MASK () {0xff00;}' unless defined(&SMBCSR_CMD_ADDR_MASK);
    eval 'sub SMBCSR_SCL_STAT () {0x80;}' unless defined(&SMBCSR_SCL_STAT);
    eval 'sub SMBCSR_SDA_STAT () {0x40;}' unless defined(&SMBCSR_SDA_STAT);
    eval 'sub SMBCSR_EEPROM_PRESENT () {0x20;}' unless defined(&SMBCSR_EEPROM_PRESENT);
    eval 'sub SMBCSR_INIT_LD_DONE () {0x10;}' unless defined(&SMBCSR_INIT_LD_DONE);
    eval 'sub SMBCSR_HW_BUSY_MASK () {0xf;}' unless defined(&SMBCSR_HW_BUSY_MASK);
    eval 'sub SMBCSR_HW_IDLE () {0x;}' unless defined(&SMBCSR_HW_IDLE);
    eval 'sub JME_SMBINTF () {0x444;}' unless defined(&JME_SMBINTF);
    eval 'sub SMBINTF_RD_DATA_MASK () {0xff000000;}' unless defined(&SMBINTF_RD_DATA_MASK);
    eval 'sub SMBINTF_RD_DATA_SHIFT () {24;}' unless defined(&SMBINTF_RD_DATA_SHIFT);
    eval 'sub SMBINTF_WR_DATA_MASK () {0xff0000;}' unless defined(&SMBINTF_WR_DATA_MASK);
    eval 'sub SMBINTF_WR_DATA_SHIFT () {16;}' unless defined(&SMBINTF_WR_DATA_SHIFT);
    eval 'sub SMBINTF_ADDR_MASK () {0xff00;}' unless defined(&SMBINTF_ADDR_MASK);
    eval 'sub SMBINTF_ADDR_SHIFT () {8;}' unless defined(&SMBINTF_ADDR_SHIFT);
    eval 'sub SMBINTF_RD () {0x20;}' unless defined(&SMBINTF_RD);
    eval 'sub SMBINTF_WR () {0x;}' unless defined(&SMBINTF_WR);
    eval 'sub SMBINTF_CMD_TRIGGER () {0x10;}' unless defined(&SMBINTF_CMD_TRIGGER);
    eval 'sub SMBINTF_BUSY () {0x10;}' unless defined(&SMBINTF_BUSY);
    eval 'sub SMBINTF_FAST_MODE () {0x8;}' unless defined(&SMBINTF_FAST_MODE);
    eval 'sub SMBINTF_GPIO_SCL () {0x4;}' unless defined(&SMBINTF_GPIO_SCL);
    eval 'sub SMBINTF_GPIO_SDA () {0x2;}' unless defined(&SMBINTF_GPIO_SDA);
    eval 'sub SMBINTF_GPIO_ENB () {0x1;}' unless defined(&SMBINTF_GPIO_ENB);
    eval 'sub JME_EEPROM_SIG0 () {0x55;}' unless defined(&JME_EEPROM_SIG0);
    eval 'sub JME_EEPROM_SIG1 () {0xaa;}' unless defined(&JME_EEPROM_SIG1);
    eval 'sub JME_EEPROM_DESC_BYTES () {3;}' unless defined(&JME_EEPROM_DESC_BYTES);
    eval 'sub JME_EEPROM_DESC_END () {0x80;}' unless defined(&JME_EEPROM_DESC_END);
    eval 'sub JME_EEPROM_FUNC_MASK () {0x70;}' unless defined(&JME_EEPROM_FUNC_MASK);
    eval 'sub JME_EEPROM_FUNC_SHIFT () {4;}' unless defined(&JME_EEPROM_FUNC_SHIFT);
    eval 'sub JME_EEPROM_PAGE_MASK () {0xf;}' unless defined(&JME_EEPROM_PAGE_MASK);
    eval 'sub JME_EEPROM_PAGE_SHIFT () {0;}' unless defined(&JME_EEPROM_PAGE_SHIFT);
    eval 'sub JME_EEPROM_FUNC0 () {0;}' unless defined(&JME_EEPROM_FUNC0);
    eval 'sub JME_EEPROM_PAGE_BAR0 () {0;}' unless defined(&JME_EEPROM_PAGE_BAR0);
    eval 'sub JME_EEPROM_PAGE_BAR1 () {1;}' unless defined(&JME_EEPROM_PAGE_BAR1);
    eval 'sub JME_EEPROM_PAGE_BAR2 () {2;}' unless defined(&JME_EEPROM_PAGE_BAR2);
    eval 'sub JME_EEPROM_END () {0xff;}' unless defined(&JME_EEPROM_END);
    eval 'sub JME_EEPROM_MKDESC {
        my($f, $p) = @_;
	    eval q((((($f) &  &JME_EEPROM_FUNC_MASK) <<  &JME_EEPROM_FUNC_SHIFT) | ((($p) &  &JME_EEPROM_PAGE_MASK) <<  &JME_EEPROM_PAGE_SHIFT)));
    }' unless defined(&JME_EEPROM_MKDESC);
    eval 'sub JME_EEPINTF () {0x448;}' unless defined(&JME_EEPINTF);
    eval 'sub EEPINTF_DATA_MASK () {0xffff0000;}' unless defined(&EEPINTF_DATA_MASK);
    eval 'sub EEPINTF_DATA_SHIFT () {16;}' unless defined(&EEPINTF_DATA_SHIFT);
    eval 'sub EEPINTF_ADDR_MASK () {0xfc00;}' unless defined(&EEPINTF_ADDR_MASK);
    eval 'sub EEPINTF_ADDR_SHIFT () {10;}' unless defined(&EEPINTF_ADDR_SHIFT);
    eval 'sub EEPRINTF_OP_MASK () {0x300;}' unless defined(&EEPRINTF_OP_MASK);
    eval 'sub EEPINTF_OP_EXECUTE () {0x80;}' unless defined(&EEPINTF_OP_EXECUTE);
    eval 'sub EEPINTF_DATA_OUT () {0x8;}' unless defined(&EEPINTF_DATA_OUT);
    eval 'sub EEPINTF_DATA_IN () {0x4;}' unless defined(&EEPINTF_DATA_IN);
    eval 'sub EEPINTF_CLK () {0x2;}' unless defined(&EEPINTF_CLK);
    eval 'sub EEPINTF_SEL () {0x1;}' unless defined(&EEPINTF_SEL);
    eval 'sub JME_EEPCSR () {0x44c;}' unless defined(&JME_EEPCSR);
    eval 'sub EEPCSR_EEPROM_RELOAD () {0x2;}' unless defined(&EEPCSR_EEPROM_RELOAD);
    eval 'sub EEPCSR_EEPROM_PRESENT () {0x1;}' unless defined(&EEPCSR_EEPROM_PRESENT);
    eval 'sub JME_MISC_BASE_ADDR () {0x800;}' unless defined(&JME_MISC_BASE_ADDR);
    eval 'sub JME_TMCSR () {0x800;}' unless defined(&JME_TMCSR);
    eval 'sub TMCSR_SW_INTR () {0x80000000;}' unless defined(&TMCSR_SW_INTR);
    eval 'sub TMCSR_TIMER_INTR () {0x10000000;}' unless defined(&TMCSR_TIMER_INTR);
    eval 'sub TMCSR_TIMER_ENB () {0x1000000;}' unless defined(&TMCSR_TIMER_ENB);
    eval 'sub TMCSR_TIMER_COUNT_MASK () {0xffffff;}' unless defined(&TMCSR_TIMER_COUNT_MASK);
    eval 'sub JME_GPIO () {0x804;}' unless defined(&JME_GPIO);
    eval 'sub GPIO_4_SPI_IN () {0x80000000;}' unless defined(&GPIO_4_SPI_IN);
    eval 'sub GPIO_3_SPI_IN () {0x40000000;}' unless defined(&GPIO_3_SPI_IN);
    eval 'sub GPIO_4_SPI_OUT () {0x20000000;}' unless defined(&GPIO_4_SPI_OUT);
    eval 'sub GPIO_4_SPI_OUT_ENB () {0x10000000;}' unless defined(&GPIO_4_SPI_OUT_ENB);
    eval 'sub GPIO_3_SPI_OUT () {0x8000000;}' unless defined(&GPIO_3_SPI_OUT);
    eval 'sub GPIO_3_SPI_OUT_ENB () {0x4000000;}' unless defined(&GPIO_3_SPI_OUT_ENB);
    eval 'sub GPIO_3_4_LED () {0x;}' unless defined(&GPIO_3_4_LED);
    eval 'sub GPIO_3_4_GPIO () {0x2000000;}' unless defined(&GPIO_3_4_GPIO);
    eval 'sub GPIO_2_CLKREQN_IN () {0x100000;}' unless defined(&GPIO_2_CLKREQN_IN);
    eval 'sub GPIO_2_CLKREQN_OUT () {0x40000;}' unless defined(&GPIO_2_CLKREQN_OUT);
    eval 'sub GPIO_2_CLKREQN_OUT_ENB () {0x20000;}' unless defined(&GPIO_2_CLKREQN_OUT_ENB);
    eval 'sub GPIO_1_LED42_IN () {0x1000;}' unless defined(&GPIO_1_LED42_IN);
    eval 'sub GPIO_1_LED42_OUT () {0x400;}' unless defined(&GPIO_1_LED42_OUT);
    eval 'sub GPIO_1_LED42_OUT_ENB () {0x200;}' unless defined(&GPIO_1_LED42_OUT_ENB);
    eval 'sub GPIO_1_LED42_ENB () {0x100;}' unless defined(&GPIO_1_LED42_ENB);
    eval 'sub GPIO_0_SDA_IN () {0x10;}' unless defined(&GPIO_0_SDA_IN);
    eval 'sub GPIO_0_SDA_OUT () {0x4;}' unless defined(&GPIO_0_SDA_OUT);
    eval 'sub GPIO_0_SDA_OUT_ENB () {0x2;}' unless defined(&GPIO_0_SDA_OUT_ENB);
    eval 'sub GPIO_0_SDA_ENB () {0x1;}' unless defined(&GPIO_0_SDA_ENB);
    eval 'sub JME_GPREG0 () {0x808;}' unless defined(&JME_GPREG0);
    eval 'sub GPREG0_SH_POST_DW7_DIS () {0x80000000;}' unless defined(&GPREG0_SH_POST_DW7_DIS);
    eval 'sub GPREG0_SH_POST_DW6_DIS () {0x40000000;}' unless defined(&GPREG0_SH_POST_DW6_DIS);
    eval 'sub GPREG0_SH_POST_DW5_DIS () {0x20000000;}' unless defined(&GPREG0_SH_POST_DW5_DIS);
    eval 'sub GPREG0_SH_POST_DW4_DIS () {0x10000000;}' unless defined(&GPREG0_SH_POST_DW4_DIS);
    eval 'sub GPREG0_SH_POST_DW3_DIS () {0x8000000;}' unless defined(&GPREG0_SH_POST_DW3_DIS);
    eval 'sub GPREG0_SH_POST_DW2_DIS () {0x4000000;}' unless defined(&GPREG0_SH_POST_DW2_DIS);
    eval 'sub GPREG0_SH_POST_DW1_DIS () {0x2000000;}' unless defined(&GPREG0_SH_POST_DW1_DIS);
    eval 'sub GPREG0_SH_POST_DW0_DIS () {0x1000000;}' unless defined(&GPREG0_SH_POST_DW0_DIS);
    eval 'sub GPREG0_DMA_RD_REQ_8 () {0x;}' unless defined(&GPREG0_DMA_RD_REQ_8);
    eval 'sub GPREG0_DMA_RD_REQ_6 () {0x100000;}' unless defined(&GPREG0_DMA_RD_REQ_6);
    eval 'sub GPREG0_DMA_RD_REQ_5 () {0x200000;}' unless defined(&GPREG0_DMA_RD_REQ_5);
    eval 'sub GPREG0_DMA_RD_REQ_4 () {0x300000;}' unless defined(&GPREG0_DMA_RD_REQ_4);
    eval 'sub GPREG0_POST_DW0_ENB () {0x40000;}' unless defined(&GPREG0_POST_DW0_ENB);
    eval 'sub GPREG0_PCC_CLR_DIS () {0x20000;}' unless defined(&GPREG0_PCC_CLR_DIS);
    eval 'sub GPREG0_FORCE_SCL_OUT () {0x10000;}' unless defined(&GPREG0_FORCE_SCL_OUT);
    eval 'sub GPREG0_DL_RSTB_DIS () {0x8000;}' unless defined(&GPREG0_DL_RSTB_DIS);
    eval 'sub GPREG0_STICKY_RESET () {0x4000;}' unless defined(&GPREG0_STICKY_RESET);
    eval 'sub GPREG0_DL_RSTB_CFG_DIS () {0x2000;}' unless defined(&GPREG0_DL_RSTB_CFG_DIS);
    eval 'sub GPREG0_LINK_CHG_POLL () {0x1000;}' unless defined(&GPREG0_LINK_CHG_POLL);
    eval 'sub GPREG0_LINK_CHG_DIRECT () {0x;}' unless defined(&GPREG0_LINK_CHG_DIRECT);
    eval 'sub GPREG0_MSI_GEN_SEL () {0x800;}' unless defined(&GPREG0_MSI_GEN_SEL);
    eval 'sub GPREG0_SMB_PAD_PU_DIS () {0x400;}' unless defined(&GPREG0_SMB_PAD_PU_DIS);
    eval 'sub GPREG0_PCC_UNIT_16US () {0x;}' unless defined(&GPREG0_PCC_UNIT_16US);
    eval 'sub GPREG0_PCC_UNIT_256US () {0x100;}' unless defined(&GPREG0_PCC_UNIT_256US);
    eval 'sub GPREG0_PCC_UNIT_US () {0x200;}' unless defined(&GPREG0_PCC_UNIT_US);
    eval 'sub GPREG0_PCC_UNIT_MS () {0x300;}' unless defined(&GPREG0_PCC_UNIT_MS);
    eval 'sub GPREG0_PCC_UNIT_MASK () {0x300;}' unless defined(&GPREG0_PCC_UNIT_MASK);
    eval 'sub GPREG0_INTR_EVENT_ENB () {0x80;}' unless defined(&GPREG0_INTR_EVENT_ENB);
    eval 'sub GPREG0_PME_ENB () {0x20;}' unless defined(&GPREG0_PME_ENB);
    eval 'sub GPREG0_PHY_ADDR_MASK () {0x1f;}' unless defined(&GPREG0_PHY_ADDR_MASK);
    eval 'sub GPREG0_PHY_ADDR_SHIFT () {0;}' unless defined(&GPREG0_PHY_ADDR_SHIFT);
    eval 'sub GPREG0_PHY_ADDR () {1;}' unless defined(&GPREG0_PHY_ADDR);
    eval 'sub JME_GPREG1 () {0x80c;}' unless defined(&JME_GPREG1);
    eval 'sub GPREG1_HALF_PATCH () {0x20;}' unless defined(&GPREG1_HALF_PATCH);
    eval 'sub GPREG1_RSS_PATCH () {0x40;}' unless defined(&GPREG1_RSS_PATCH);
    eval 'sub JME_MSINUM_BASE () {0x810;}' unless defined(&JME_MSINUM_BASE);
    eval 'sub JME_MSINUM_END () {0x81f;}' unless defined(&JME_MSINUM_END);
    eval 'sub MSINUM_MASK () {0x7fffffff;}' unless defined(&MSINUM_MASK);
    eval 'sub MSINUM_ENTRY_MASK () {7;}' unless defined(&MSINUM_ENTRY_MASK);
    eval 'sub MSINUM_REG_INDEX {
        my($x) = @_;
	    eval q((($x) / 8));
    }' unless defined(&MSINUM_REG_INDEX);
    eval 'sub MSINUM_INTR_SOURCE {
        my($x, $y) = @_;
	    eval q(((($x) &  &MSINUM_ENTRY_MASK) << ((($y) & 7) * 4)));
    }' unless defined(&MSINUM_INTR_SOURCE);
    eval 'sub MSINUM_NUM_INTR_SOURCE () {32;}' unless defined(&MSINUM_NUM_INTR_SOURCE);
    eval 'sub JME_INTR_STATUS () {0x820;}' unless defined(&JME_INTR_STATUS);
    eval 'sub INTR_SW () {0x80000000;}' unless defined(&INTR_SW);
    eval 'sub INTR_TIMER () {0x40000000;}' unless defined(&INTR_TIMER);
    eval 'sub INTR_LINKCHG () {0x20000000;}' unless defined(&INTR_LINKCHG);
    eval 'sub INTR_PAUSE () {0x10000000;}' unless defined(&INTR_PAUSE);
    eval 'sub INTR_MAGIC_PKT () {0x8000000;}' unless defined(&INTR_MAGIC_PKT);
    eval 'sub INTR_WAKEUP_PKT () {0x4000000;}' unless defined(&INTR_WAKEUP_PKT);
    eval 'sub INTR_RXQ0_COAL_TO () {0x2000000;}' unless defined(&INTR_RXQ0_COAL_TO);
    eval 'sub INTR_RXQ1_COAL_TO () {0x1000000;}' unless defined(&INTR_RXQ1_COAL_TO);
    eval 'sub INTR_RXQ2_COAL_TO () {0x800000;}' unless defined(&INTR_RXQ2_COAL_TO);
    eval 'sub INTR_RXQ3_COAL_TO () {0x400000;}' unless defined(&INTR_RXQ3_COAL_TO);
    eval 'sub INTR_TXQ_COAL_TO () {0x200000;}' unless defined(&INTR_TXQ_COAL_TO);
    eval 'sub INTR_RXQ0_COAL () {0x100000;}' unless defined(&INTR_RXQ0_COAL);
    eval 'sub INTR_RXQ1_COAL () {0x80000;}' unless defined(&INTR_RXQ1_COAL);
    eval 'sub INTR_RXQ2_COAL () {0x40000;}' unless defined(&INTR_RXQ2_COAL);
    eval 'sub INTR_RXQ3_COAL () {0x20000;}' unless defined(&INTR_RXQ3_COAL);
    eval 'sub INTR_TXQ_COAL () {0x10000;}' unless defined(&INTR_TXQ_COAL);
    eval 'sub INTR_RXQ3_DESC_EMPTY () {0x8000;}' unless defined(&INTR_RXQ3_DESC_EMPTY);
    eval 'sub INTR_RXQ2_DESC_EMPTY () {0x4000;}' unless defined(&INTR_RXQ2_DESC_EMPTY);
    eval 'sub INTR_RXQ1_DESC_EMPTY () {0x2000;}' unless defined(&INTR_RXQ1_DESC_EMPTY);
    eval 'sub INTR_RXQ0_DESC_EMPTY () {0x1000;}' unless defined(&INTR_RXQ0_DESC_EMPTY);
    eval 'sub INTR_RXQ3_COMP () {0x800;}' unless defined(&INTR_RXQ3_COMP);
    eval 'sub INTR_RXQ2_COMP () {0x400;}' unless defined(&INTR_RXQ2_COMP);
    eval 'sub INTR_RXQ1_COMP () {0x200;}' unless defined(&INTR_RXQ1_COMP);
    eval 'sub INTR_RXQ0_COMP () {0x100;}' unless defined(&INTR_RXQ0_COMP);
    eval 'sub INTR_TXQ7_COMP () {0x80;}' unless defined(&INTR_TXQ7_COMP);
    eval 'sub INTR_TXQ6_COMP () {0x40;}' unless defined(&INTR_TXQ6_COMP);
    eval 'sub INTR_TXQ5_COMP () {0x20;}' unless defined(&INTR_TXQ5_COMP);
    eval 'sub INTR_TXQ4_COMP () {0x10;}' unless defined(&INTR_TXQ4_COMP);
    eval 'sub INTR_TXQ3_COMP () {0x8;}' unless defined(&INTR_TXQ3_COMP);
    eval 'sub INTR_TXQ2_COMP () {0x4;}' unless defined(&INTR_TXQ2_COMP);
    eval 'sub INTR_TXQ1_COMP () {0x2;}' unless defined(&INTR_TXQ1_COMP);
    eval 'sub INTR_TXQ0_COMP () {0x1;}' unless defined(&INTR_TXQ0_COMP);
    eval 'sub INTR_RXQ_COAL_TO () {( &INTR_RXQ0_COAL_TO |  &INTR_RXQ1_COAL_TO |  &INTR_RXQ2_COAL_TO |  &INTR_RXQ3_COAL_TO);}' unless defined(&INTR_RXQ_COAL_TO);
    eval 'sub INTR_RXQ_COAL () {( &INTR_RXQ0_COAL |  &INTR_RXQ1_COAL |  &INTR_RXQ2_COAL |  &INTR_RXQ3_COAL);}' unless defined(&INTR_RXQ_COAL);
    eval 'sub INTR_RXQ_COMP () {( &INTR_RXQ0_COMP |  &INTR_RXQ1_COMP |  &INTR_RXQ2_COMP |  &INTR_RXQ3_COMP);}' unless defined(&INTR_RXQ_COMP);
    eval 'sub INTR_RXQ_DESC_EMPTY () {( &INTR_RXQ0_DESC_EMPTY |  &INTR_RXQ1_DESC_EMPTY |  &INTR_RXQ2_DESC_EMPTY |  &INTR_RXQ3_DESC_EMPTY);}' unless defined(&INTR_RXQ_DESC_EMPTY);
    eval 'sub INTR_RXQ_COMP () {( &INTR_RXQ0_COMP |  &INTR_RXQ1_COMP |  &INTR_RXQ2_COMP |  &INTR_RXQ3_COMP);}' unless defined(&INTR_RXQ_COMP);
    eval 'sub INTR_TXQ_COMP () {( &INTR_TXQ0_COMP |  &INTR_TXQ1_COMP |  &INTR_TXQ2_COMP |  &INTR_TXQ3_COMP |  &INTR_TXQ4_COMP |  &INTR_TXQ5_COMP |  &INTR_TXQ6_COMP |  &INTR_TXQ7_COMP);}' unless defined(&INTR_TXQ_COMP);
    eval 'sub JME_INTRS () {( &INTR_RXQ_COAL_TO |  &INTR_TXQ_COAL_TO |  &INTR_RXQ_COAL |  &INTR_TXQ_COAL |  &INTR_RXQ_DESC_EMPTY);}' unless defined(&JME_INTRS);
    eval 'sub N_INTR_SW () {31;}' unless defined(&N_INTR_SW);
    eval 'sub N_INTR_TIMER () {30;}' unless defined(&N_INTR_TIMER);
    eval 'sub N_INTR_LINKCHG () {29;}' unless defined(&N_INTR_LINKCHG);
    eval 'sub N_INTR_PAUSE () {28;}' unless defined(&N_INTR_PAUSE);
    eval 'sub N_INTR_MAGIC_PKT () {27;}' unless defined(&N_INTR_MAGIC_PKT);
    eval 'sub N_INTR_WAKEUP_PKT () {26;}' unless defined(&N_INTR_WAKEUP_PKT);
    eval 'sub N_INTR_RXQ0_COAL_TO () {25;}' unless defined(&N_INTR_RXQ0_COAL_TO);
    eval 'sub N_INTR_RXQ1_COAL_TO () {24;}' unless defined(&N_INTR_RXQ1_COAL_TO);
    eval 'sub N_INTR_RXQ2_COAL_TO () {23;}' unless defined(&N_INTR_RXQ2_COAL_TO);
    eval 'sub N_INTR_RXQ3_COAL_TO () {22;}' unless defined(&N_INTR_RXQ3_COAL_TO);
    eval 'sub N_INTR_TXQ_COAL_TO () {21;}' unless defined(&N_INTR_TXQ_COAL_TO);
    eval 'sub N_INTR_RXQ0_COAL () {20;}' unless defined(&N_INTR_RXQ0_COAL);
    eval 'sub N_INTR_RXQ1_COAL () {19;}' unless defined(&N_INTR_RXQ1_COAL);
    eval 'sub N_INTR_RXQ2_COAL () {18;}' unless defined(&N_INTR_RXQ2_COAL);
    eval 'sub N_INTR_RXQ3_COAL () {17;}' unless defined(&N_INTR_RXQ3_COAL);
    eval 'sub N_INTR_TXQ_COAL () {16;}' unless defined(&N_INTR_TXQ_COAL);
    eval 'sub N_INTR_RXQ3_DESC_EMPTY () {15;}' unless defined(&N_INTR_RXQ3_DESC_EMPTY);
    eval 'sub N_INTR_RXQ2_DESC_EMPTY () {14;}' unless defined(&N_INTR_RXQ2_DESC_EMPTY);
    eval 'sub N_INTR_RXQ1_DESC_EMPTY () {13;}' unless defined(&N_INTR_RXQ1_DESC_EMPTY);
    eval 'sub N_INTR_RXQ0_DESC_EMPTY () {12;}' unless defined(&N_INTR_RXQ0_DESC_EMPTY);
    eval 'sub N_INTR_RXQ3_COMP () {11;}' unless defined(&N_INTR_RXQ3_COMP);
    eval 'sub N_INTR_RXQ2_COMP () {10;}' unless defined(&N_INTR_RXQ2_COMP);
    eval 'sub N_INTR_RXQ1_COMP () {9;}' unless defined(&N_INTR_RXQ1_COMP);
    eval 'sub N_INTR_RXQ0_COMP () {8;}' unless defined(&N_INTR_RXQ0_COMP);
    eval 'sub N_INTR_TXQ7_COMP () {7;}' unless defined(&N_INTR_TXQ7_COMP);
    eval 'sub N_INTR_TXQ6_COMP () {6;}' unless defined(&N_INTR_TXQ6_COMP);
    eval 'sub N_INTR_TXQ5_COMP () {5;}' unless defined(&N_INTR_TXQ5_COMP);
    eval 'sub N_INTR_TXQ4_COMP () {4;}' unless defined(&N_INTR_TXQ4_COMP);
    eval 'sub N_INTR_TXQ3_COMP () {3;}' unless defined(&N_INTR_TXQ3_COMP);
    eval 'sub N_INTR_TXQ2_COMP () {2;}' unless defined(&N_INTR_TXQ2_COMP);
    eval 'sub N_INTR_TXQ1_COMP () {1;}' unless defined(&N_INTR_TXQ1_COMP);
    eval 'sub N_INTR_TXQ0_COMP () {0;}' unless defined(&N_INTR_TXQ0_COMP);
    eval 'sub JME_INTR_REQ_STATUS () {0x824;}' unless defined(&JME_INTR_REQ_STATUS);
    eval 'sub JME_INTR_MASK_SET () {0x828;}' unless defined(&JME_INTR_MASK_SET);
    eval 'sub JME_INTR_MASK_CLR () {0x82c;}' unless defined(&JME_INTR_MASK_CLR);
    eval 'sub JME_PCCRX0 () {0x830;}' unless defined(&JME_PCCRX0);
    eval 'sub JME_PCCRX1 () {0x834;}' unless defined(&JME_PCCRX1);
    eval 'sub JME_PCCRX2 () {0x838;}' unless defined(&JME_PCCRX2);
    eval 'sub JME_PCCRX3 () {0x83c;}' unless defined(&JME_PCCRX3);
    eval 'sub PCCRX_COAL_TO_MASK () {0xffff0000;}' unless defined(&PCCRX_COAL_TO_MASK);
    eval 'sub PCCRX_COAL_TO_SHIFT () {16;}' unless defined(&PCCRX_COAL_TO_SHIFT);
    eval 'sub PCCRX_COAL_PKT_MASK () {0xff00;}' unless defined(&PCCRX_COAL_PKT_MASK);
    eval 'sub PCCRX_COAL_PKT_SHIFT () {8;}' unless defined(&PCCRX_COAL_PKT_SHIFT);
    eval 'sub PCCRX_COAL_TO_MIN () {1;}' unless defined(&PCCRX_COAL_TO_MIN);
    eval 'sub PCCRX_COAL_TO_DEFAULT () {100;}' unless defined(&PCCRX_COAL_TO_DEFAULT);
    eval 'sub PCCRX_COAL_TO_MAX () {65535;}' unless defined(&PCCRX_COAL_TO_MAX);
    eval 'sub PCCRX_COAL_PKT_MIN () {1;}' unless defined(&PCCRX_COAL_PKT_MIN);
    eval 'sub PCCRX_COAL_PKT_DEFAULT () {64;}' unless defined(&PCCRX_COAL_PKT_DEFAULT);
    eval 'sub PCCRX_COAL_PKT_MAX () {255;}' unless defined(&PCCRX_COAL_PKT_MAX);
    eval 'sub JME_PCCTX () {0x840;}' unless defined(&JME_PCCTX);
    eval 'sub PCCTX_COAL_TO_MASK () {0xffff0000;}' unless defined(&PCCTX_COAL_TO_MASK);
    eval 'sub PCCTX_COAL_TO_SHIFT () {16;}' unless defined(&PCCTX_COAL_TO_SHIFT);
    eval 'sub PCCTX_COAL_PKT_MASK () {0xff00;}' unless defined(&PCCTX_COAL_PKT_MASK);
    eval 'sub PCCTX_COAL_PKT_SHIFT () {8;}' unless defined(&PCCTX_COAL_PKT_SHIFT);
    eval 'sub PCCTX_COAL_TXQ7 () {0x80;}' unless defined(&PCCTX_COAL_TXQ7);
    eval 'sub PCCTX_COAL_TXQ6 () {0x40;}' unless defined(&PCCTX_COAL_TXQ6);
    eval 'sub PCCTX_COAL_TXQ5 () {0x20;}' unless defined(&PCCTX_COAL_TXQ5);
    eval 'sub PCCTX_COAL_TXQ4 () {0x10;}' unless defined(&PCCTX_COAL_TXQ4);
    eval 'sub PCCTX_COAL_TXQ3 () {0x8;}' unless defined(&PCCTX_COAL_TXQ3);
    eval 'sub PCCTX_COAL_TXQ2 () {0x4;}' unless defined(&PCCTX_COAL_TXQ2);
    eval 'sub PCCTX_COAL_TXQ1 () {0x2;}' unless defined(&PCCTX_COAL_TXQ1);
    eval 'sub PCCTX_COAL_TXQ0 () {0x1;}' unless defined(&PCCTX_COAL_TXQ0);
    eval 'sub PCCTX_COAL_TO_MIN () {1;}' unless defined(&PCCTX_COAL_TO_MIN);
    eval 'sub PCCTX_COAL_TO_DEFAULT () {65535;}' unless defined(&PCCTX_COAL_TO_DEFAULT);
    eval 'sub PCCTX_COAL_TO_MAX () {65535;}' unless defined(&PCCTX_COAL_TO_MAX);
    eval 'sub PCCTX_COAL_PKT_MIN () {1;}' unless defined(&PCCTX_COAL_PKT_MIN);
    eval 'sub PCCTX_COAL_PKT_DEFAULT () {64;}' unless defined(&PCCTX_COAL_PKT_DEFAULT);
    eval 'sub PCCTX_COAL_PKT_MAX () {255;}' unless defined(&PCCTX_COAL_PKT_MAX);
    eval 'sub JME_CHIPMODE () {0x844;}' unless defined(&JME_CHIPMODE);
    eval 'sub CHIPMODE_FPGA_REV_MASK () {0xffff0000;}' unless defined(&CHIPMODE_FPGA_REV_MASK);
    eval 'sub CHIPMODE_FPGA_REV_SHIFT () {16;}' unless defined(&CHIPMODE_FPGA_REV_SHIFT);
    eval 'sub CHIPMODE_NOT_FPGA () {0;}' unless defined(&CHIPMODE_NOT_FPGA);
    eval 'sub CHIPMODE_REV_MASK () {0xff00;}' unless defined(&CHIPMODE_REV_MASK);
    eval 'sub CHIPMODE_REV_SHIFT () {8;}' unless defined(&CHIPMODE_REV_SHIFT);
    eval 'sub CHIPMODE_REVFM_MASK () {0xf00;}' unless defined(&CHIPMODE_REVFM_MASK);
    eval 'sub CHIPMODE_REVFM_SHIFT () {8;}' unless defined(&CHIPMODE_REVFM_SHIFT);
    eval 'sub CHIPMODE_MODE_48P () {0xc;}' unless defined(&CHIPMODE_MODE_48P);
    eval 'sub CHIPMODE_MODE_64P () {0x4;}' unless defined(&CHIPMODE_MODE_64P);
    eval 'sub CHIPMODE_MODE_128P_MAC () {0x3;}' unless defined(&CHIPMODE_MODE_128P_MAC);
    eval 'sub CHIPMODE_MODE_128P_DBG () {0x2;}' unless defined(&CHIPMODE_MODE_128P_DBG);
    eval 'sub CHIPMODE_MODE_128P_PHY () {0x;}' unless defined(&CHIPMODE_MODE_128P_PHY);
    eval 'sub JME_SHBASE_ADDR_HI () {0x848;}' unless defined(&JME_SHBASE_ADDR_HI);
    eval 'sub JME_SHBASE_ADDR_LO () {0x84c;}' unless defined(&JME_SHBASE_ADDR_LO);
    eval 'sub SHBASE_ADDR_LO_MASK () {0xffffffe0;}' unless defined(&SHBASE_ADDR_LO_MASK);
    eval 'sub SHBASE_POST_FORCE () {0x2;}' unless defined(&SHBASE_POST_FORCE);
    eval 'sub SHBASE_POST_ENB () {0x1;}' unless defined(&SHBASE_POST_ENB);
    eval 'sub JME_TIMER1 () {0x870;}' unless defined(&JME_TIMER1);
    eval 'sub JME_TIMER2 () {0x874;}' unless defined(&JME_TIMER2);
    eval 'sub TIMER_ENB () {0x1000000;}' unless defined(&TIMER_ENB);
    eval 'sub TIMER_CNT_MASK () {0xffffff;}' unless defined(&TIMER_CNT_MASK);
    eval 'sub TIMER_CNT_SHIFT () {0;}' unless defined(&TIMER_CNT_SHIFT);
    eval 'sub TIMER_UNIT () {1024;}' unless defined(&TIMER_UNIT);
    eval 'sub JME_APMC () {0x87c;}' unless defined(&JME_APMC);
    eval 'sub APMC_PCIE_SDOWN_STAT () {0x80000000;}' unless defined(&APMC_PCIE_SDOWN_STAT);
    eval 'sub APMC_PCIE_SDOWN_ENB () {0x40000000;}' unless defined(&APMC_PCIE_SDOWN_ENB);
    eval 'sub APMC_PSEUDO_HOT_PLUG () {0x20000000;}' unless defined(&APMC_PSEUDO_HOT_PLUG);
    eval 'sub APMC_EXT_PLUGIN_ENB () {0x4000000;}' unless defined(&APMC_EXT_PLUGIN_ENB);
    eval 'sub APMC_EXT_PLUGIN_CTL_MSK () {0x3000000;}' unless defined(&APMC_EXT_PLUGIN_CTL_MSK);
    eval 'sub APMC_DIS_SRAM () {0x4;}' unless defined(&APMC_DIS_SRAM);
    eval 'sub APMC_DIS_CLKPM () {0x2;}' unless defined(&APMC_DIS_CLKPM);
    eval 'sub APMC_DIS_CLKTX () {0x1;}' unless defined(&APMC_DIS_CLKTX);
    eval 'sub JME_PCCSRX_BASE () {0x880;}' unless defined(&JME_PCCSRX_BASE);
    eval 'sub JME_PCCSRX_END () {0x88f;}' unless defined(&JME_PCCSRX_END);
    eval 'sub PCCSRX_REG {
        my($x) = @_;
	    eval q(( &JME_PCCSRX_BASE + (($x) * 4)));
    }' unless defined(&PCCSRX_REG);
    eval 'sub PCCSRX_TO_MASK () {0xffff0000;}' unless defined(&PCCSRX_TO_MASK);
    eval 'sub PCCSRX_TO_SHIFT () {16;}' unless defined(&PCCSRX_TO_SHIFT);
    eval 'sub PCCSRX_PKT_CNT_MASK () {0xff00;}' unless defined(&PCCSRX_PKT_CNT_MASK);
    eval 'sub PCCSRX_PKT_CNT_SHIFT () {8;}' unless defined(&PCCSRX_PKT_CNT_SHIFT);
    eval 'sub JME_PCCSTX () {0x890;}' unless defined(&JME_PCCSTX);
    eval 'sub PCCSTX_TO_MASK () {0xffff0000;}' unless defined(&PCCSTX_TO_MASK);
    eval 'sub PCCSTX_TO_SHIFT () {16;}' unless defined(&PCCSTX_TO_SHIFT);
    eval 'sub PCCSTX_PKT_CNT_MASK () {0xff00;}' unless defined(&PCCSTX_PKT_CNT_MASK);
    eval 'sub PCCSTX_PKT_CNT_SHIFT () {8;}' unless defined(&PCCSTX_PKT_CNT_SHIFT);
    eval 'sub JME_TXQEMPTY () {0x894;}' unless defined(&JME_TXQEMPTY);
    eval 'sub TXQEMPTY_TXQ7 () {0x80;}' unless defined(&TXQEMPTY_TXQ7);
    eval 'sub TXQEMPTY_TXQ6 () {0x40;}' unless defined(&TXQEMPTY_TXQ6);
    eval 'sub TXQEMPTY_TXQ5 () {0x20;}' unless defined(&TXQEMPTY_TXQ5);
    eval 'sub TXQEMPTY_TXQ4 () {0x10;}' unless defined(&TXQEMPTY_TXQ4);
    eval 'sub TXQEMPTY_TXQ3 () {0x8;}' unless defined(&TXQEMPTY_TXQ3);
    eval 'sub TXQEMPTY_TXQ2 () {0x4;}' unless defined(&TXQEMPTY_TXQ2);
    eval 'sub TXQEMPTY_TXQ1 () {0x2;}' unless defined(&TXQEMPTY_TXQ1);
    eval 'sub TXQEMPTY_TXQ0 () {0x1;}' unless defined(&TXQEMPTY_TXQ0);
    eval 'sub TXQEMPTY_N_TXQ {
        my($x, $y) = @_;
	    eval q((($x) & (0x1 << ($y))));
    }' unless defined(&TXQEMPTY_N_TXQ);
    eval 'sub JME_RSS_BASE () {0xc00;}' unless defined(&JME_RSS_BASE);
    eval 'sub JME_RSSC () {0xc00;}' unless defined(&JME_RSSC);
    eval 'sub RSSC_HASH_LEN_MASK () {0xe000;}' unless defined(&RSSC_HASH_LEN_MASK);
    eval 'sub RSSC_HASH_64_ENTRY () {0xa000;}' unless defined(&RSSC_HASH_64_ENTRY);
    eval 'sub RSSC_HASH_128_ENTRY () {0xe000;}' unless defined(&RSSC_HASH_128_ENTRY);
    eval 'sub RSSC_HASH_NONE () {0x1000;}' unless defined(&RSSC_HASH_NONE);
    eval 'sub RSSC_HASH_IPV6 () {0x800;}' unless defined(&RSSC_HASH_IPV6);
    eval 'sub RSSC_HASH_IPV4 () {0x400;}' unless defined(&RSSC_HASH_IPV4);
    eval 'sub RSSC_HASH_IPV6_TCP () {0x200;}' unless defined(&RSSC_HASH_IPV6_TCP);
    eval 'sub RSSC_HASH_IPV4_TCP () {0x100;}' unless defined(&RSSC_HASH_IPV4_TCP);
    eval 'sub RSSC_NCPU_MASK () {0xf8;}' unless defined(&RSSC_NCPU_MASK);
    eval 'sub RSSC_NCPU_SHIFT () {3;}' unless defined(&RSSC_NCPU_SHIFT);
    eval 'sub RSSC_DIS_RSS () {0x;}' unless defined(&RSSC_DIS_RSS);
    eval 'sub RSSC_2RXQ_ENB () {0x1;}' unless defined(&RSSC_2RXQ_ENB);
    eval 'sub RSSS_4RXQ_ENB () {0x2;}' unless defined(&RSSS_4RXQ_ENB);
    eval 'sub JME_RSSCPU () {0xc04;}' unless defined(&JME_RSSCPU);
    eval 'sub RSSCPU_N_SEL {
        my($x) = @_;
	    eval q(((1<< ($x)));
    }' unless defined(&RSSCPU_N_SEL);
    eval 'sub JME_RSSHASH () {0xc10;}' unless defined(&JME_RSSHASH);
    eval 'sub JME_RSSHASH_STAT () {0xc14;}' unless defined(&JME_RSSHASH_STAT);
    eval 'sub JME_RSS_RDATA0 () {0xc18;}' unless defined(&JME_RSS_RDATA0);
    eval 'sub JME_RSS_RDATA1 () {0xc1c;}' unless defined(&JME_RSS_RDATA1);
    eval 'sub JME_RSSKEY_BASE () {0xc40;}' unless defined(&JME_RSSKEY_BASE);
    eval 'sub JME_RSSKEY_LAST () {0xc64;}' unless defined(&JME_RSSKEY_LAST);
    eval 'sub JME_RSSKEY_END () {0xc67;}' unless defined(&JME_RSSKEY_END);
    eval 'sub HASHKEY_NBYTES () {40;}' unless defined(&HASHKEY_NBYTES);
    eval 'sub RSSKEY_REG {
        my($x) = @_;
	    eval q(( &JME_RSSKEY_LAST - (4* (($x) / 4))));
    }' unless defined(&RSSKEY_REG);
    eval 'sub RSSKEY_VALUE {
        my($x, $y) = @_;
	    eval q((($x) << (24- 8* (($y) % 4))));
    }' unless defined(&RSSKEY_VALUE);
    eval 'sub JME_RSSTBL_BASE () {0xc80;}' unless defined(&JME_RSSTBL_BASE);
    eval 'sub JME_RSSTBL_END () {0xcff;}' unless defined(&JME_RSSTBL_END);
    eval 'sub RSSTBL_NENTRY () {128;}' unless defined(&RSSTBL_NENTRY);
    eval 'sub RSSTBL_REG {
        my($x) = @_;
	    eval q(( &JME_RSSTBL_BASE + (($x) / 4)));
    }' unless defined(&RSSTBL_REG);
    eval 'sub RSSTBL_VALUE {
        my($x, $y) = @_;
	    eval q((($x) << (8* (($y) % 4))));
    }' unless defined(&RSSTBL_VALUE);
    eval 'sub JME_MSIX_BASE_ADDR () {0x2000;}' unless defined(&JME_MSIX_BASE_ADDR);
    eval 'sub JME_MSIX_BASE () {0x2000;}' unless defined(&JME_MSIX_BASE);
    eval 'sub JME_MSIX_END () {0x207f;}' unless defined(&JME_MSIX_END);
    eval 'sub JME_MSIX_NENTRY () {8;}' unless defined(&JME_MSIX_NENTRY);
    eval 'sub MSIX_REG {
        my($x) = @_;
	    eval q(( &JME_MSIX_BASE + (($x) * 0x10)));
    }' unless defined(&MSIX_REG);
    eval 'sub MSIX_ADDR_HI_OFF () {0x;}' unless defined(&MSIX_ADDR_HI_OFF);
    eval 'sub MSIX_ADDR_LO_OFF () {0x4;}' unless defined(&MSIX_ADDR_LO_OFF);
    eval 'sub MSIX_ADDR_LO_MASK () {0xfffffffc;}' unless defined(&MSIX_ADDR_LO_MASK);
    eval 'sub MSIX_DATA_OFF () {0x8;}' unless defined(&MSIX_DATA_OFF);
    eval 'sub MSIX_VECTOR_OFF () {0xc;}' unless defined(&MSIX_VECTOR_OFF);
    eval 'sub MSIX_VECTOR_RSVD () {0x80000000;}' unless defined(&MSIX_VECTOR_RSVD);
    eval 'sub MSIX_VECTOR_DIS () {0x1;}' unless defined(&MSIX_VECTOR_DIS);
    eval 'sub JME_MSIX_PBA_BASE_ADDR () {0x3000;}' unless defined(&JME_MSIX_PBA_BASE_ADDR);
    eval 'sub JME_MSIX_PBA () {0x3000;}' unless defined(&JME_MSIX_PBA);
    eval 'sub MSIX_PBA_RSVD_MASK () {0xffffff00;}' unless defined(&MSIX_PBA_RSVD_MASK);
    eval 'sub MSIX_PBA_RSVD_SHIFT () {8;}' unless defined(&MSIX_PBA_RSVD_SHIFT);
    eval 'sub MSIX_PBA_PEND_MASK () {0xff;}' unless defined(&MSIX_PBA_PEND_MASK);
    eval 'sub MSIX_PBA_PEND_SHIFT () {0;}' unless defined(&MSIX_PBA_PEND_SHIFT);
    eval 'sub MSIX_PBA_PEND_ENTRY7 () {0x80;}' unless defined(&MSIX_PBA_PEND_ENTRY7);
    eval 'sub MSIX_PBA_PEND_ENTRY6 () {0x40;}' unless defined(&MSIX_PBA_PEND_ENTRY6);
    eval 'sub MSIX_PBA_PEND_ENTRY5 () {0x20;}' unless defined(&MSIX_PBA_PEND_ENTRY5);
    eval 'sub MSIX_PBA_PEND_ENTRY4 () {0x10;}' unless defined(&MSIX_PBA_PEND_ENTRY4);
    eval 'sub MSIX_PBA_PEND_ENTRY3 () {0x8;}' unless defined(&MSIX_PBA_PEND_ENTRY3);
    eval 'sub MSIX_PBA_PEND_ENTRY2 () {0x4;}' unless defined(&MSIX_PBA_PEND_ENTRY2);
    eval 'sub MSIX_PBA_PEND_ENTRY1 () {0x2;}' unless defined(&MSIX_PBA_PEND_ENTRY1);
    eval 'sub MSIX_PBA_PEND_ENTRY0 () {0x1;}' unless defined(&MSIX_PBA_PEND_ENTRY0);
    eval 'sub JME_PHY_OUI () {0x1b8c;}' unless defined(&JME_PHY_OUI);
    eval 'sub JME_PHY_MODEL () {0x21;}' unless defined(&JME_PHY_MODEL);
    eval 'sub JME_PHY_REV () {0x1;}' unless defined(&JME_PHY_REV);
    eval 'sub JME_PHY_ADDR () {1;}' unless defined(&JME_PHY_ADDR);
    eval 'sub JME_TD_OWN () {0x80000000;}' unless defined(&JME_TD_OWN);
    eval 'sub JME_TD_INTR () {0x40000000;}' unless defined(&JME_TD_INTR);
    eval 'sub JME_TD_64BIT () {0x20000000;}' unless defined(&JME_TD_64BIT);
    eval 'sub JME_TD_TCPCSUM () {0x10000000;}' unless defined(&JME_TD_TCPCSUM);
    eval 'sub JME_TD_UDPCSUM () {0x8000000;}' unless defined(&JME_TD_UDPCSUM);
    eval 'sub JME_TD_IPCSUM () {0x4000000;}' unless defined(&JME_TD_IPCSUM);
    eval 'sub JME_TD_TSO () {0x2000000;}' unless defined(&JME_TD_TSO);
    eval 'sub JME_TD_VLAN_TAG () {0x1000000;}' unless defined(&JME_TD_VLAN_TAG);
    eval 'sub JME_TD_VLAN_MASK () {0xffff;}' unless defined(&JME_TD_VLAN_MASK);
    eval 'sub JME_TD_MSS_MASK () {0xfffc0000;}' unless defined(&JME_TD_MSS_MASK);
    eval 'sub JME_TD_MSS_SHIFT () {18;}' unless defined(&JME_TD_MSS_SHIFT);
    eval 'sub JME_TD_BUF_LEN_MASK () {0xffff;}' unless defined(&JME_TD_BUF_LEN_MASK);
    eval 'sub JME_TD_BUF_LEN_SHIFT () {0;}' unless defined(&JME_TD_BUF_LEN_SHIFT);
    eval 'sub JME_TD_FRAME_LEN_MASK () {0xffff;}' unless defined(&JME_TD_FRAME_LEN_MASK);
    eval 'sub JME_TD_FRAME_LEN_SHIFT () {0;}' unless defined(&JME_TD_FRAME_LEN_SHIFT);
    eval 'sub JME_TD_TMOUT () {0x20000000;}' unless defined(&JME_TD_TMOUT);
    eval 'sub JME_TD_RETRY_EXP () {0x10000000;}' unless defined(&JME_TD_RETRY_EXP);
    eval 'sub JME_TD_COLLISION () {0x8000000;}' unless defined(&JME_TD_COLLISION);
    eval 'sub JME_TD_UNDERRUN () {0x4000000;}' unless defined(&JME_TD_UNDERRUN);
    eval 'sub JME_TD_EHDR_SIZE_MASK () {0xff;}' unless defined(&JME_TD_EHDR_SIZE_MASK);
    eval 'sub JME_TD_EHDR_SIZE_SHIFT () {0;}' unless defined(&JME_TD_EHDR_SIZE_SHIFT);
    eval 'sub JME_TD_SEG_CNT_MASK () {0xffff0000;}' unless defined(&JME_TD_SEG_CNT_MASK);
    eval 'sub JME_TD_SEG_CNT_SHIFT () {16;}' unless defined(&JME_TD_SEG_CNT_SHIFT);
    eval 'sub JME_TD_RETRY_CNT_MASK () {0xffff;}' unless defined(&JME_TD_RETRY_CNT_MASK);
    eval 'sub JME_TD_RETRY_CNT_SHIFT () {0;}' unless defined(&JME_TD_RETRY_CNT_SHIFT);
    eval 'sub JME_RD_OWN () {0x80000000;}' unless defined(&JME_RD_OWN);
    eval 'sub JME_RD_INTR () {0x40000000;}' unless defined(&JME_RD_INTR);
    eval 'sub JME_RD_64BIT () {0x20000000;}' unless defined(&JME_RD_64BIT);
    eval 'sub JME_RD_BUF_LEN_MASK () {0xffff;}' unless defined(&JME_RD_BUF_LEN_MASK);
    eval 'sub JME_RD_BUF_LEN_SHIFT () {0;}' unless defined(&JME_RD_BUF_LEN_SHIFT);
    eval 'sub JME_RD_MORE_FRAG () {0x20000000;}' unless defined(&JME_RD_MORE_FRAG);
    eval 'sub JME_RD_TCP () {0x10000000;}' unless defined(&JME_RD_TCP);
    eval 'sub JME_RD_UDP () {0x8000000;}' unless defined(&JME_RD_UDP);
    eval 'sub JME_RD_IPCSUM () {0x4000000;}' unless defined(&JME_RD_IPCSUM);
    eval 'sub JME_RD_TCPCSUM () {0x2000000;}' unless defined(&JME_RD_TCPCSUM);
    eval 'sub JME_RD_UDPCSUM () {0x1000000;}' unless defined(&JME_RD_UDPCSUM);
    eval 'sub JME_RD_VLAN_TAG () {0x800000;}' unless defined(&JME_RD_VLAN_TAG);
    eval 'sub JME_RD_IPV4 () {0x400000;}' unless defined(&JME_RD_IPV4);
    eval 'sub JME_RD_IPV6 () {0x200000;}' unless defined(&JME_RD_IPV6);
    eval 'sub JME_RD_PAUSE () {0x100000;}' unless defined(&JME_RD_PAUSE);
    eval 'sub JME_RD_MAGIC () {0x80000;}' unless defined(&JME_RD_MAGIC);
    eval 'sub JME_RD_WAKEUP () {0x40000;}' unless defined(&JME_RD_WAKEUP);
    eval 'sub JME_RD_BCAST () {0x30000;}' unless defined(&JME_RD_BCAST);
    eval 'sub JME_RD_MCAST () {0x20000;}' unless defined(&JME_RD_MCAST);
    eval 'sub JME_RD_UCAST () {0x10000;}' unless defined(&JME_RD_UCAST);
    eval 'sub JME_RD_VLAN_MASK () {0xffff;}' unless defined(&JME_RD_VLAN_MASK);
    eval 'sub JME_RD_VLAN_SHIFT () {0;}' unless defined(&JME_RD_VLAN_SHIFT);
    eval 'sub JME_RD_VALID () {0x80000000;}' unless defined(&JME_RD_VALID);
    eval 'sub JME_RD_CNT_MASK () {0x7f000000;}' unless defined(&JME_RD_CNT_MASK);
    eval 'sub JME_RD_CNT_SHIFT () {24;}' unless defined(&JME_RD_CNT_SHIFT);
    eval 'sub JME_RD_GIANT () {0x800000;}' unless defined(&JME_RD_GIANT);
    eval 'sub JME_RD_GMII_ERR () {0x400000;}' unless defined(&JME_RD_GMII_ERR);
    eval 'sub JME_RD_NBL_RCVD () {0x200000;}' unless defined(&JME_RD_NBL_RCVD);
    eval 'sub JME_RD_COLL () {0x100000;}' unless defined(&JME_RD_COLL);
    eval 'sub JME_RD_ABORT () {0x80000;}' unless defined(&JME_RD_ABORT);
    eval 'sub JME_RD_RUNT () {0x40000;}' unless defined(&JME_RD_RUNT);
    eval 'sub JME_RD_FIFO_OVRN () {0x20000;}' unless defined(&JME_RD_FIFO_OVRN);
    eval 'sub JME_RD_CRC_ERR () {0x10000;}' unless defined(&JME_RD_CRC_ERR);
    eval 'sub JME_RD_FRAME_LEN_MASK () {0xffff;}' unless defined(&JME_RD_FRAME_LEN_MASK);
    eval 'sub JME_RX_ERR_STAT () {( &JME_RD_GIANT |  &JME_RD_GMII_ERR |  &JME_RD_NBL_RCVD |  &JME_RD_COLL |  &JME_RD_ABORT |  &JME_RD_RUNT |  &JME_RD_FIFO_OVRN |  &JME_RD_CRC_ERR);}' unless defined(&JME_RX_ERR_STAT);
    eval 'sub JME_RD_ERR_MASK () {0xff0000;}' unless defined(&JME_RD_ERR_MASK);
    eval 'sub JME_RD_ERR_SHIFT () {16;}' unless defined(&JME_RD_ERR_SHIFT);
    eval 'sub JME_RX_ERR {
        my($x) = @_;
	    eval q(((($x) &  &JME_RD_ERR_MASK) >>  &JME_RD_ERR_SHIFT));
    }' unless defined(&JME_RX_ERR);
    eval 'sub JME_RX_ERR_BITS () {"\\20" "\\1CRCERR\\2FIFOOVRN\\3RUNT\\4ABORT" "\\5COLL\\6NBLRCVD\\7GMIIERR\\10";}' unless defined(&JME_RX_ERR_BITS);
    eval 'sub JME_RX_NSEGS {
        my($x) = @_;
	    eval q(((($x) &  &JME_RD_CNT_MASK) >>  &JME_RD_CNT_SHIFT));
    }' unless defined(&JME_RX_NSEGS);
    eval 'sub JME_RX_BYTES {
        my($x) = @_;
	    eval q((($x) &  &JME_RD_FRAME_LEN_MASK));
    }' unless defined(&JME_RX_BYTES);
    eval 'sub JME_RX_PAD_BYTES () {10;}' unless defined(&JME_RX_PAD_BYTES);
    eval 'sub JME_RD_RSS_HASH_VALUE () {0xffffffff;}' unless defined(&JME_RD_RSS_HASH_VALUE);
    eval 'sub JME_RD_RSS_HASH_MASK () {0x3f00;}' unless defined(&JME_RD_RSS_HASH_MASK);
    eval 'sub JME_RD_RSS_HASH_SHIFT () {8;}' unless defined(&JME_RD_RSS_HASH_SHIFT);
    eval 'sub JME_RD_RSS_HASH_NONE () {0x;}' unless defined(&JME_RD_RSS_HASH_NONE);
    eval 'sub JME_RD_RSS_HASH_IPV4 () {0x100;}' unless defined(&JME_RD_RSS_HASH_IPV4);
    eval 'sub JME_RD_RSS_HASH_IPV4TCP () {0x200;}' unless defined(&JME_RD_RSS_HASH_IPV4TCP);
    eval 'sub JME_RD_RSS_HASH_IPV6 () {0x400;}' unless defined(&JME_RD_RSS_HASH_IPV6);
    eval 'sub JME_RD_RSS_HASH_IPV6TCP () {0x1000;}' unless defined(&JME_RD_RSS_HASH_IPV6TCP);
    eval 'sub JME_RD_HASH_FN_NONE () {0x;}' unless defined(&JME_RD_HASH_FN_NONE);
    eval 'sub JME_RD_HASH_FN_TOEPLITZ () {0x1;}' unless defined(&JME_RD_HASH_FN_TOEPLITZ);
}
1;
