require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&RT2661_TX_RING_COUNT)) {
    sub RT2661_TX_RING_COUNT () {	32;}
}
unless(defined(&RT2661_MGT_RING_COUNT)) {
    sub RT2661_MGT_RING_COUNT () {	32;}
}
unless(defined(&RT2661_RX_RING_COUNT)) {
    sub RT2661_RX_RING_COUNT () {	64;}
}
unless(defined(&RT2661_TX_DESC_SIZE)) {
    sub RT2661_TX_DESC_SIZE () {	($sizeof{'struct rt2661_tx_desc'});}
}
unless(defined(&RT2661_TX_DESC_WSIZE)) {
    sub RT2661_TX_DESC_WSIZE () {	( &RT2661_TX_DESC_SIZE / 4);}
}
unless(defined(&RT2661_RX_DESC_SIZE)) {
    sub RT2661_RX_DESC_SIZE () {	($sizeof{'struct rt2661_rx_desc'});}
}
unless(defined(&RT2661_RX_DESC_WSIZE)) {
    sub RT2661_RX_DESC_WSIZE () {	( &RT2661_RX_DESC_SIZE / 4);}
}
unless(defined(&RT2661_MAX_SCATTER)) {
    sub RT2661_MAX_SCATTER () {	5;}
}
unless(defined(&RT2661_HOST_CMD_CSR)) {
    sub RT2661_HOST_CMD_CSR () {	0x8;}
}
unless(defined(&RT2661_MCU_CNTL_CSR)) {
    sub RT2661_MCU_CNTL_CSR () {	0xc;}
}
unless(defined(&RT2661_SOFT_RESET_CSR)) {
    sub RT2661_SOFT_RESET_CSR () {	0x10;}
}
unless(defined(&RT2661_MCU_INT_SOURCE_CSR)) {
    sub RT2661_MCU_INT_SOURCE_CSR () {	0x14;}
}
unless(defined(&RT2661_MCU_INT_MASK_CSR)) {
    sub RT2661_MCU_INT_MASK_CSR () {	0x18;}
}
unless(defined(&RT2661_PCI_USEC_CSR)) {
    sub RT2661_PCI_USEC_CSR () {	0x1c;}
}
unless(defined(&RT2661_H2M_MAILBOX_CSR)) {
    sub RT2661_H2M_MAILBOX_CSR () {	0x2100;}
}
unless(defined(&RT2661_M2H_CMD_DONE_CSR)) {
    sub RT2661_M2H_CMD_DONE_CSR () {	0x2104;}
}
unless(defined(&RT2661_HW_BEACON_BASE0)) {
    sub RT2661_HW_BEACON_BASE0 () {	0x2c00;}
}
unless(defined(&RT2661_MAC_CSR0)) {
    sub RT2661_MAC_CSR0 () {	0x3000;}
}
unless(defined(&RT2661_MAC_CSR1)) {
    sub RT2661_MAC_CSR1 () {	0x3004;}
}
unless(defined(&RT2661_MAC_CSR2)) {
    sub RT2661_MAC_CSR2 () {	0x3008;}
}
unless(defined(&RT2661_MAC_CSR3)) {
    sub RT2661_MAC_CSR3 () {	0x300c;}
}
unless(defined(&RT2661_MAC_CSR4)) {
    sub RT2661_MAC_CSR4 () {	0x3010;}
}
unless(defined(&RT2661_MAC_CSR5)) {
    sub RT2661_MAC_CSR5 () {	0x3014;}
}
unless(defined(&RT2661_MAC_CSR6)) {
    sub RT2661_MAC_CSR6 () {	0x3018;}
}
unless(defined(&RT2661_MAC_CSR7)) {
    sub RT2661_MAC_CSR7 () {	0x301c;}
}
unless(defined(&RT2661_MAC_CSR8)) {
    sub RT2661_MAC_CSR8 () {	0x3020;}
}
unless(defined(&RT2661_MAC_CSR9)) {
    sub RT2661_MAC_CSR9 () {	0x3024;}
}
unless(defined(&RT2661_MAC_CSR10)) {
    sub RT2661_MAC_CSR10 () {	0x3028;}
}
unless(defined(&RT2661_MAC_CSR11)) {
    sub RT2661_MAC_CSR11 () {	0x302c;}
}
unless(defined(&RT2661_MAC_CSR12)) {
    sub RT2661_MAC_CSR12 () {	0x3030;}
}
unless(defined(&RT2661_MAC_CSR13)) {
    sub RT2661_MAC_CSR13 () {	0x3034;}
}
unless(defined(&RT2661_MAC_CSR14)) {
    sub RT2661_MAC_CSR14 () {	0x3038;}
}
unless(defined(&RT2661_MAC_CSR15)) {
    sub RT2661_MAC_CSR15 () {	0x303c;}
}
unless(defined(&RT2661_TXRX_CSR0)) {
    sub RT2661_TXRX_CSR0 () {	0x3040;}
}
unless(defined(&RT2661_TXRX_CSR1)) {
    sub RT2661_TXRX_CSR1 () {	0x3044;}
}
unless(defined(&RT2661_TXRX_CSR2)) {
    sub RT2661_TXRX_CSR2 () {	0x3048;}
}
unless(defined(&RT2661_TXRX_CSR3)) {
    sub RT2661_TXRX_CSR3 () {	0x304c;}
}
unless(defined(&RT2661_TXRX_CSR4)) {
    sub RT2661_TXRX_CSR4 () {	0x3050;}
}
unless(defined(&RT2661_TXRX_CSR5)) {
    sub RT2661_TXRX_CSR5 () {	0x3054;}
}
unless(defined(&RT2661_TXRX_CSR6)) {
    sub RT2661_TXRX_CSR6 () {	0x3058;}
}
unless(defined(&RT2661_TXRX_CSR7)) {
    sub RT2661_TXRX_CSR7 () {	0x305c;}
}
unless(defined(&RT2661_TXRX_CSR8)) {
    sub RT2661_TXRX_CSR8 () {	0x3060;}
}
unless(defined(&RT2661_TXRX_CSR9)) {
    sub RT2661_TXRX_CSR9 () {	0x3064;}
}
unless(defined(&RT2661_TXRX_CSR10)) {
    sub RT2661_TXRX_CSR10 () {	0x3068;}
}
unless(defined(&RT2661_TXRX_CSR11)) {
    sub RT2661_TXRX_CSR11 () {	0x306c;}
}
unless(defined(&RT2661_TXRX_CSR12)) {
    sub RT2661_TXRX_CSR12 () {	0x3070;}
}
unless(defined(&RT2661_TXRX_CSR13)) {
    sub RT2661_TXRX_CSR13 () {	0x3074;}
}
unless(defined(&RT2661_TXRX_CSR14)) {
    sub RT2661_TXRX_CSR14 () {	0x3078;}
}
unless(defined(&RT2661_TXRX_CSR15)) {
    sub RT2661_TXRX_CSR15 () {	0x307c;}
}
unless(defined(&RT2661_PHY_CSR0)) {
    sub RT2661_PHY_CSR0 () {	0x3080;}
}
unless(defined(&RT2661_PHY_CSR1)) {
    sub RT2661_PHY_CSR1 () {	0x3084;}
}
unless(defined(&RT2661_PHY_CSR2)) {
    sub RT2661_PHY_CSR2 () {	0x3088;}
}
unless(defined(&RT2661_PHY_CSR3)) {
    sub RT2661_PHY_CSR3 () {	0x308c;}
}
unless(defined(&RT2661_PHY_CSR4)) {
    sub RT2661_PHY_CSR4 () {	0x3090;}
}
unless(defined(&RT2661_PHY_CSR5)) {
    sub RT2661_PHY_CSR5 () {	0x3094;}
}
unless(defined(&RT2661_PHY_CSR6)) {
    sub RT2661_PHY_CSR6 () {	0x3098;}
}
unless(defined(&RT2661_PHY_CSR7)) {
    sub RT2661_PHY_CSR7 () {	0x309c;}
}
unless(defined(&RT2661_SEC_CSR0)) {
    sub RT2661_SEC_CSR0 () {	0x30a0;}
}
unless(defined(&RT2661_SEC_CSR1)) {
    sub RT2661_SEC_CSR1 () {	0x30a4;}
}
unless(defined(&RT2661_SEC_CSR2)) {
    sub RT2661_SEC_CSR2 () {	0x30a8;}
}
unless(defined(&RT2661_SEC_CSR3)) {
    sub RT2661_SEC_CSR3 () {	0x30ac;}
}
unless(defined(&RT2661_SEC_CSR4)) {
    sub RT2661_SEC_CSR4 () {	0x30b0;}
}
unless(defined(&RT2661_SEC_CSR5)) {
    sub RT2661_SEC_CSR5 () {	0x30b4;}
}
unless(defined(&RT2661_STA_CSR0)) {
    sub RT2661_STA_CSR0 () {	0x30c0;}
}
unless(defined(&RT2661_STA_CSR1)) {
    sub RT2661_STA_CSR1 () {	0x30c4;}
}
unless(defined(&RT2661_STA_CSR2)) {
    sub RT2661_STA_CSR2 () {	0x30c8;}
}
unless(defined(&RT2661_STA_CSR3)) {
    sub RT2661_STA_CSR3 () {	0x30cc;}
}
unless(defined(&RT2661_STA_CSR4)) {
    sub RT2661_STA_CSR4 () {	0x30d0;}
}
unless(defined(&RT2661_AC0_BASE_CSR)) {
    sub RT2661_AC0_BASE_CSR () {	0x3400;}
}
unless(defined(&RT2661_AC1_BASE_CSR)) {
    sub RT2661_AC1_BASE_CSR () {	0x3404;}
}
unless(defined(&RT2661_AC2_BASE_CSR)) {
    sub RT2661_AC2_BASE_CSR () {	0x3408;}
}
unless(defined(&RT2661_AC3_BASE_CSR)) {
    sub RT2661_AC3_BASE_CSR () {	0x340c;}
}
unless(defined(&RT2661_MGT_BASE_CSR)) {
    sub RT2661_MGT_BASE_CSR () {	0x3410;}
}
unless(defined(&RT2661_TX_RING_CSR0)) {
    sub RT2661_TX_RING_CSR0 () {	0x3418;}
}
unless(defined(&RT2661_TX_RING_CSR1)) {
    sub RT2661_TX_RING_CSR1 () {	0x341c;}
}
unless(defined(&RT2661_AIFSN_CSR)) {
    sub RT2661_AIFSN_CSR () {	0x3420;}
}
unless(defined(&RT2661_CWMIN_CSR)) {
    sub RT2661_CWMIN_CSR () {	0x3424;}
}
unless(defined(&RT2661_CWMAX_CSR)) {
    sub RT2661_CWMAX_CSR () {	0x3428;}
}
unless(defined(&RT2661_TX_DMA_DST_CSR)) {
    sub RT2661_TX_DMA_DST_CSR () {	0x342c;}
}
unless(defined(&RT2661_TX_CNTL_CSR)) {
    sub RT2661_TX_CNTL_CSR () {	0x3430;}
}
unless(defined(&RT2661_LOAD_TX_RING_CSR)) {
    sub RT2661_LOAD_TX_RING_CSR () {	0x3434;}
}
unless(defined(&RT2661_RX_BASE_CSR)) {
    sub RT2661_RX_BASE_CSR () {	0x3450;}
}
unless(defined(&RT2661_RX_RING_CSR)) {
    sub RT2661_RX_RING_CSR () {	0x3454;}
}
unless(defined(&RT2661_RX_CNTL_CSR)) {
    sub RT2661_RX_CNTL_CSR () {	0x3458;}
}
unless(defined(&RT2661_PCI_CFG_CSR)) {
    sub RT2661_PCI_CFG_CSR () {	0x3460;}
}
unless(defined(&RT2661_INT_SOURCE_CSR)) {
    sub RT2661_INT_SOURCE_CSR () {	0x3468;}
}
unless(defined(&RT2661_INT_MASK_CSR)) {
    sub RT2661_INT_MASK_CSR () {	0x346c;}
}
unless(defined(&RT2661_E2PROM_CSR)) {
    sub RT2661_E2PROM_CSR () {	0x3470;}
}
unless(defined(&RT2661_AC_TXOP_CSR0)) {
    sub RT2661_AC_TXOP_CSR0 () {	0x3474;}
}
unless(defined(&RT2661_AC_TXOP_CSR1)) {
    sub RT2661_AC_TXOP_CSR1 () {	0x3478;}
}
unless(defined(&RT2661_TEST_MODE_CSR)) {
    sub RT2661_TEST_MODE_CSR () {	0x3484;}
}
unless(defined(&RT2661_IO_CNTL_CSR)) {
    sub RT2661_IO_CNTL_CSR () {	0x3498;}
}
unless(defined(&RT2661_MCU_CODE_BASE)) {
    sub RT2661_MCU_CODE_BASE () {	0x4000;}
}
unless(defined(&RT2661_KICK_CMD)) {
    sub RT2661_KICK_CMD () {	(1<< 7);}
}
unless(defined(&RT2661_MCU_CMD_SLEEP)) {
    sub RT2661_MCU_CMD_SLEEP () {	0x30;}
}
unless(defined(&RT2661_MCU_CMD_WAKEUP)) {
    sub RT2661_MCU_CMD_WAKEUP () {	0x31;}
}
unless(defined(&RT2661_MCU_SET_LED)) {
    sub RT2661_MCU_SET_LED () {	0x50;}
}
unless(defined(&RT2661_MCU_SET_RSSI_LED)) {
    sub RT2661_MCU_SET_RSSI_LED () {	0x52;}
}
unless(defined(&RT2661_MCU_SEL)) {
    sub RT2661_MCU_SEL () {	(1<< 0);}
}
unless(defined(&RT2661_MCU_RESET)) {
    sub RT2661_MCU_RESET () {	(1<< 1);}
}
unless(defined(&RT2661_MCU_READY)) {
    sub RT2661_MCU_READY () {	(1<< 2);}
}
unless(defined(&RT2661_MCU_CMD_DONE)) {
    sub RT2661_MCU_CMD_DONE () {	0xff;}
}
unless(defined(&RT2661_MCU_WAKEUP)) {
    sub RT2661_MCU_WAKEUP () {	(1<< 8);}
}
unless(defined(&RT2661_MCU_BEACON_EXPIRE)) {
    sub RT2661_MCU_BEACON_EXPIRE () {	(1<< 9);}
}
unless(defined(&RT2661_H2M_BUSY)) {
    sub RT2661_H2M_BUSY () {	(1<< 24);}
}
unless(defined(&RT2661_TOKEN_NO_INTR)) {
    sub RT2661_TOKEN_NO_INTR () {	0xff;}
}
unless(defined(&RT2661_ONE_BSSID)) {
    sub RT2661_ONE_BSSID () {	3;}
}
unless(defined(&RT2661_AUTO_TX_SEQ)) {
    sub RT2661_AUTO_TX_SEQ () {	(1<< 15);}
}
unless(defined(&RT2661_DISABLE_RX)) {
    sub RT2661_DISABLE_RX () {	(1<< 16);}
}
unless(defined(&RT2661_DROP_CRC_ERROR)) {
    sub RT2661_DROP_CRC_ERROR () {	(1<< 17);}
}
unless(defined(&RT2661_DROP_PHY_ERROR)) {
    sub RT2661_DROP_PHY_ERROR () {	(1<< 18);}
}
unless(defined(&RT2661_DROP_CTL)) {
    sub RT2661_DROP_CTL () {	(1<< 19);}
}
unless(defined(&RT2661_DROP_NOT_TO_ME)) {
    sub RT2661_DROP_NOT_TO_ME () {	(1<< 20);}
}
unless(defined(&RT2661_DROP_TODS)) {
    sub RT2661_DROP_TODS () {	(1<< 21);}
}
unless(defined(&RT2661_DROP_VER_ERROR)) {
    sub RT2661_DROP_VER_ERROR () {	(1<< 22);}
}
unless(defined(&RT2661_DROP_MULTICAST)) {
    sub RT2661_DROP_MULTICAST () {	(1<< 23);}
}
unless(defined(&RT2661_DROP_BROADCAST)) {
    sub RT2661_DROP_BROADCAST () {	(1<< 24);}
}
unless(defined(&RT2661_DROP_ACKCTS)) {
    sub RT2661_DROP_ACKCTS () {	(1<< 25);}
}
unless(defined(&RT2661_SHORT_PREAMBLE)) {
    sub RT2661_SHORT_PREAMBLE () {	(1<< 18);}
}
unless(defined(&RT2661_MRR_ENABLED)) {
    sub RT2661_MRR_ENABLED () {	(1<< 19);}
}
unless(defined(&RT2661_MRR_CCK_FALLBACK)) {
    sub RT2661_MRR_CCK_FALLBACK () {	(1<< 22);}
}
unless(defined(&RT2661_TSF_TICKING)) {
    sub RT2661_TSF_TICKING () {	(1<< 16);}
}
unless(defined(&RT2661_TSF_MODE)) {
    sub RT2661_TSF_MODE {
	my($x) = @_;
	eval q(((($x) & 0x3) << 17));
    }
}
unless(defined(&RT2661_ENABLE_TBTT)) {
    sub RT2661_ENABLE_TBTT () {	(1<< 19);}
}
unless(defined(&RT2661_GENERATE_BEACON)) {
    sub RT2661_GENERATE_BEACON () {	(1<< 20);}
}
unless(defined(&RT2661_PA_PE_2GHZ)) {
    sub RT2661_PA_PE_2GHZ () {	(1<< 16);}
}
unless(defined(&RT2661_PA_PE_5GHZ)) {
    sub RT2661_PA_PE_5GHZ () {	(1<< 17);}
}
unless(defined(&RT2661_BBP_READ)) {
    sub RT2661_BBP_READ () {	(1<< 15);}
}
unless(defined(&RT2661_BBP_BUSY)) {
    sub RT2661_BBP_BUSY () {	(1<< 16);}
}
unless(defined(&RT2661_RF_21BIT)) {
    sub RT2661_RF_21BIT () {	(21<< 24);}
}
unless(defined(&RT2661_RF_BUSY)) {
    sub RT2661_RF_BUSY () {	(1<< 31);}
}
unless(defined(&RT2661_TX_STAT_VALID)) {
    sub RT2661_TX_STAT_VALID () {	(1<< 0);}
}
unless(defined(&RT2661_TX_RESULT)) {
    sub RT2661_TX_RESULT {
	my($v) = @_;
	eval q(((($v) >> 1) & 0x7));
    }
}
unless(defined(&RT2661_TX_RETRYCNT)) {
    sub RT2661_TX_RETRYCNT {
	my($v) = @_;
	eval q(((($v) >> 4) & 0xf));
    }
}
unless(defined(&RT2661_TX_QID)) {
    sub RT2661_TX_QID {
	my($v) = @_;
	eval q(((($v) >> 8) & 0xf));
    }
}
unless(defined(&RT2661_TX_SUCCESS)) {
    sub RT2661_TX_SUCCESS () {	0;}
}
unless(defined(&RT2661_TX_RETRY_FAIL)) {
    sub RT2661_TX_RETRY_FAIL () {	6;}
}
unless(defined(&RT2661_KICK_MGT)) {
    sub RT2661_KICK_MGT () {	(1<< 4);}
}
unless(defined(&RT2661_TX_DONE)) {
    sub RT2661_TX_DONE () {	(1<< 0);}
}
unless(defined(&RT2661_RX_DONE)) {
    sub RT2661_RX_DONE () {	(1<< 1);}
}
unless(defined(&RT2661_TX0_DMA_DONE)) {
    sub RT2661_TX0_DMA_DONE () {	(1<< 16);}
}
unless(defined(&RT2661_TX1_DMA_DONE)) {
    sub RT2661_TX1_DMA_DONE () {	(1<< 17);}
}
unless(defined(&RT2661_TX2_DMA_DONE)) {
    sub RT2661_TX2_DMA_DONE () {	(1<< 18);}
}
unless(defined(&RT2661_TX3_DMA_DONE)) {
    sub RT2661_TX3_DMA_DONE () {	(1<< 19);}
}
unless(defined(&RT2661_MGT_DONE)) {
    sub RT2661_MGT_DONE () {	(1<< 20);}
}
unless(defined(&RT2661_C)) {
    sub RT2661_C () {	(1<< 1);}
}
unless(defined(&RT2661_S)) {
    sub RT2661_S () {	(1<< 2);}
}
unless(defined(&RT2661_D)) {
    sub RT2661_D () {	(1<< 3);}
}
unless(defined(&RT2661_Q)) {
    sub RT2661_Q () {	(1<< 4);}
}
unless(defined(&RT2661_93C46)) {
    sub RT2661_93C46 () {	(1<< 5);}
}
unless(defined(&RT2661_TX_BUSY)) {
    sub RT2661_TX_BUSY () {	(1<< 0);}
}
unless(defined(&RT2661_TX_VALID)) {
    sub RT2661_TX_VALID () {	(1<< 1);}
}
unless(defined(&RT2661_TX_MORE_FRAG)) {
    sub RT2661_TX_MORE_FRAG () {	(1<< 2);}
}
unless(defined(&RT2661_TX_NEED_ACK)) {
    sub RT2661_TX_NEED_ACK () {	(1<< 3);}
}
unless(defined(&RT2661_TX_TIMESTAMP)) {
    sub RT2661_TX_TIMESTAMP () {	(1<< 4);}
}
unless(defined(&RT2661_TX_OFDM)) {
    sub RT2661_TX_OFDM () {	(1<< 5);}
}
unless(defined(&RT2661_TX_IFS_SIFS)) {
    sub RT2661_TX_IFS_SIFS () {	(1<< 6);}
}
unless(defined(&RT2661_TX_LONG_RETRY)) {
    sub RT2661_TX_LONG_RETRY () {	(1<< 7);}
}
unless(defined(&RT2661_TX_BURST)) {
    sub RT2661_TX_BURST () {	(1<< 28);}
}
unless(defined(&RT2661_QID)) {
    sub RT2661_QID {
	my($v) = @_;
	eval q(($v));
    }
}
unless(defined(&RT2661_AIFSN)) {
    sub RT2661_AIFSN {
	my($v) = @_;
	eval q((($v) << 4));
    }
}
unless(defined(&RT2661_LOGCWMIN)) {
    sub RT2661_LOGCWMIN {
	my($v) = @_;
	eval q((($v) << 8));
    }
}
unless(defined(&RT2661_LOGCWMAX)) {
    sub RT2661_LOGCWMAX {
	my($v) = @_;
	eval q((($v) << 12));
    }
}
unless(defined(&RT2661_TX_HWSEQ)) {
    sub RT2661_TX_HWSEQ () {	(1<< 12);}
}
unless(defined(&RT2661_PLCP_LENGEXT)) {
    sub RT2661_PLCP_LENGEXT () {	0x80;}
}
unless(defined(&RT2661_QID_MGT)) {
    sub RT2661_QID_MGT () {	13;}
}
unless(defined(&RT2661_DEFAULT_TXPOWER)) {
    sub RT2661_DEFAULT_TXPOWER () {	0;}
}
unless(defined(&RT2661_RX_BUSY)) {
    sub RT2661_RX_BUSY () {	(1<< 0);}
}
unless(defined(&RT2661_RX_DROP)) {
    sub RT2661_RX_DROP () {	(1<< 1);}
}
unless(defined(&RT2661_RX_CRC_ERROR)) {
    sub RT2661_RX_CRC_ERROR () {	(1<< 6);}
}
unless(defined(&RT2661_RX_OFDM)) {
    sub RT2661_RX_OFDM () {	(1<< 7);}
}
unless(defined(&RT2661_RX_PHY_ERROR)) {
    sub RT2661_RX_PHY_ERROR () {	(1<< 8);}
}
unless(defined(&RT2661_RX_CIPHER_MASK)) {
    sub RT2661_RX_CIPHER_MASK () {	0x600;}
}
unless(defined(&RAL_RF1)) {
    sub RAL_RF1 () {	0;}
}
unless(defined(&RAL_RF2)) {
    sub RAL_RF2 () {	2;}
}
unless(defined(&RAL_RF3)) {
    sub RAL_RF3 () {	1;}
}
unless(defined(&RAL_RF4)) {
    sub RAL_RF4 () {	3;}
}
unless(defined(&RT2661_RF_5225)) {
    sub RT2661_RF_5225 () {	1;}
}
unless(defined(&RT2661_RF_5325)) {
    sub RT2661_RF_5325 () {	2;}
}
unless(defined(&RT2661_RF_2527)) {
    sub RT2661_RF_2527 () {	3;}
}
unless(defined(&RT2661_RF_2529)) {
    sub RT2661_RF_2529 () {	4;}
}
unless(defined(&RT2661_RX_DESC_BACK)) {
    sub RT2661_RX_DESC_BACK () {	4;}
}
unless(defined(&RT2661_SMART_MODE)) {
    sub RT2661_SMART_MODE () {	(1<< 0);}
}
unless(defined(&RT2661_BBPR94_DEFAULT)) {
    sub RT2661_BBPR94_DEFAULT () {	6;}
}
unless(defined(&RT2661_SHIFT_D)) {
    sub RT2661_SHIFT_D () {	3;}
}
unless(defined(&RT2661_SHIFT_Q)) {
    sub RT2661_SHIFT_Q () {	4;}
}
unless(defined(&RT2661_EEPROM_MAC01)) {
    sub RT2661_EEPROM_MAC01 () {	0x2;}
}
unless(defined(&RT2661_EEPROM_MAC23)) {
    sub RT2661_EEPROM_MAC23 () {	0x3;}
}
unless(defined(&RT2661_EEPROM_MAC45)) {
    sub RT2661_EEPROM_MAC45 () {	0x4;}
}
unless(defined(&RT2661_EEPROM_ANTENNA)) {
    sub RT2661_EEPROM_ANTENNA () {	0x10;}
}
unless(defined(&RT2661_EEPROM_CONFIG2)) {
    sub RT2661_EEPROM_CONFIG2 () {	0x11;}
}
unless(defined(&RT2661_EEPROM_BBP_BASE)) {
    sub RT2661_EEPROM_BBP_BASE () {	0x13;}
}
unless(defined(&RT2661_EEPROM_TXPOWER)) {
    sub RT2661_EEPROM_TXPOWER () {	0x23;}
}
unless(defined(&RT2661_EEPROM_FREQ_OFFSET)) {
    sub RT2661_EEPROM_FREQ_OFFSET () {	0x2f;}
}
unless(defined(&RT2661_EEPROM_RSSI_2GHZ_OFFSET)) {
    sub RT2661_EEPROM_RSSI_2GHZ_OFFSET () {	0x4d;}
}
unless(defined(&RT2661_EEPROM_RSSI_5GHZ_OFFSET)) {
    sub RT2661_EEPROM_RSSI_5GHZ_OFFSET () {	0x4e;}
}
unless(defined(&RT2661_EEPROM_DELAY)) {
    sub RT2661_EEPROM_DELAY () {	1;}
}
unless(defined(&RAL_READ)) {
    sub RAL_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&RAL_READ_REGION_4)) {
    sub RAL_READ_REGION_4 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_read_region_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
unless(defined(&RAL_WRITE)) {
    sub RAL_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&RAL_WRITE_1)) {
    sub RAL_WRITE_1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&RAL_RW_BARRIER_1)) {
    sub RAL_RW_BARRIER_1 {
	my($sc, $reg) = @_;
	eval q( &bus_space_barrier(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), 1,  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE));
    }
}
unless(defined(&RAL_WRITE_REGION_1)) {
    sub RAL_WRITE_REGION_1 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_write_region_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
unless(defined(&RT2661_EEPROM_CTL)) {
    sub RT2661_EEPROM_CTL {
	my($sc, $val) = @_;
	eval q( &do {  &RAL_WRITE(($sc),  &RT2661_E2PROM_CSR, ($val));  &DELAY( &RT2661_EEPROM_DELAY); }  &while ( 0));
    }
}
unless(defined(&RT2661_DEF_MAC)) {
    sub RT2661_DEF_MAC () {	{  &RT2661_TXRX_CSR0, 0xb032 }, {  &RT2661_TXRX_CSR1, 0x9eb39eb3 }, {  &RT2661_TXRX_CSR2, 0x8a8b8c8d }, {  &RT2661_TXRX_CSR3, 0x858687 }, {  &RT2661_TXRX_CSR7, 0x2e31353b }, {  &RT2661_TXRX_CSR8, 0x2a2a2a2c }, {  &RT2661_TXRX_CSR15, 0xf }, {  &RT2661_MAC_CSR6, 0xfff }, {  &RT2661_MAC_CSR8, 0x16c030a }, {  &RT2661_MAC_CSR10, 0x718 }, {  &RT2661_MAC_CSR12, 0x4 }, {  &RT2661_MAC_CSR13, 0xe000 }, {  &RT2661_SEC_CSR0, 0x }, {  &RT2661_SEC_CSR1, 0x }, {  &RT2661_SEC_CSR5, 0x }, {  &RT2661_PHY_CSR1, 0x23b0 }, {  &RT2661_PHY_CSR5, 0x60a100c }, {  &RT2661_PHY_CSR6, 0x80606 }, {  &RT2661_PHY_CSR7, 0xa08 }, {  &RT2661_PCI_CFG_CSR, 0x3cca4808 }, {  &RT2661_AIFSN_CSR, 0x2273 }, {  &RT2661_CWMIN_CSR, 0x2344 }, {  &RT2661_CWMAX_CSR, 0x34aa }, {  &RT2661_TEST_MODE_CSR, 0x200 }, {  &RT2661_M2H_CMD_DONE_CSR, 0xffffffff };}
}
unless(defined(&RT2661_DEF_BBP)) {
    sub RT2661_DEF_BBP () {	{ 3, 0x }, { 15, 0x30 }, { 17, 0x20 }, { 21, 0xc8 }, { 22, 0x38 }, { 23, 0x6 }, { 24, 0xfe }, { 25, 0xa }, { 26, 0xd }, { 34, 0x12 }, { 37, 0x7 }, { 39, 0xf8 }, { 41, 0x60 }, { 53, 0x10 }, { 54, 0x18 }, { 60, 0x10 }, { 61, 0x4 }, { 62, 0x4 }, { 75, 0xfe }, { 86, 0xfe }, { 88, 0xfe }, { 90, 0xf }, { 99, 0x }, { 102, 0x16 }, { 107, 0x4 };}
}
unless(defined(&RT2661_RF5225_1)) {
    sub RT2661_RF5225_1 () {	{ 1, 0xb33, 0x11e1, 0x1a014, 0x30282 }, { 2, 0xb33, 0x11e1, 0x1a014, 0x30287 }, { 3, 0xb33, 0x11e2, 0x1a014, 0x30282 }, { 4, 0xb33, 0x11e2, 0x1a014, 0x30287 }, { 5, 0xb33, 0x11e3, 0x1a014, 0x30282 }, { 6, 0xb33, 0x11e3, 0x1a014, 0x30287 }, { 7, 0xb33, 0x11e4, 0x1a014, 0x30282 }, { 8, 0xb33, 0x11e4, 0x1a014, 0x30287 }, { 9, 0xb33, 0x11e5, 0x1a014, 0x30282 }, { 10, 0xb33, 0x11e5, 0x1a014, 0x30287 }, { 11, 0xb33, 0x11e6, 0x1a014, 0x30282 }, { 12, 0xb33, 0x11e6, 0x1a014, 0x30287 }, { 13, 0xb33, 0x11e7, 0x1a014, 0x30282 }, { 14, 0xb33, 0x11e8, 0x1a014, 0x30284 }, { 36, 0xb33, 0x1266, 0x26014, 0x30288 }, { 40, 0xb33, 0x1268, 0x26014, 0x30280 }, { 44, 0xb33, 0x1269, 0x26014, 0x30282 }, { 48, 0xb33, 0x126a, 0x26014, 0x30284 }, { 52, 0xb33, 0x126b, 0x26014, 0x30286 }, { 56, 0xb33, 0x126c, 0x26014, 0x30288 }, { 60, 0xb33, 0x126e, 0x26014, 0x30280 }, { 64, 0xb33, 0x126f, 0x26014, 0x30282 }, { 100, 0xb33, 0x128a, 0x2e014, 0x30280 }, { 104, 0xb33, 0x128b, 0x2e014, 0x30282 }, { 108, 0xb33, 0x128c, 0x2e014, 0x30284 }, { 112, 0xb33, 0x128d, 0x2e014, 0x30286 }, { 116, 0xb33, 0x128e, 0x2e014, 0x30288 }, { 120, 0xb33, 0x12a0, 0x2e014, 0x30280 }, { 124, 0xb33, 0x12a1, 0x2e014, 0x30282 }, { 128, 0xb33, 0x12a2, 0x2e014, 0x30284 }, { 132, 0xb33, 0x12a3, 0x2e014, 0x30286 }, { 136, 0xb33, 0x12a4, 0x2e014, 0x30288 }, { 140, 0xb33, 0x12a6, 0x2e014, 0x30280 }, { 149, 0xb33, 0x12a8, 0x2e014, 0x30287 }, { 153, 0xb33, 0x12a9, 0x2e014, 0x30289 }, { 157, 0xb33, 0x12ab, 0x2e014, 0x30281 }, { 161, 0xb33, 0x12ac, 0x2e014, 0x30283 }, { 165, 0xb33, 0x12ad, 0x2e014, 0x30285 };}
}
unless(defined(&RT2661_RF5225_2)) {
    sub RT2661_RF5225_2 () {	{ 1, 0xb33, 0x11e1, 0x1a014, 0x30282 }, { 2, 0xb33, 0x11e1, 0x1a014, 0x30287 }, { 3, 0xb33, 0x11e2, 0x1a014, 0x30282 }, { 4, 0xb33, 0x11e2, 0x1a014, 0x30287 }, { 5, 0xb33, 0x11e3, 0x1a014, 0x30282 }, { 6, 0xb33, 0x11e3, 0x1a014, 0x30287 }, { 7, 0xb33, 0x11e4, 0x1a014, 0x30282 }, { 8, 0xb33, 0x11e4, 0x1a014, 0x30287 }, { 9, 0xb33, 0x11e5, 0x1a014, 0x30282 }, { 10, 0xb33, 0x11e5, 0x1a014, 0x30287 }, { 11, 0xb33, 0x11e6, 0x1a014, 0x30282 }, { 12, 0xb33, 0x11e6, 0x1a014, 0x30287 }, { 13, 0xb33, 0x11e7, 0x1a014, 0x30282 }, { 14, 0xb33, 0x11e8, 0x1a014, 0x30284 }, { 36, 0xb35, 0x11206, 0x26014, 0x30280 }, { 40, 0xb34, 0x111a0, 0x26014, 0x30280 }, { 44, 0xb34, 0x111a1, 0x26014, 0x30286 }, { 48, 0xb34, 0x111a3, 0x26014, 0x30282 }, { 52, 0xb34, 0x111a4, 0x26014, 0x30288 }, { 56, 0xb34, 0x111a6, 0x26014, 0x30284 }, { 60, 0xb34, 0x111a8, 0x26014, 0x30280 }, { 64, 0xb34, 0x111a9, 0x26014, 0x30286 }, { 100, 0xb35, 0x11226, 0x2e014, 0x30280 }, { 104, 0xb35, 0x11228, 0x2e014, 0x30280 }, { 108, 0xb35, 0x1122a, 0x2e014, 0x30280 }, { 112, 0xb35, 0x1122c, 0x2e014, 0x30280 }, { 116, 0xb35, 0x1122e, 0x2e014, 0x30280 }, { 120, 0xb34, 0x111c0, 0x2e014, 0x30280 }, { 124, 0xb34, 0x111c1, 0x2e014, 0x30286 }, { 128, 0xb34, 0x111c3, 0x2e014, 0x30282 }, { 132, 0xb34, 0x111c4, 0x2e014, 0x30288 }, { 136, 0xb34, 0x111c6, 0x2e014, 0x30284 }, { 140, 0xb34, 0x111c8, 0x2e014, 0x30280 }, { 149, 0xb34, 0x111cb, 0x2e014, 0x30286 }, { 153, 0xb34, 0x111cd, 0x2e014, 0x30282 }, { 157, 0xb35, 0x11242, 0x2e014, 0x30285 }, { 161, 0xb35, 0x11244, 0x2e014, 0x30285 }, { 165, 0xb35, 0x11246, 0x2e014, 0x30285 };}
}
1;
