
#ifndef MANAGER_PLUGIN_H
#define MANAGER_PLUGIN_H

#include <glib.h>
#include <gtk/gtk.h>
#include <gmodule.h>
#include <libxfce4mcs/mcs-manager.h>

/* Xfce4 mcs plugin API version */
#define XFCE_MCS_PLUGIN_VERSION	2

#define SETTINGS_MANAGER_ICON_SIZE 48

#ifdef __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

    typedef enum
    {
        MCS_PLUGIN_INIT_OK,
        MCS_PLUGIN_INIT_ERROR
    }
    McsPluginInitResult;


    typedef struct _McsPlugin McsPlugin;
    typedef void (*run_dialog_hook) (McsPlugin * plugin);
    struct _McsPlugin
    {
        McsManager *manager;
        gchar *plugin_name;
        GdkPixbuf *icon;
        gchar *caption;
        run_dialog_hook run_dialog;
    };

    gchar *mcs_plugin_check_version(gint version);

#define MCS_PLUGIN_CHECK_INIT \
G_MODULE_EXPORT const gchar *g_module_check_init(GModule *gmodule); \
const gchar * \
g_module_check_init(GModule *gmodule) \
{ \
  return mcs_plugin_check_version(XFCE_MCS_PLUGIN_VERSION); \
}

/* prototype for plugin init function (should be implemented by plugin) */
    G_MODULE_EXPORT McsPluginInitResult mcs_plugin_init(McsPlugin * plugin);

#ifdef __cplusplus
}
#endif                          /* __cplusplus */


#endif                          /* MANAGER_PLUGIN_H */
