;;
;; Set up the menu
;;
(add-menu "File")
(add-menu-entry "File" "New" "(new-buffer)")
(add-menu-entry "File" "Open" "(load-buffer)")
(add-menu-entry "File" "Save" "(save-buffer)")
(add-menu-entry "File" "Save As" "(save-buffer-as)")
(add-menu-entry "File" "Preview" "(preview)")
(add-menu-entry "File" "-" "-")
(add-submenu "File" "Backup Copies")
(add-submenu-entry "File" "Backup Copies" "Yes" "(make-backups 1)")
(add-submenu-entry "File" "Backup Copies" "No" "(make-backups 0)")
(add-submenu "File" "Settings")
(add-submenu-entry "File" "Settings" "Margins" "(change-margins nil)")
(add-submenu-entry "File" "Settings" "Paper Size" "(change-paper-size nil)")
(add-submenu-entry "File" "Settings" "Header and Footer" "(change-headfoot nil)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Print" "(print)")
(add-menu-entry "File" "Print Format" "(print-format)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Load External" "(load-external)")
(add-menu-entry "File" "Save External" "(save-external)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Exit" "(quit-program)")

(add-menu "Edit")
;(add-menu-entry "Edit" "Delete" "(delete-char)")
; not particularly useful
;(add-menu-entry "Edit" "Insert Line" "(insert-line)")
;(add-menu-entry "Edit" "Remove Line" "(remove-line)")
(add-menu-entry "Edit" "Select All" "(select-all)")
(add-menu-entry "Edit" "Delete Block" "(delete-block)")
(add-menu-entry "Edit" "-" "-")
;FIXME(add-menu-entry "Edit" "Find" "(search-forward)")
;FIXME(add-menu-entry "Edit" "Find Backward" "(search-backward)")
;FIXME(add-menu-entry "Edit" "Replace" "(query-replace)")
(add-menu-entry "Edit" "Spell" "(spell-buffer)")
(add-menu-entry "Edit" "Special Char" "(ins-special-char)")

; The block is a concept I don't want to use like this in PW
;(add-menu "Block")
;(add-menu-entry "Block" "Set Block" "(set-block)")
;(add-menu-entry "Block" "Set Mark" "(set-mark-command)")
;(add-menu-entry "Block" "Copy Block" "(copy-block)")
;(add-menu-entry "Block" "Delete Block" "(delete-block)")
;(add-menu-entry "Block" "Fill Block" "(fill-block)")

(add-menu "Format")
(add-menu-entry "Format" "Margins" "(change-margins \"\")")
(add-menu-entry "Format" "Paper Size" "(change-paper-size \"\")")
(add-menu-entry "Format" "Header and Footer" "(change-headfoot \"\")")
(add-menu-entry "Format" "First Page Number" "(change-first-page \"\")")
;(add-menu-entry "Format" "Tab Distance" "(change-tab-distance \"\")")
(add-menu-entry "Format" "Edit Tabs" "(edit_tabs)")
(add-menu-entry "Format" "Line Height" "(set-line-height)")
(add-menu-entry "Format" "-" "-")
(add-menu-entry "Format" "Copy" "(copy-current-format)")
(add-menu-entry "Format" "Use" "(use-copied-format)")
(add-menu-entry "Format" "Define Style" "(define-style)")
(add-menu-entry "Format" "Cleanup" "(cleanup-style)")
(add-menu-entry "Format" "Foreground Color" "(new_attribute \"fg\")")
(add-menu-entry "Format" "Background Color" "(new_attribute \"bg\")")

(add-menu "Window")
(add-menu-entry "Window" "Zoom" "(zoom-adjust)")
(add-menu-entry "Window" "Change Buffer" "(switch-to-buffer)")
(add-menu-entry "Window" "Delete Buffer" "(kill-buffer)")
(add-menu-entry "Window" "-" "-")
(add-menu-entry "Window" "Split Window" "(split-window-vertically)")
(add-menu-entry "Window" "Remove Window" "(delete-window)")
(add-menu-entry "Window" "One Window" "(delete-other-windows)")
(add-menu-entry "Window" "Change Window" "(other-window)")
(add-menu-entry "Window" "-" "-")
(add-menu-entry "Window" "Add Sheet" "(add-sheet)")
(add-menu-entry "Window" "Remove Sheet" "(remove-sheet)")
(add-menu-entry "Window" "Rename Sheet" "(rename-sheet)")
(add-submenu "Window" "Move Sheet")
(add-submenu-entry "Window" "Move Sheet" "Up" "(move-sheet-up)")
(add-submenu-entry "Window" "Move Sheet" "Down" "(move-sheet-down)")
(add-submenu-entry "Window" "Move Sheet" "Top" "(move-sheet-top)")
(add-submenu-entry "Window" "Move Sheet" "Bottom" "(move-sheet-bottom)")

(add-menu-entry "Window" "-" "-")
(add-submenu "Window" "Go To")
(add-submenu-entry "Window" "Go To" "Line in buffer" "(goto-line)")
(add-submenu-entry "Window" "Go To" "Beginning of buffer" "(beginning-of-buffer)")
(add-submenu-entry "Window" "Go To" "End of buffer" "(end-of-buffer)")
(add-submenu-entry "Window" "Go To" "Beginning of paragraph" "(beginning-of-paragraph)")
(add-submenu-entry "Window" "Go To" "End of paragraph" "(end-of-paragraph)")

(define (tooltip-set m)
  (set! *tooltip-mode* m)
  (tooltip-mode m))
(add-submenu "Window" "Helptexts")
(add-submenu-entry "Window" "Helptexts" "Disable" "(tooltip-set 0)")
(add-submenu-entry "Window" "Helptexts" "Label" "(tooltip-set 1)")
(add-submenu-entry "Window" "Helptexts" "Popup" "(tooltip-set 2)")
(add-submenu-entry "Window" "Helptexts" "Both" "(tooltip-set 3)")

(add-submenu "Window" "Theme")
(add-submenu-entry "Window" "Theme" "Select" "(select_theme)")
(add-submenu-entry "Window" "Theme" "Edit" "(edit_theme)")
(add-submenu-entry "Window" "Theme" "None" "(delete_theme)")

(add-menu-entry "Window" "Save Preferences" "(save-preferences)")

(add-menu "Tools")

(require (string-append datadir "/common/tools.scm"))
(add-menu-entry "Tools" "-" "-")
; These experimental commands don't have to be on the menu
;(add-menu-entry "Tools" "Spell Test" "(spell-test)")
;(add-menu-entry "Tools" "Dump Words" "(dump-words)")
;(add-menu-entry "Tools" "-" "-")
(add-submenu "Tools" "Form Test")
(add-submenu-entry "Tools" "Form Test" "Test 1" "(form-test)")
(add-submenu-entry "Tools" "Form Test" "Test 2" "(form-test2)")
(add-submenu-entry "Tools" "Form Test" "Test 3" "(form-test3)")

(add-menu "Plugin")
(add-menu-entry "Plugin" "Import" "(plugin-import nil)")
(add-menu-entry "Plugin" "Export" "(plugin-export)")
(add-menu-entry "Plugin" "Link" "(plugin-link nil)")
(add-menu-entry "Plugin" "Delete" "(plugin-delete)")
(add-menu-entry "Plugin" "Move" "(plugin-move)")
(add-menu-entry "Plugin" "Resize" "(plugin-resize)")
(add-submenu "Plugin" "App")
(add-submenu-entry "Plugin" "App" "Xclock" "(plugin-import \"xclock.run\")")
(add-submenu-entry "Plugin" "App" "Xterm" "(plugin-import \"xterm.run\")")
(add-submenu-entry "Plugin" "App" "Xload" "(plugin-import \"xload.run\")")
(add-submenu-entry "Plugin" "App" "Siag" "(plugin-import \"PlUgIn.siag\")")
(add-submenu-entry "Plugin" "App" "PW" "(plugin-import \"PlUgIn.pw\")")
(add-submenu-entry "Plugin" "App" "Hello World" "(plugin-import \"x.hello\")")

(add-menu "Help")
(add-menu-entry "Help" "Contents" "(help-contents)")
;(add-menu-entry "Help" "Search" "(help-search)")
(add-menu-entry "Help" "Copying" "(help-copyright)")
(add-menu-entry "Help" "Help for Help" "(help-for-help)")

(add-submenu "Help" "Links")

(define (help-link name url)
  (add-submenu-entry "Help"
		     "Links"
		     name
		     (string-append "(do-link \"" url "\")")))

(help-link "Siag Home" "http://siag.nu/")
(help-link "FTP Directory" "ftp://siag.nu/pub/siag/")

(add-menu-entry "Help" "-" "-")
;(add-menu-entry "Help" "About Pathetic Writer" "(print-version)")
(add-menu-entry "Help" "About Pathetic Writer..." "(aboutbox)")
(add-menu-entry "Help" "About Siag Office..." "(aboutsiag)")

(add-pseudo-menu "Shortcuts")

(add-menu-entry "Shortcuts" "Open" "(load-buffer)")
(add-menu-entry "Shortcuts" "Save" "(save-buffer-as)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Undo" "(undo-restore)")
(add-menu-entry "Shortcuts" "Spell" "(spell-buffer)")
(add-menu-entry "Shortcuts" "Command" "(exec-siod)")
(add-menu-entry "Shortcuts" "-" "-")
(add-submenu "Shortcuts" "Plugin")
(add-submenu-entry "Shortcuts" "Plugin" "Import" "(plugin-import)")
(add-submenu-entry "Shortcuts" "Plugin" "Export" "(plugin-export)")
(add-submenu-entry "Shortcuts" "Plugin" "Link" "(plugin-link)")
(add-submenu-entry "Shortcuts" "Plugin" "Delete" "(plugin-delete)")
(add-submenu-entry "Shortcuts" "Plugin" "Move" "(plugin-move)")
(add-menu-entry "Shortcuts" "Help" "(help-contents)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Quit" "(quit-program)")

