/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/04/24 16:51:08 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pgprogressbar.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.1 $
    Status:           $State: Exp $
*/

#ifndef PG_PROGRESSBAR_H
#define PG_PROGRESSBAR_H

#ifdef SWIG
%include "swigcommon.h"
%module pgprogressbar
%{
#include "pgprogressbar.h"
%}
#endif

#include "pgstaticframe.h"

/**
	@author Alexander Pipelka

	@short A progress bar.

	Displays progress by taking a percentage and sizing the bar appropriately.
*/
/* Perhaps this could be created with a 'max value' attribute (or what 100%
 * actually is) to ease the load on the application coder so he does not have
 * to worry about converting to percent?
 */
class DECLSPEC PG_ProgressBar : public PG_StaticFrame {
public:

	/** */
	PG_ProgressBar(PG_Widget* parent, const PG_Rect& r, const char* style="Progressbar");

	/** */
	~PG_ProgressBar();

	/** */
	void SetProgress(double p);

	void LoadThemeStyle(const char* widgettype);

protected:

	/** */
	void eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst);

	/**
	void eventDraw(SDL_Surface* surface, const PG_Rect& rect);
	*/
private:

	PG_ProgressBar(const PG_ProgressBar&);
	PG_ProgressBar& operator=(const PG_ProgressBar&);

	PG_Gradient my_pbGradient;
	SDL_Surface* my_pbBackground;
	int my_pbBackmode;
	int my_pbBlend;
	SDL_Color my_colorText;
	double my_percentCurrent;

};

#endif // PG_PROGRESSBAR_H

