#TRUSTED 3dc7744317036cd3c505aff539e40de18bfdcd9962112246e39d0f7944d0f00f3a664772cad43d7e109c346b8f18bc3885f60256d4d87060d82840de656da5bb2f19803428a8eb085c2219e7ea85370e69baf1dd386a48b00b47c75076ceb8b58b5ab86e122bfd255435ab94a0a7263b489a46f1459dd5cb1b777656ba27118068dda87954b9143118c991b40d1e61f74720b3198df821fc51a821ad9fe4ce4db1536be33dead15ffb386e5919d416346053c180cb70354739a3e0437e14c0b9d055b8b4e0212860e1b97fbe022390c60caf5ce43d17045af60b101f4399b1f3e236a5dcb5ca077c93a6ff08c41da56670ba30fb52f462b4099274c58c2fb1305097efe877b5dd26f7d0f1de7a64ce20756eef3bddf1430b9ada0916102d20aca04f264f493a6c60d218a609fe9327396879bfc84275bfebc473005cd24ef1c68c91d4a2eda4e5f5952c2903b771f2cac50a974a262ffeaaa3ffd8981270812872d27aead9194b7518f570dad52824f3a8e55b8497d037026f078739c7b22b5fe02ce53e763633071efb18a266b9a5fee8b007b9cee24a36f5c83eeafbc66c178302d028b95b46b24b6b5419d0abd9a219992bfb6be8e297c675b2f487dbcc8f84fd854abd2d5b233707b6d5c4eab2a91a0802e6ad6cd9fbf556cf3c208b746c8e02bbf4fab7398d3bb7cb21a3b04a7072001ee0e1e08ebdb4859b3bf2e515cc
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("pread") ) exit(0);
if ( ! find_in_path("snmpwalk") ) exit(0);


if(description)
{
 script_id(14274);
 script_version ("1.5");
 name["english"] = "snmpwalk 'scanner'";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs snmpwalk against the remote machine to find open ports.
See the section 'plugins options' to configure it

Risk factor : None";

 script_description(english:desc["english"]);
 
 summary["english"] = "Find open ports with snmpwalk";
 script_summary(english:summary["english"]);
 
 script_category(ACT_SCANNER);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "Port scanners";
 family["francais"] = "Scanners de ports";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencies("ping_host.nasl");

if (NASL_LEVEL < 2181) exit(0);	# Cannot run

 script_add_preference(name: "Community name :", type: "entry", value: "public");
 script_add_preference(name: "SNMP protocol :", type: "radio", value: "1;2c");
 script_add_preference(name: "SNMP transport layer :", type: "radio", value: "udp;tcp");
 script_add_preference(name: "TCP/UDP port :", type: "entry", value: "");
 script_add_preference(name: "Number of retries :", type: "entry", value: "");
 script_add_preference(name: "Timeout between retries :", type: "entry", value: "");
 exit(0);
}

#

if (NASL_LEVEL < 2181) exit(0);	# Cannot run

check = 
 (! safe_checks()) ||
 ("yes" >< get_kb_item("global_settings/experimental_scripts_tests")) ||
 ("yes" >< get_preference("unscanned_closed")) ||
 ("yes" >< get_kb_item("global_settings/thorough_tests"));
# ("Avoid false alarms" >< get_kb_item("global_settings/report_paranoia"))

global_var	snmp_layer, argv, snmp_port, snmp_comm;
seen_tcp_ports = make_list(0);	# Do not want to see this!
seen_udp_ports = make_list(0);	# Do not want to see this!

function make_argv(obj)
{
 local_var	i, p;

 i = 0;
 argv = NULL;
 argv[i++] = "snmpwalk";

 p = script_get_preference("SNMP protocol :");
 if (! p) p = "2c";
 argv[i++] = "-v";
 argv[i++] = p;

 snmp_layer = "udp";

 if (! v506)
 {
  p = script_get_preference("SNMP transport layer :");
  if (p)
  {
   argv[i++] = "-T";
   argv[i++] = p;
   snmp_layer = p;
  }
 }

 p = script_get_preference("Number of retries :");
 if (p && p =~ '^[0-9]+$')
 {
  argv[i++] = "-r";
  argv[i++] = p;
 }

 p = script_get_preference("Timeout between retries :");
 if (p && p =~ '^[0-9]+$')
 {
  argv[i++] = "-t";
  argv[i++] = p;
 }

 p = script_get_preference("TCP/UDP port :");
 if (p && p =~ '^[0-9]+$')
 {
  argv[i++] = "-p";
  argv[i++] = p;
  snmp_port = p;
 }

 if (!v506) argv[i++] = ip;

 p = script_get_preference("Community name :");
 if (strlen(p) == 0) p = "public";
 if (v506) argv[i++] = "-c";
 argv[i++] = p;
 snmp_comm = p;

 # Version 5.0.6 orlater: put the hostname *after* the options
 if (v506) argv[i++] = ip;

 argv[i++] = obj;
}


ver = pread(cmd: "snmpwalk", argv: make_list("snmpwalk", "-V"));
if (ereg(string: ver, pattern: "NET-SNMP version: +([6-9]\.|5\.([1-9]|0\.[6-9]))", icase: 1, multiline: 1))
  v506 = 1;
else
  v506 = 0;

ip = get_host_ip();

i = 0;
scanned = 0; udp_scanned = 0;
foreach o (
  make_list("tcp.tcpConnTable.tcpConnEntry.tcpConnLocalPort.0.0.0.0",
            "tcp.tcpConnTable.tcpConnEntry.tcpConnLocalPort." + ip,
            "udp.udpTable.udpEntry.udpLocalPort.0.0.0.0", 
            "udp.udpTable.udpEntry.udpLocalPort." + ip))
{
 scanner_status(current: 0, total: i++);
 make_argv(obj: o);
 buf = pread(cmd: "snmpwalk", argv: argv);
 proto = substr(o, 0, 2);
 if (buf)
 {
  foreach line( split(buf))
  {
   v = eregmatch(pattern: '=[ \t]*([a-zA-Z0-9-]+:)?[ \t]*([0-9]+)[ \t\r\n]*$',
		string: line);
   if (! isnull(v))
   {
    port = v[2];
    if (proto == 'tcp' && ! seen_tcp_ports[port])
    {
     if (check && proto == "tcp")
     {
      soc = open_sock_tcp(port);
      if (soc)
      {
       scanner_add_port(proto: proto, port: port);
       close(soc);
      }
      else
       display("snmpwalk_portscan(", get_host_ip(), "): TCP port ",  port, " is closed in fact\n");
     }
     else
      scanner_add_port(proto: proto, port: port);
     seen_tcp_ports[port] ++;
    scanned ++;
    }
    if (proto == "udp" && ! seen_udp_ports[port])
    {
     scanner_add_port(proto: proto, port: port);
     seen_udp_ports[port] ++;
     udp_scanned ++;
    }
   }
  }
 } 
}

if (scanned)
{
 set_kb_item(name: "Host/scanned", value: TRUE);
 set_kb_item(name: "Host/full_scan", value: TRUE);
 set_kb_item(name: 'Host/scanners/snmpwalk', value: TRUE);
 security_note(port: snmp_port, proto: snmp_layer, 
data: strcat("snmpwalk could get the open port list with the community name ", snmp_comm));
}

if (udp_scanned) set_kb_item(name: "Host/udp_scanned", value: TRUE);

exit(0);

# make_argv(obj: "host.hrSWInstalled.hrSWInstalledTable.hrSWInstalledEntry.hrSWInstalledName");

