/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __libnd_tcp_h
#define __libnd_tcp_h

#include <libnd.h>

#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum {
  LND_TCP_STATE_NONE,
  LND_TCP_STATE_ONCE,         
  LND_TCP_STATE_UPDATE_SINGLE,
  LND_TCP_STATE_UPDATE_ALL,
  LND_TCP_STATE_UNKNOWN
} LND_TCPStateMode;

/* These are the implementations of LND_Protocol's callbacks: */
void       libnd_tcp_init_packet(LND_Packet *packet, guchar *data, guchar *data_end);
gboolean   libnd_tcp_header_complete(const LND_Packet *packet, guint nesting);
gboolean   libnd_tcp_fix_packet(LND_Packet *packet);
void       libnd_tcp_init_state(LND_Trace *trace);
void       libnd_tcp_update_state(const LND_Packet *packet, int index);
void       libnd_tcp_update_tcpdump_line(const LND_Packet *packet, char *line);
void       libnd_tcp_free_state(LND_Trace *trace);

/**
 * libnd_tcp_set_state_mode - sets state keeping modus
 * @mode: new state mode.
 *
 * The function sets the TCP state keeping mode.
 */
void             libnd_tcp_set_state_mode(LND_TCPStateMode mode);
LND_TCPStateMode libnd_tcp_get_state_mode(void);
LND_TCPStateMode libnd_tcp_get_old_state_mode(void);

/* Generic accessor function for the protocol implementation: */
LND_Protocol    *libnd_tcp_get(void);
LND_Protocol    *libnd_tcp_get_ip(void);

gboolean         libnd_tcp_get_headers(const LND_Packet *packet,
				       struct ip **iphdr,
				       struct tcphdr **tcphdr);

guint            libnd_tcp_get_payload_length(struct ip *iphdr, struct tcphdr *tcphdr);

guint16          libnd_tcp_checksum(const LND_Packet *packet);
gboolean         libnd_tcp_csum_correct(const LND_Packet *packet, guint16 *correct_sum);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
