/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_registry_h
#define __libnd_registry_h


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct lnd_registry LND_Registry;

typedef void (*LND_RegCB)(const char *name, void *item, void *user_data);

LND_Registry *              libnd_reg_new(const char *name);
void                        libnd_reg_free(LND_Registry *reg);

void                        libnd_reg_set_data(LND_Registry *reg, const char *key, void *data);
void                       *libnd_reg_get_data(const LND_Registry *reg, const char *key);
void                       *libnd_reg_del_data(LND_Registry *reg, const char *key);

void                        libnd_reg_foreach(const LND_Registry *reg,
					      LND_RegCB callback,
					      void *user_data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
