// -*- c++ -*-
//  Generated by gtkmmproc from /usr/obj/ports/gtkmm-1.2.10p5/gtkmm-1.2.10/src/build_sources/../toolbar.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_TOOLBAR_H
#define _GTKMM_TOOLBAR_H

/* $Id: toolbar.gen_h,v 1.90 2001/07/15 13:33:38 murrayc Exp $ */


/* toolbar.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/container.h>
#include <gtk/gtktoolbar.h>

namespace Gtk {
class Toolbar;
class Toolbar_Class;
}
namespace Gtk { Gtk::Toolbar *wrap (GtkToolbar *o); }
namespace Gtk
{

/* toolbar is a bit of a factory.  We will
represent this by making a virtual list called
tools.  Tools iterates through the children
of list.  It looks like list<Toolbar_Helpers::Tool*>
but inserts Toolbar::Element.  Elements
are a factory for spaces, widget, buttons, toggle
buttons and radio buttons.

The name "icon" in the gtk+ interface is very
misleading, it is really a button content
not a pixmap.  We will rename it to "content".

Confused?  Okay go read the interface.
*/
class Toolbar;
namespace RadioButton_Helpers {
  class Group;
}

namespace Toolbar_Helpers
{
/*********************************************************************
***** Elem classes (This should be an easy and cool interface)
*********************************************************************/

  // Tool is the output class (very thin wrapper)
  class Tool: protected GtkToolbarChild
    {
      private:
        Tool& operator=(const Tool&);
        Tool(const Tool&);
      protected:
        Tool(void* do_not_derive_this);
      public:
        GtkToolbarChildType get_type() {return GtkToolbarChild::type;}
        Widget* get_widget();
        Widget* get_content();
        Label*  get_label();
    };

  // Element is the input class
  class ToolList;
  class Element
    {
      friend class ToolList;
      protected:
        GtkToolbarChildType  type_;
        Widget*              widget_;
        nstring              text_;
        nstring              tooltip_text_;
        nstring              tooltip_private_text_;
        Widget*              content_;  // this does not need to be a pixmap.
        SigC::Slot0<void>    callback_;
        Gtk::RadioButton_Helpers::Group* group_;

      private:
        Element& operator=(const Element&);

      protected:
        // some fields are mutually exclusive
        Element(GtkToolbarChildType  type,
                Widget          *widget,
                const nstring   &text,
                const nstring   &tooltip_text,
                const nstring   &tooltip_private_text,
                Widget          *content,
                SigC::Slot0<void>          callback);
      public:
        Element(const Element& p);

        Element(Widget& w,
                const nstring &tooltip_text=0,
                const nstring &tooltip_private_text=0);
    };

  struct Space: public Element
    {
      Space();
    };

  typedef Element WidgetElem;

  // Order here is different than gtk+, watch yourself
  // Each button set has 3 forms i
  //   with a string and content
  //   with a string
  //   with content (ie Pixmap, images, etc)
  struct ButtonElem: public Element
    {
      ButtonElem(const nstring &text,
                 Widget         &content,
                 SigC::Slot0<void>        callback,
                 const nstring &tooltip_text=0,
                 const nstring &tooltip_private_text=0);
      ButtonElem(Widget         &content,
                 SigC::Slot0<void>        callback,
                 const nstring &tooltip_text=0,
                 const nstring &tooltip_private_text=0);
      ButtonElem(const nstring &text,
                 SigC::Slot0<void>        callback,
                 const nstring &tooltip_text=0,
                 const nstring &tooltip_private_text=0);
    };

  struct ToggleElem: public Element
    {
      ToggleElem(const nstring &text,
                 Widget         &content,
                 SigC::Slot0<void>        callback,
                 const nstring &tooltip_text=0,
                 const nstring &tooltip_private_text=0);
      ToggleElem(Widget         &content,
                 SigC::Slot0<void>        callback,
                 const nstring &tooltip_text=0,
                 const nstring &tooltip_private_text=0);

      ToggleElem(const nstring &text,
                 SigC::Slot0<void>        callback,
                 const nstring &tooltip_text=0,
                 const nstring &tooltip_private_text=0);
    };

  struct RadioElem: public Element
    {
      RadioElem (Gtk::RadioButton_Helpers::Group& group,
                 const nstring&      text,
                 Widget&             content,
                 SigC::Slot0<void>   callback=0,
                 const nstring&      tooltip_text=0,
                 const nstring&      tooltip_private_text=0);
      RadioElem (Gtk::RadioButton_Helpers::Group& group,
                 Widget&             content,
                 SigC::Slot0<void>   callback=0,
                 const nstring&      tooltip_text=0,
                 const nstring&      tooltip_private_text=0);
      RadioElem (Gtk::RadioButton_Helpers::Group& group,
                 const nstring&      text,
                 SigC::Slot0<void>   callback=0,
                 const nstring&      tooltip_text=0,
                 const nstring&      tooltip_private_text=0);
    };

/*********************************************************************
***** List properties
*********************************************************************/

  class ToolList
    {
      public:
        typedef Tool*                       value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_List_Iterator<value_type>        iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;
        typedef G_List_ReverseIterator<iterator>   reverse_iterator;
        typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend class Gtk::Toolbar;
        Gtk::Toolbar *parent_;
        explicit ToolList(Toolbar* parent): parent_(parent) {}

        GList*& glist() const;      // front of list

        iterator begin_() const;
        iterator end_() const;

      public:
        ~ToolList() {}

        inline iterator begin()
          {return begin_();}
        inline iterator end()
          {return end_();}

        inline const_iterator begin() const
          { return const_iterator(begin_()); }
        inline const_iterator end() const
          { return const_iterator(end_()); }

        inline reverse_iterator rbegin()
          { return reverse_iterator(end_()); }
        inline reverse_iterator rend()
          { return reverse_iterator(begin_()); }

        inline const_reverse_iterator rbegin() const
          { return const_reverse_iterator(reverse_iterator(end_())); }
        inline const_reverse_iterator rend() const
          { return const_reverse_iterator(reverse_iterator(begin_())); }

        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }

        iterator insert(iterator position, const Element& e);
        template <class InputIterator>
        inline void insert(iterator position, InputIterator first, InputIterator last)
          { for (;first!=last;++first) position=insert(position,*first); }

        inline void push_front(const Element& e) { insert(begin(), e); }
        inline void push_back(const Element& e)  { insert(end(), e); }
        inline void pop_front()                  { erase(begin()); }
        inline void pop_back()                   { erase(--end()); }

        void clear();

        iterator erase(iterator);
        void erase(iterator start, iterator stop);
        void remove(const_reference);

        iterator find(const_reference c);
        iterator find(Widget&);

        value_type front() const     { return *begin(); }
        value_type back() const      { return *(--end()); }

        // This is order n. (use at own risk)
        value_type operator[](size_type l) const;

        // Non-standard
        void remove(Widget&);
     };

};


//: Create bars of buttons and other widgets.
class Toolbar : public Container
{

public:
  typedef Toolbar          CppObjectType;
  typedef Toolbar_Class    CppClassType;
  typedef GtkToolbar           BaseObjectType;
  typedef GtkToolbarClass      BaseClassType;

private:
  friend class Toolbar_Class;
  static CppClassType toolbar_class;

  Toolbar(const Toolbar&);
  Toolbar& operator=(const Toolbar&); // not implemented

protected:
  void   initialize_class();
  explicit Toolbar(GtkToolbar *castitem);

public:
  static GtkType get_type();
  GtkToolbar* gtkobj()             { return (GtkToolbar*)(gtkobject); }
  const GtkToolbar* gtkobj() const { return (GtkToolbar*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Toolbar();

private:

public:
  typedef Toolbar_Helpers::ToolList ToolList;

  Toolbar(GtkOrientation orientation = GTK_ORIENTATION_HORIZONTAL,
	      GtkToolbarStyle style = GTK_TOOLBAR_BOTH);


// All the gtk+ add methods were horrible interface use tools().

/* Style methods */
  GtkOrientation get_orientation() const;


  //: sets whether a toolbar should appear horizontally or vertically.
  //- {\var orientation}: A new {\type GtkOrientation}. This is one of:
  //- {\enum GTK_ORIENTATION_HORIZONTAL}, or {\enum GTK_ORIENTATION_VERTICAL}.

  void set_orientation(GtkOrientation orientation);


  GtkToolbarStyle get_style() const;

  //: alters the view of toolbar to display either icons only, text only, or both.
  //- {\var style}: The new style for toolbar. This is one of:
  //- {\enum  GTK_TOOLBAR_ICONS}, {\enum GTK_TOOLBAR_TEXT}, or
  //- {\enum GTK_TOOLBAR_BOTH}.

  void set_style(GtkToolbarStyle style);


  gint get_space_size() const;

  //: should be used to set the number of pixels each item of space takes up in a toolbar.
  //- {\var space_size}: The new number of pixels that spaces should consume.

  void set_space_size(gint space_size);


  GtkToolbarSpaceStyle get_space_style() const;

  //: sets whether a 'space' in the toolbar appears as a line or just plain empty space.
  //- {\var space_style}: The new style for the toolbar's spaces. This is one of:
  //- {\enum  GTK_TOOLBAR_SPACE_EMPTY}, or {\enum GTK_TOOLBAR_SPACE_LINE}.

  void set_space_style(GtkToolbarSpaceStyle space_style);

  //: sets if the tooltips of a toolbar should be active or not.
  //- {\enum enable}: Set to 0 to disable the tooltips, or 1 to enable them.

  void set_tooltips(bool enable);


  GtkReliefStyle get_button_relief() const;
  void set_button_relief(GtkReliefStyle relief);



/* signals (not emitable) */
  //: Should be used if you wish to perform an action when the orientation of a toolbar is changed.

  //: should be used if you wish to perform an action when ever the style of a toolbar is adjusted.
  //- For example, this would be a useful signal to connect to if you want to display more items
  //- on the toolbar when it is in icon-only mode; each item takes less space on the bar.


  ToolList& tools()
    {return reinterpret_cast<ToolList&>(toolbar_self); }
  const ToolList& tools() const
    {return reinterpret_cast<const ToolList&>(toolbar_self); }

public:

  union
    {
      CppObjectType * toolbar_self;
    };

protected:
  // impl functions
    virtual void orientation_changed_impl(GtkOrientation p0);
    virtual void style_changed_impl(GtkToolbarStyle p0);

};



}


//+ PROPERTIES(Gtk_ToolBar)
//. name: num_children
//. type: gint
//. get:
//. set:
//. desc:

//. name: children
//. type: GList*
//. get:
//. set:
//. desc:

//. name: orientation
//. type: GtkOrientation
//. get:
//. set:
//. desc:

//. name: style
//. type: GtkToolbarStyle
//. get:
//. set:
//. desc:

//. name: space_size
//. type: gint
//. get:
//. set:
//. desc: big optional space between buttons

//. name: space_style
//. type: GtkToolbarSpaceStyle
//. get:
//. set:
//. desc:

//. name: tooltips
//. type: GtkTooltips*
//. get:
//. set:
//. desc:

//. name: button_maxw
//. type: gint
//. get:
//. set:
//. desc:

//. name: button_maxh
//. type: gint
//. get:
//. set:
//. desc:

//. name: relief
//. type: GtkReliefStyle
//. get:
//. set:
//. desc:

#endif
