// -*- c++ -*-
//  Generated by gtkmmproc from /usr/obj/ports/gtkmm-1.2.10p5/gtkmm-1.2.10/src/build_sources/../style.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_STYLE_H
#define _GTKMM_STYLE_H

/* $Id: style.gen_h,v 1.49 2000/08/21 19:24:37 kenelson Exp $ */

/* style.gen_h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--config.h>
#include <gtk/gtkstyle.h>
#include <gdk--.h>
#include <gtk--/base.h>


namespace Gtk
{
class RC;
class RCStyle;
class Widget;
class Style;

inline Style *wrap (GtkStyle *o)
{
   return (Style *)o;
}

// This wrapper is very temporary.  There should be a new
// replacement for this at some point when gtk+ adds a data
// field.  For now only setting the colors works.  When
// gtk+ gets field, all draw_* become virtual and one can define
// their own style in C++.
class Style : protected GtkStyle
{
public:
  typedef Style          CppObjectType;
  typedef GtkStyle           BaseObjectType;

private:

  Style();
  //Gtk_Style(GtkStyle *castitem);
  Style(const Style&);
  Style operator=(const Style&);

  friend class RC;
  friend class RCStyle;
  friend class Widget;

protected:
  Style(void* do_not_derive_me);

public:
  ~Style();

  // These are worthless to the users they should use set_style instead.
  //Gtk_Style* attach(Gdk_Window &window);
  //void       detach();

  // Many objects share styles so they must be on heap so they
  // can't fall out of scope while being used.
  static Style* create();
  Style* copy() const;
  Style* ref();
  void       unref();

/* These can only be called pior to the first use */
  void set_background(const Gdk_Drawable& window, GtkStateType state_type);
  void apply_default_background(const Gdk_Drawable &window,
				bool set_bg,
				GtkStateType state_type,
				const Gdk_Rectangle &area,
				gint          x,
				gint          y,
				gint          width,
				gint          height);

  void set_bg    ( GtkStateType state_type, const Gdk_Color &new_color );
  void set_light ( GtkStateType state_type, const Gdk_Color &new_color );
  void set_dark  ( GtkStateType state_type, const Gdk_Color &new_color );
  void set_mid   ( GtkStateType state_type, const Gdk_Color &new_color );
  void set_base  ( GtkStateType state_type, const Gdk_Color &new_color );
  void set_fg    ( GtkStateType state_type, const Gdk_Color &new_color );
  void set_text  ( GtkStateType state_type, const Gdk_Color &new_color );

  void set_font(Gdk_Font f);

/* These are only available after being attached to a window */
  Gdk_Font get_font () const;

  // FIXME: The Gdk_GC need to be real const, not handle const! Damn!
  inline Gdk_GC get_fg_gc  ( GtkStateType state_type)
    { return fg_gc[state_type]; }
  inline Gdk_GC get_bg_gc  ( GtkStateType state_type)
    { return bg_gc[state_type]; }
  inline Gdk_GC get_light_gc( GtkStateType state_type)
    { return light_gc[state_type]; }
  inline Gdk_GC get_dark_gc( GtkStateType state_type)
    { return dark_gc[state_type]; }
  inline Gdk_GC get_mid_gc ( GtkStateType state_type)
    { return mid_gc[state_type]; }
  inline Gdk_GC get_text_gc( GtkStateType state_type)
    { return text_gc[state_type]; }
  inline Gdk_GC get_base_gc( GtkStateType state_type)
    { return base_gc[state_type]; }

  inline Gdk_GC get_black_gc() { return black_gc; }
  inline Gdk_GC get_white_gc() { return white_gc; }

  inline Gdk_Pixmap get_background(GtkStateType state_type)
    {return bg_pixmap[state_type]; }

/* Drawing functions */
  void draw_hline               (Gdk_Window     &window,
				 GtkStateType   state_type,
				 gint           x1,
				 gint           x2,
				 gint           y) const;

  void draw_vline               (Gdk_Window     &window,
				 GtkStateType   state_type,
				 gint           y1,
				 gint           y2,
				 gint           x) const;

  void draw_shadow              (Gdk_Window     &window,
				 GtkStateType   state_type,
				 GtkShadowType  shadow_type,
				 gint           x,
				 gint           y,
				 gint           width,
				 gint           height) const;

  void draw_polygon             (Gdk_Window     &window,
				 GtkStateType   state_type,
				 GtkShadowType  shadow_type,
				 GdkPoint      *points,
				 gint           npoints,
				 gint           fill) const;

  void draw_arrow               (Gdk_Window     &window,
				 GtkStateType   state_type,
				 GtkShadowType  shadow_type,
				 GtkArrowType   arrow_type,
				 gint           fill,
				 gint           x,
				 gint           y,
				 gint           width,
				 gint           height) const;

  void draw_diamond             (Gdk_Window     &window,
				 GtkStateType   state_type,
				 GtkShadowType  shadow_type,
				 gint           x,
				 gint           y,
				 gint           width,
				 gint           height) const;

  void draw_oval                (Gdk_Window     &window,
				 GtkStateType   state_type,
				 GtkShadowType  shadow_type,
				 gint           x,
				 gint           y,
				 gint           width,
				 gint           height) const;

  void draw_string              (Gdk_Window     &window,
				 GtkStateType   state_type,
				 gint           x,
				 gint           y,
				 const nstring &string) const;

  inline const GtkStyle* gtkobj() const { return (GtkStyle*)this; }
  inline GtkStyle* gtkobj()             { return (GtkStyle*)this; }

};

}


//+ PROPERTIES(gtkstyle)

//. name: fg
//. type: GdkColor[5]
//. get:
//. set:
//. desc:

//. name: bg
//. type: GdkColor[5]
//. get:
//. set:
//. desc:

//. name: light
//. type: GdkColor[5]
//. get:
//. set:
//. desc:

//. name: dark
//. type: GdkColor[5]
//. get:
//. set:
//. desc:

//. name: mid
//. type: GdkColor[5]
//. get:
//. set:
//. desc:

//. name: text
//. type: GdkColor[5]
//. get:
//. set:
//. desc:

//. name: base
//. type: GdkColor[5]
//. get:
//. set:
//. desc:

//. name: black
//. type: GdkColor
//. get:
//. set:
//. desc:

//. name: white
//. type: GdkColor
//. get:
//. set:
//. desc:

//. name: font
//. type: GdkFont*
//. get:
//. set:
//. desc:

//. name: fg_gc[5]
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: bg_gc[5]
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: light_gc[5]
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: dark_gc[5]
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: mid_gc[5]
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: text_gc[5]
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: base_gc[5]
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: black_gc
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: white_gc
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: bg_pixmap[5]
//. type: GdkPixmap*
//. get:
//. set:
//. desc:

//. name: ref_count
//. type: gint
//. get:
//. set:
//. desc: private

//. name: attach_count
//. type: gint
//. get:
//. set:
//. desc:

//. name: depth
//. type: gint
//. get:
//. set:
//. desc:

//. name: colormap
//. type: GdkColormap*
//. get:
//. set:
//. desc:

//. name: engine
//. type: GtkThemeEngine*
//. get:
//. set:
//. desc:

//. name: engine_data
//. type: gpointer
//. get:
//. set:
//. desc:

//. name: styles
//. type: GSList*
//. get:
//. set:
//. desc: the Rc style from which this style
//. was created
//.

#endif
