// -*- c++ -*-
//  Generated by gtkmmproc from /usr/obj/ports/gtkmm-1.2.10p5/gtkmm-1.2.10/src/build_sources/../editable.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_EDITABLE_H
#define _GTKMM_EDITABLE_H

/* $Id: editable.gen_h,v 1.46 2002/04/14 15:28:30 murrayc Exp $ */

/* editable.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/widget.h>
#include <gtk/gtkeditable.h>

namespace Gtk {
class Editable;
class Editable_Class;
}
namespace Gtk { Gtk::Editable *wrap (GtkEditable *o); }
namespace Gtk
{
//: Base class for text-editing widgets.
//- The {\class Gtk::Editable} class is a base class for widgets for editing
//- text, such as {\class Gtk::Entry} and {\class Gtk::Text}. It cannot be
//- instantiated by itself. The editable class contains functions for
//- generically manipulating an editable widget, a large number of action
//- signals used for key bindings, and several signals that an application
//- can connect to to modify the behavior of a widget.
class Editable : public Widget {

public:
  typedef Editable          CppObjectType;
  typedef Editable_Class    CppClassType;
  typedef GtkEditable           BaseObjectType;
  typedef GtkEditableClass      BaseClassType;

private:
  friend class Editable_Class;
  static CppClassType editable_class;

  Editable(const Editable&);
  Editable& operator=(const Editable&); // not implemented

protected:
  void   initialize_class();
  explicit Editable(GtkEditable *castitem);

public:
  static GtkType get_type();
  GtkEditable* gtkobj()             { return (GtkEditable*)(gtkobject); }
  const GtkEditable* gtkobj() const { return (GtkEditable*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Editable();

private:

public:
  Editable();



  //: Indicates that the user has changed the contents of the widget.

  //: Indicates that the user has activated the widget in some fashion.
  //- Generally, this will be done with a keystroke. (The default binding
  //- for this action is Return for {\class Gtk::Entry} and Control-Return
  //- for {\class Gtk::Text}.)

  //: This signal is emitted when text is inserted into the widget by the user.
  //- The default handler for this signal will normally be responsible for
  //- inserting the text, so by connecting to this signal and then stopping
  //- the signal, it is possible to modify the
  //- inserted text, or prevent it from being inserted entirely.

  //: This signal is emitted when text is deleted from the widget by the user.
  //- The default handler for this signal will normally be responsible for
  //- deleting the text, so by connecting to this signal and then stopping
  //- the signal, it is possible to modify the deleted text, or prevent it
  //- from being deleted entirely. The start_pos and end_pos parameters are
  //- interpreted as for {delete_text()}.


  //:Determines if the user can edit the text in the editable widget or not.
  //- This is meant to be overriden by child classes and should not generally useful to applications.

  //: An action signal. Move the cursor position.

  //: An action signal. Move the cursor by words.

  //: An action signal. Move the cursor by pages.

  //: An action signal. Move the cursor to the given row.

  //: An action signal. Move the cursor to the given column.

  //: An action signal. Delete a single character.

  //: An action signal. Delete a single word.

  //: An action signal. Delete a single line.

  //: An action signal. Causes the characters in the current selection to be copied to the clipboard
  //: and then deleted from the widget.

  //: An action signal. Causes the characters in the current selection to be copied to the clipboard.

  //: An action signal. Causes the contents of the clipboard to be pasted into the editable widget
  //: at the current cursor position.



  //SIGNAL_SPEC("get_chars",vfunc,gchar* get_chars(gint,gint),gtk_editable_get_chars);



  //: Selects a region of text.
  //- The characters that are selected are those characters at positions from
  //- start_pos up to, but not including end_pos. If end_pos is negative,
  //- then the the characters selected will be those characters from start_pos
  //- to the end of the text.
  //-
  //- start: The starting position.
  //-
  //- end: The end position.

  void select_region(gint start,gint end);

  /* no function for 1.1, we'll use signal instead */
  //: Retrieves the current cursor position.
  //- Returns : the position of the cursor. The cursor is displayed before
  //- the character with the given (base 0) index in the widget. The value
  //- will be less than or equal to the number of characters in the widget.
  //- Note that this position is in characters, not in bytes.

  gint get_position() const;

  //: Retrieves a sequence of characters.
  //- The characters that are retrieved are those characters at positions
  //- from start_pos up to, but not including end_pos. If end_pos is
  //- negative, then the the characters retrieved will be those characters
  //- from start_pos to the end of the text.
  //-
  //- start_pos: The starting position.
  //-
  //- end_pos: The end position.
  //-
  //- Returns: The characters in the indicated region.
  string get_chars (int start_pos = 0, int end_pos = - 1) const;

  //: Claim or disclaim ownership of the PRIMARY X selection.
  //- claim: If TRUE, claim the selection, otherwise, disclaim it.
  //-
  //- time: The timestamp for claiming the selection.

  void claim_selection(gboolean claim,guint32 time);

  //: Deletes the current contents of the widgets selection and disclaims the selection.

  void delete_selection();

  guint get_selection_start_pos() const { return gtkobj()->selection_start_pos; }
  guint get_selection_end_pos()   const { return gtkobj()->selection_end_pos; }
  bool  has_selection()           const { return gtkobj()->has_selection; }

public:

  union
    {
      CppObjectType * editable_self;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,0,&gtk_editable_changed> changed;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,1> activate;
      Gtk::EmitProxySignal3<void,const gchar*,gint,gint*,CppObjectType,BaseObjectType,2,&gtk_editable_insert_text> insert_text;
      Gtk::EmitProxySignal2<void,gint,gint,CppObjectType,BaseObjectType,3,&gtk_editable_delete_text> delete_text;
      Gtk::EmitProxySignal1<void,gboolean,CppObjectType,BaseObjectType,4,&gtk_editable_set_editable> set_editable;
      Gtk::ProxySignal2<void,gint,gint,CppObjectType,BaseObjectType,5> move_cursor;
      Gtk::ProxySignal1<void,gint,CppObjectType,BaseObjectType,6> move_word;
      Gtk::ProxySignal2<void,gint,gint,CppObjectType,BaseObjectType,7> move_page;
      Gtk::ProxySignal1<void,gint,CppObjectType,BaseObjectType,8> move_to_row;
      Gtk::ProxySignal1<void,gint,CppObjectType,BaseObjectType,9> move_to_column;
      Gtk::ProxySignal1<void,gint,CppObjectType,BaseObjectType,10> kill_char;
      Gtk::ProxySignal1<void,gint,CppObjectType,BaseObjectType,11> kill_word;
      Gtk::ProxySignal1<void,gint,CppObjectType,BaseObjectType,12> kill_line;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,13,&gtk_editable_cut_clipboard> cut_clipboard;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,14,&gtk_editable_copy_clipboard> copy_clipboard;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,15,&gtk_editable_paste_clipboard> paste_clipboard;
    };

protected:
  // impl functions
    virtual void changed_impl();
    virtual void activate_impl();
    virtual void insert_text_impl(const gchar* p0,gint p1,gint* p2);
    virtual void delete_text_impl(gint p0,gint p1);
    virtual void set_editable_impl(gboolean p0);
    virtual void move_cursor_impl(gint p0,gint p1);
    virtual void move_word_impl(gint p0);
    virtual void move_page_impl(gint p0,gint p1);
    virtual void move_to_row_impl(gint p0);
    virtual void move_to_column_impl(gint p0);
    virtual void kill_char_impl(gint p0);
    virtual void kill_word_impl(gint p0);
    virtual void kill_line_impl(gint p0);
    virtual void cut_clipboard_impl();
    virtual void copy_clipboard_impl();
    virtual void paste_clipboard_impl();

};

}


//+ PROPERTIES(Gtk_Editable)
//. name: current_pos
//. type: guint
//. get:
//. set:
//. desc:

//. name: selection_start_pos
//. type: guint
//. get:
//. set:
//. desc:

//. name: selection_end_pos
//. type: guint
//. get:
//. set:
//. desc:

//. name: has_selection
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: editable
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: ic
//. type: GdkIC*
//. get:
//. set:
//. desc:

//. name: ic_attr
//. type: GdkICAttr*
//. get:
//. set:
//. desc:

//. name: clipboard_text
//. type: string
//. get:
//. set:
//. desc:

#endif
