// -*- c++ -*-
//  Generated by gtkmmproc from /usr/obj/ports/gtkmm-1.2.10p5/gtkmm-1.2.10/src/build_sources/../colorselection.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_COLORSELECTION_H
#define _GTKMM_COLORSELECTION_H

/* $Id: colorselection.gen_h,v 1.44 2001/07/15 13:33:38 murrayc Exp $ */

/* colorselection.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/box.h>
#include <gtk--/window.h>
#include <gtk--/button.h>
#include <gtk/gtkcolorsel.h>

namespace Gtk {
class ColorSelection;
class ColorSelection_Class;
}
namespace Gtk { Gtk::ColorSelection *wrap (GtkColorSelection *o); }
namespace Gtk {
class ColorSelectionDialog;
class ColorSelectionDialog_Class;
}
namespace Gtk { Gtk::ColorSelectionDialog *wrap (GtkColorSelectionDialog *o); }
namespace Gtk
{
//: A widget used to select a color.
//- The {\class Gtk::ColorSelection} is a widget that is used to select a color. It
//- consists of a color wheel and number of sliders and entry boxes for
//- color parameters such as hue, saturation, value, red, green, blue,
//- and opacity. It is found on the standard color selection dialog box
//- {Gtk::ColorSelectionDialog}.
class ColorSelection : public VBox {

public:
  typedef ColorSelection          CppObjectType;
  typedef ColorSelection_Class    CppClassType;
  typedef GtkColorSelection           BaseObjectType;
  typedef GtkColorSelectionClass      BaseClassType;

private:
  friend class ColorSelection_Class;
  static CppClassType color_selection_class;

  ColorSelection(const ColorSelection&);
  ColorSelection& operator=(const ColorSelection&); // not implemented

protected:
  void   initialize_class();
  explicit ColorSelection(GtkColorSelection *castitem);

public:
  static GtkType get_type();
  GtkColorSelection* gtkobj()             { return (GtkColorSelection*)(gtkobject); }
  const GtkColorSelection* gtkobj() const { return (GtkColorSelection*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~ColorSelection();

private:

public:

  ColorSelection();



  //: Sets the policy controlling when the color_changed signals are emitted.
  //- The available policies are:
  //-
  //- {\enum GTK_UPDATE_CONTINUOUS} - signals are sent continuously as the color selection changes.
  //-
  //- {\enum GTK_UPDATE_DISCONTINUOUS} - signals are sent only when the mouse button is released.
  //-
  //- {\enum GTK_UPDATE_DELAYED} - signals are sent when the mouse button is released or when the
  //- mouse has been motionless for a period of time.

  void set_update_policy(GtkUpdateType policy);

  //: Controls whether opacity can be set with the {\class Gtk::ColorSelection}.
  //- If this functionality is enabled, the necessary additional widgets are added
  //- to the {\class Gtk::ColorSelection} and the opacity value can be retrieved
  //- via the fourth value in the color array returned by the {get_color()} function.

  void set_opacity(gint use_opacity);

  // NOTE: mail gtk+ that second argument should be const.
  //: Sets the color in the {\class Gtk::ColorSelection}.
  //- The widgets are updated to reflect the new color.
  //-
  //- color: A color array consisting of 4 gfloat values for red, green, blue, and opacity.

  void set_color(const gdouble* color);

  //: Retrieve the currently selected color value.
  //- color: A color array consisting of 4 gfloat values for red, green, blue, and opacity.

  void get_color(gdouble* color) const;

  //: This signal is emitted when the color changes in the {\class Gtk::ColorSelection} according to its update policy.

public:

  union
    {
      CppObjectType * color_selection_self;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,0> color_changed;
    };

protected:
  // impl functions
    virtual void color_changed_impl();

};

//: A standard dialog box for selecting a color.
//- The {\class Gtk::ColorSelectionDialog} provides a standard dialog which allows
//- the user to select a color much like the {\class Gtk::FileSelection} provides
//- a standard dialog for file selection.
class ColorSelectionDialog : public Window {

public:
  typedef ColorSelectionDialog          CppObjectType;
  typedef ColorSelectionDialog_Class    CppClassType;
  typedef GtkColorSelectionDialog           BaseObjectType;
  typedef GtkColorSelectionDialogClass      BaseClassType;

private:
  friend class ColorSelectionDialog_Class;
  static CppClassType color_selection_dialog_class;

  ColorSelectionDialog(const ColorSelectionDialog&);
  ColorSelectionDialog& operator=(const ColorSelectionDialog&); // not implemented

protected:
  void   initialize_class();
  explicit ColorSelectionDialog(GtkColorSelectionDialog *castitem);

public:
  static GtkType get_type();
  GtkColorSelectionDialog* gtkobj()             { return (GtkColorSelectionDialog*)(gtkobject); }
  const GtkColorSelectionDialog* gtkobj() const { return (GtkColorSelectionDialog*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~ColorSelectionDialog();

private:

public:

  ColorSelectionDialog(const nstring &title);

  Gtk::ColorSelection* get_colorsel() const;

  Gtk::VBox* get_vbox() const;

  Gtk::Button* get_ok_button() const;

  Gtk::Button* get_reset_button() const;

  Gtk::Button* get_cancel_button() const;

  Gtk::Button* get_help_button() const;

public:

protected:
  // impl functions

};

}


#endif
