<?php

$block_name = _("Notes Summary");

/**
 * Implementation of Horde_Block api to show notes summary.
 *
 * $Horde: mnemo/lib/Block/summary.php,v 1.22 2004/11/16 16:24:43 jan Exp $
 *
 * @package Horde_Block
 */
class Horde_Block_Mnemo_summary extends Horde_Block {

    var $_app = 'mnemo';

    function _title()
    {
        global $registry;
        require_once dirname(__FILE__) . '/../Mnemo.php';

        $html  = Horde::link(Horde::url($registry->getInitialPage(), true), $registry->get('name'), 'header') . $registry->get('name') . '</a> :: ';
        $html .= Horde::link(Horde::applicationUrl('memo.php?actionID=add_memo', true), _("New Note"), 'smallheader') . Horde::img('mnemo.png', _("New Note"), 'align="middle"', Horde::url($registry->getImageDir(), true, -1)) . ' ' . _("New Note") . '</a>';

        return $html;
    }

    function _params()
    {
        require_once dirname(__FILE__) . '/../base.php';
        require_once 'Horde/Prefs/CategoryManager.php';
        $cManager = &new Prefs_CategoryManager();
        $categories = array();
        foreach ($cManager->get() as $c) {
            $categories[$c] = $c;
        }

        return array('show_actions' => array('type' => 'checkbox',
                                             'name' => _("Show action buttons?"),
                                             'default' => 1),
                     'show_notepad' => array('type' => 'checkbox',
                                             'name' => _("Show notepad name?"),
                                             'default' => 1),
                     'show_categories' => array('type' => 'multienum',
                                                'name' => _("Show notes from these categories"),
                                                'default' => array(),
                                                'values' => $categories)
               );
    }

    function _content()
    {
        require_once dirname(__FILE__) . '/../base.php';
        global $registry, $prefs, $conf;

        if (!isset($conf['storage']['driver']) ||
            !isset($conf['storage']['params'])) {
            return PEAR::raiseError('Not configured');
        }

        require_once 'Horde/Prefs/CategoryManager.php';
        $cManager = &new Prefs_CategoryManager();
        $colors = $cManager->colors();

        if (!empty($this->_params['show_notepad'])) {
            $shares = &Horde_Share::singleton('mnemo');
        }

        $html = '<table border="0" cellpadding="0" cellspacing="1" width="100%" class="item">';
        $memos = Mnemo::listMemos($prefs->getValue('sortby'),
                                  $prefs->getValue('sortdir'));
        foreach ($memos as $id => $memo) {
            if (!empty($this->_params['show_categories']) &&
                !in_array($memo['category'], $this->_params['show_categories'])) {
                continue;
            }

            $html .= '  <tr>';

            if (!empty($this->_params['show_actions'])) {
                $editurl = Util::addParameter('memo.php', 'memo', $memo['memo_id']);
                $editurl = Util::addParameter($editurl, 'memolist', $memo['memolist_id']);
                $html .= '<td width="1%">' . Horde::link(Horde::applicationUrl(Util::addParameter($editurl, 'actionID', 'modify_memo')), _("Edit Note"), 'widget') . Horde::img('edit.png', _("Edit Note"), '', $registry->getImageDir('horde')) . '</a></td>';
            }

            $color = isset($colors[$memo['category']]) ? $colors[$memo['category']] : $colors['_default_'];
            $priority_cell = '<td width="20" align="center" style="background-color:' . $color . '">';
            if (!empty($this->_params['show_notepad'])) {
                $owner = $memo['memolist_id'];
                $share = $shares->getShare($owner);
                if (!is_a($share, 'PEAR_Error')) {
                    $owner = $share->get('name');
                }
                $priority_cell .= "<nobr>$owner</nobr>";
            } else {
                $priority_cell .= '&nbsp;&nbsp;&nbsp;';
            }
            $priority_cell .= '</td>';
            $spacer_cell = '<td width="1">&nbsp;</td>';
            $html .= $priority_cell . $spacer_cell;

            $html .= '<td class="text">';
            $viewurl = Util::addParameter('view.php', 'memo=' . $memo['memo_id']);
            $viewurl = Util::addParameter($viewurl, 'memolist=' . $memo['memolist_id']);
            $html .= Horde::link(Horde::applicationUrl($viewurl, true), $memo['desc']) . htmlspecialchars($memo['desc']) . '</a>';
            $html .= "</td></tr>\n";
        }
        if (!count($memos)) {
            $html .= '<tr><td><i>' . _("No notes to display") . '</i></td></tr>';
        }
        $html .= '</table>';

        return $html;
    }

}
