/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.GroupEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteStackEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.SeparatorEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.SliderPaletteEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.TemplateEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.PaletteTemplateEntry;

public class PaletteEditPartFactory
implements EditPartFactory {
    protected EditPart createDrawerEditPart(EditPart parentEditPart, Object model) {
        return new DrawerEditPart((PaletteDrawer)model);
    }

    public EditPart createEditPart(EditPart parentEditPart, Object model) {
        if (model instanceof PaletteRoot) {
            return this.createMainPaletteEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteStack) {
            return this.createStackEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteContainer && PaletteDrawer.PALETTE_TYPE_DRAWER.equals(((PaletteContainer)model).getType())) {
            return this.createDrawerEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteContainer && ("Palette_Group".equals(((PaletteContainer)model).getType()) || "Palette_type_Unknown".equals(((PaletteContainer)model).getType()))) {
            return this.createGroupEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteTemplateEntry) {
            return this.createTemplateEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteSeparator) {
            return this.createSeparatorEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteEntry) {
            return this.createEntryEditPart(parentEditPart, model);
        }
        return null;
    }

    protected EditPart createSeparatorEditPart(EditPart parentEditPart, Object model) {
        return new SeparatorEditPart((PaletteSeparator)model);
    }

    protected EditPart createStackEditPart(EditPart parentEditPart, Object model) {
        return new PaletteStackEditPart((PaletteStack)model);
    }

    protected EditPart createEntryEditPart(EditPart parentEditPart, Object model) {
        return new ToolEntryEditPart((PaletteEntry)model);
    }

    protected EditPart createGroupEditPart(EditPart parentEditPart, Object model) {
        return new GroupEditPart((PaletteContainer)model);
    }

    protected EditPart createMainPaletteEditPart(EditPart parentEditPart, Object model) {
        return new SliderPaletteEditPart((PaletteRoot)model);
    }

    protected EditPart createTemplateEditPart(EditPart parentEditPart, Object model) {
        return new TemplateEditPart((PaletteTemplateEntry)model);
    }
}

