// I18N constants

// Translation Note
// 1. translate the left  side of fontname, font size and formatblock
// 2. translate the right side of tooltips

HTMLArea.I18N = {
	fontname: {
		"Arial":           'arial,helvetica,sans-serif',
		"Courier New":     'courier new,courier,monospace',
		"Georgia":         'georgia,times new roman,times,serif',
		"Tahoma":          'tahoma,arial,helvetica,sans-serif',
		"Times New Roman": 'times new roman,times,serif',
		"Verdana":         'verdana,arial,helvetica,sans-serif',
		"impact":          'impact',
		"WingDings":       'wingdings'
	},

	fontsize: {
		"1 (8 pt)":  "1",
		"2 (10 pt)": "2",
		"3 (12 pt)": "3",
		"4 (14 pt)": "4",
		"5 (18 pt)": "5",
		"6 (24 pt)": "6",
		"7 (36 pt)": "7"
	},

	formatblock: {
		"Heading 1": "h1",
		"Heading 2": "h2",
		"Heading 3": "h3",
		"Heading 4": "h4",
		"Heading 5": "h5",
		"Heading 6": "h6",
		"Normal": "p",
		"Address": "address",
		"Formatted": "pre"
	},

	tooltips: {
		bold:           "Fett",
		italic:         "Kursiv",
		underline:      "Unterstrichen",
		strikethrough:  "Durchgestrichen",
		subscript:      "Tiefgestellt",
		superscript:    "Hochgestellt",
		justifyleft:    "Linksbuendig",
		justifycenter:  "Zentriert",
		justifyright:   "Rechtsbuendig",
		justifyfull:    "Blocksatz",
		insertorderedlist:    "Ordered List",
		insertunorderedlist:  "Bulleted List",
		outdent:        "Decrease Indent",
		indent:         "Increase Indent",
		forecolor:      "Schriftfarbe",
		hilitecolor:    "Hintergrundfarbe",
		inserthorizontalrule: "Waagerechte Linie",
		createlink:     "Web-Link einfuegen",
		insertimage:    "Bild einfuegen",
		insertsound:    "Klang einfuegen",
		inserttable:    "Tabelle einfuegen",
		htmlmode:       "HTML Quellcodeansicht (de-)aktivieren",
		popupeditor:    "Eingabefeld vergrern",
		about:          "ber diesen Editor",
		showhelp:       "Hilfe",
		textindicator:  "Aktuelle Schrift",
		undo:           "Rckgngig",
		redo:           "Wiederholen",
		cut:            "ausschneiden",
		copy:           "kopieren",
		paste:          "einfgen"
	},

	buttons: {
		"ok":           "OK",
		"cancel":       "Abbrechen"
	},

	msg: {
		"Path":         "Pfad",
		"TEXT_MODE":    "Sie befinden sich im Text-Modus. Benutzen Sie den [<>]-Button um in den HTML-Modus zurckzuwechseln."
	}
};
