/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Parameter;
import org.eclipse.uml2.RedefinableElement;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class OperationOperations
extends UML2Operations {
    static /* synthetic */ Class class$0;

    private OperationOperations() {
    }

    public static boolean isConsistentWith(Operation operation, RedefinableElement redefinee) {
        if (redefinee.isRedefinitionContextValid(operation)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.uml2.Operation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isInstance(redefinee)) {
                Operation op = (Operation)redefinee;
                if (operation.getFormalParameters().size() == op.getFormalParameters().size() && operation.getReturnResults().size() == op.getReturnResults().size()) {
                    int i = 0;
                    while (i < operation.getFormalParameters().size()) {
                        Type opFormalParameterType = ((Parameter)op.getFormalParameters().get(i)).getType();
                        Type operationFormalParameterType = ((Parameter)operation.getFormalParameters().get(i)).getType();
                        if (opFormalParameterType == null ? operationFormalParameterType != null : !opFormalParameterType.conformsTo(operationFormalParameterType)) {
                            return false;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < operation.getReturnResults().size()) {
                        Type opReturnResultType = ((Parameter)op.getReturnResults().get(i)).getType();
                        Type operationReturnResultType = ((Parameter)operation.getReturnResults().get(i)).getType();
                        if (opReturnResultType == null ? operationReturnResultType != null : !opReturnResultType.conformsTo(operationReturnResultType)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isOrdered(Operation operation) {
        return 1 == operation.getReturnResults().size() ? ((Parameter)operation.getReturnResults().get(0)).isOrdered() : false;
    }

    public static boolean isUnique(Operation operation) {
        return 1 == operation.getReturnResults().size() ? ((Parameter)operation.getReturnResults().get(0)).isUnique() : true;
    }

    public static int lower(Operation operation) {
        return 1 == operation.getReturnResults().size() ? ((Parameter)operation.getReturnResults().get(0)).lower() : 1;
    }

    public static Classifier type(Operation operation) {
        return 1 == operation.getReturnResults().size() ? (Classifier)((Parameter)operation.getReturnResults().get(0)).getType() : null;
    }

    public static int upper(Operation operation) {
        return 1 == operation.getReturnResults().size() ? ((Parameter)operation.getReturnResults().get(0)).upper() : 1;
    }

    public static boolean validateTypeOfResult(Operation operation, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (!UML2Operations.safeEquals(operation.getType(), 1 == operation.getReturnResults().size() ? ((Parameter)operation.getReturnResults().get(0)).getType() : null)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 20, UML2Plugin.INSTANCE.getString("_UI_Operation_TypeOfResult_diagnostic", UML2Operations.getMessageSubstitutions(context, operation)), new Object[]{operation}));
            }
        }
        return result;
    }

    public static boolean validateOnlyBodyForQuery(Operation operation, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (operation.getBodyCondition() != null && !operation.isQuery()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 21, UML2Plugin.INSTANCE.getString("_UI_Operation_OnlyBodyForQuery_diagnostic", UML2Operations.getMessageSubstitutions(context, operation)), new Object[]{operation}));
            }
        }
        return result;
    }
}

