### Name: reorder
### Title: Reorder a dendrogram
### Aliases: reorder reorder.dendrogram
### Keywords: manip

### ** Examples

  set.seed(123)
  x <- rnorm(10)
  hc <- hclust(dist(x))
  dd <- as.dendrogram(hc)
  dd.reorder <- reorder(dd, 10:1)

  op <- par(mfcol = 1:2)
  plot(dd, main = "random dendrogram `dd'")
  plot(dd.reorder, main = "reorder(dd, 10:1)")
  par(op)



