### Name: plot.gam
### Title: Default GAM plotting
### Aliases: plot.gam
### Keywords: models smooth regression hplot

### ** Examples

library(mgcv)
set.seed(0)
n<-200
sig2<-4
x0 <- runif(n, 0, 1)
x1 <- runif(n, 0, 1)
x2 <- runif(n, 0, 1)
x3 <- runif(n, 0, 1)
pi <- asin(1) * 2
y <- 2 * sin(pi * x0)
y <- y + exp(2 * x1) - 3.75887
y <- y + 0.2 * x2^11 * (10 * (1 - x2))^6 + 10 * (10 * x2)^3 * (1 - x2)^10 - 1.396
e <- rnorm(n, 0, sqrt(abs(sig2)))
y <- y + e
b<-gam(y~s(x0)+s(x1)+s(x2)+s(x3))
plot(b,pages=1,residuals=TRUE)
# example with 2-d plots
b1<-gam(y~s(x0,x1)+s(x2)+s(x3))
op<-par(mfrow=c(2,2))
plot(b1)
par(op) 



