EEF.profile               package:boot               R Documentation

_E_m_p_i_r_i_c_a_l _L_i_k_e_l_i_h_o_o_d_s

_D_e_s_c_r_i_p_t_i_o_n:

     Construct the empirical log likelihood or empirical exponential 
     family log likelihood for a mean.

_U_s_a_g_e:

     EEF.profile(y, tmin=min(y) + 0.1, tmax=max(y) - 0.1, n.t=25, 
                 u=function(y, t) { y-t})
     EL.profile(y, tmin = min(y) + 0.1, tmax = max(y) - 0.1, n.t = 25, 
                u = function(y, t) y - t)

_A_r_g_u_m_e_n_t_s:

       y: A vector or matrix of data

    tmin: The minimum value of the range over which the  likelihood
          should be computed.  This must be larger than  'min(y)'.

    tmax: The maximum value of the range over which the  likelihood
          should be computed.  This must be smaller than  'max(y)'.

     n.t: The number of points between 'tmin' and 'tmax' at which the
          value of the log-liklihood should be computed.

       u: A function of the data and the parameter.

_D_e_t_a_i_l_s:

     These functions calculate the log likelihood for a mean using
     either an empirical likelihood or an empirical exponential family
     likelihood. They are supplied as part of the package 'boot' for
     demonstration purposes with the practicals in chapter 10 of
     Davison and Hinkley (1997). The functions are not intended for
     general use and are not supported as part of the 'boot'package. 
     For more general and more robust code to calculate empirical
     likelihoods see Professor A. B. Owen's  empirical likelihood home
     page at the URL <URL:
     http://www-stat.stanford.edu/~owen/empirical/>.

_V_a_l_u_e:

     A matrix with 'n.t' rows.  The first column contains the values of
     the parameter used.  The second colmn of the output of
     'EL.profile' contains the values of the empirical log likelihood.
     The second and third columns of the output of 'EEF.profile'
     contain two versions of the empirical exponential family
     log-likelihood.  The final column of the output matrix contains
     the values of the Lagrange multiplier used in the optimization
     procedure.

_A_u_t_h_o_r(_s):

     Angelo J. Canty

_R_e_f_e_r_e_n_c_e_s:

     Davison, A. C. and Hinkley, D. V. (1997) _Bootstrap Methods and
     Their Application_. Cambridge University Press.

