'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: button.n,v 1.6 2000/08/25 06:58:31 ericm Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.4 2000/08/25 06:18:32 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH button n 4.4 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
button \- Create and manipulate button widgets
.SH SYNOPSIS
\fBbutton\fR \fIpathName \fR?\fIoptions\fR?
.SO
\-activebackground	\-foreground	\-repeatdelay
\-activeforeground	\-highlightbackground	\-repeatinterval
\-anchor	\-highlightcolor	\-takefocus
\-background	\-highlightthickness	\-text
\-bitmap	\-image	\-textvariable
\-borderwidth	\-justify	\-underline
\-cursor	\-padx	\-wraplength
\-disabledforeground	\-pady
\-font	\-relief
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-command command Command
Specifies a Tcl command to associate with the button.  This command
is typically invoked when mouse button 1 is released over the button
window.
.VS 8.4
.OP \-compound compound Compound
Specifies whether the button should display both an image and text,
and if so, where the image should be placed relative to the text.
Valid values for this option are \fBbottom\fR, \fBcenter\fR,
\fBleft\fR, \fBnone\fR, \fBright\fR and \fBtop\fR.  The default value
is \fBnone\fR, meaning that the button will display either an image or
text, depending on the values of the \fB\-image\fR and \fB\-bitmap\fR
options.
.VE
.OP \-default default Default
.VS
Specifies one of three states for the default ring: \fBnormal\fR,
\fBactive\fR, or \fBdisabled\fR.  In active state, the button is drawn
with the platform specific appearance for a default button.  In normal
state, the button is drawn with the platform specific appearance for a
non-default button, leaving enough space to draw the default button
appearance.  The normal and active states will result in buttons of
the same size.  In disabled state, the button is drawn with the
non-default button appearance without leaving space for the default
appearance.  The disabled state may result in a smaller button than
the active state.
ring.
.VE
.OP \-height height Height
Specifies a desired height for the button.
If an image or bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in lines of text.
If this option isn't specified, the button's desired height is computed
from the size of the image or bitmap or text being displayed in it.
.VS 8.4
.OP \-overrelief overRelief OverRelief
Specifies an alternative relief for the button, to be used when the
mouse cursor is over the widget.  This option can be used to make
toolbar buttons, by configuring \fB\-relief flat \-overrelief
raised\fR.  If the value of this option is the empty string, then no
alternative relief is used when the mouse cursor is over the button.
The empty string is the default value.
.VE 8.4
.OP \-state state State
Specifies one of three states for the button:  \fBnormal\fR, \fBactive\fR,
or \fBdisabled\fR.  In normal state the button is displayed using the
\fBforeground\fR and \fBbackground\fR options.  The active state is
typically used when the pointer is over the button.  In active state
the button is displayed using the \fBactiveForeground\fR and
\fBactiveBackground\fR options.  Disabled state means that the button
should be insensitive:  the default bindings will refuse to activate
the widget and will ignore mouse button presses.
In this state the \fBdisabledForeground\fR and
\fBbackground\fR options determine how the button is displayed.
.OP \-width width Width
Specifies a desired width for the button.
If an image or bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in characters.
If this option isn't specified, the button's desired width is computed
from the size of the image or bitmap or text being displayed in it.
.BE

.SH DESCRIPTION
.PP
The \fBbutton\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a button widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the button such as its colors, font,
text, and initial relief.  The \fBbutton\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A button is a widget that displays a textual string, bitmap or image.
If text is displayed, it must all be in a single font, but it
can occupy multiple lines on the screen (if it contains newlines
or if wrapping occurs because of the \fBwrapLength\fR option) and
one of the characters may optionally be underlined using the
\fBunderline\fR option.
It can display itself in either of three different ways, according
to
the \fBstate\fR option; 
it can be made to appear raised, sunken, or flat;
and it can be made to flash.  When a user invokes the
button (by pressing mouse button 1 with the cursor over the
button), then the Tcl command specified in the \fB\-command\fR
option is invoked.

.SH "WIDGET COMMAND"
.PP
The \fBbutton\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for button widgets:
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBbutton\fR
command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBbutton\fR
command.
.TP
\fIpathName \fBflash\fR
Flash the button.  This is accomplished by redisplaying the button
several times, alternating between active and normal colors.  At
the end of the flash the button is left in the same normal/active
state as when the command was invoked.
This command is ignored if the button's state is \fBdisabled\fR.
.TP
\fIpathName \fBinvoke\fR
Invoke the Tcl command associated with the button, if there is one.
The return value is the return value from the Tcl command, or an
empty string if there is no command associated with the button.
This command is ignored if the button's state is \fBdisabled\fR.

.SH "DEFAULT BINDINGS"
.PP
Tk automatically creates class bindings for buttons that give them
default behavior:
.IP [1]
A button activates whenever the mouse passes over it and deactivates
whenever the mouse leaves the button.
.VS
Under Windows, this binding is only active when mouse button 1 has
been pressed over the button.
.VE
.IP [2]
A button's relief is changed to sunken whenever mouse button 1 is
pressed over the button, and the relief is restored to its original
value when button 1 is later released.
.IP [3]
If mouse button 1 is pressed over a button and later released over
the button, the button is invoked.  However, if the mouse is not
over the button when button 1 is released, then no invocation occurs.
.IP [4]
When a button has the input focus, the space key causes the button
to be invoked.
.PP
If the button's state is \fBdisabled\fR then none of the above
actions occur:  the button is completely non-responsive.
.PP
The behavior of buttons can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH KEYWORDS
button, widget
